# Responses
RESPONSE_OK = b"1"
RESPONSE_ERROR = b"0"

# Statuses
STATUS_DISCONNECTED = "Disconnected"
STATUS_CONNECTING = "Connecting"
STATUS_CONNECTED = "Connected"
STATUS_CONFIGURING = "Configuring"
STATUS_CONFIGURED = "Configured"
STATUS_IDLE = "Idle"
STATUS_BUSY = "Busy"
STATUS_ERROR = "Error"
STATUS_DISCONNECTING = "Disconnecting"

READY_DEVICE_STATUSES = (STATUS_CONFIGURED, STATUS_IDLE, STATUS_BUSY)
IDLE_DEVICE_STATUSES = (STATUS_CONFIGURED, STATUS_IDLE)
STATUSES_PRIORITY = (
    STATUS_ERROR, STATUS_DISCONNECTING, STATUS_DISCONNECTED, STATUS_CONNECTING, STATUS_CONNECTED, STATUS_CONFIGURING,
    STATUS_BUSY, STATUS_IDLE, STATUS_CONFIGURED)

# Macro states
IDLE = 0
BUSY = 1
PAUSED = 2
DONE = 3
STOPPED = 4
ERROR = 5
WARNING = 6

ABORT = "Abort macro"
SKIP = "Skip"

MODE_ALL = 2
MODE_EXTENDED = 1
MODE_SIMPLE = 0

# Attribute values
VALUE = "Value"
TYPE = "Type"
MIN = "Min"
MAX = "Max"
UNIT = "Unit"
DECIMALS = "Decimals"
DESCRIPTION = "Description"
READONLY = "Readonly"
TYPE_LIST = "<type> List"
TYPE_LIST_VALUES = "<type> List values"
TYPE_ARRAY = "<type> Array"
FACTOR = "Factor"
OFFSET = "Offset"
TOLERANCE = "Tolerance"
SETPOINT = "Setpoint"
PREVIOUS = "Previous"
SAVE_CHANGE = "Save"
ALL = "*"
DISPLAY = "display"
IMAGE = "Image"
LOCAL_FILESYSTEM = "Local filesystem"

# Basic attributes
ATTR_ID = "Id"
ATTR_DESCRIPTION = "Description"
ATTR_STATUS = "Status"
ATTR_ENABLED = "Enabled"

INSTRUCTION_GET = b"0"
INSTRUCTION_SET = b"1"
INSTRUCTION_COMMAND = b"2"
INSTRUCTION_INIT = b"3"
INSTRUCTION_METHOD = b"4"
INSTRUCTION_POLL = b"5"
INSTRUCTION_PULL = b"6"
INSTRUCTION_PUSH = b"7"
INSTRUCTION_FORWARD = b"8"
INSTRUCTION_SYNC = b"9"

# Tokens
TOKEN_ATTRIBUTE = "A!"
TOKEN_ATTRIBUTE_REPLACE = "R!"
TOKEN_ATTRIBUTE_DELETE = "D!"
TOKEN_ATTRIBUTE_GROUP_DELETE = "GD!"
TOKEN_ALL = "*"

# Words
RISING = u"Rising"
FALLING = u"Falling"
POSITIVE = u"Positive"
NEGATIVE = u"Negative"
ROWS = u"Rows"
COLUMNS = u"Columns"

# Macro steps
MACRO_SET_ATTRIBUTE_STEP = u"Set attribute"
MACRO_EXECUTE_METHOD_STEP = u"Execute method"

# Config enums
CFG_TEMPLATE = 0

# Zmq message tokens
WORKER_READY = b"1"
MSG_TERMINATE = b"0"
WORKER_DONE = b"2"
MSG_EMPTY = b""
MSG_JSON = b"J"
MSG_ARRAY = b"A"
MSG_PICKLE = b"P"
MSG_FILE = b"F"
MSG_ACK = b"ACK"
MSG_FORWARD = b"FRWD"
MSG_ABORT = b"ABT"
MSG_PROGRESS = b"PROG"

# List of general Attributes
ATTR_SERIAL_NUMBER = u"Serial number"
ATTR_PRODUCT_TYPE = u"Product type"
ATTR_MODEL = u"Model name"
ATTR_ANALOG_INPUT_READOUT_TASK = u"Analog readout task"
ATTR_TERMINAL_CONFIGURATION = u"Terminal configuration"
ATTR_SAMPLES_NUMBER = u"Number of samples"
ATTR_READOUT_AT_SAMPLES = u"Readout at samples"
ATTR_TEMPERATURE = u"Temperature"
ATTR_CHANNELS = u"Channels"
ATTR_POSITION = u"Position"
ATTR_TARGET_POSITION = u"Target position"
ATTR_STALL_FLAG = u"Stall flag"
ATTR_MOVING = u"Moving"
ATTR_VELOCITY = u"Velocity"
ATTR_HOLDING_CURRENT = u"Holding current"
ATTR_MAXIMUM_VELOCITY = u"Maximum velocity"
ATTR_RUN_CURRENT = u"Run current"
ATTR_ROTATION_DIRECTION = u"Rotation direction"
ATTR_TORQUE_SPEED = u"Torque speed"
ATTR_ENCODER_ENABLED = u"Encoder enabled"
ATTR_MICROSTEP_RESOLUTION = u"Microstep resolution"
ATTR_STEPS_PER_REVOLUTION = u"Steps / revolution"
ATTR_STALL_FACTOR = u"Stall factor"
ATTR_POSITIVE_LIMIT_SWITCH = u"+limit switch"
ATTR_NEGATIVE_LIMIT_SWITCH = u"-limit switch"
ATTR_INDEX_MARK = u"Index mark"
ATTR_USE_POSITIVE_LIMIT_SWITCH = u"Use +limit switch"
ATTR_USE_NEGATIVE_LIMIT_SWITCH = u"Use -limit switch"
ATTR_INITIAL_VELOCITY = u"Initial velocity"
ATTR_REFERENCING = u"Referencing"
ATTR_ERROR_CODE = u"Error code"
ATTR_LATENCY = u"Latency"
ATTR_MODULES = u"Modules count"
ATTR_STATE = u"State"
ATTR_ENCODER_BASE_UNIT = u"Enc. base unit"
ATTR_HAND_TOOL = u"Hand tool"
ATTR_MOVEMENT_LOCKED = u"Movement locked"
ATTR_INTERNAL_COMM_FAILURE = u"Comm failure"
ATTR_STREAMING = u"Streaming"
ATTR_SENSOR_PRESENT = u"Sensor present"
ATTR_BOOSTER_PRESENT = u"Booster present"
ATTR_ADJUSTMENT_ACTIVE = u"Adjustment active"
ATTR_IOM_PRESENT = u"I/O present"
ATTR_HIGH_VOLTAGE_FAILURE = u"High vol. failure"
ATTR_HIGH_VOLTAGE_OVERLOAD = u"High vol. overload"
ATTR_OVER_TEMPERATURE = u"Over temperature"
ATTR_CLOSED_LOOP_ACTIVE = u"Closed loop active"
ATTR_CALIBRATING = u"Calibrating"
ATTR_MOVE_DELAYED = u"Move delayed"
ATTR_CALIBRATED = u"Calibrated"
ATTR_REFERENCED = u"Referenced"
ATTR_END_STOP_REACHED = u"On end stop"
ATTR_RANGE_LIMIT_REACHED = u"On range limit"
ATTR_FOLLOWING_LIMIT_REACHED = u"On Following limit"
ATTR_MOVEMENT_FAILED = u"Movement failed"
ATTR_POSITIONER_TYPE = u"Positioner type"
ATTR_POSITIONER_CODE = u"Positioner code"
ATTR_POSITION_UPPER_LIMIT = u"Position +limit"
ATTR_POSITION_LOWER_LIMIT = u"Position -limit"
ATTR_STEP_FREQUENCY = u"Step frequency"
ATTR_STEP_AMPLITUDE = u"Step amplitude"
ATTR_ACCELERATION = u"Acceleration"
ATTR_DECELERATION = u"Deceleration"
ATTR_SENSOR_MODE = u"Sensor mode"
ATTR_MOVE_MODE = u"Move mode"
ATTR_SAFE_DIRECTION = u"Safe direction"
ATTR_HAND_TOOL_MODE = u"Hand tool mode"
ATTR_SENSOR_TYPE = u"Sensor type"
ATTR_REVOLUTIONS = u"Revolutions"
ATTR_BAUDRATE = u"Baudrate"
ATTR_REFERENCING_METHOD = u"Referencing method"
ATTR_ACCELERATION_PATTERN = u"Acceleration pattern"
ATTR_ACCELERATION_TIME = u"Acceleration time"
ATTR_CORRECTION = u"Position correction"
ATTR_CORRECTION_RETRY = u"Correction retry_count"
ATTR_DECELERATION_TIME = u"Deceleration time"
ATTR_ENCODER_ADDING = u"Encoder adding"
ATTR_ENCODER_READ = u"Encoder read"
ATTR_ENCODER_RESOLUTION = u"Encoder resolution"
ATTR_PULSE_POSITION = u"Pulse position"
ATTR_PULSE_READ = u"Pulse read"
ATTR_START_SPEED = u"Start speed"
ATTR_STEP_FACTOR = u"Step factor"
ATTR_STEP_RESOLUTION = u"Step resolution"
ATTR_TOP_SPEED = u"Top speed"
ATTR_TRIGGER_EDGE = u"Trigger edge"
ATTR_TRIGGER_ENC_PITCH = u"Trigger enc pitch"
ATTR_TRIGGER_LOGIC = u"Trigger logic"
ATTR_TRIGGER_PM_PITCH = u"Trigger pm pitch"
ATTR_TRIGGER_PULSE_WIDTH = u"Trigger pulse width"
ATTR_TRIGGER_SELECT = u"Trigger select"
ATTR_TRIGGER_SOURCE = u"Trigger source"
ATTR_ENCODER_CALC_NUM = u"Encoder calc num"
ATTR_ENCODER_CALC_DEN = u"Encoder calc den"
ATTR_ROTATION_CHANGE = u"Rotation change"
ATTR_SWAP_LIMITS = u"Swap limits"
ATTR_RETRY_COUNT = u"Retry count"
ATTR_FEEDBACK_TIMEOUT = u"Feedback timeout"
ATTR_FEEDBACK_CONTROL_TYPE = u"Feedback type"
ATTR_MOTOR_EXCITATION = u"Motor excitation"
ATTR_MOTOR_SELECTION = u"Motor selection"
ATTR_MICROSTEP_SELECT = u"Microstep select"
ATTR_STOP_TYPE = u"Stop type"
ATTR_EMERGENCY_STOP = u"Emergency stop"
ATTR_CWL = u"CW limit"
ATTR_CCWL = u"CCW limit"
ATTR_ORG = u"ORG signal"
ATTR_NORG = u"NORG signal"
ATTR_LAST_ERROR = u"Last error"
ATTR_LOG_DIRECTORY = u"Log directory"
ATTR_SCAN_DIRECTORY = u"Scan directory"
ATTR_ALLOW_CONSOLE_LOG = u"Allow console log"
ATTR_ALLOW_DEVICE_LOG = u"Allow device log"
ATTR_ALLOW_GUI_LOG = u"Allow gui log"
ATTR_ALLOW_ATTRIBUTE_LOG = u"Allow attribute log"
ATTR_ALLOW_MACRO_LOG = u"Allow macro log"
ATTR_DEVICES_COUNT = u"Devices count"
ATTR_LOOPS_RUNNING = u"Control loops running"
ATTR_FILEPATH = u"Filepath"
ATTR_CONTENT = u"Content"
ATTR_STEP_INDEX = u"Step index"
ATTR_POINT_INDEX = u"Point index"
ATTR_STEPS_COUNT = u"Steps count"
ATTR_POINTS_COUNT = u"Points count"
ATTR_PROGRESS = u"Progress"
ATTR_STARTED_AT = u"Started at"
ATTR_RUNNING_TIME = u"Running time"
ATTR_ESTIMATED_TIME = u"Estimated time"
ATTR_ESTIMATED_END = u"Estimated end"
ATTR_REMAINING_TIME = u"Remaining time"
ATTR_CHAIN_LINK = u"Chain link"
ATTR_OPENED = u"Opened"
ATTR_OPENED_POSITION = u"Opened position"
ATTR_CLOSED_POSITION = u"Closed position"
ATTR_OPENED_VALUE = u"Opened value"
ATTR_CLOSED_VALUE = u"Closed value"
ATTR_OPENED_AT = u"Opened at"
ATTR_AUTO_MODE = u"Auto mode"
ATTR_SYNTAX_VERSION = u"Syntax vesrion"
ATTR_SERVO_STATE = u"Servo state"
ATTR_ON_TARGET = u"On target"
ATTR_ACTIVE_UNIT = u"Active unit"
ATTR_REFERENCING_DIRECTION_X = u"Ref direction X"
ATTR_REFERENCING_DIRECTION_Y = u"Ref direction Y"
ATTR_REFERENCING_DIRECTION_Z = u"Ref direction Z"
ATTR_PIVOT_MODE = u"Pivot mode"
ATTR_PIVOT_X = u"Pivot X"
ATTR_PIVOT_Y = u"Pivot Y"
ATTR_PIVOT_Z = u"Pivot Z"
ATTR_POSITIONS = u"Positions"
ATTR_USE_MARK_INDEX = u"Use mark index"
ATTR_BACKLASH_DISTANCE = u"Backlash distance"
ATTR_BUFFERED_COMMANDS = u"Buffered commands"
ATTR_HANGING_COMMANDS = u"Hanging commands"
ATTR_CONSTANT_CURRENT = u"Constant current"
ATTR_CONSTANT_VOLTAGE = u"Constant voltage"
ATTR_CURRENT = u"Current"
ATTR_VOLTAGE = u"Voltage"
ATTR_MAX_CURRENT = u"Max current"
ATTR_MAX_VOLTAGE = u"Max voltage"
ATTR_OUTPUT_SWITCH = u"Output switch"
ATTR_INTENSITY = u"Intensity"
ATTR_RESOURCE_DIRECTORY = u"Resource directory"
ATTR_CACHE_DIRECTORY = u"Cache directory"
ATTR_SCAN_PREFIX = u"Scan prefix"
ATTR_SCAN_COUNT = u"Scan count"
ATTR_OUTPUT_FILENAME = u"Output filename"
ATTR_TIMEOUT = u"Timeout"
ATTR_ACRONYM = u"Acronym"
ATTR_MOTOR_TYPE = u"Motor type"
ATTR_AMPLIFIER_GAIN = u"Amplifier gain"
ATTR_FAST_REFERENCE_SPEED = u"Fast reference speed"
ATTR_FULL_STEP_RESOLUTION = u"Full step resolution"
ATTR_HOMING_DIRECTION = u"Homing direction"
ATTR_JOG_BACKWARD = u"Jog backward"
ATTR_JOG_FORWARD = u"Jog forward"
ATTR_LATCH_INPUT_LEVEL = u"Latch input level"
ATTR_LIMIT_SWITCH_ACTIVE_LEVEL = u"Limit switch active level"
ATTR_LOW_CURRENT_STEPPER_MODE = u"Low current stepper mode"
ATTR_SLOW_REFERENCE_SPEED = u"Slow reference speed"
ATTR_STEP_DRIVE_RESOLUTION = u"Step drive resolution"
ATTR_JOG_MOTOR = u"Jog motor"
ATTR_HOMING_METHOD = u"Homing method"
ATTR_LIMIT_SWITCHES_MODE = u"Limit switches mode"
ATTR_REMOTE_TIMESTAMP = u"Remote timestamp"
ATTR_LOCAL_TIMESTAMP = u"Local timestamp"
ATTR_DELTA_TIMESTAMP = u"Delta timestamp"
ATTR_REMOTE_TRAIN_ID = u"Remote train id"
ATTR_LOCAL_TRAIN_ID = u"Local train id"
ATTR_MIN_UPDATE_TIMEOUT = u"Min update timeout"
ATTR_TRAIN_TIMEOUT = u"Train timeout"
ATTR_TRAIN_OFFSET = u"Train id offset"
ATTR_COUNTER = u"Counter"
ATTR_REFRESHING = u"Refreshing"
ATTR_WAVETABLE_LENGTH = u"Wavetable length"
ATTR_WAVETABLE_DATA = u"Wave table data"
ATTR_WAVETABLE_RATE = u"Wave table rate"
ATTR_WAVETABLE_INTERPOLATION = u"Wave table interpolation"
ATTR_WAVE_GEN_OFFSET = u"Wave gen offset"
ATTR_TRIGGER_OUTPUTS_COUNT = u"Trigger outputs count"
ATTR_WAVE_GEN_COUNT = u"Wave generators count"
ATTR_WAVE_TABLE = u"Wave table"
ATTR_SERVO_UPDATE_TIME = u"Servo update time"
ATTR_RECORD_TABLE_RATE = u"Record table rate"
ATTR_RECORD_TABLE_DATA = u"Record table data"
ATTR_RECORD_TABLE_DATA_SETPOINTS = u"Record table data setpoints"
ATTR_WAVETABLE_OFFSET = u"Wave table offset"
ATTR_TRIGGER_LINE_DATA = u"Trigger line data"
ATTR_SCANNING = u"Scanning"
ATTR_READOUT = u"Readout"
ATTR_CAMERA_CALIBRATION = u"Pixel calibration"
ATTR_COLOR_OUTPUT = u"Color output"
ATTR_COMMENT = u"Comment"
ATTR_DUMMY_IMAGE = u"Dummy image"
ATTR_EXPOSURE_TIME = u"Exposure time"
ATTR_FRAMERATE = u"Framerate"
ATTR_FRAME_IMAGE = u"Frame image"
ATTR_GAIN = u"Gain"
ATTR_HEIGHT_DIVIDER = u"Height divider"
ATTR_HEIGHT_MAX = u"Height max"
ATTR_LIVE_VIEW = u"Live view"
ATTR_LIVE_VIEW_FPS_LIMIT = u"Live view limit"
ATTR_OUTPUT_NAME = u"Output name"
ATTR_PIXEL_BITSIZE = u"PixelSize"
ATTR_REAL_FRAMERATE = u"Real framerate"
ATTR_ROI_OFFSET_X = u"ROI offset X"
ATTR_ROI_OFFSET_Y = u"ROI offset Y"
ATTR_SAVE_FRAMES = u"Save frames"
ATTR_START_ACQUISITION = u"Start acquisition"
ATTR_STOP_ACQUISITION = u"Stop acquisition"
ATTR_SUMMED_FRAMES = u"Summed frames"
ATTR_TRIGGER_MODE = u"Trigger mode"
ATTR_WIDTH_DIVIDER = u"Width divider"
ATTR_WIDTH_MAX = u"Width max"
GROUP_ROI = u"Roi"
ATTR_WAVE_GENERATOR = u"Wave generator"
ATTR_OUTPUT_DIRECTORY = u"Output directory"
ATTR_TRIGGER_DURATION = u"Trigger duration"
ATTR_SETPOINT = u"Setpoint"
ATTR_FAULT_BYTE = u"Fault byte"
ATTR_FAST_REFERENCE_VELOCITY = u"Fast reference velocity"
ATTR_SLOW_REFERENCE_VELOCITY = u"Slow reference velocity"
ATTR_REFERENCE_STEPS_BACK = u"Reference steps back"
ATTR_HOLDING_TIME = u"Holding time"
ATTR_PRESSURE = u"Pressure"
ATTR_POWER = u"Power"
ATTR_CURRENT_SAMPLE = u"Current sample"
ATTR_CURRENT_CHANNEL = u"Current channel"
ATTR_ACTIVE_SWITCHES = u"Active switches"
ATTR_LIBRARY = u"Library"
ATTR_ENCODER_READOUT = u"Encoder readout"
ATTR_COUNTS_PER_REVOLUTION = u"Counts pre revolution"
ATTR_REFERENCE_VELOCITY = u"Reference velocity"
ATTR_DIRECTION = u"Direction"
ATTR_DWELL_TIME = u"Dwell time"
ATTR_TEMPLATES_COUNT = u"Templates count"
ATTR_MACRO_COUNT = u"Macro count"
ATTR_MACRO_PREFIX = u"Macro prefix"
ATTR_TEMPLATE_DIRECTORY = u"Template directory"
ATTR_UPLOADED_COUNT = u"Uploaded count"
ATTR_FINISHED_COUNT = u"Finished count"
ATTR_RUNNING_COUNT = u"Running count"
ATTR_MAX_RUNNING_MACROS = u"Max running macros"
ATTR_MAX_MACRO_HISTORY = u"Max macro history"
ATTR_TEMPLATE = u"Template"
ATTR_CHAIN_LINK_OUTPUT = u"Chain link output"
ATTR_OFF = u"Off"
ATTR_PS1_VOLTAGE = u"PS 1 voltage"
ATTR_PS1_POWER = u"PS 1 power"
ATTR_PS1_CURRENT = u"PS 1 current"
ATTR_PS2_VOLTAGE = u"PS 2 voltage"
ATTR_PS2_POWER = u"PS 2 power"
ATTR_PS2_CURRENT = u"PS 2 current"
ATTR_PS3_VOLTAGE = u"PS 3 voltage"
ATTR_PS3_POWER = u"PS 3 power"
ATTR_PS3_CURRENT = u"PS 3 current"
ATTR_PS4_VOLTAGE = u"PS 4 voltage"
ATTR_PS4_POWER = u"PS 4 power"
ATTR_PS4_CURRENT = u"PS 4 current"
ATTR_POWER_SETPOINT = u"Power setpoint"
ATTR_VOLTAGE_SETPOINT = u"Voltage setpoint"
ATTR_CURRENT_SETPOINT = u"Current setpoint"
ATTR_OUTPUT_RELEASED = u"Output released"
ATTR_PROCESS_ID = u"Process ID"
ATTR_MEMORY_USAGE = u"Memory usage"
ATTR_CPU_USAGE = u"Cpu usage"
ATTR_AVAILABLE_MEMORY = u"Available memory"
ATTR_HOME_SWITCH_FLAG = u"Home switch flag"
ATTR_HARDWARE_VERSION = u"Hardware version"
ATTR_SOFTWARE_VERSION = u"Software version"
ATTR_MANUFACTURE_DATE = u"Manufacture date"
ATTR_APPLICATION_NUMBER = u"Application number"
ATTR_APPLICATION_VERSION = u"Application version"
ATTR_OPERATION_MODE = u"Operation mode"
ATTR_VELOCITY_UNITS = u"Velocity units"
ATTR_WIDTH = u"Width"
ATTR_HEIGHT = u"Height"
ATTR_INPUT_DIR_LIST = u"Input dir list"
ATTR_OUTPUT_DIR_LIST = u"Output dir list"
ATTR_FILE_FILTER_PATTERN = u"File filter pattern"
ATTR_ADDRESS = u"Address"
ATTR_HOST = u"Host"
ATTR_PORT = u"Port"
ATTR_TASKS = u"Tasks"
ATTR_WORKER = u"Worker"
ATTR_CLIENT = u"Client"
ATTR_TASK_INSTRUCTION = u"Task instruction"
ATTR_SOURCE_FILE = u"Source file"
ATTR_TARGET_FILE = u"Target file"
ATTR_ABORTED = u"Aborted"
ATTR_DRIVES = u"Drives"
ATTR_FINISHED_AT = u"Finished at"
ATTR_REQUESTED_FILES = u"Requested files"
ATTR_SYNCED_FILES = u"Synced files"
ATTR_METADATA = u"Metadata"
ATTR_LOGFILE = u"Logfile"
ATTR_HEADER = u"Header"
ATTR_LAST_LOG_LINE = u"Last log line"
ATTR_INTERVAL = u"Interval"
ATTR_LOGGING = u"Logging"
ATTR_MEASURING_SCALE = u"Measuring scale"
ATTR_DISTANCE = u"Distance"
ATTR_MODES = u"Modes"
ATTR_AUTO_STOP = u"Auto stop"
ATTR_ABSOLUTE_POSITION = u"Absolute position"
ATTR_WARNING = u"Warning"
ATTR_VELOCITY_TIMEOUT = u"Velocity timeout"
ATTR_SPEED_TABLE_ROW = u"Speed table row"
ATTR_RESISTANCE = u"Resistance"
