/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class ChangeState
implements Comparable<ChangeState> {
    private final TimeTick when;
    private final String[] states;
    private final String comment;
    private final Colors colors;

    public ChangeState(TimeTick when, String comment, Colors colors, String ... states) {
        if (states.length == 0) {
            throw new IllegalArgumentException();
        }
        this.when = when;
        this.states = states;
        this.comment = comment;
        this.colors = colors;
    }

    @Override
    public int compareTo(ChangeState other) {
        return this.when.compareTo(other.when);
    }

    public final TimeTick getWhen() {
        return this.when;
    }

    public final String[] getStates() {
        return this.states;
    }

    public final String getState() {
        return this.states[0];
    }

    public String getComment() {
        return this.comment;
    }

    public final HColor getBackColor(ISkinParam skinParam, Style style) {
        if (this.colors == null || this.colors.getColor(ColorType.BACK) == null) {
            if (!UseStyle.useBetaStyle()) {
                return HColorUtils.COL_D7E0F2;
            }
            return style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        }
        return this.colors.getColor(ColorType.BACK);
    }

    private final HColor getLineColor(ISkinParam skinParam, Style style) {
        if (this.colors == null || this.colors.getColor(ColorType.LINE) == null) {
            if (!UseStyle.useBetaStyle()) {
                return HColorUtils.COL_038048;
            }
            return style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        }
        return this.colors.getColor(ColorType.LINE);
    }

    public SymbolContext getContext(ISkinParam skinParam, Style style) {
        return new SymbolContext(this.getBackColor(skinParam, style), this.getLineColor(skinParam, style)).withStroke(new UStroke(1.5));
    }

    public final boolean isBlank() {
        return this.states[0].equals("{...}");
    }

    public final boolean isCompletelyHidden() {
        return this.states[0].equals("{hidden}");
    }

    public final boolean isFlat() {
        return this.states[0].equals("{-}");
    }
}

