/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.Img;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.Splitter;
import net.sourceforge.plantuml.graphic.SpriteCommand;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextLink;
import net.sourceforge.plantuml.graphic.TileText;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class SingleLine
extends AbstractTextBlock
implements Line {
    private final List<TextBlock> blocs = new ArrayList<TextBlock>();
    private final HorizontalAlignment horizontalAlignment;

    public static SingleLine withSomeHtmlTag(String text, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer) {
        SingleLine result = new SingleLine(horizontalAlignment);
        if (text.length() == 0) {
            text = " ";
        }
        Splitter lineSplitter = new Splitter(text);
        for (HtmlCommand cmd : lineSplitter.getHtmlCommands(spriteContainer.getThemeStyle(), false)) {
            String s;
            if (cmd instanceof Text) {
                s = ((Text)cmd).getText();
                result.blocs.add(new TileText(s, fontConfiguration, null));
                continue;
            }
            if (cmd instanceof TextLink) {
                s = ((TextLink)cmd).getText();
                Url url = ((TextLink)cmd).getUrl();
                result.blocs.add(new TileText(s, fontConfiguration, url));
                continue;
            }
            if (cmd instanceof Img) {
                result.blocs.add(((Img)cmd).createMonoImage());
                continue;
            }
            if (cmd instanceof SpriteCommand) {
                Sprite sprite = spriteContainer.getSprite(((SpriteCommand)cmd).getSprite());
                if (sprite == null) continue;
                result.blocs.add(sprite.asTextBlock(fontConfiguration.getColor(), 1.0));
                continue;
            }
            if (!(cmd instanceof FontChange)) continue;
            fontConfiguration = ((FontChange)cmd).apply(fontConfiguration);
        }
        return result;
    }

    public static SingleLine rawText(String text, FontConfiguration fontConfiguration) {
        SingleLine result = new SingleLine(HorizontalAlignment.LEFT);
        if (text.length() == 0) {
            text = " ";
        }
        result.blocs.add(new TileText(text, fontConfiguration, null));
        return result;
    }

    private SingleLine(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (TextBlock b : this.blocs) {
            Dimension2D size2D = b.calculateDimension(stringBounder);
            width += size2D.getWidth();
            height = Math.max(height, size2D.getHeight());
        }
        return new Dimension2DDouble(width, height);
    }

    private double maxDeltaY(UGraphic ug) {
        double result = 0.0;
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        for (TextBlock b : this.blocs) {
            if (!(b instanceof TileText)) continue;
            Dimension2D dimBloc = b.calculateDimension(ug.getStringBounder());
            double deltaY = dim.getHeight() - dimBloc.getHeight() + ((TileText)b).getFontSize2D();
            result = Math.max(result, deltaY);
        }
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        double deltaY = this.maxDeltaY(ug);
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dim = this.calculateDimension(stringBounder);
        double x = 0.0;
        for (TextBlock b : this.blocs) {
            if (b instanceof TileText) {
                b.drawU(ug.apply(new UTranslate(x, deltaY)));
            } else {
                double dy = dim.getHeight() - b.calculateDimension(stringBounder).getHeight();
                b.drawU(ug.apply(new UTranslate(x, dy)));
            }
            x += b.calculateDimension(stringBounder).getWidth();
        }
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }
}

