/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public abstract class BodyEnhancedAbstract
extends AbstractTextBlock
implements TextBlock {
    protected final HorizontalAlignment align;
    protected final FontConfiguration titleConfig;
    protected TextBlock area;
    private final Style style;

    BodyEnhancedAbstract(HorizontalAlignment align, FontConfiguration titleConfig, Style style) {
        this.align = align;
        this.titleConfig = titleConfig;
        this.style = style;
    }

    public static boolean isBlockSeparator(CharSequence cs) {
        String s = cs.toString();
        if (s.startsWith("--") && s.endsWith("--")) {
            return true;
        }
        if (s.startsWith("==") && s.endsWith("==")) {
            return true;
        }
        if (s.startsWith("..") && s.endsWith("..") && !s.equals("...")) {
            return true;
        }
        return s.startsWith("__") && s.endsWith("__");
    }

    @Override
    public final Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        this.getArea(ug.getStringBounder()).drawU(ug);
    }

    protected final TextBlock getTitle(String s, ISkinSimple spriteContainer) {
        if (s.length() <= 4) {
            return null;
        }
        s = StringUtils.trin(s.substring(2, s.length() - 2));
        return Display.getWithNewlines(s).create(this.titleConfig, HorizontalAlignment.LEFT, spriteContainer);
    }

    protected abstract TextBlock getArea(StringBounder var1);

    protected abstract double getMarginX();

    protected final TextBlock decorate(StringBounder stringBounder, TextBlock b, char separator, TextBlock title) {
        double marginX = this.getMarginX();
        if (separator == '\u0000') {
            return TextBlockUtils.withMargin(b, marginX, 0.0);
        }
        if (title == null) {
            return new TextBlockLineBefore(this.getDefaultThickness(), TextBlockUtils.withMargin(b, marginX, 4.0), separator);
        }
        Dimension2D dimTitle = title.calculateDimension(stringBounder);
        TextBlockLineBefore raw = new TextBlockLineBefore(this.getDefaultThickness(), TextBlockUtils.withMargin(b, marginX, 6.0, dimTitle.getHeight() / 2.0, 4.0), separator, title);
        return TextBlockUtils.withMargin(raw, 0.0, 0.0, dimTitle.getHeight() / 2.0, 0.0);
    }

    protected final double getDefaultThickness() {
        if (UseStyle.useBetaStyle()) {
            return this.style.value(PName.LineThickness).asDouble();
        }
        return 1.5;
    }
}

