/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtileRoot;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileHexagonInside;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithIncomingArrow;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithMargin;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithOutgoingArrow;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Gtiles {
    private static final Rose rose = new Rose();

    public static GtileHexagonInside hexagonInside(Swimlane swimlane, StringBounder stringBounder, ISkinParam skinParam, StyleSignatureBasic styleSignature, HColor color, Display label) {
        FontConfiguration fcTest;
        HColor backColor;
        HColor borderColor;
        ConditionStyle conditionStyle = skinParam.getConditionStyle();
        if (UseStyle.useBetaStyle()) {
            Style style = styleSignature.getMergedStyle(skinParam.getCurrentStyleBuilder());
            borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            backColor = color == null ? style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet()) : color;
            fcTest = style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        } else {
            FontParam testParam = conditionStyle == ConditionStyle.INSIDE_HEXAGON ? FontParam.ACTIVITY_DIAMOND : FontParam.ARROW;
            borderColor = rose.getHtmlColor(skinParam, ColorParam.activityDiamondBorder);
            backColor = color == null ? rose.getHtmlColor(skinParam, ColorParam.activityDiamondBackground) : color;
            fcTest = FontConfiguration.create(skinParam, testParam, null).changeColor(Gtiles.fontColor(skinParam, FontParam.ACTIVITY_DIAMOND));
        }
        Sheet sheet = Parser.build(fcTest, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), skinParam, CreoleMode.FULL).createSheet(label);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, skinParam.getPadding());
        SheetBlock2 tbTest = new SheetBlock2(sheetBlock1, Hexagon.asStencil(sheetBlock1), new UStroke());
        return new GtileHexagonInside(stringBounder, tbTest, skinParam, backColor, borderColor, swimlane);
    }

    public static AbstractGtileRoot diamondEmpty(Swimlane swimlane, StringBounder stringBounder, ISkinParam skinParam, StyleSignatureBasic styleSignature, HColor color) {
        HColor backColor;
        HColor borderColor;
        if (UseStyle.useBetaStyle()) {
            Style style = styleSignature.getMergedStyle(skinParam.getCurrentStyleBuilder());
            borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
            backColor = color == null ? style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet()) : color;
        } else {
            borderColor = rose.getHtmlColor(skinParam, ColorParam.activityDiamondBorder);
            backColor = color == null ? rose.getHtmlColor(skinParam, ColorParam.activityDiamondBackground) : color;
        }
        return new GtileHexagonInside(stringBounder, TextBlockUtils.EMPTY_TEXT_BLOCK, skinParam, backColor, borderColor, swimlane);
    }

    private static HColor fontColor(ISkinParam skinParam, FontParam param) {
        return skinParam.getFontHtmlColor(null, param);
    }

    public static Gtile withSouthMargin(Gtile orig, double south) {
        return new GtileWithMargin((AbstractGtileRoot)orig, 0.0, south, 0.0);
    }

    public static Gtile withNorthMargin(Gtile orig, double north) {
        return new GtileWithMargin((AbstractGtileRoot)orig, north, 0.0, 0.0);
    }

    public static Gtile withIncomingArrow(Gtile orig, double margin) {
        if (orig instanceof GtileEmpty) {
            return orig;
        }
        return new GtileWithIncomingArrow((AbstractGtileRoot)orig, margin);
    }

    public static Gtile withOutgoingArrow(Gtile orig, double margin) {
        if (orig instanceof GtileEmpty) {
            return orig;
        }
        return new GtileWithOutgoingArrow((AbstractGtileRoot)orig, margin);
    }
}

