/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collection;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.MathUtils;

public class FtileWithNotes
extends AbstractFtile {
    private final Ftile tile;
    private TextBlock left;
    private TextBlock right;
    private final double suppSpace = 20.0;

    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    public FtileWithNotes(Ftile tile, Collection<PositionedNote> notes, ISkinParam skinParam) {
        super(tile.skinParam());
        this.tile = tile;
        Rose rose = new Rose();
        for (PositionedNote note : notes) {
            LineBreakStrategy wrapWidth;
            double shadowing;
            FontConfiguration fc;
            HColor borderColor;
            HColor noteBackgroundColor;
            ISkinParam skinParam2 = skinParam;
            if (note.getColors() != null) {
                skinParam2 = note.getColors().mute(skinParam2);
            }
            UStroke stroke = new UStroke();
            if (UseStyle.useBetaStyle()) {
                Style style = this.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder()).eventuallyOverride(note.getColors());
                noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
                borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
                fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
                shadowing = style.value(PName.Shadowing).asDouble();
                wrapWidth = style.wrapWidth();
                stroke = style.getStroke();
            } else {
                noteBackgroundColor = rose.getHtmlColor(skinParam2, ColorParam.noteBackground);
                borderColor = rose.getHtmlColor(skinParam2, ColorParam.noteBorder);
                fc = FontConfiguration.create(skinParam, FontParam.NOTE, null);
                shadowing = skinParam.shadowing(null) ? 4.0 : 0.0;
                wrapWidth = skinParam.wrapWidth();
            }
            Sheet sheet = Parser.build(fc, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), skinParam, CreoleMode.FULL).createSheet(note.getDisplay());
            final SheetBlock1 sheet1 = new SheetBlock1(sheet, wrapWidth, skinParam.getPadding());
            SheetBlock2 sheet2 = new SheetBlock2(sheet1, new Stencil(){

                @Override
                public double getStartingX(StringBounder stringBounder, double y) {
                    return -6.0;
                }

                @Override
                public double getEndingX(StringBounder stringBounder, double y) {
                    return sheet1.getEndingX(stringBounder, y) + 15.0;
                }
            }, new UStroke());
            Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet2, false, stroke);
            TextBlock opaleMarged = TextBlockUtils.withMargin(opale, 10.0, 10.0);
            if (note.getNotePosition() == NotePosition.LEFT) {
                if (this.left == null) {
                    this.left = opaleMarged;
                    continue;
                }
                this.left = TextBlockUtils.mergeTB(this.left, opaleMarged, HorizontalAlignment.CENTER);
                continue;
            }
            if (this.right == null) {
                this.right = opaleMarged;
                continue;
            }
            this.right = TextBlockUtils.mergeTB(this.right, opaleMarged, HorizontalAlignment.CENTER);
        }
        if (this.left == null) {
            this.left = TextBlockUtils.empty(0.0, 0.0);
        }
        if (this.right == null) {
            this.right = TextBlockUtils.empty(0.0, 0.0);
        }
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double xDelta = this.left.calculateDimension(stringBounder).getWidth();
        double yDelta = (dimTotal.getHeight() - ((Dimension2D)dimTile).getHeight()) / 2.0;
        return new UTranslate(xDelta, yDelta);
    }

    private UTranslate getTranslateForLeft(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimLeft = this.left.calculateDimension(stringBounder);
        double xDelta = 0.0;
        double yDelta = (dimTotal.getHeight() - dimLeft.getHeight()) / 2.0;
        return new UTranslate(0.0, yDelta);
    }

    private UTranslate getTranslateForRight(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimRight = this.right.calculateDimension(stringBounder);
        double xDelta = dimTotal.getWidth() - dimRight.getWidth();
        double yDelta = (dimTotal.getHeight() - dimRight.getHeight()) / 2.0;
        return new UTranslate(xDelta, yDelta);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.left.drawU(ug.apply(this.getTranslateForLeft(stringBounder)));
        this.right.drawU(ug.apply(this.getTranslateForRight(stringBounder)));
        ug.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        UTranslate translate = this.getTranslate(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy(), orig.getOutY() + translate.getDy());
        }
        return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        Dimension2D dimLeft = this.left.calculateDimension(stringBounder);
        Dimension2D dimRight = this.right.calculateDimension(stringBounder);
        double height = MathUtils.max(dimLeft.getHeight(), dimRight.getHeight(), ((Dimension2D)dimTile).getHeight());
        return new Dimension2DDouble(((Dimension2D)dimTile).getWidth() + dimLeft.getWidth() + dimRight.getWidth(), height);
    }
}

