/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileBreak;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Genealogy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWhile;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileFactoryDelegatorWhile
extends FtileFactoryDelegator {
    public FtileFactoryDelegatorWhile(FtileFactory factory) {
        super(factory);
    }

    @Override
    public Ftile createWhile(LinkRendering outColor, Swimlane swimlane, Ftile whileBlock, Display test, Display yes, HColor color, Instruction specialOut, Ftile backward, LinkRendering incoming1, LinkRendering incoming2) {
        FontConfiguration fcTest;
        FontConfiguration fontArrow;
        Rainbow arrowColor;
        HColor backColor;
        HColor borderColor;
        FontParam testParam;
        ConditionStyle conditionStyle = this.skinParam().getConditionStyle();
        FontParam fontParam = testParam = conditionStyle == ConditionStyle.INSIDE_HEXAGON ? FontParam.ACTIVITY_DIAMOND : FontParam.ARROW;
        if (UseStyle.useBetaStyle()) {
            Style styleArrow = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            Style styleDiamond = this.getDefaultStyleDefinitionDiamond().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            borderColor = styleDiamond.value(PName.LineColor).asColor(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
            backColor = styleDiamond.value(PName.BackGroundColor).asColor(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
            arrowColor = Rainbow.build(styleArrow, this.skinParam().getIHtmlColorSet(), this.skinParam().getThemeStyle());
            fontArrow = styleArrow.getFontConfiguration(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
            fcTest = styleDiamond.getFontConfiguration(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
        } else {
            borderColor = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBorder);
            backColor = color == null ? this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBackground) : color;
            arrowColor = Rainbow.build(this.skinParam());
            fontArrow = FontConfiguration.create(this.skinParam(), FontParam.ARROW, null);
            fcTest = FontConfiguration.create(this.skinParam(), testParam, null);
        }
        incoming1 = this.ensureColor(incoming1, arrowColor);
        incoming2 = this.ensureColor(incoming2, arrowColor);
        outColor = this.ensureColor(outColor, arrowColor);
        Ftile result = FtileWhile.create(outColor, swimlane, whileBlock, test, borderColor, backColor, arrowColor, yes, fontArrow, this.getFactory(), conditionStyle, fcTest, specialOut, backward, incoming1, incoming2);
        List<WeldingPoint> weldingPoints = whileBlock.getWeldingPoints();
        if (weldingPoints.size() > 0) {
            final Genealogy genealogy = new Genealogy(result);
            for (WeldingPoint w : weldingPoints) {
                final FtileBreak ftileBreak = (FtileBreak)w;
                result = FtileUtils.addConnection(result, new Connection(){

                    @Override
                    public void drawU(UGraphic ug) {
                        UTranslate tr1 = genealogy.getTranslate(ftileBreak, ug.getStringBounder());
                        Snake snake = Snake.create(FtileFactoryDelegatorWhile.this.skinParam(), arrowColor, Arrows.asToLeft());
                        snake.addPoint(tr1.getDx(), tr1.getDy());
                        snake.addPoint(12.0, tr1.getDy());
                        ug.draw(snake);
                    }

                    @Override
                    public Ftile getFtile1() {
                        return ftileBreak;
                    }

                    @Override
                    public Ftile getFtile2() {
                        return null;
                    }
                });
            }
        }
        return result;
    }

    private LinkRendering ensureColor(LinkRendering link, Rainbow color) {
        if (link.getRainbow().size() == 0) {
            return link.withRainbow(color);
        }
        return link;
    }
}

