unicode_to_latex_dict = {
    # Unicode numeric subscripts
    '₀': r'\textsubscript{0}', '₁': r'\textsubscript{1}', '₂': r'\textsubscript{2}', '₃': r'\textsubscript{3}',
    '₄': r'\textsubscript{4}', '₅': r'\textsubscript{5}', '₆': r'\textsubscript{6}', '₇': r'\textsubscript{7}',
    '₈': r'\textsubscript{8}', '₉': r'\textsubscript{9}',
    # Unicode numeric superscripts
    '⁰': r'\textsuperscript{0}', '¹': r'\textsuperscript{1}', '²': r'\textsuperscript{2}', '³': r'\textsuperscript{3}',
    '⁴': r'\textsuperscript{4}', '⁵': r'\textsuperscript{5}', '⁶': r'\textsuperscript{6}', '⁷': r'\textsuperscript{7}',
    '⁸': r'\textsuperscript{8}', '⁹': r'\textsuperscript{9}', '⁺': r'\textsuperscript{+}', '⁻': r'\textsuperscript{-}',
    # Often used European non-ascii-characters
    'ä': r'{\"a}',
    'ö': r'{\"o}',
    'ü': r'{\"u}',
    'Ä': r'{\"A}',
    'Ö': r'{\"O}',
    'Ü': r'{\"U}',
    'ß': r'{\ss}',
    'é': r"{\'e}",
    'è': r"{\`e}",
    'ê': r"{\^e}",
    'à': r"{\`a}",
    'â': r"{\^a}",
    'ç': r"{\c{c}}",
    'É': r"{\'E}",
    'È': r"{\`E}",
    'Ê': r"{\^E}",
    'À': r"{\`A}",
    'Â': r"{\^A}",
    'Ç': r"{\c{C}}",
    'ó': r"{\'o}",
    'ò': r"{\`o}",
    'ô': r"{\^o}",
    'Ó': r"{\'O}",
    'Ò': r"{\`O}",
    'Ô': r"{\^O}",
    'í': r"{\'i}",
    'ì': r"{\`i}",
    'î': r"{\^i}",
    'Í': r"{\'I}",
    'Ì': r"{\`I}",
    'Î': r"{\^I}",
    'ú': r"{\'u}",
    'ù': r"{\`u}",
    'û': r"{\^u}",
    'Ú': r"{\'U}",
    'Ù': r"{\`U}",
    'Û': r"{\^U}",
    'å': r"{\r{a}}",
    'Å': r"{\r{A}}",
    'ø': r"{\o}",
    'Ø': r"{\O}",
    'æ': r"{\ae}",
    'Æ': r"{\AE}",
    'œ': r"{\oe}",
    'Œ': r"{\OE}",
    # Other unicode
    '°': r'{\textdegree}',
    'µ': r'{\textmu}',
    'π': r'$\pi$',
    '≈': r'$\approx$',
    '±': r'$\pm$',
    '≠': r'$\neq$',
    '∆': r'$\Delta$',
    'Ω': r'$\Omega$',
    'Λ': r'$\Lambda$',
    'Σ': r'$\Sigma$',
    # '€': r'{\euro}',
    '£': r'{\pounds}',
    '¥': r'{\yen}',
    '\u00A0': r'~',  # Non-breaking space
    '\u2007': ' '  # Figure space
}

latex_escape_dict = {
    '&': r'\&',
    '%': r'\%',
    r'\$': r'\$',
    '#': r'\#',
    '_': r'\_',
    '{': r'\{',
    '}': r'\}',
    '<': r'{\textless}',
    '>': r'{\textgreater}',
    '~': r'\textasciitilde{}',
    r'\^': r'\textasciicircum{}',
    r'\\': r'\textbackslash{}',
    # References:
    r'@(\w+:[\w\_\-]+)': r'\ref{\g<1>}'
}
