# Pyladoc

## Description
Pyladoc is a python package for programmatically generating HTML and
PDF/LaTex output. This package targets specifically applications where reports
or results with Pandas-tables and Matplotlib-figures are generated programmatically
to be displayed as website and as PDF document without any manual formatting
steps.

This package focuses on the "Document in Code" approach for cases
where a lot of calculations and data handling is done but not a lot of
document text needs to be displayed.

As backend for PDF generation LaTex is used. There are excellent engines for
rendering HTML to PDF available, but even if there is no requirement for an
accurate typesetting, placing programmatically content of variable
composition and sizes on fixed size pages without manual intervention
is a hard problem that LaTeX is very capable of.

### Sported primitives
- Text (can be Markdown or HTML formatted)
- Headings
- Tables (Pandas, Markdown or HTML)
- Matplotlib figures
- LaTex equations
- Named references for figures, tables and equation

### Key Features
- HTML and PDF/LaTex rendering of the same document
- Single file output including figures
- Figure and equation embedding in HTML by inline SVG, SVG in Base64 or PNG in Base64
- Figure embedding in LaTex as PGF/TikZ

### Usage Scenarios
- Webservices
- Report generation for lab equipment

## Installation
It can be installed with pip:

```bash
pip install pyladoc
```

## Usage
It is easy to use as the following example code shows:

```python
import pyladoc

doc = pyladoc.DocumentWriter()

doc.add_markdown("""
    # Example
    This is an example. The @table:pandas_example shows some random data.
    """)

some_data = {
    'Row1': ["Line1", "Line2", "Line3"],
    'Row2': [120, 100, 110],
    'Row3': ['12 g/km', '> 150 g/km', '110 g/km']
}
df = pd.DataFrame(some_data)
dw.add_table(df, 'This is a pandas example table', 'pandas_example')

html_code = doc.to_html()

doc.to_pdf('test.pdf')
```

## Example outputs
The following documents are generated by tests/test_rendering_example_doc.py:

- HTML: [test_html_render.html](https://html-preview.github.io/?url=https://github.com/Nonannet/pyladoc/blob/main/tests/out/test_html_render.html)
- PDF: [test_latex_render.pdf](https://raw.githubusercontent.com/Nonannet/pyladoc/refs/heads/main/tests/out/test_latex_render.pdf)

## Contributing
Contributions are welcome, please open an issue or submit a pull request on GitHub.

## Developer Guide
To get started with developing the `pyladoc` package, follow these steps.

First, clone the repository to your local machine using Git:

```bash
git clone https://github.com/Nonannet/pyladoc.git
cd pyladoc
```

It's recommended to setup an venv:

```bash
python -m venv venv
source venv/bin/activate  # On Windows use `venv\Scripts\activate`
```

Install the package and dev-dependencies while keeping files in the
current directory:

```bash
pip install -e .[dev]
```

Ensure that everything is set up correctly by running the tests:

```bash
pytest
```
   
## License
This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.