# Generated by Django 2.0 on 2018-01-25 17:39

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("spectator_events", "0011_auto_20180125_1348"),
    ]

    operations = [
        migrations.CreateModel(
            name="ClassicalWorkSelection",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.PositiveSmallIntegerField(
                        default=1, help_text="Position on the Event programme."
                    ),
                ),
                (
                    "classical_work",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="events",
                        to="spectator_events.ClassicalWork",
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="classical_work_selections",
                        to="spectator_events.Event",
                    ),
                ),
            ],
            options={
                "verbose_name": "classical work selection",
                "ordering": ("order",),
            },
        ),
        migrations.CreateModel(
            name="DancePieceSelection",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.PositiveSmallIntegerField(
                        default=1, help_text="Position on the Event programme."
                    ),
                ),
                (
                    "dance_piece",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="events",
                        to="spectator_events.DancePiece",
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dance_piece_selections",
                        to="spectator_events.Event",
                    ),
                ),
            ],
            options={"verbose_name": "dance piece selection", "ordering": ("order",)},
        ),
        migrations.AddField(
            model_name="event",
            name="classicalworks2",
            field=models.ManyToManyField(
                blank=True,
                help_text="Only used if event is of 'Classical Concert' kind.",
                related_name="event_set_2",
                through="spectator_events.ClassicalWorkSelection",
                to="spectator_events.ClassicalWork",
            ),
        ),
        migrations.AddField(
            model_name="event",
            name="dancepieces2",
            field=models.ManyToManyField(
                blank=True,
                help_text="Only used if event is of 'Dance' kind.",
                related_name="event_set_2",
                through="spectator_events.DancePieceSelection",
                to="spectator_events.DancePiece",
            ),
        ),
    ]
