![Python CI](https://github.com/Liam-Deacon/alice_and_bob/workflows/Python%20package/badge.svg)

<!--lint disable no-inline-padding-->

[![ ](https://github.com/liam-deacon/alice_and_bob/workflows/Python%20CI/badge.svg)](https://github.com/liam-deacon/alice_and_bob/actions?query=workflow%3A"Python+CI")
[![ ](https://img.shields.io/pypi/pyversions/alice_and_bob.svg?logo=python)](https://pypi.org/pypi/alice_and_bob/)
[![ ](https://img.shields.io/pypi/l/alice_and_bob.svg)](https://pypi.org/pypi/alice_and_bob/)
[![ ](https://img.shields.io/pypi/implementation/alice_and_bob?color=seagreen)](https://pypi.org/pypi/alice_and_bob/)
[![ ](https://img.shields.io/pypi/dm/alice_and_bob.svg?color=yellow)](https://pypi.org/pypi/alice_and_bob/)
[![ ](https://coveralls.io/repos/github/Liam-Deacon/alice_and_bob/badge.svg?branch=master)](https://coveralls.io/github/Liam-Deacon/alice_and_bob?branch=master)
[![ ](https://codecov.io/gh/Liam-Deacon/alice_and_bob/branch/master/graph/badge.svg)](https://codecov.io/gh/Liam-Deacon/alice_and_bob)
[![ ](https://api.codacy.com/project/badge/Grade/de571d98b5ed4203b6eda5f927c8835d)](https://www.codacy.com/gh/Liam-Deacon/alice_and_bob?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=Liam-Deacon/alice_and_bob&amp;utm_campaign=Badge_Grade)
[![ ](https://coveralls.io/github/Liam-Deacon/alice_and_bob)](https://www.codefactor.io/repository/github/Liam-Deacon/alice_and_bob)
![ ](https://img.shields.io/pypi/v/alice_and_bob)
[![ ](https://img.shields.io/badge/Donate-buy%20me%20a%20coffee-green?logo=Buy%20me%20a%20coffee&logoColor=white)](https://ko-fi.com/lightbytes)
![ ](https://img.shields.io/badge/dev-Open%20in%20Gitpod-blue?logo=gitpod&link=https://gitpod.io/#https://github.com/liam-deacon/alice_and_bob)
[![ ](https://camo.githubusercontent.com/52feade06f2fecbf006889a904d221e6a730c194/68747470733a2f2f636f6c61622e72657365617263682e676f6f676c652e636f6d2f6173736574732f636f6c61622d62616467652e737667)](https://colab.research.google.com/github/liam-deacon/alice_and_bob)
[![ ](https://img.shields.io/badge/Binder%20Launch:-Jupyter%20Lab-blue.svg?colorA=&logo=data:image/png;base64,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)](https://mybinder.org/v2/gh/Liam-Deacon/alice_and_bob/master?urlpath=lab)

<!--lint enable no-inline-padding-->

# Alice and Bob information sharing code challenge
Diffie-Hellman coding challenge for secret information exchange using public/private keys

## Background

Alice and Bob use the Diffie-Hellman key exchange algorithm to share secret information. Alice and Bob start with prime numbers, pick private keys, generate and share public keys, finally they then generate a shared secret key.

Your code module should take in two prime numbers, **p** and **g** and output the value of p and g, the private key a for Alice and b for Bob. Finally your program should print out the Shared Secret key for Alice and Bob.

If your implementation is correct, the Shared Secret keys should match.

Note: This challenge requires you to perform calculations on large numbers. Further information can be found at 
https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange

## Code requirements

  - Ensure that your code is clean and uses good practice (e.g. error handling) and is commented well.
  - Ensure that your code can work cross platform and across different versions of Python.
  - Feel free to add as many bells and whistles as you so desired (e.g. Unit Tests)

## Running the code

```bash
git clone https://github.com/Liam-Deacon/alice_and_bob
cd alice_and_bob
python3 -m alice_and_bob.key_share --help
```

### CLI Example

```bash
$ python3 -m alice_and_bob.key_share -p 61 -g 53
Shared secret key: 60
```

It is also possible to specify the number of bits used for the generated private keys:

```bash
$ python3 -m alice_and_bob.key_share -p 88937 -g 104729  --bits=2048
Shared secret key: 39885
```

### Python Example

```python
>>> from alice_and_bob.key_share import main as code
>>> code(p=2, g=3)  # only one possibility as primes very small
Shared secret key: 1
>>> code(61, 53)
Shared secret key: 34
>>> code(61, 53)
Shared secret key: 37
>>> code(61, 53)
Shared secret key: 9
>>> code(61, 53)
Shared secret key: 11
```
