# xepmts
API for the XENON PMT database

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.2
- Package version: 0.3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pmts.xenonnt.org](https://pmts.xenonnt.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/XENONnT/pmts-api-client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/XENONnT/pmts-api-client.git`)

Then import the package:
```python
import xepmts
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import xepmts
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import xepmts
from xepmts.rest import ApiException
from pprint import pprint

configuration = xepmts.Configuration()
# Configure Bearer authorization: BearerAuth
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.pmts.xenonnt.org/v1
configuration.host = "https://api.pmts.xenonnt.org/v1"

# Defining host is optional and default to https://api.pmts.xenonnt.org/v1
configuration.host = "https://api.pmts.xenonnt.org/v1"
# Enter a context with an instance of the API client
with xepmts.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = xepmts.AccountApi(api_client)
    account_id = 'account_id_example' # str | 
if_match = 'if_match_example' # str | Current value of the _etag field (optional)

    try:
        # Deletes a Account document
        api_instance.delete_account_item(account_id, if_match=if_match)
    except ApiException as e:
        print("Exception when calling AccountApi->delete_account_item: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.pmts.xenonnt.org/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**delete_account_item**](docs/AccountApi.md#delete_account_item) | **DELETE** /accounts/{accountId} | Deletes a Account document
*AccountApi* | [**get_account_item**](docs/AccountApi.md#get_account_item) | **GET** /accounts/{accountId} | Retrieves a Account document
*AccountApi* | [**get_account_item_by_username**](docs/AccountApi.md#get_account_item_by_username) | **GET** /accounts/{Username} | Retrieves a Account document by username
*AccountApi* | [**get_accounts**](docs/AccountApi.md#get_accounts) | **GET** /accounts | Retrieves one or more Accounts
*AccountApi* | [**post_accounts**](docs/AccountApi.md#post_accounts) | **POST** /accounts | Stores one or more Accounts.
*AccountApi* | [**put_account_item**](docs/AccountApi.md#put_account_item) | **PUT** /accounts/{accountId} | Replaces a Account document
*HighVoltageChangeApi* | [**delete_high_voltage_change_item**](docs/HighVoltageChangeApi.md#delete_high_voltage_change_item) | **DELETE** /hv_changes/{highvoltagechangeId} | Deletes a HighVoltageChange document
*HighVoltageChangeApi* | [**get_high_voltage_change_item**](docs/HighVoltageChangeApi.md#get_high_voltage_change_item) | **GET** /hv_changes/{highvoltagechangeId} | Retrieves a HighVoltageChange document
*HighVoltageChangeApi* | [**get_high_voltage_changes**](docs/HighVoltageChangeApi.md#get_high_voltage_changes) | **GET** /hv_changes | Retrieves one or more HighVoltageChanges
*HighVoltageChangeApi* | [**post_high_voltage_changes**](docs/HighVoltageChangeApi.md#post_high_voltage_changes) | **POST** /hv_changes | Stores one or more HighVoltageChanges.
*HighVoltageChangeApi* | [**put_high_voltage_change_item**](docs/HighVoltageChangeApi.md#put_high_voltage_change_item) | **PUT** /hv_changes/{highvoltagechangeId} | Replaces a HighVoltageChange document
*MuvetoAfterpulseApi* | [**delete_muveto_afterpulse_item**](docs/MuvetoAfterpulseApi.md#delete_muveto_afterpulse_item) | **DELETE** /muveto/afterpules/{muvetoafterpulseId} | Deletes a MuvetoAfterpulse document
*MuvetoAfterpulseApi* | [**get_muveto_afterpulse_item**](docs/MuvetoAfterpulseApi.md#get_muveto_afterpulse_item) | **GET** /muveto/afterpules/{muvetoafterpulseId} | Retrieves a MuvetoAfterpulse document
*MuvetoAfterpulseApi* | [**get_muveto_afterpulses**](docs/MuvetoAfterpulseApi.md#get_muveto_afterpulses) | **GET** /muveto/afterpules | Retrieves one or more MuvetoAfterpulses
*MuvetoAfterpulseApi* | [**post_muveto_afterpulses**](docs/MuvetoAfterpulseApi.md#post_muveto_afterpulses) | **POST** /muveto/afterpules | Stores one or more MuvetoAfterpulses.
*MuvetoAfterpulseApi* | [**put_muveto_afterpulse_item**](docs/MuvetoAfterpulseApi.md#put_muveto_afterpulse_item) | **PUT** /muveto/afterpules/{muvetoafterpulseId} | Replaces a MuvetoAfterpulse document
*MuvetoAfterpulse1tApi* | [**delete_muveto_afterpulse1t_item**](docs/MuvetoAfterpulse1tApi.md#delete_muveto_afterpulse1t_item) | **DELETE** /xenon1t/muveto/afterpules/{muvetoafterpulse1tId} | Deletes a MuvetoAfterpulse1t document
*MuvetoAfterpulse1tApi* | [**get_muveto_afterpulse1t_item**](docs/MuvetoAfterpulse1tApi.md#get_muveto_afterpulse1t_item) | **GET** /xenon1t/muveto/afterpules/{muvetoafterpulse1tId} | Retrieves a MuvetoAfterpulse1t document
*MuvetoAfterpulse1tApi* | [**get_muveto_afterpulse1ts**](docs/MuvetoAfterpulse1tApi.md#get_muveto_afterpulse1ts) | **GET** /xenon1t/muveto/afterpules | Retrieves one or more MuvetoAfterpulse1ts
*MuvetoAfterpulse1tApi* | [**post_muveto_afterpulse1ts**](docs/MuvetoAfterpulse1tApi.md#post_muveto_afterpulse1ts) | **POST** /xenon1t/muveto/afterpules | Stores one or more MuvetoAfterpulse1ts.
*MuvetoAfterpulse1tApi* | [**put_muveto_afterpulse1t_item**](docs/MuvetoAfterpulse1tApi.md#put_muveto_afterpulse1t_item) | **PUT** /xenon1t/muveto/afterpules/{muvetoafterpulse1tId} | Replaces a MuvetoAfterpulse1t document
*MuvetoCurrentChangeApi* | [**delete_muveto_current_change_item**](docs/MuvetoCurrentChangeApi.md#delete_muveto_current_change_item) | **DELETE** /muveto/current_changes/{muvetocurrentchangeId} | Deletes a MuvetoCurrentChange document
*MuvetoCurrentChangeApi* | [**get_muveto_current_change_item**](docs/MuvetoCurrentChangeApi.md#get_muveto_current_change_item) | **GET** /muveto/current_changes/{muvetocurrentchangeId} | Retrieves a MuvetoCurrentChange document
*MuvetoCurrentChangeApi* | [**get_muveto_current_changes**](docs/MuvetoCurrentChangeApi.md#get_muveto_current_changes) | **GET** /muveto/current_changes | Retrieves one or more MuvetoCurrentChanges
*MuvetoCurrentChangeApi* | [**post_muveto_current_changes**](docs/MuvetoCurrentChangeApi.md#post_muveto_current_changes) | **POST** /muveto/current_changes | Stores one or more MuvetoCurrentChanges.
*MuvetoCurrentChangeApi* | [**put_muveto_current_change_item**](docs/MuvetoCurrentChangeApi.md#put_muveto_current_change_item) | **PUT** /muveto/current_changes/{muvetocurrentchangeId} | Replaces a MuvetoCurrentChange document
*MuvetoCurrentChange1tApi* | [**delete_muveto_current_change1t_item**](docs/MuvetoCurrentChange1tApi.md#delete_muveto_current_change1t_item) | **DELETE** /xenon1t/muveto/current_changes/{muvetocurrentchange1tId} | Deletes a MuvetoCurrentChange1t document
*MuvetoCurrentChange1tApi* | [**get_muveto_current_change1t_item**](docs/MuvetoCurrentChange1tApi.md#get_muveto_current_change1t_item) | **GET** /xenon1t/muveto/current_changes/{muvetocurrentchange1tId} | Retrieves a MuvetoCurrentChange1t document
*MuvetoCurrentChange1tApi* | [**get_muveto_current_change1ts**](docs/MuvetoCurrentChange1tApi.md#get_muveto_current_change1ts) | **GET** /xenon1t/muveto/current_changes | Retrieves one or more MuvetoCurrentChange1ts
*MuvetoCurrentChange1tApi* | [**post_muveto_current_change1ts**](docs/MuvetoCurrentChange1tApi.md#post_muveto_current_change1ts) | **POST** /xenon1t/muveto/current_changes | Stores one or more MuvetoCurrentChange1ts.
*MuvetoCurrentChange1tApi* | [**put_muveto_current_change1t_item**](docs/MuvetoCurrentChange1tApi.md#put_muveto_current_change1t_item) | **PUT** /xenon1t/muveto/current_changes/{muvetocurrentchange1tId} | Replaces a MuvetoCurrentChange1t document
*MuvetoDarkCountRateApi* | [**delete_muveto_dark_count_rate_item**](docs/MuvetoDarkCountRateApi.md#delete_muveto_dark_count_rate_item) | **DELETE** /muveto/dark_counts_rates/{muvetodarkcountrateId} | Deletes a MuvetoDarkCountRate document
*MuvetoDarkCountRateApi* | [**get_muveto_dark_count_rate_item**](docs/MuvetoDarkCountRateApi.md#get_muveto_dark_count_rate_item) | **GET** /muveto/dark_counts_rates/{muvetodarkcountrateId} | Retrieves a MuvetoDarkCountRate document
*MuvetoDarkCountRateApi* | [**get_muveto_dark_count_rates**](docs/MuvetoDarkCountRateApi.md#get_muveto_dark_count_rates) | **GET** /muveto/dark_counts_rates | Retrieves one or more MuvetoDarkCountRates
*MuvetoDarkCountRateApi* | [**post_muveto_dark_count_rates**](docs/MuvetoDarkCountRateApi.md#post_muveto_dark_count_rates) | **POST** /muveto/dark_counts_rates | Stores one or more MuvetoDarkCountRates.
*MuvetoDarkCountRateApi* | [**put_muveto_dark_count_rate_item**](docs/MuvetoDarkCountRateApi.md#put_muveto_dark_count_rate_item) | **PUT** /muveto/dark_counts_rates/{muvetodarkcountrateId} | Replaces a MuvetoDarkCountRate document
*MuvetoDarkCountRate1tApi* | [**delete_muveto_dark_count_rate1t_item**](docs/MuvetoDarkCountRate1tApi.md#delete_muveto_dark_count_rate1t_item) | **DELETE** /xenon1t/muveto/dark_counts_rates/{muvetodarkcountrate1tId} | Deletes a MuvetoDarkCountRate1t document
*MuvetoDarkCountRate1tApi* | [**get_muveto_dark_count_rate1t_item**](docs/MuvetoDarkCountRate1tApi.md#get_muveto_dark_count_rate1t_item) | **GET** /xenon1t/muveto/dark_counts_rates/{muvetodarkcountrate1tId} | Retrieves a MuvetoDarkCountRate1t document
*MuvetoDarkCountRate1tApi* | [**get_muveto_dark_count_rate1ts**](docs/MuvetoDarkCountRate1tApi.md#get_muveto_dark_count_rate1ts) | **GET** /xenon1t/muveto/dark_counts_rates | Retrieves one or more MuvetoDarkCountRate1ts
*MuvetoDarkCountRate1tApi* | [**post_muveto_dark_count_rate1ts**](docs/MuvetoDarkCountRate1tApi.md#post_muveto_dark_count_rate1ts) | **POST** /xenon1t/muveto/dark_counts_rates | Stores one or more MuvetoDarkCountRate1ts.
*MuvetoDarkCountRate1tApi* | [**put_muveto_dark_count_rate1t_item**](docs/MuvetoDarkCountRate1tApi.md#put_muveto_dark_count_rate1t_item) | **PUT** /xenon1t/muveto/dark_counts_rates/{muvetodarkcountrate1tId} | Replaces a MuvetoDarkCountRate1t document
*MuvetoGainApi* | [**delete_muveto_gain_item**](docs/MuvetoGainApi.md#delete_muveto_gain_item) | **DELETE** /muveto/gains/{muvetogainId} | Deletes a MuvetoGain document
*MuvetoGainApi* | [**get_muveto_gain_item**](docs/MuvetoGainApi.md#get_muveto_gain_item) | **GET** /muveto/gains/{muvetogainId} | Retrieves a MuvetoGain document
*MuvetoGainApi* | [**get_muveto_gains**](docs/MuvetoGainApi.md#get_muveto_gains) | **GET** /muveto/gains | Retrieves one or more MuvetoGains
*MuvetoGainApi* | [**post_muveto_gains**](docs/MuvetoGainApi.md#post_muveto_gains) | **POST** /muveto/gains | Stores one or more MuvetoGains.
*MuvetoGainApi* | [**put_muveto_gain_item**](docs/MuvetoGainApi.md#put_muveto_gain_item) | **PUT** /muveto/gains/{muvetogainId} | Replaces a MuvetoGain document
*MuvetoGain1tApi* | [**delete_muveto_gain1t_item**](docs/MuvetoGain1tApi.md#delete_muveto_gain1t_item) | **DELETE** /xenon1t/muveto/gains/{muvetogain1tId} | Deletes a MuvetoGain1t document
*MuvetoGain1tApi* | [**get_muveto_gain1t_item**](docs/MuvetoGain1tApi.md#get_muveto_gain1t_item) | **GET** /xenon1t/muveto/gains/{muvetogain1tId} | Retrieves a MuvetoGain1t document
*MuvetoGain1tApi* | [**get_muveto_gain1ts**](docs/MuvetoGain1tApi.md#get_muveto_gain1ts) | **GET** /xenon1t/muveto/gains | Retrieves one or more MuvetoGain1ts
*MuvetoGain1tApi* | [**post_muveto_gain1ts**](docs/MuvetoGain1tApi.md#post_muveto_gain1ts) | **POST** /xenon1t/muveto/gains | Stores one or more MuvetoGain1ts.
*MuvetoGain1tApi* | [**put_muveto_gain1t_item**](docs/MuvetoGain1tApi.md#put_muveto_gain1t_item) | **PUT** /xenon1t/muveto/gains/{muvetogain1tId} | Replaces a MuvetoGain1t document
*MuvetoGainMeasurementApi* | [**delete_muveto_gain_measurement_item**](docs/MuvetoGainMeasurementApi.md#delete_muveto_gain_measurement_item) | **DELETE** /muveto/gain_measurements/{muvetogainmeasurementId} | Deletes a MuvetoGainMeasurement document
*MuvetoGainMeasurementApi* | [**get_muveto_gain_measurement_item**](docs/MuvetoGainMeasurementApi.md#get_muveto_gain_measurement_item) | **GET** /muveto/gain_measurements/{muvetogainmeasurementId} | Retrieves a MuvetoGainMeasurement document
*MuvetoGainMeasurementApi* | [**get_muveto_gain_measurements**](docs/MuvetoGainMeasurementApi.md#get_muveto_gain_measurements) | **GET** /muveto/gain_measurements | Retrieves one or more MuvetoGainMeasurements
*MuvetoGainMeasurementApi* | [**post_muveto_gain_measurements**](docs/MuvetoGainMeasurementApi.md#post_muveto_gain_measurements) | **POST** /muveto/gain_measurements | Stores one or more MuvetoGainMeasurements.
*MuvetoGainMeasurementApi* | [**put_muveto_gain_measurement_item**](docs/MuvetoGainMeasurementApi.md#put_muveto_gain_measurement_item) | **PUT** /muveto/gain_measurements/{muvetogainmeasurementId} | Replaces a MuvetoGainMeasurement document
*MuvetoGainMeasurement1tApi* | [**delete_muveto_gain_measurement1t_item**](docs/MuvetoGainMeasurement1tApi.md#delete_muveto_gain_measurement1t_item) | **DELETE** /xenon1t/muveto/gain_measurements/{muvetogainmeasurement1tId} | Deletes a MuvetoGainMeasurement1t document
*MuvetoGainMeasurement1tApi* | [**get_muveto_gain_measurement1t_item**](docs/MuvetoGainMeasurement1tApi.md#get_muveto_gain_measurement1t_item) | **GET** /xenon1t/muveto/gain_measurements/{muvetogainmeasurement1tId} | Retrieves a MuvetoGainMeasurement1t document
*MuvetoGainMeasurement1tApi* | [**get_muveto_gain_measurement1ts**](docs/MuvetoGainMeasurement1tApi.md#get_muveto_gain_measurement1ts) | **GET** /xenon1t/muveto/gain_measurements | Retrieves one or more MuvetoGainMeasurement1ts
*MuvetoGainMeasurement1tApi* | [**post_muveto_gain_measurement1ts**](docs/MuvetoGainMeasurement1tApi.md#post_muveto_gain_measurement1ts) | **POST** /xenon1t/muveto/gain_measurements | Stores one or more MuvetoGainMeasurement1ts.
*MuvetoGainMeasurement1tApi* | [**put_muveto_gain_measurement1t_item**](docs/MuvetoGainMeasurement1tApi.md#put_muveto_gain_measurement1t_item) | **PUT** /xenon1t/muveto/gain_measurements/{muvetogainmeasurement1tId} | Replaces a MuvetoGainMeasurement1t document
*MuvetoGainModelApi* | [**delete_muveto_gain_model_item**](docs/MuvetoGainModelApi.md#delete_muveto_gain_model_item) | **DELETE** /muveto/gain_models/{muvetogainmodelId} | Deletes a MuvetoGainModel document
*MuvetoGainModelApi* | [**get_muveto_gain_model_item**](docs/MuvetoGainModelApi.md#get_muveto_gain_model_item) | **GET** /muveto/gain_models/{muvetogainmodelId} | Retrieves a MuvetoGainModel document
*MuvetoGainModelApi* | [**get_muveto_gain_models**](docs/MuvetoGainModelApi.md#get_muveto_gain_models) | **GET** /muveto/gain_models | Retrieves one or more MuvetoGainModels
*MuvetoGainModelApi* | [**post_muveto_gain_models**](docs/MuvetoGainModelApi.md#post_muveto_gain_models) | **POST** /muveto/gain_models | Stores one or more MuvetoGainModels.
*MuvetoGainModelApi* | [**put_muveto_gain_model_item**](docs/MuvetoGainModelApi.md#put_muveto_gain_model_item) | **PUT** /muveto/gain_models/{muvetogainmodelId} | Replaces a MuvetoGainModel document
*MuvetoGainModel1tApi* | [**delete_muveto_gain_model1t_item**](docs/MuvetoGainModel1tApi.md#delete_muveto_gain_model1t_item) | **DELETE** /xenon1t/muveto/gain_models/{muvetogainmodel1tId} | Deletes a MuvetoGainModel1t document
*MuvetoGainModel1tApi* | [**get_muveto_gain_model1t_item**](docs/MuvetoGainModel1tApi.md#get_muveto_gain_model1t_item) | **GET** /xenon1t/muveto/gain_models/{muvetogainmodel1tId} | Retrieves a MuvetoGainModel1t document
*MuvetoGainModel1tApi* | [**get_muveto_gain_model1ts**](docs/MuvetoGainModel1tApi.md#get_muveto_gain_model1ts) | **GET** /xenon1t/muveto/gain_models | Retrieves one or more MuvetoGainModel1ts
*MuvetoGainModel1tApi* | [**post_muveto_gain_model1ts**](docs/MuvetoGainModel1tApi.md#post_muveto_gain_model1ts) | **POST** /xenon1t/muveto/gain_models | Stores one or more MuvetoGainModel1ts.
*MuvetoGainModel1tApi* | [**put_muveto_gain_model1t_item**](docs/MuvetoGainModel1tApi.md#put_muveto_gain_model1t_item) | **PUT** /xenon1t/muveto/gain_models/{muvetogainmodel1tId} | Replaces a MuvetoGainModel1t document
*MuvetoInstallApi* | [**delete_muveto_install_item**](docs/MuvetoInstallApi.md#delete_muveto_install_item) | **DELETE** /muveto/installs/{muvetoinstallId} | Deletes a MuvetoInstall document
*MuvetoInstallApi* | [**get_muveto_install_item**](docs/MuvetoInstallApi.md#get_muveto_install_item) | **GET** /muveto/installs/{muvetoinstallId} | Retrieves a MuvetoInstall document
*MuvetoInstallApi* | [**get_muveto_install_item_by_uid**](docs/MuvetoInstallApi.md#get_muveto_install_item_by_uid) | **GET** /muveto/installs/{Uid} | Retrieves a MuvetoInstall document by uid
*MuvetoInstallApi* | [**get_muveto_installs**](docs/MuvetoInstallApi.md#get_muveto_installs) | **GET** /muveto/installs | Retrieves one or more MuvetoInstalls
*MuvetoInstallApi* | [**post_muveto_installs**](docs/MuvetoInstallApi.md#post_muveto_installs) | **POST** /muveto/installs | Stores one or more MuvetoInstalls.
*MuvetoInstallApi* | [**put_muveto_install_item**](docs/MuvetoInstallApi.md#put_muveto_install_item) | **PUT** /muveto/installs/{muvetoinstallId} | Replaces a MuvetoInstall document
*MuvetoInstall1tApi* | [**delete_muveto_install1t_item**](docs/MuvetoInstall1tApi.md#delete_muveto_install1t_item) | **DELETE** /xenon1t/muveto/installs/{muvetoinstall1tId} | Deletes a MuvetoInstall1t document
*MuvetoInstall1tApi* | [**get_muveto_install1t_item**](docs/MuvetoInstall1tApi.md#get_muveto_install1t_item) | **GET** /xenon1t/muveto/installs/{muvetoinstall1tId} | Retrieves a MuvetoInstall1t document
*MuvetoInstall1tApi* | [**get_muveto_install1t_item_by_uid**](docs/MuvetoInstall1tApi.md#get_muveto_install1t_item_by_uid) | **GET** /xenon1t/muveto/installs/{Uid} | Retrieves a MuvetoInstall1t document by uid
*MuvetoInstall1tApi* | [**get_muveto_install1ts**](docs/MuvetoInstall1tApi.md#get_muveto_install1ts) | **GET** /xenon1t/muveto/installs | Retrieves one or more MuvetoInstall1ts
*MuvetoInstall1tApi* | [**post_muveto_install1ts**](docs/MuvetoInstall1tApi.md#post_muveto_install1ts) | **POST** /xenon1t/muveto/installs | Stores one or more MuvetoInstall1ts.
*MuvetoInstall1tApi* | [**put_muveto_install1t_item**](docs/MuvetoInstall1tApi.md#put_muveto_install1t_item) | **PUT** /xenon1t/muveto/installs/{muvetoinstall1tId} | Replaces a MuvetoInstall1t document
*MuvetoPmtApi* | [**delete_muveto_pmt_item**](docs/MuvetoPmtApi.md#delete_muveto_pmt_item) | **DELETE** /muveto/pmts/{muvetopmtId} | Deletes a MuvetoPmt document
*MuvetoPmtApi* | [**get_muveto_pmt_item**](docs/MuvetoPmtApi.md#get_muveto_pmt_item) | **GET** /muveto/pmts/{muvetopmtId} | Retrieves a MuvetoPmt document
*MuvetoPmtApi* | [**get_muveto_pmt_item_by_serial_number**](docs/MuvetoPmtApi.md#get_muveto_pmt_item_by_serial_number) | **GET** /muveto/pmts/{Serial_Number} | Retrieves a MuvetoPmt document by serial_number
*MuvetoPmtApi* | [**get_muveto_pmts**](docs/MuvetoPmtApi.md#get_muveto_pmts) | **GET** /muveto/pmts | Retrieves one or more MuvetoPmts
*MuvetoPmtApi* | [**post_muveto_pmts**](docs/MuvetoPmtApi.md#post_muveto_pmts) | **POST** /muveto/pmts | Stores one or more MuvetoPmts.
*MuvetoPmtApi* | [**put_muveto_pmt_item**](docs/MuvetoPmtApi.md#put_muveto_pmt_item) | **PUT** /muveto/pmts/{muvetopmtId} | Replaces a MuvetoPmt document
*MuvetoPmt1tApi* | [**delete_muveto_pmt1t_item**](docs/MuvetoPmt1tApi.md#delete_muveto_pmt1t_item) | **DELETE** /xenon1t/muveto/pmts/{muvetopmt1tId} | Deletes a MuvetoPmt1t document
*MuvetoPmt1tApi* | [**get_muveto_pmt1t_item**](docs/MuvetoPmt1tApi.md#get_muveto_pmt1t_item) | **GET** /xenon1t/muveto/pmts/{muvetopmt1tId} | Retrieves a MuvetoPmt1t document
*MuvetoPmt1tApi* | [**get_muveto_pmt1t_item_by_serial_number**](docs/MuvetoPmt1tApi.md#get_muveto_pmt1t_item_by_serial_number) | **GET** /xenon1t/muveto/pmts/{Serial_Number} | Retrieves a MuvetoPmt1t document by serial_number
*MuvetoPmt1tApi* | [**get_muveto_pmt1ts**](docs/MuvetoPmt1tApi.md#get_muveto_pmt1ts) | **GET** /xenon1t/muveto/pmts | Retrieves one or more MuvetoPmt1ts
*MuvetoPmt1tApi* | [**post_muveto_pmt1ts**](docs/MuvetoPmt1tApi.md#post_muveto_pmt1ts) | **POST** /xenon1t/muveto/pmts | Stores one or more MuvetoPmt1ts.
*MuvetoPmt1tApi* | [**put_muveto_pmt1t_item**](docs/MuvetoPmt1tApi.md#put_muveto_pmt1t_item) | **PUT** /xenon1t/muveto/pmts/{muvetopmt1tId} | Replaces a MuvetoPmt1t document
*MuvetoPmtErrorApi* | [**delete_muveto_pmt_error_item**](docs/MuvetoPmtErrorApi.md#delete_muveto_pmt_error_item) | **DELETE** /muveto/pmt_errors/{muvetopmterrorId} | Deletes a MuvetoPmtError document
*MuvetoPmtErrorApi* | [**get_muveto_pmt_error_item**](docs/MuvetoPmtErrorApi.md#get_muveto_pmt_error_item) | **GET** /muveto/pmt_errors/{muvetopmterrorId} | Retrieves a MuvetoPmtError document
*MuvetoPmtErrorApi* | [**get_muveto_pmt_errors**](docs/MuvetoPmtErrorApi.md#get_muveto_pmt_errors) | **GET** /muveto/pmt_errors | Retrieves one or more MuvetoPmtErrors
*MuvetoPmtErrorApi* | [**post_muveto_pmt_errors**](docs/MuvetoPmtErrorApi.md#post_muveto_pmt_errors) | **POST** /muveto/pmt_errors | Stores one or more MuvetoPmtErrors.
*MuvetoPmtErrorApi* | [**put_muveto_pmt_error_item**](docs/MuvetoPmtErrorApi.md#put_muveto_pmt_error_item) | **PUT** /muveto/pmt_errors/{muvetopmterrorId} | Replaces a MuvetoPmtError document
*MuvetoPmtError1tApi* | [**delete_muveto_pmt_error1t_item**](docs/MuvetoPmtError1tApi.md#delete_muveto_pmt_error1t_item) | **DELETE** /xenon1t/muveto/pmt_errors/{muvetopmterror1tId} | Deletes a MuvetoPmtError1t document
*MuvetoPmtError1tApi* | [**get_muveto_pmt_error1t_item**](docs/MuvetoPmtError1tApi.md#get_muveto_pmt_error1t_item) | **GET** /xenon1t/muveto/pmt_errors/{muvetopmterror1tId} | Retrieves a MuvetoPmtError1t document
*MuvetoPmtError1tApi* | [**get_muveto_pmt_error1ts**](docs/MuvetoPmtError1tApi.md#get_muveto_pmt_error1ts) | **GET** /xenon1t/muveto/pmt_errors | Retrieves one or more MuvetoPmtError1ts
*MuvetoPmtError1tApi* | [**post_muveto_pmt_error1ts**](docs/MuvetoPmtError1tApi.md#post_muveto_pmt_error1ts) | **POST** /xenon1t/muveto/pmt_errors | Stores one or more MuvetoPmtError1ts.
*MuvetoPmtError1tApi* | [**put_muveto_pmt_error1t_item**](docs/MuvetoPmtError1tApi.md#put_muveto_pmt_error1t_item) | **PUT** /xenon1t/muveto/pmt_errors/{muvetopmterror1tId} | Replaces a MuvetoPmtError1t document
*MuvetoVoltageChangeApi* | [**delete_muveto_voltage_change_item**](docs/MuvetoVoltageChangeApi.md#delete_muveto_voltage_change_item) | **DELETE** /muveto/voltage_changes/{muvetovoltagechangeId} | Deletes a MuvetoVoltageChange document
*MuvetoVoltageChangeApi* | [**get_muveto_voltage_change_item**](docs/MuvetoVoltageChangeApi.md#get_muveto_voltage_change_item) | **GET** /muveto/voltage_changes/{muvetovoltagechangeId} | Retrieves a MuvetoVoltageChange document
*MuvetoVoltageChangeApi* | [**get_muveto_voltage_changes**](docs/MuvetoVoltageChangeApi.md#get_muveto_voltage_changes) | **GET** /muveto/voltage_changes | Retrieves one or more MuvetoVoltageChanges
*MuvetoVoltageChangeApi* | [**post_muveto_voltage_changes**](docs/MuvetoVoltageChangeApi.md#post_muveto_voltage_changes) | **POST** /muveto/voltage_changes | Stores one or more MuvetoVoltageChanges.
*MuvetoVoltageChangeApi* | [**put_muveto_voltage_change_item**](docs/MuvetoVoltageChangeApi.md#put_muveto_voltage_change_item) | **PUT** /muveto/voltage_changes/{muvetovoltagechangeId} | Replaces a MuvetoVoltageChange document
*MuvetoVoltageChange1tApi* | [**delete_muveto_voltage_change1t_item**](docs/MuvetoVoltageChange1tApi.md#delete_muveto_voltage_change1t_item) | **DELETE** /xenon1t/muveto/voltage_changes/{muvetovoltagechange1tId} | Deletes a MuvetoVoltageChange1t document
*MuvetoVoltageChange1tApi* | [**get_muveto_voltage_change1t_item**](docs/MuvetoVoltageChange1tApi.md#get_muveto_voltage_change1t_item) | **GET** /xenon1t/muveto/voltage_changes/{muvetovoltagechange1tId} | Retrieves a MuvetoVoltageChange1t document
*MuvetoVoltageChange1tApi* | [**get_muveto_voltage_change1ts**](docs/MuvetoVoltageChange1tApi.md#get_muveto_voltage_change1ts) | **GET** /xenon1t/muveto/voltage_changes | Retrieves one or more MuvetoVoltageChange1ts
*MuvetoVoltageChange1tApi* | [**post_muveto_voltage_change1ts**](docs/MuvetoVoltageChange1tApi.md#post_muveto_voltage_change1ts) | **POST** /xenon1t/muveto/voltage_changes | Stores one or more MuvetoVoltageChange1ts.
*MuvetoVoltageChange1tApi* | [**put_muveto_voltage_change1t_item**](docs/MuvetoVoltageChange1tApi.md#put_muveto_voltage_change1t_item) | **PUT** /xenon1t/muveto/voltage_changes/{muvetovoltagechange1tId} | Replaces a MuvetoVoltageChange1t document
*MuvetoVoltageMapApi* | [**delete_muveto_voltage_map_item**](docs/MuvetoVoltageMapApi.md#delete_muveto_voltage_map_item) | **DELETE** /muveto/voltage_maps/{muvetovoltagemapId} | Deletes a MuvetoVoltageMap document
*MuvetoVoltageMapApi* | [**delete_muveto_voltage_maps**](docs/MuvetoVoltageMapApi.md#delete_muveto_voltage_maps) | **DELETE** /muveto/voltage_maps | Deletes all MuvetoVoltageMaps
*MuvetoVoltageMapApi* | [**get_muveto_voltage_map_item**](docs/MuvetoVoltageMapApi.md#get_muveto_voltage_map_item) | **GET** /muveto/voltage_maps/{muvetovoltagemapId} | Retrieves a MuvetoVoltageMap document
*MuvetoVoltageMapApi* | [**get_muveto_voltage_map_item_by_name**](docs/MuvetoVoltageMapApi.md#get_muveto_voltage_map_item_by_name) | **GET** /muveto/voltage_maps/{Name} | Retrieves a MuvetoVoltageMap document by name
*MuvetoVoltageMapApi* | [**get_muveto_voltage_maps**](docs/MuvetoVoltageMapApi.md#get_muveto_voltage_maps) | **GET** /muveto/voltage_maps | Retrieves one or more MuvetoVoltageMaps
*MuvetoVoltageMapApi* | [**post_muveto_voltage_maps**](docs/MuvetoVoltageMapApi.md#post_muveto_voltage_maps) | **POST** /muveto/voltage_maps | Stores one or more MuvetoVoltageMaps.
*MuvetoVoltageMapApi* | [**put_muveto_voltage_map_item**](docs/MuvetoVoltageMapApi.md#put_muveto_voltage_map_item) | **PUT** /muveto/voltage_maps/{muvetovoltagemapId} | Replaces a MuvetoVoltageMap document
*MuvetoVoltageMap1tApi* | [**delete_muveto_voltage_map1t_item**](docs/MuvetoVoltageMap1tApi.md#delete_muveto_voltage_map1t_item) | **DELETE** /xenon1t/muveto/voltage_maps/{muvetovoltagemap1tId} | Deletes a MuvetoVoltageMap1t document
*MuvetoVoltageMap1tApi* | [**delete_muveto_voltage_map1ts**](docs/MuvetoVoltageMap1tApi.md#delete_muveto_voltage_map1ts) | **DELETE** /xenon1t/muveto/voltage_maps | Deletes all MuvetoVoltageMap1ts
*MuvetoVoltageMap1tApi* | [**get_muveto_voltage_map1t_item**](docs/MuvetoVoltageMap1tApi.md#get_muveto_voltage_map1t_item) | **GET** /xenon1t/muveto/voltage_maps/{muvetovoltagemap1tId} | Retrieves a MuvetoVoltageMap1t document
*MuvetoVoltageMap1tApi* | [**get_muveto_voltage_map1t_item_by_name**](docs/MuvetoVoltageMap1tApi.md#get_muveto_voltage_map1t_item_by_name) | **GET** /xenon1t/muveto/voltage_maps/{Name} | Retrieves a MuvetoVoltageMap1t document by name
*MuvetoVoltageMap1tApi* | [**get_muveto_voltage_map1ts**](docs/MuvetoVoltageMap1tApi.md#get_muveto_voltage_map1ts) | **GET** /xenon1t/muveto/voltage_maps | Retrieves one or more MuvetoVoltageMap1ts
*MuvetoVoltageMap1tApi* | [**post_muveto_voltage_map1ts**](docs/MuvetoVoltageMap1tApi.md#post_muveto_voltage_map1ts) | **POST** /xenon1t/muveto/voltage_maps | Stores one or more MuvetoVoltageMap1ts.
*MuvetoVoltageMap1tApi* | [**put_muveto_voltage_map1t_item**](docs/MuvetoVoltageMap1tApi.md#put_muveto_voltage_map1t_item) | **PUT** /xenon1t/muveto/voltage_maps/{muvetovoltagemap1tId} | Replaces a MuvetoVoltageMap1t document
*MuvetoVoltageMapNameApi* | [**get_muveto_voltage_map_names**](docs/MuvetoVoltageMapNameApi.md#get_muveto_voltage_map_names) | **GET** /muveto/voltage_maps/names | Retrieves one or more MuvetoVoltageMapNames
*MuvetoVoltageMapName1tApi* | [**get_muveto_voltage_map_name1ts**](docs/MuvetoVoltageMapName1tApi.md#get_muveto_voltage_map_name1ts) | **GET** /xenon1t/muveto/voltage_maps/names | Retrieves one or more MuvetoVoltageMapName1ts
*NvetoAfterpulseApi* | [**delete_nveto_afterpulse_item**](docs/NvetoAfterpulseApi.md#delete_nveto_afterpulse_item) | **DELETE** /nveto/afterpules/{nvetoafterpulseId} | Deletes a NvetoAfterpulse document
*NvetoAfterpulseApi* | [**get_nveto_afterpulse_item**](docs/NvetoAfterpulseApi.md#get_nveto_afterpulse_item) | **GET** /nveto/afterpules/{nvetoafterpulseId} | Retrieves a NvetoAfterpulse document
*NvetoAfterpulseApi* | [**get_nveto_afterpulses**](docs/NvetoAfterpulseApi.md#get_nveto_afterpulses) | **GET** /nveto/afterpules | Retrieves one or more NvetoAfterpulses
*NvetoAfterpulseApi* | [**post_nveto_afterpulses**](docs/NvetoAfterpulseApi.md#post_nveto_afterpulses) | **POST** /nveto/afterpules | Stores one or more NvetoAfterpulses.
*NvetoAfterpulseApi* | [**put_nveto_afterpulse_item**](docs/NvetoAfterpulseApi.md#put_nveto_afterpulse_item) | **PUT** /nveto/afterpules/{nvetoafterpulseId} | Replaces a NvetoAfterpulse document
*NvetoCurrentChangeApi* | [**delete_nveto_current_change_item**](docs/NvetoCurrentChangeApi.md#delete_nveto_current_change_item) | **DELETE** /nveto/current_changes/{nvetocurrentchangeId} | Deletes a NvetoCurrentChange document
*NvetoCurrentChangeApi* | [**get_nveto_current_change_item**](docs/NvetoCurrentChangeApi.md#get_nveto_current_change_item) | **GET** /nveto/current_changes/{nvetocurrentchangeId} | Retrieves a NvetoCurrentChange document
*NvetoCurrentChangeApi* | [**get_nveto_current_changes**](docs/NvetoCurrentChangeApi.md#get_nveto_current_changes) | **GET** /nveto/current_changes | Retrieves one or more NvetoCurrentChanges
*NvetoCurrentChangeApi* | [**post_nveto_current_changes**](docs/NvetoCurrentChangeApi.md#post_nveto_current_changes) | **POST** /nveto/current_changes | Stores one or more NvetoCurrentChanges.
*NvetoCurrentChangeApi* | [**put_nveto_current_change_item**](docs/NvetoCurrentChangeApi.md#put_nveto_current_change_item) | **PUT** /nveto/current_changes/{nvetocurrentchangeId} | Replaces a NvetoCurrentChange document
*NvetoDarkCountRateApi* | [**delete_nveto_dark_count_rate_item**](docs/NvetoDarkCountRateApi.md#delete_nveto_dark_count_rate_item) | **DELETE** /nveto/dark_counts_rates/{nvetodarkcountrateId} | Deletes a NvetoDarkCountRate document
*NvetoDarkCountRateApi* | [**get_nveto_dark_count_rate_item**](docs/NvetoDarkCountRateApi.md#get_nveto_dark_count_rate_item) | **GET** /nveto/dark_counts_rates/{nvetodarkcountrateId} | Retrieves a NvetoDarkCountRate document
*NvetoDarkCountRateApi* | [**get_nveto_dark_count_rates**](docs/NvetoDarkCountRateApi.md#get_nveto_dark_count_rates) | **GET** /nveto/dark_counts_rates | Retrieves one or more NvetoDarkCountRates
*NvetoDarkCountRateApi* | [**post_nveto_dark_count_rates**](docs/NvetoDarkCountRateApi.md#post_nveto_dark_count_rates) | **POST** /nveto/dark_counts_rates | Stores one or more NvetoDarkCountRates.
*NvetoDarkCountRateApi* | [**put_nveto_dark_count_rate_item**](docs/NvetoDarkCountRateApi.md#put_nveto_dark_count_rate_item) | **PUT** /nveto/dark_counts_rates/{nvetodarkcountrateId} | Replaces a NvetoDarkCountRate document
*NvetoGainApi* | [**delete_nveto_gain_item**](docs/NvetoGainApi.md#delete_nveto_gain_item) | **DELETE** /nveto/gains/{nvetogainId} | Deletes a NvetoGain document
*NvetoGainApi* | [**get_nveto_gain_item**](docs/NvetoGainApi.md#get_nveto_gain_item) | **GET** /nveto/gains/{nvetogainId} | Retrieves a NvetoGain document
*NvetoGainApi* | [**get_nveto_gains**](docs/NvetoGainApi.md#get_nveto_gains) | **GET** /nveto/gains | Retrieves one or more NvetoGains
*NvetoGainApi* | [**post_nveto_gains**](docs/NvetoGainApi.md#post_nveto_gains) | **POST** /nveto/gains | Stores one or more NvetoGains.
*NvetoGainApi* | [**put_nveto_gain_item**](docs/NvetoGainApi.md#put_nveto_gain_item) | **PUT** /nveto/gains/{nvetogainId} | Replaces a NvetoGain document
*NvetoGainMeasurementApi* | [**delete_nveto_gain_measurement_item**](docs/NvetoGainMeasurementApi.md#delete_nveto_gain_measurement_item) | **DELETE** /nveto/gain_measurements/{nvetogainmeasurementId} | Deletes a NvetoGainMeasurement document
*NvetoGainMeasurementApi* | [**get_nveto_gain_measurement_item**](docs/NvetoGainMeasurementApi.md#get_nveto_gain_measurement_item) | **GET** /nveto/gain_measurements/{nvetogainmeasurementId} | Retrieves a NvetoGainMeasurement document
*NvetoGainMeasurementApi* | [**get_nveto_gain_measurements**](docs/NvetoGainMeasurementApi.md#get_nveto_gain_measurements) | **GET** /nveto/gain_measurements | Retrieves one or more NvetoGainMeasurements
*NvetoGainMeasurementApi* | [**post_nveto_gain_measurements**](docs/NvetoGainMeasurementApi.md#post_nveto_gain_measurements) | **POST** /nveto/gain_measurements | Stores one or more NvetoGainMeasurements.
*NvetoGainMeasurementApi* | [**put_nveto_gain_measurement_item**](docs/NvetoGainMeasurementApi.md#put_nveto_gain_measurement_item) | **PUT** /nveto/gain_measurements/{nvetogainmeasurementId} | Replaces a NvetoGainMeasurement document
*NvetoGainModelApi* | [**delete_nveto_gain_model_item**](docs/NvetoGainModelApi.md#delete_nveto_gain_model_item) | **DELETE** /nveto/gain_models/{nvetogainmodelId} | Deletes a NvetoGainModel document
*NvetoGainModelApi* | [**get_nveto_gain_model_item**](docs/NvetoGainModelApi.md#get_nveto_gain_model_item) | **GET** /nveto/gain_models/{nvetogainmodelId} | Retrieves a NvetoGainModel document
*NvetoGainModelApi* | [**get_nveto_gain_models**](docs/NvetoGainModelApi.md#get_nveto_gain_models) | **GET** /nveto/gain_models | Retrieves one or more NvetoGainModels
*NvetoGainModelApi* | [**post_nveto_gain_models**](docs/NvetoGainModelApi.md#post_nveto_gain_models) | **POST** /nveto/gain_models | Stores one or more NvetoGainModels.
*NvetoGainModelApi* | [**put_nveto_gain_model_item**](docs/NvetoGainModelApi.md#put_nveto_gain_model_item) | **PUT** /nveto/gain_models/{nvetogainmodelId} | Replaces a NvetoGainModel document
*NvetoInstallApi* | [**delete_nveto_install_item**](docs/NvetoInstallApi.md#delete_nveto_install_item) | **DELETE** /nveto/installs/{nvetoinstallId} | Deletes a NvetoInstall document
*NvetoInstallApi* | [**get_nveto_install_item**](docs/NvetoInstallApi.md#get_nveto_install_item) | **GET** /nveto/installs/{nvetoinstallId} | Retrieves a NvetoInstall document
*NvetoInstallApi* | [**get_nveto_install_item_by_uid**](docs/NvetoInstallApi.md#get_nveto_install_item_by_uid) | **GET** /nveto/installs/{Uid} | Retrieves a NvetoInstall document by uid
*NvetoInstallApi* | [**get_nveto_installs**](docs/NvetoInstallApi.md#get_nveto_installs) | **GET** /nveto/installs | Retrieves one or more NvetoInstalls
*NvetoInstallApi* | [**post_nveto_installs**](docs/NvetoInstallApi.md#post_nveto_installs) | **POST** /nveto/installs | Stores one or more NvetoInstalls.
*NvetoInstallApi* | [**put_nveto_install_item**](docs/NvetoInstallApi.md#put_nveto_install_item) | **PUT** /nveto/installs/{nvetoinstallId} | Replaces a NvetoInstall document
*NvetoPmtApi* | [**delete_nveto_pmt_item**](docs/NvetoPmtApi.md#delete_nveto_pmt_item) | **DELETE** /nveto/pmts/{nvetopmtId} | Deletes a NvetoPmt document
*NvetoPmtApi* | [**get_nveto_pmt_item**](docs/NvetoPmtApi.md#get_nveto_pmt_item) | **GET** /nveto/pmts/{nvetopmtId} | Retrieves a NvetoPmt document
*NvetoPmtApi* | [**get_nveto_pmt_item_by_serial_number**](docs/NvetoPmtApi.md#get_nveto_pmt_item_by_serial_number) | **GET** /nveto/pmts/{Serial_Number} | Retrieves a NvetoPmt document by serial_number
*NvetoPmtApi* | [**get_nveto_pmts**](docs/NvetoPmtApi.md#get_nveto_pmts) | **GET** /nveto/pmts | Retrieves one or more NvetoPmts
*NvetoPmtApi* | [**post_nveto_pmts**](docs/NvetoPmtApi.md#post_nveto_pmts) | **POST** /nveto/pmts | Stores one or more NvetoPmts.
*NvetoPmtApi* | [**put_nveto_pmt_item**](docs/NvetoPmtApi.md#put_nveto_pmt_item) | **PUT** /nveto/pmts/{nvetopmtId} | Replaces a NvetoPmt document
*NvetoPmtErrorApi* | [**delete_nveto_pmt_error_item**](docs/NvetoPmtErrorApi.md#delete_nveto_pmt_error_item) | **DELETE** /nveto/pmt_errors/{nvetopmterrorId} | Deletes a NvetoPmtError document
*NvetoPmtErrorApi* | [**get_nveto_pmt_error_item**](docs/NvetoPmtErrorApi.md#get_nveto_pmt_error_item) | **GET** /nveto/pmt_errors/{nvetopmterrorId} | Retrieves a NvetoPmtError document
*NvetoPmtErrorApi* | [**get_nveto_pmt_errors**](docs/NvetoPmtErrorApi.md#get_nveto_pmt_errors) | **GET** /nveto/pmt_errors | Retrieves one or more NvetoPmtErrors
*NvetoPmtErrorApi* | [**post_nveto_pmt_errors**](docs/NvetoPmtErrorApi.md#post_nveto_pmt_errors) | **POST** /nveto/pmt_errors | Stores one or more NvetoPmtErrors.
*NvetoPmtErrorApi* | [**put_nveto_pmt_error_item**](docs/NvetoPmtErrorApi.md#put_nveto_pmt_error_item) | **PUT** /nveto/pmt_errors/{nvetopmterrorId} | Replaces a NvetoPmtError document
*NvetoVoltageChangeApi* | [**delete_nveto_voltage_change_item**](docs/NvetoVoltageChangeApi.md#delete_nveto_voltage_change_item) | **DELETE** /nveto/voltage_changes/{nvetovoltagechangeId} | Deletes a NvetoVoltageChange document
*NvetoVoltageChangeApi* | [**get_nveto_voltage_change_item**](docs/NvetoVoltageChangeApi.md#get_nveto_voltage_change_item) | **GET** /nveto/voltage_changes/{nvetovoltagechangeId} | Retrieves a NvetoVoltageChange document
*NvetoVoltageChangeApi* | [**get_nveto_voltage_changes**](docs/NvetoVoltageChangeApi.md#get_nveto_voltage_changes) | **GET** /nveto/voltage_changes | Retrieves one or more NvetoVoltageChanges
*NvetoVoltageChangeApi* | [**post_nveto_voltage_changes**](docs/NvetoVoltageChangeApi.md#post_nveto_voltage_changes) | **POST** /nveto/voltage_changes | Stores one or more NvetoVoltageChanges.
*NvetoVoltageChangeApi* | [**put_nveto_voltage_change_item**](docs/NvetoVoltageChangeApi.md#put_nveto_voltage_change_item) | **PUT** /nveto/voltage_changes/{nvetovoltagechangeId} | Replaces a NvetoVoltageChange document
*NvetoVoltageMapApi* | [**delete_nveto_voltage_map_item**](docs/NvetoVoltageMapApi.md#delete_nveto_voltage_map_item) | **DELETE** /nveto/voltage_maps/{nvetovoltagemapId} | Deletes a NvetoVoltageMap document
*NvetoVoltageMapApi* | [**delete_nveto_voltage_maps**](docs/NvetoVoltageMapApi.md#delete_nveto_voltage_maps) | **DELETE** /nveto/voltage_maps | Deletes all NvetoVoltageMaps
*NvetoVoltageMapApi* | [**get_nveto_voltage_map_item**](docs/NvetoVoltageMapApi.md#get_nveto_voltage_map_item) | **GET** /nveto/voltage_maps/{nvetovoltagemapId} | Retrieves a NvetoVoltageMap document
*NvetoVoltageMapApi* | [**get_nveto_voltage_map_item_by_name**](docs/NvetoVoltageMapApi.md#get_nveto_voltage_map_item_by_name) | **GET** /nveto/voltage_maps/{Name} | Retrieves a NvetoVoltageMap document by name
*NvetoVoltageMapApi* | [**get_nveto_voltage_maps**](docs/NvetoVoltageMapApi.md#get_nveto_voltage_maps) | **GET** /nveto/voltage_maps | Retrieves one or more NvetoVoltageMaps
*NvetoVoltageMapApi* | [**post_nveto_voltage_maps**](docs/NvetoVoltageMapApi.md#post_nveto_voltage_maps) | **POST** /nveto/voltage_maps | Stores one or more NvetoVoltageMaps.
*NvetoVoltageMapApi* | [**put_nveto_voltage_map_item**](docs/NvetoVoltageMapApi.md#put_nveto_voltage_map_item) | **PUT** /nveto/voltage_maps/{nvetovoltagemapId} | Replaces a NvetoVoltageMap document
*NvetoVoltageMapNameApi* | [**get_nveto_voltage_map_names**](docs/NvetoVoltageMapNameApi.md#get_nveto_voltage_map_names) | **GET** /nveto/voltage_maps/names | Retrieves one or more NvetoVoltageMapNames
*TpcAfterpulseApi* | [**delete_tpc_afterpulse_item**](docs/TpcAfterpulseApi.md#delete_tpc_afterpulse_item) | **DELETE** /tpc/afterpules/{tpcafterpulseId} | Deletes a TpcAfterpulse document
*TpcAfterpulseApi* | [**get_tpc_afterpulse_item**](docs/TpcAfterpulseApi.md#get_tpc_afterpulse_item) | **GET** /tpc/afterpules/{tpcafterpulseId} | Retrieves a TpcAfterpulse document
*TpcAfterpulseApi* | [**get_tpc_afterpulses**](docs/TpcAfterpulseApi.md#get_tpc_afterpulses) | **GET** /tpc/afterpules | Retrieves one or more TpcAfterpulses
*TpcAfterpulseApi* | [**post_tpc_afterpulses**](docs/TpcAfterpulseApi.md#post_tpc_afterpulses) | **POST** /tpc/afterpules | Stores one or more TpcAfterpulses.
*TpcAfterpulseApi* | [**put_tpc_afterpulse_item**](docs/TpcAfterpulseApi.md#put_tpc_afterpulse_item) | **PUT** /tpc/afterpules/{tpcafterpulseId} | Replaces a TpcAfterpulse document
*TpcAfterpulse1tApi* | [**delete_tpc_afterpulse1t_item**](docs/TpcAfterpulse1tApi.md#delete_tpc_afterpulse1t_item) | **DELETE** /xenon1t/tpc/afterpules/{tpcafterpulse1tId} | Deletes a TpcAfterpulse1t document
*TpcAfterpulse1tApi* | [**get_tpc_afterpulse1t_item**](docs/TpcAfterpulse1tApi.md#get_tpc_afterpulse1t_item) | **GET** /xenon1t/tpc/afterpules/{tpcafterpulse1tId} | Retrieves a TpcAfterpulse1t document
*TpcAfterpulse1tApi* | [**get_tpc_afterpulse1ts**](docs/TpcAfterpulse1tApi.md#get_tpc_afterpulse1ts) | **GET** /xenon1t/tpc/afterpules | Retrieves one or more TpcAfterpulse1ts
*TpcAfterpulse1tApi* | [**post_tpc_afterpulse1ts**](docs/TpcAfterpulse1tApi.md#post_tpc_afterpulse1ts) | **POST** /xenon1t/tpc/afterpules | Stores one or more TpcAfterpulse1ts.
*TpcAfterpulse1tApi* | [**put_tpc_afterpulse1t_item**](docs/TpcAfterpulse1tApi.md#put_tpc_afterpulse1t_item) | **PUT** /xenon1t/tpc/afterpules/{tpcafterpulse1tId} | Replaces a TpcAfterpulse1t document
*TpcCurrentChangeApi* | [**delete_tpc_current_change_item**](docs/TpcCurrentChangeApi.md#delete_tpc_current_change_item) | **DELETE** /tpc/current_changes/{tpccurrentchangeId} | Deletes a TpcCurrentChange document
*TpcCurrentChangeApi* | [**get_tpc_current_change_item**](docs/TpcCurrentChangeApi.md#get_tpc_current_change_item) | **GET** /tpc/current_changes/{tpccurrentchangeId} | Retrieves a TpcCurrentChange document
*TpcCurrentChangeApi* | [**get_tpc_current_changes**](docs/TpcCurrentChangeApi.md#get_tpc_current_changes) | **GET** /tpc/current_changes | Retrieves one or more TpcCurrentChanges
*TpcCurrentChangeApi* | [**post_tpc_current_changes**](docs/TpcCurrentChangeApi.md#post_tpc_current_changes) | **POST** /tpc/current_changes | Stores one or more TpcCurrentChanges.
*TpcCurrentChangeApi* | [**put_tpc_current_change_item**](docs/TpcCurrentChangeApi.md#put_tpc_current_change_item) | **PUT** /tpc/current_changes/{tpccurrentchangeId} | Replaces a TpcCurrentChange document
*TpcCurrentChange1tApi* | [**delete_tpc_current_change1t_item**](docs/TpcCurrentChange1tApi.md#delete_tpc_current_change1t_item) | **DELETE** /xenon1t/tpc/current_changes/{tpccurrentchange1tId} | Deletes a TpcCurrentChange1t document
*TpcCurrentChange1tApi* | [**get_tpc_current_change1t_item**](docs/TpcCurrentChange1tApi.md#get_tpc_current_change1t_item) | **GET** /xenon1t/tpc/current_changes/{tpccurrentchange1tId} | Retrieves a TpcCurrentChange1t document
*TpcCurrentChange1tApi* | [**get_tpc_current_change1ts**](docs/TpcCurrentChange1tApi.md#get_tpc_current_change1ts) | **GET** /xenon1t/tpc/current_changes | Retrieves one or more TpcCurrentChange1ts
*TpcCurrentChange1tApi* | [**post_tpc_current_change1ts**](docs/TpcCurrentChange1tApi.md#post_tpc_current_change1ts) | **POST** /xenon1t/tpc/current_changes | Stores one or more TpcCurrentChange1ts.
*TpcCurrentChange1tApi* | [**put_tpc_current_change1t_item**](docs/TpcCurrentChange1tApi.md#put_tpc_current_change1t_item) | **PUT** /xenon1t/tpc/current_changes/{tpccurrentchange1tId} | Replaces a TpcCurrentChange1t document
*TpcDarkCountRateApi* | [**delete_tpc_dark_count_rate_item**](docs/TpcDarkCountRateApi.md#delete_tpc_dark_count_rate_item) | **DELETE** /tpc/dark_counts_rates/{tpcdarkcountrateId} | Deletes a TpcDarkCountRate document
*TpcDarkCountRateApi* | [**get_tpc_dark_count_rate_item**](docs/TpcDarkCountRateApi.md#get_tpc_dark_count_rate_item) | **GET** /tpc/dark_counts_rates/{tpcdarkcountrateId} | Retrieves a TpcDarkCountRate document
*TpcDarkCountRateApi* | [**get_tpc_dark_count_rates**](docs/TpcDarkCountRateApi.md#get_tpc_dark_count_rates) | **GET** /tpc/dark_counts_rates | Retrieves one or more TpcDarkCountRates
*TpcDarkCountRateApi* | [**post_tpc_dark_count_rates**](docs/TpcDarkCountRateApi.md#post_tpc_dark_count_rates) | **POST** /tpc/dark_counts_rates | Stores one or more TpcDarkCountRates.
*TpcDarkCountRateApi* | [**put_tpc_dark_count_rate_item**](docs/TpcDarkCountRateApi.md#put_tpc_dark_count_rate_item) | **PUT** /tpc/dark_counts_rates/{tpcdarkcountrateId} | Replaces a TpcDarkCountRate document
*TpcDarkCountRate1tApi* | [**delete_tpc_dark_count_rate1t_item**](docs/TpcDarkCountRate1tApi.md#delete_tpc_dark_count_rate1t_item) | **DELETE** /xenon1t/tpc/dark_counts_rates/{tpcdarkcountrate1tId} | Deletes a TpcDarkCountRate1t document
*TpcDarkCountRate1tApi* | [**get_tpc_dark_count_rate1t_item**](docs/TpcDarkCountRate1tApi.md#get_tpc_dark_count_rate1t_item) | **GET** /xenon1t/tpc/dark_counts_rates/{tpcdarkcountrate1tId} | Retrieves a TpcDarkCountRate1t document
*TpcDarkCountRate1tApi* | [**get_tpc_dark_count_rate1ts**](docs/TpcDarkCountRate1tApi.md#get_tpc_dark_count_rate1ts) | **GET** /xenon1t/tpc/dark_counts_rates | Retrieves one or more TpcDarkCountRate1ts
*TpcDarkCountRate1tApi* | [**post_tpc_dark_count_rate1ts**](docs/TpcDarkCountRate1tApi.md#post_tpc_dark_count_rate1ts) | **POST** /xenon1t/tpc/dark_counts_rates | Stores one or more TpcDarkCountRate1ts.
*TpcDarkCountRate1tApi* | [**put_tpc_dark_count_rate1t_item**](docs/TpcDarkCountRate1tApi.md#put_tpc_dark_count_rate1t_item) | **PUT** /xenon1t/tpc/dark_counts_rates/{tpcdarkcountrate1tId} | Replaces a TpcDarkCountRate1t document
*TpcGainApi* | [**delete_tpc_gain_item**](docs/TpcGainApi.md#delete_tpc_gain_item) | **DELETE** /tpc/gains/{tpcgainId} | Deletes a TpcGain document
*TpcGainApi* | [**get_tpc_gain_item**](docs/TpcGainApi.md#get_tpc_gain_item) | **GET** /tpc/gains/{tpcgainId} | Retrieves a TpcGain document
*TpcGainApi* | [**get_tpc_gains**](docs/TpcGainApi.md#get_tpc_gains) | **GET** /tpc/gains | Retrieves one or more TpcGains
*TpcGainApi* | [**post_tpc_gains**](docs/TpcGainApi.md#post_tpc_gains) | **POST** /tpc/gains | Stores one or more TpcGains.
*TpcGainApi* | [**put_tpc_gain_item**](docs/TpcGainApi.md#put_tpc_gain_item) | **PUT** /tpc/gains/{tpcgainId} | Replaces a TpcGain document
*TpcGain1tApi* | [**delete_tpc_gain1t_item**](docs/TpcGain1tApi.md#delete_tpc_gain1t_item) | **DELETE** /xenon1t/tpc/gains/{tpcgain1tId} | Deletes a TpcGain1t document
*TpcGain1tApi* | [**get_tpc_gain1t_item**](docs/TpcGain1tApi.md#get_tpc_gain1t_item) | **GET** /xenon1t/tpc/gains/{tpcgain1tId} | Retrieves a TpcGain1t document
*TpcGain1tApi* | [**get_tpc_gain1ts**](docs/TpcGain1tApi.md#get_tpc_gain1ts) | **GET** /xenon1t/tpc/gains | Retrieves one or more TpcGain1ts
*TpcGain1tApi* | [**post_tpc_gain1ts**](docs/TpcGain1tApi.md#post_tpc_gain1ts) | **POST** /xenon1t/tpc/gains | Stores one or more TpcGain1ts.
*TpcGain1tApi* | [**put_tpc_gain1t_item**](docs/TpcGain1tApi.md#put_tpc_gain1t_item) | **PUT** /xenon1t/tpc/gains/{tpcgain1tId} | Replaces a TpcGain1t document
*TpcGainMeasurementApi* | [**delete_tpc_gain_measurement_item**](docs/TpcGainMeasurementApi.md#delete_tpc_gain_measurement_item) | **DELETE** /tpc/gain_measurements/{tpcgainmeasurementId} | Deletes a TpcGainMeasurement document
*TpcGainMeasurementApi* | [**get_tpc_gain_measurement_item**](docs/TpcGainMeasurementApi.md#get_tpc_gain_measurement_item) | **GET** /tpc/gain_measurements/{tpcgainmeasurementId} | Retrieves a TpcGainMeasurement document
*TpcGainMeasurementApi* | [**get_tpc_gain_measurements**](docs/TpcGainMeasurementApi.md#get_tpc_gain_measurements) | **GET** /tpc/gain_measurements | Retrieves one or more TpcGainMeasurements
*TpcGainMeasurementApi* | [**post_tpc_gain_measurements**](docs/TpcGainMeasurementApi.md#post_tpc_gain_measurements) | **POST** /tpc/gain_measurements | Stores one or more TpcGainMeasurements.
*TpcGainMeasurementApi* | [**put_tpc_gain_measurement_item**](docs/TpcGainMeasurementApi.md#put_tpc_gain_measurement_item) | **PUT** /tpc/gain_measurements/{tpcgainmeasurementId} | Replaces a TpcGainMeasurement document
*TpcGainMeasurement1tApi* | [**delete_tpc_gain_measurement1t_item**](docs/TpcGainMeasurement1tApi.md#delete_tpc_gain_measurement1t_item) | **DELETE** /xenon1t/tpc/gain_measurements/{tpcgainmeasurement1tId} | Deletes a TpcGainMeasurement1t document
*TpcGainMeasurement1tApi* | [**get_tpc_gain_measurement1t_item**](docs/TpcGainMeasurement1tApi.md#get_tpc_gain_measurement1t_item) | **GET** /xenon1t/tpc/gain_measurements/{tpcgainmeasurement1tId} | Retrieves a TpcGainMeasurement1t document
*TpcGainMeasurement1tApi* | [**get_tpc_gain_measurement1ts**](docs/TpcGainMeasurement1tApi.md#get_tpc_gain_measurement1ts) | **GET** /xenon1t/tpc/gain_measurements | Retrieves one or more TpcGainMeasurement1ts
*TpcGainMeasurement1tApi* | [**post_tpc_gain_measurement1ts**](docs/TpcGainMeasurement1tApi.md#post_tpc_gain_measurement1ts) | **POST** /xenon1t/tpc/gain_measurements | Stores one or more TpcGainMeasurement1ts.
*TpcGainMeasurement1tApi* | [**put_tpc_gain_measurement1t_item**](docs/TpcGainMeasurement1tApi.md#put_tpc_gain_measurement1t_item) | **PUT** /xenon1t/tpc/gain_measurements/{tpcgainmeasurement1tId} | Replaces a TpcGainMeasurement1t document
*TpcGainModelApi* | [**delete_tpc_gain_model_item**](docs/TpcGainModelApi.md#delete_tpc_gain_model_item) | **DELETE** /tpc/gain_models/{tpcgainmodelId} | Deletes a TpcGainModel document
*TpcGainModelApi* | [**get_tpc_gain_model_item**](docs/TpcGainModelApi.md#get_tpc_gain_model_item) | **GET** /tpc/gain_models/{tpcgainmodelId} | Retrieves a TpcGainModel document
*TpcGainModelApi* | [**get_tpc_gain_models**](docs/TpcGainModelApi.md#get_tpc_gain_models) | **GET** /tpc/gain_models | Retrieves one or more TpcGainModels
*TpcGainModelApi* | [**post_tpc_gain_models**](docs/TpcGainModelApi.md#post_tpc_gain_models) | **POST** /tpc/gain_models | Stores one or more TpcGainModels.
*TpcGainModelApi* | [**put_tpc_gain_model_item**](docs/TpcGainModelApi.md#put_tpc_gain_model_item) | **PUT** /tpc/gain_models/{tpcgainmodelId} | Replaces a TpcGainModel document
*TpcGainModel1tApi* | [**delete_tpc_gain_model1t_item**](docs/TpcGainModel1tApi.md#delete_tpc_gain_model1t_item) | **DELETE** /xenon1t/tpc/gain_models/{tpcgainmodel1tId} | Deletes a TpcGainModel1t document
*TpcGainModel1tApi* | [**get_tpc_gain_model1t_item**](docs/TpcGainModel1tApi.md#get_tpc_gain_model1t_item) | **GET** /xenon1t/tpc/gain_models/{tpcgainmodel1tId} | Retrieves a TpcGainModel1t document
*TpcGainModel1tApi* | [**get_tpc_gain_model1ts**](docs/TpcGainModel1tApi.md#get_tpc_gain_model1ts) | **GET** /xenon1t/tpc/gain_models | Retrieves one or more TpcGainModel1ts
*TpcGainModel1tApi* | [**post_tpc_gain_model1ts**](docs/TpcGainModel1tApi.md#post_tpc_gain_model1ts) | **POST** /xenon1t/tpc/gain_models | Stores one or more TpcGainModel1ts.
*TpcGainModel1tApi* | [**put_tpc_gain_model1t_item**](docs/TpcGainModel1tApi.md#put_tpc_gain_model1t_item) | **PUT** /xenon1t/tpc/gain_models/{tpcgainmodel1tId} | Replaces a TpcGainModel1t document
*TpcInstallApi* | [**delete_tpc_install_item**](docs/TpcInstallApi.md#delete_tpc_install_item) | **DELETE** /tpc/installs/{tpcinstallId} | Deletes a TpcInstall document
*TpcInstallApi* | [**get_tpc_install_item**](docs/TpcInstallApi.md#get_tpc_install_item) | **GET** /tpc/installs/{tpcinstallId} | Retrieves a TpcInstall document
*TpcInstallApi* | [**get_tpc_install_item_by_uid**](docs/TpcInstallApi.md#get_tpc_install_item_by_uid) | **GET** /tpc/installs/{Uid} | Retrieves a TpcInstall document by uid
*TpcInstallApi* | [**get_tpc_installs**](docs/TpcInstallApi.md#get_tpc_installs) | **GET** /tpc/installs | Retrieves one or more TpcInstalls
*TpcInstallApi* | [**post_tpc_installs**](docs/TpcInstallApi.md#post_tpc_installs) | **POST** /tpc/installs | Stores one or more TpcInstalls.
*TpcInstallApi* | [**put_tpc_install_item**](docs/TpcInstallApi.md#put_tpc_install_item) | **PUT** /tpc/installs/{tpcinstallId} | Replaces a TpcInstall document
*TpcInstall1tApi* | [**delete_tpc_install1t_item**](docs/TpcInstall1tApi.md#delete_tpc_install1t_item) | **DELETE** /xenon1t/tpc/installs/{tpcinstall1tId} | Deletes a TpcInstall1t document
*TpcInstall1tApi* | [**get_tpc_install1t_item**](docs/TpcInstall1tApi.md#get_tpc_install1t_item) | **GET** /xenon1t/tpc/installs/{tpcinstall1tId} | Retrieves a TpcInstall1t document
*TpcInstall1tApi* | [**get_tpc_install1t_item_by_uid**](docs/TpcInstall1tApi.md#get_tpc_install1t_item_by_uid) | **GET** /xenon1t/tpc/installs/{Uid} | Retrieves a TpcInstall1t document by uid
*TpcInstall1tApi* | [**get_tpc_install1ts**](docs/TpcInstall1tApi.md#get_tpc_install1ts) | **GET** /xenon1t/tpc/installs | Retrieves one or more TpcInstall1ts
*TpcInstall1tApi* | [**post_tpc_install1ts**](docs/TpcInstall1tApi.md#post_tpc_install1ts) | **POST** /xenon1t/tpc/installs | Stores one or more TpcInstall1ts.
*TpcInstall1tApi* | [**put_tpc_install1t_item**](docs/TpcInstall1tApi.md#put_tpc_install1t_item) | **PUT** /xenon1t/tpc/installs/{tpcinstall1tId} | Replaces a TpcInstall1t document
*TpcPmtApi* | [**delete_tpc_pmt_item**](docs/TpcPmtApi.md#delete_tpc_pmt_item) | **DELETE** /tpc/pmts/{tpcpmtId} | Deletes a TpcPmt document
*TpcPmtApi* | [**get_tpc_pmt_item**](docs/TpcPmtApi.md#get_tpc_pmt_item) | **GET** /tpc/pmts/{tpcpmtId} | Retrieves a TpcPmt document
*TpcPmtApi* | [**get_tpc_pmt_item_by_serial_number**](docs/TpcPmtApi.md#get_tpc_pmt_item_by_serial_number) | **GET** /tpc/pmts/{Serial_Number} | Retrieves a TpcPmt document by serial_number
*TpcPmtApi* | [**get_tpc_pmts**](docs/TpcPmtApi.md#get_tpc_pmts) | **GET** /tpc/pmts | Retrieves one or more TpcPmts
*TpcPmtApi* | [**post_tpc_pmts**](docs/TpcPmtApi.md#post_tpc_pmts) | **POST** /tpc/pmts | Stores one or more TpcPmts.
*TpcPmtApi* | [**put_tpc_pmt_item**](docs/TpcPmtApi.md#put_tpc_pmt_item) | **PUT** /tpc/pmts/{tpcpmtId} | Replaces a TpcPmt document
*TpcPmt1tApi* | [**delete_tpc_pmt1t_item**](docs/TpcPmt1tApi.md#delete_tpc_pmt1t_item) | **DELETE** /xenon1t/tpc/pmts/{tpcpmt1tId} | Deletes a TpcPmt1t document
*TpcPmt1tApi* | [**get_tpc_pmt1t_item**](docs/TpcPmt1tApi.md#get_tpc_pmt1t_item) | **GET** /xenon1t/tpc/pmts/{tpcpmt1tId} | Retrieves a TpcPmt1t document
*TpcPmt1tApi* | [**get_tpc_pmt1t_item_by_serial_number**](docs/TpcPmt1tApi.md#get_tpc_pmt1t_item_by_serial_number) | **GET** /xenon1t/tpc/pmts/{Serial_Number} | Retrieves a TpcPmt1t document by serial_number
*TpcPmt1tApi* | [**get_tpc_pmt1ts**](docs/TpcPmt1tApi.md#get_tpc_pmt1ts) | **GET** /xenon1t/tpc/pmts | Retrieves one or more TpcPmt1ts
*TpcPmt1tApi* | [**post_tpc_pmt1ts**](docs/TpcPmt1tApi.md#post_tpc_pmt1ts) | **POST** /xenon1t/tpc/pmts | Stores one or more TpcPmt1ts.
*TpcPmt1tApi* | [**put_tpc_pmt1t_item**](docs/TpcPmt1tApi.md#put_tpc_pmt1t_item) | **PUT** /xenon1t/tpc/pmts/{tpcpmt1tId} | Replaces a TpcPmt1t document
*TpcPmtErrorApi* | [**delete_tpc_pmt_error_item**](docs/TpcPmtErrorApi.md#delete_tpc_pmt_error_item) | **DELETE** /tpc/pmt_errors/{tpcpmterrorId} | Deletes a TpcPmtError document
*TpcPmtErrorApi* | [**get_tpc_pmt_error_item**](docs/TpcPmtErrorApi.md#get_tpc_pmt_error_item) | **GET** /tpc/pmt_errors/{tpcpmterrorId} | Retrieves a TpcPmtError document
*TpcPmtErrorApi* | [**get_tpc_pmt_errors**](docs/TpcPmtErrorApi.md#get_tpc_pmt_errors) | **GET** /tpc/pmt_errors | Retrieves one or more TpcPmtErrors
*TpcPmtErrorApi* | [**post_tpc_pmt_errors**](docs/TpcPmtErrorApi.md#post_tpc_pmt_errors) | **POST** /tpc/pmt_errors | Stores one or more TpcPmtErrors.
*TpcPmtErrorApi* | [**put_tpc_pmt_error_item**](docs/TpcPmtErrorApi.md#put_tpc_pmt_error_item) | **PUT** /tpc/pmt_errors/{tpcpmterrorId} | Replaces a TpcPmtError document
*TpcPmtError1tApi* | [**delete_tpc_pmt_error1t_item**](docs/TpcPmtError1tApi.md#delete_tpc_pmt_error1t_item) | **DELETE** /xenon1t/tpc/pmt_errors/{tpcpmterror1tId} | Deletes a TpcPmtError1t document
*TpcPmtError1tApi* | [**get_tpc_pmt_error1t_item**](docs/TpcPmtError1tApi.md#get_tpc_pmt_error1t_item) | **GET** /xenon1t/tpc/pmt_errors/{tpcpmterror1tId} | Retrieves a TpcPmtError1t document
*TpcPmtError1tApi* | [**get_tpc_pmt_error1ts**](docs/TpcPmtError1tApi.md#get_tpc_pmt_error1ts) | **GET** /xenon1t/tpc/pmt_errors | Retrieves one or more TpcPmtError1ts
*TpcPmtError1tApi* | [**post_tpc_pmt_error1ts**](docs/TpcPmtError1tApi.md#post_tpc_pmt_error1ts) | **POST** /xenon1t/tpc/pmt_errors | Stores one or more TpcPmtError1ts.
*TpcPmtError1tApi* | [**put_tpc_pmt_error1t_item**](docs/TpcPmtError1tApi.md#put_tpc_pmt_error1t_item) | **PUT** /xenon1t/tpc/pmt_errors/{tpcpmterror1tId} | Replaces a TpcPmtError1t document
*TpcVoltageChangeApi* | [**delete_tpc_voltage_change_item**](docs/TpcVoltageChangeApi.md#delete_tpc_voltage_change_item) | **DELETE** /tpc/voltage_changes/{tpcvoltagechangeId} | Deletes a TpcVoltageChange document
*TpcVoltageChangeApi* | [**get_tpc_voltage_change_item**](docs/TpcVoltageChangeApi.md#get_tpc_voltage_change_item) | **GET** /tpc/voltage_changes/{tpcvoltagechangeId} | Retrieves a TpcVoltageChange document
*TpcVoltageChangeApi* | [**get_tpc_voltage_changes**](docs/TpcVoltageChangeApi.md#get_tpc_voltage_changes) | **GET** /tpc/voltage_changes | Retrieves one or more TpcVoltageChanges
*TpcVoltageChangeApi* | [**post_tpc_voltage_changes**](docs/TpcVoltageChangeApi.md#post_tpc_voltage_changes) | **POST** /tpc/voltage_changes | Stores one or more TpcVoltageChanges.
*TpcVoltageChangeApi* | [**put_tpc_voltage_change_item**](docs/TpcVoltageChangeApi.md#put_tpc_voltage_change_item) | **PUT** /tpc/voltage_changes/{tpcvoltagechangeId} | Replaces a TpcVoltageChange document
*TpcVoltageChange1tApi* | [**delete_tpc_voltage_change1t_item**](docs/TpcVoltageChange1tApi.md#delete_tpc_voltage_change1t_item) | **DELETE** /xenon1t/tpc/voltage_changes/{tpcvoltagechange1tId} | Deletes a TpcVoltageChange1t document
*TpcVoltageChange1tApi* | [**get_tpc_voltage_change1t_item**](docs/TpcVoltageChange1tApi.md#get_tpc_voltage_change1t_item) | **GET** /xenon1t/tpc/voltage_changes/{tpcvoltagechange1tId} | Retrieves a TpcVoltageChange1t document
*TpcVoltageChange1tApi* | [**get_tpc_voltage_change1ts**](docs/TpcVoltageChange1tApi.md#get_tpc_voltage_change1ts) | **GET** /xenon1t/tpc/voltage_changes | Retrieves one or more TpcVoltageChange1ts
*TpcVoltageChange1tApi* | [**post_tpc_voltage_change1ts**](docs/TpcVoltageChange1tApi.md#post_tpc_voltage_change1ts) | **POST** /xenon1t/tpc/voltage_changes | Stores one or more TpcVoltageChange1ts.
*TpcVoltageChange1tApi* | [**put_tpc_voltage_change1t_item**](docs/TpcVoltageChange1tApi.md#put_tpc_voltage_change1t_item) | **PUT** /xenon1t/tpc/voltage_changes/{tpcvoltagechange1tId} | Replaces a TpcVoltageChange1t document
*TpcVoltageMapApi* | [**delete_tpc_voltage_map_item**](docs/TpcVoltageMapApi.md#delete_tpc_voltage_map_item) | **DELETE** /tpc/voltage_maps/{tpcvoltagemapId} | Deletes a TpcVoltageMap document
*TpcVoltageMapApi* | [**delete_tpc_voltage_maps**](docs/TpcVoltageMapApi.md#delete_tpc_voltage_maps) | **DELETE** /tpc/voltage_maps | Deletes all TpcVoltageMaps
*TpcVoltageMapApi* | [**get_tpc_voltage_map_item**](docs/TpcVoltageMapApi.md#get_tpc_voltage_map_item) | **GET** /tpc/voltage_maps/{tpcvoltagemapId} | Retrieves a TpcVoltageMap document
*TpcVoltageMapApi* | [**get_tpc_voltage_map_item_by_name**](docs/TpcVoltageMapApi.md#get_tpc_voltage_map_item_by_name) | **GET** /tpc/voltage_maps/{Name} | Retrieves a TpcVoltageMap document by name
*TpcVoltageMapApi* | [**get_tpc_voltage_maps**](docs/TpcVoltageMapApi.md#get_tpc_voltage_maps) | **GET** /tpc/voltage_maps | Retrieves one or more TpcVoltageMaps
*TpcVoltageMapApi* | [**post_tpc_voltage_maps**](docs/TpcVoltageMapApi.md#post_tpc_voltage_maps) | **POST** /tpc/voltage_maps | Stores one or more TpcVoltageMaps.
*TpcVoltageMapApi* | [**put_tpc_voltage_map_item**](docs/TpcVoltageMapApi.md#put_tpc_voltage_map_item) | **PUT** /tpc/voltage_maps/{tpcvoltagemapId} | Replaces a TpcVoltageMap document
*TpcVoltageMap1tApi* | [**delete_tpc_voltage_map1t_item**](docs/TpcVoltageMap1tApi.md#delete_tpc_voltage_map1t_item) | **DELETE** /xenon1t/tpc/voltage_maps/{tpcvoltagemap1tId} | Deletes a TpcVoltageMap1t document
*TpcVoltageMap1tApi* | [**delete_tpc_voltage_map1ts**](docs/TpcVoltageMap1tApi.md#delete_tpc_voltage_map1ts) | **DELETE** /xenon1t/tpc/voltage_maps | Deletes all TpcVoltageMap1ts
*TpcVoltageMap1tApi* | [**get_tpc_voltage_map1t_item**](docs/TpcVoltageMap1tApi.md#get_tpc_voltage_map1t_item) | **GET** /xenon1t/tpc/voltage_maps/{tpcvoltagemap1tId} | Retrieves a TpcVoltageMap1t document
*TpcVoltageMap1tApi* | [**get_tpc_voltage_map1t_item_by_name**](docs/TpcVoltageMap1tApi.md#get_tpc_voltage_map1t_item_by_name) | **GET** /xenon1t/tpc/voltage_maps/{Name} | Retrieves a TpcVoltageMap1t document by name
*TpcVoltageMap1tApi* | [**get_tpc_voltage_map1ts**](docs/TpcVoltageMap1tApi.md#get_tpc_voltage_map1ts) | **GET** /xenon1t/tpc/voltage_maps | Retrieves one or more TpcVoltageMap1ts
*TpcVoltageMap1tApi* | [**post_tpc_voltage_map1ts**](docs/TpcVoltageMap1tApi.md#post_tpc_voltage_map1ts) | **POST** /xenon1t/tpc/voltage_maps | Stores one or more TpcVoltageMap1ts.
*TpcVoltageMap1tApi* | [**put_tpc_voltage_map1t_item**](docs/TpcVoltageMap1tApi.md#put_tpc_voltage_map1t_item) | **PUT** /xenon1t/tpc/voltage_maps/{tpcvoltagemap1tId} | Replaces a TpcVoltageMap1t document
*TpcVoltageMapNameApi* | [**get_tpc_voltage_map_names**](docs/TpcVoltageMapNameApi.md#get_tpc_voltage_map_names) | **GET** /tpc/voltage_maps/names | Retrieves one or more TpcVoltageMapNames
*TpcVoltageMapName1tApi* | [**get_tpc_voltage_map_name1ts**](docs/TpcVoltageMapName1tApi.md#get_tpc_voltage_map_name1ts) | **GET** /xenon1t/tpc/voltage_maps/names | Retrieves one or more TpcVoltageMapName1ts


## Documentation For Models

 - [Account](docs/Account.md)
 - [Error](docs/Error.md)
 - [ErrorError](docs/ErrorError.md)
 - [HighVoltageChange](docs/HighVoltageChange.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse20015](docs/InlineResponse20015.md)
 - [InlineResponse20016](docs/InlineResponse20016.md)
 - [InlineResponse20017](docs/InlineResponse20017.md)
 - [InlineResponse20018](docs/InlineResponse20018.md)
 - [InlineResponse20019](docs/InlineResponse20019.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse20020](docs/InlineResponse20020.md)
 - [InlineResponse20021](docs/InlineResponse20021.md)
 - [InlineResponse20022](docs/InlineResponse20022.md)
 - [InlineResponse20023](docs/InlineResponse20023.md)
 - [InlineResponse20024](docs/InlineResponse20024.md)
 - [InlineResponse20025](docs/InlineResponse20025.md)
 - [InlineResponse20026](docs/InlineResponse20026.md)
 - [InlineResponse20027](docs/InlineResponse20027.md)
 - [InlineResponse20028](docs/InlineResponse20028.md)
 - [InlineResponse20029](docs/InlineResponse20029.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse20030](docs/InlineResponse20030.md)
 - [InlineResponse20031](docs/InlineResponse20031.md)
 - [InlineResponse20032](docs/InlineResponse20032.md)
 - [InlineResponse20033](docs/InlineResponse20033.md)
 - [InlineResponse20034](docs/InlineResponse20034.md)
 - [InlineResponse20035](docs/InlineResponse20035.md)
 - [InlineResponse20036](docs/InlineResponse20036.md)
 - [InlineResponse20037](docs/InlineResponse20037.md)
 - [InlineResponse20038](docs/InlineResponse20038.md)
 - [InlineResponse20039](docs/InlineResponse20039.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse20040](docs/InlineResponse20040.md)
 - [InlineResponse20041](docs/InlineResponse20041.md)
 - [InlineResponse20042](docs/InlineResponse20042.md)
 - [InlineResponse20043](docs/InlineResponse20043.md)
 - [InlineResponse20044](docs/InlineResponse20044.md)
 - [InlineResponse20045](docs/InlineResponse20045.md)
 - [InlineResponse20046](docs/InlineResponse20046.md)
 - [InlineResponse20047](docs/InlineResponse20047.md)
 - [InlineResponse20048](docs/InlineResponse20048.md)
 - [InlineResponse20049](docs/InlineResponse20049.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse20050](docs/InlineResponse20050.md)
 - [InlineResponse20051](docs/InlineResponse20051.md)
 - [InlineResponse20052](docs/InlineResponse20052.md)
 - [InlineResponse20053](docs/InlineResponse20053.md)
 - [InlineResponse20054](docs/InlineResponse20054.md)
 - [InlineResponse20055](docs/InlineResponse20055.md)
 - [InlineResponse20056](docs/InlineResponse20056.md)
 - [InlineResponse20057](docs/InlineResponse20057.md)
 - [InlineResponse20058](docs/InlineResponse20058.md)
 - [InlineResponse20059](docs/InlineResponse20059.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse20060](docs/InlineResponse20060.md)
 - [InlineResponse20061](docs/InlineResponse20061.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [MuvetoAfterpulse](docs/MuvetoAfterpulse.md)
 - [MuvetoAfterpulse1t](docs/MuvetoAfterpulse1t.md)
 - [MuvetoCurrentChange](docs/MuvetoCurrentChange.md)
 - [MuvetoCurrentChange1t](docs/MuvetoCurrentChange1t.md)
 - [MuvetoDarkCountRate](docs/MuvetoDarkCountRate.md)
 - [MuvetoDarkCountRate1t](docs/MuvetoDarkCountRate1t.md)
 - [MuvetoGain](docs/MuvetoGain.md)
 - [MuvetoGain1t](docs/MuvetoGain1t.md)
 - [MuvetoGainMeasurement](docs/MuvetoGainMeasurement.md)
 - [MuvetoGainMeasurement1t](docs/MuvetoGainMeasurement1t.md)
 - [MuvetoGainModel](docs/MuvetoGainModel.md)
 - [MuvetoGainModel1t](docs/MuvetoGainModel1t.md)
 - [MuvetoInstall](docs/MuvetoInstall.md)
 - [MuvetoInstall1t](docs/MuvetoInstall1t.md)
 - [MuvetoPmt](docs/MuvetoPmt.md)
 - [MuvetoPmt1t](docs/MuvetoPmt1t.md)
 - [MuvetoPmtError](docs/MuvetoPmtError.md)
 - [MuvetoPmtError1t](docs/MuvetoPmtError1t.md)
 - [MuvetoVoltageChange](docs/MuvetoVoltageChange.md)
 - [MuvetoVoltageChange1t](docs/MuvetoVoltageChange1t.md)
 - [MuvetoVoltageMap](docs/MuvetoVoltageMap.md)
 - [MuvetoVoltageMap1t](docs/MuvetoVoltageMap1t.md)
 - [MuvetoVoltageMapName](docs/MuvetoVoltageMapName.md)
 - [MuvetoVoltageMapName1t](docs/MuvetoVoltageMapName1t.md)
 - [NvetoAfterpulse](docs/NvetoAfterpulse.md)
 - [NvetoCurrentChange](docs/NvetoCurrentChange.md)
 - [NvetoDarkCountRate](docs/NvetoDarkCountRate.md)
 - [NvetoGain](docs/NvetoGain.md)
 - [NvetoGainMeasurement](docs/NvetoGainMeasurement.md)
 - [NvetoGainModel](docs/NvetoGainModel.md)
 - [NvetoInstall](docs/NvetoInstall.md)
 - [NvetoPmt](docs/NvetoPmt.md)
 - [NvetoPmtError](docs/NvetoPmtError.md)
 - [NvetoVoltageChange](docs/NvetoVoltageChange.md)
 - [NvetoVoltageMap](docs/NvetoVoltageMap.md)
 - [NvetoVoltageMapName](docs/NvetoVoltageMapName.md)
 - [ResponeLinks](docs/ResponeLinks.md)
 - [ResponeLinksParent](docs/ResponeLinksParent.md)
 - [ResponeMetadata](docs/ResponeMetadata.md)
 - [TpcAfterpulse](docs/TpcAfterpulse.md)
 - [TpcAfterpulse1t](docs/TpcAfterpulse1t.md)
 - [TpcCurrentChange](docs/TpcCurrentChange.md)
 - [TpcCurrentChange1t](docs/TpcCurrentChange1t.md)
 - [TpcDarkCountRate](docs/TpcDarkCountRate.md)
 - [TpcDarkCountRate1t](docs/TpcDarkCountRate1t.md)
 - [TpcGain](docs/TpcGain.md)
 - [TpcGain1t](docs/TpcGain1t.md)
 - [TpcGainMeasurement](docs/TpcGainMeasurement.md)
 - [TpcGainMeasurement1t](docs/TpcGainMeasurement1t.md)
 - [TpcGainModel](docs/TpcGainModel.md)
 - [TpcGainModel1t](docs/TpcGainModel1t.md)
 - [TpcInstall](docs/TpcInstall.md)
 - [TpcInstall1t](docs/TpcInstall1t.md)
 - [TpcPmt](docs/TpcPmt.md)
 - [TpcPmt1t](docs/TpcPmt1t.md)
 - [TpcPmtError](docs/TpcPmtError.md)
 - [TpcPmtError1t](docs/TpcPmtError1t.md)
 - [TpcVoltageChange](docs/TpcVoltageChange.md)
 - [TpcVoltageChange1t](docs/TpcVoltageChange1t.md)
 - [TpcVoltageMap](docs/TpcVoltageMap.md)
 - [TpcVoltageMap1t](docs/TpcVoltageMap1t.md)
 - [TpcVoltageMapName](docs/TpcVoltageMapName.md)
 - [TpcVoltageMapName1t](docs/TpcVoltageMapName1t.md)
 - [TpcVoltageMapVoltages](docs/TpcVoltageMapVoltages.md)


## Documentation For Authorization


## BearerAuth

- **Type**: Bearer authentication


## Author

joe.mosbacher@gmail.com


