# pylint: disable=invalid-name
"""
Utility module for TS3 Exceptions.
"""
from enum import IntEnum


class TS3QueryExceptionType(IntEnum):
    """
    TS3 Query Exception based on TS3 error codes.
    """
    OK = 0
    UNDEFINED = 1
    NOT_IMPLEMENTED = 2
    OK_NO_UPDATE = 3
    DONT_NOTIFY = 4
    LIB_TIME_LIMIT_REACHED = 5
    COMMAND_NOT_FOUND = 256
    UNABLE_TO_BIND_NETWORK_PORT = 257
    NO_NETWORK_PORT_AVAILABLE = 258
    CLIENT_INVALID_ID = 512
    CLIENT_NICKNAME_INUSE = 513
    CLIENT_PROTOCOL_LIMIT_REACHED = 515
    CLIENT_INVALID_TYPE = 516
    CLIENT_ALREADY_SUBSCRIBED = 517
    CLIENT_NOT_LOGGED_IN = 518
    CLIENT_COULD_NOT_VALIDATE_IDENTITY = 519
    CLIENT_INVALID_PASSWORD = 520
    CLIENT_TOO_MANY_CLONES_CONNECTED = 521
    CLIENT_VERSION_OUTDATED = 522
    CLIENT_IS_ONLINE = 523
    CLIENT_IS_FLOODING = 524
    CLIENT_HACKED = 525
    CLIENT_CANNOT_VERIFY_NOW = 526
    CLIENT_LOGIN_NOT_PERMITTED = 527
    CLIENT_NOT_SUBSCRIBED = 528
    CHANNEL_INVALID_ID = 768
    CHANNEL_PROTOCOL_LIMIT_REACHED = 769
    CHANNEL_ALREADY_IN = 770
    CHANNEL_NAME_INUSE = 771
    CHANNEL_NOT_EMPTY = 772
    CHANNEL_CAN_NOT_DELETE_DEFAULT = 773
    CHANNEL_DEFAULT_REQUIRE_PERMANENT = 774
    CHANNEL_INVALID_FLAGS = 775
    CHANNEL_PARENT_NOT_PERMANENT = 776
    CHANNEL_MAXCLIENTS_REACHED = 777
    CHANNEL_MAXFAMILY_REACHED = 778
    CHANNEL_INVALID_ORDER = 779
    CHANNEL_NO_FILETRANSFER_SUPPORTED = 780
    CHANNEL_INVALID_PASSWORD = 781
    CHANNEL_IS_PRIVATE_CHANNEL = 782
    CHANNEL_INVALID_SECURITY_HASH = 783
    SERVER_INVALID_ID = 1024
    SERVER_RUNNING = 1025
    SERVER_IS_SHUTTING_DOWN = 1026
    SERVER_MAXCLIENTS_REACHED = 1027
    SERVER_INVALID_PASSWORD = 1028
    SERVER_DEPLOYMENT_ACTIVE = 1029
    SERVER_UNABLE_TO_STOP_OWN_SERVER = 1030
    SERVER_IS_VIRTUAL = 1031
    SERVER_WRONG_MACHINEID = 1032
    SERVER_IS_NOT_RUNNING = 1033
    SERVER_IS_BOOTING = 1034
    SERVER_STATUS_INVALID = 1035
    SERVER_MODAL_QUIT = 1036
    SERVER_VERSION_OUTDATED = 1037
    DATABASE = 1280
    DATABASE_EMPTY_RESULT = 1281
    DATABASE_DUPLICATE_ENTRY = 1282
    DATABASE_NO_MODIFICATIONS = 1283
    DATABASE_CONSTRAINT = 1284
    DATABASE_REINVOKE = 1285
    PARAMETER_QUOTE = 1536
    PARAMETER_INVALID_COUNT = 1537
    PARAMETER_INVALID = 1538
    PARAMETER_NOT_FOUND = 1539
    PARAMETER_CONVERT = 1540
    PARAMETER_INVALID_SIZE = 1541
    PARAMETER_MISSING = 1542
    PARAMETER_CHECKSUM = 1543
    VS_CRITICAL = 1792
    CONNECTION_LOST = 1793
    NOT_CONNECTED = 1794
    NO_CACHED_CONNECTION_INFO = 1795
    CURRENTLY_NOT_POSSIBLE = 1796
    FAILED_CONNECTION_INITIALISATION = 1797
    COULD_NOT_RESOLVE_HOSTNAME = 1798
    INVALID_SERVER_CONNECTION_HANDLER_ID = 1799
    COULD_NOT_INITIALISE_INPUT_MANAGER = 1800
    CLIENTLIBRARY_NOT_INITIALISED = 1801
    SERVERLIBRARY_NOT_INITIALISED = 1802
    WHISPER_TOO_MANY_TARGETS = 1803
    WHISPER_NO_TARGETS = 1804
    FILE_INVALID_NAME = 2048
    FILE_INVALID_PERMISSIONS = 2049
    FILE_ALREADY_EXISTS = 2050
    FILE_NOT_FOUND = 2051
    FILE_IO_ERROR = 2052
    FILE_INVALID_TRANSFER_ID = 2053
    FILE_INVALID_PATH = 2054
    FILE_NO_FILES_AVAILABLE = 2055
    FILE_OVERWRITE_EXCLUDES_RESUME = 2056
    FILE_INVALID_SIZE = 2057
    FILE_ALREADY_IN_USE = 2058
    FILE_COULD_NOT_OPEN_CONNECTION = 2059
    FILE_NO_SPACE_LEFT_ON_DEVICE = 2060
    FILE_EXCEEDS_FILE_SYSTEM_MAXIMUM_SIZE = 2061
    FILE_TRANSFER_CONNECTION_TIMEOUT = 2062
    FILE_CONNECTION_LOST = 2063
    FILE_EXCEEDS_SUPPLIED_SIZE = 2064
    FILE_TRANSFER_COMPLETE = 2065
    FILE_TRANSFER_CANCELED = 2066
    FILE_TRANSFER_INTERRUPTED = 2067
    FILE_TRANSFER_SERVER_QUOTA_EXCEEDED = 2068
    FILE_TRANSFER_CLIENT_QUOTA_EXCEEDED = 2069
    FILE_TRANSFER_RESET = 2070
    FILE_TRANSFER_LIMIT_REACHED = 2071
    SOUND_PREPROCESSOR_DISABLED = 2304
    SOUND_INTERNAL_PREPROCESSOR = 2305
    SOUND_INTERNAL_ENCODER = 2306
    SOUND_INTERNAL_PLAYBACK = 2307
    SOUND_NO_CAPTURE_DEVICE_AVAILABLE = 2308
    SOUND_NO_PLAYBACK_DEVICE_AVAILABLE = 2309
    SOUND_COULD_NOT_OPEN_CAPTURE_DEVICE = 2310
    SOUND_COULD_NOT_OPEN_PLAYBACK_DEVICE = 2311
    SOUND_HANDLER_HAS_DEVICE = 2312
    SOUND_INVALID_CAPTURE_DEVICE = 2313
    SOUND_INVALID_PLAYBACK_DEVICE = 2314
    SOUND_INVALID_WAVE = 2315
    SOUND_UNSUPPORTED_WAVE = 2316
    SOUND_OPEN_WAVE = 2317
    SOUND_INTERNAL_CAPTURE = 2318
    SOUND_DEVICE_IN_USE = 2319
    SOUND_DEVICE_ALREADY_REGISTERRED = 2320
    SOUND_UNKNOWN_DEVICE = 2321
    SOUND_UNSUPPORTED_FREQUENCY = 2322
    SOUND_INVALID_CHANNEL_COUNT = 2323
    SOUND_READ_WAVE = 2324
    SOUND_NEED_MORE_DATA = 2325
    SOUND_DEVICE_BUSY = 2326
    SOUND_NO_DATA = 2327
    SOUND_CHANNEL_MASK_MISMATCH = 2328
    PERMISSION_INVALID_GROUP_ID = 2560
    PERMISSION_DUPLICATE_ENTRY = 2561
    PERMISSION_INVALID_PERM_ID = 2562
    PERMISSION_EMPTY_RESULT = 2563
    PERMISSION_DEFAULT_GROUP_FORBIDDEN = 2564
    PERMISSION_INVALID_SIZE = 2565
    PERMISSION_INVALID_VALUE = 2566
    PERMISSIONS_GROUP_NOT_EMPTY = 2567
    PERMISSIONS_CLIENT_INSUFFICIENT = 2568
    PERMISSIONS_INSUFFICIENT_GROUP_POWER = 2569
    PERMISSIONS_INSUFFICIENT_PERMISSION_POWER = 2570
    PERMISSION_TEMPLATE_GROUP_IS_USED = 2571
    PERMISSIONS = 2572
    ACCOUNTING_VIRTUALSERVER_LIMIT_REACHED = 2816
    ACCOUNTING_SLOT_LIMIT_REACHED = 2817
    ACCOUNTING_LICENSE_FILE_NOT_FOUND = 2818
    ACCOUNTING_LICENSE_DATE_NOT_OK = 2819
    ACCOUNTING_UNABLE_TO_CONNECT_TO_SERVER = 2820
    ACCOUNTING_UNKNOWN_ERROR = 2821
    ACCOUNTING_SERVER_ERROR = 2822
    ACCOUNTING_INSTANCE_LIMIT_REACHED = 2823
    ACCOUNTING_INSTANCE_CHECK_ERROR = 2824
    ACCOUNTING_LICENSE_FILE_INVALID = 2825
    ACCOUNTING_RUNNING_ELSEWHERE = 2826
    ACCOUNTING_INSTANCE_DUPLICATED = 2827
    ACCOUNTING_ALREADY_STARTED = 2828
    ACCOUNTING_NOT_STARTED = 2829
    ACCOUNTING_TO_MANY_STARTS = 2830
    MESSAGE_INVALID_ID = 3072
    BAN_INVALID_ID = 3328
    CONNECT_FAILED_BANNED = 3329
    RENAME_FAILED_BANNED = 3330
    BAN_FLOODING = 3331
    TTS_UNABLE_TO_INITIALIZE = 3584
    PRIVILEGE_KEY_INVALID = 3840
    VOIP_PJSUA = 4096
    VOIP_ALREADY_INITIALIZED = 4097
    VOIP_TOO_MANY_ACCOUNTS = 4098
    VOIP_INVALID_ACCOUNT = 4099
    VOIP_INTERNAL_ERROR = 4100
    VOIP_INVALID_CONNECTIONID = 4101
    VOIP_CANNOT_ANSWER_INITIATED_CALL = 4102
    VOIP_NOT_INITIALIZED = 4103
    PROVISIONING_INVALID_PASSWORD = 4352
    PROVISIONING_INVALID_REQUEST = 4353
    PROVISIONING_NO_SLOTS_AVAILABLE = 4354
    PROVISIONING_POOL_MISSING = 4355
    PROVISIONING_POOL_UNKNOWN = 4356
    PROVISIONING_UNKNOWN_IP_LOCATION = 4357
    PROVISIONING_INTERNAL_TRIES_EXCEEDED = 4358
    PROVISIONING_TOO_MANY_SLOTS_REQUESTED = 4359
    PROVISIONING_TOO_MANY_RESERVED = 4360
    PROVISIONING_COULD_NOT_CONNECT = 4361
    PROVISIONING_AUTH_SERVER_NOT_CONNECTED = 4368
    PROVISIONING_AUTH_DATA_TOO_LARGE = 4369
    PROVISIONING_ALREADY_INITIALIZED = 4370
    PROVISIONING_NOT_INITIALIZED = 4371
    PROVISIONING_CONNECTING = 4372
    PROVISIONING_ALREADY_CONNECTED = 4373
    PROVISIONING_NOT_CONNECTED = 4374
    PROVISIONING_IO_ERROR = 4375
    PROVISIONING_INVALID_TIMEOUT = 4376
    PROVISIONING_TS3SERVER_NOT_FOUND = 4377
    PROVISIONING_NO_PERMISSION = 4378
