"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3CodeCommitBackup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
class S3CodeCommitBackup extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { backupBucket, schedule, computeType, repository } = props;
        const { repositoryName, repositoryCloneUrlHttp, repositoryArn } = repository;
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_2_0;
        this.backupProject = new aws_codebuild_1.Project(this, 'BackupProject', {
            environment: {
                buildImage,
                computeType: computeType || buildImage.defaultComputeType,
            },
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                env: {
                    'git-credential-helper': 'yes',
                },
                phases: {
                    pre_build: {
                        commands: [`echo "[===== Clone repository: ${repositoryName} =====]"`, `git clone "${repositoryCloneUrlHttp}"`],
                    },
                    build: {
                        commands: [
                            "dt=$(date -u '+%Y_%m_%d_%H_%M')",
                            `zipfile="${repositoryName}_backup_\${dt}_UTC.tar.gz"`,
                            `echo "Compressing repository: ${repositoryName} into file: \${zipfile} and uploading to S3 bucket: ${backupBucket.bucketName}/${repositoryName}"`,
                            `tar -zcvf "\${zipfile}" "${repositoryName}/"`,
                            `aws s3 cp "\${zipfile}" "s3://${backupBucket.bucketName}/${repositoryName}/\${zipfile}"`,
                        ],
                    },
                },
            }),
        });
        backupBucket.grantPut(this.backupProject);
        this.backupProject.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: [repositoryArn],
            actions: ['codecommit:BatchGet*', 'codecommit:Get*', 'codecommit:Describe*', 'codecommit:List*', 'codecommit:GitPull'],
        }));
        new aws_events_1.Rule(this, 'ScheduleRule', {
            schedule,
            targets: [new aws_events_targets_1.CodeBuildProject(this.backupProject)],
        });
    }
    /**
     * Defines an event rule which triggers when a backup fails.
     */
    onBackupFailed(id, options) {
        return this.backupProject.onBuildFailed(id, options);
    }
    /**
     * Defines an event rule which triggers when a backup starts.
     */
    onBackupStarted(id, options) {
        return this.backupProject.onBuildStarted(id, options);
    }
    /**
     * Defines an event rule which triggers when a backup complets successfully.
     */
    onBackupSucceeded(id, options) {
        return this.backupProject.onBuildSucceeded(id, options);
    }
}
exports.S3CodeCommitBackup = S3CodeCommitBackup;
_a = JSII_RTTI_SYMBOL_1;
S3CodeCommitBackup[_a] = { fqn: "@cloudcomponents/cdk-codecommit-backup.S3CodeCommitBackup", version: "1.49.0" };
//# sourceMappingURL=data:application/json;base64,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