"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhookHandler = void 0;
const cdk = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const utils_1 = require("./utils");
/**
 * Create a Lambda with a public URL to handle GitHub webhook events. After validating the event with the given secret, the orchestrator step function is called with information about the workflow job.
 *
 * This construct is not meant to be used by itself.
 */
class GithubWebhookHandler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.handler = new utils_1.BundledNodejsFunction(this, 'webhook-handler', {
            description: 'Handle GitHub webhook and start runner orchestrator',
            environment: {
                STEP_FUNCTION_ARN: props.orchestrator.stateMachineArn,
                WEBHOOK_SECRET_ARN: props.secrets.webhook.secretArn,
            },
            timeout: cdk.Duration.seconds(30),
        });
        this.url = this.handler.addFunctionUrl({ authType: aws_lambda_1.FunctionUrlAuthType.NONE }).url;
        props.secrets.webhook.grantRead(this.handler);
        props.orchestrator.grantStartExecution(this.handler);
    }
}
exports.GithubWebhookHandler = GithubWebhookHandler;
//# sourceMappingURL=data:application/json;base64,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