"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsComponents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const common_1 = require("../common");
const common_2 = require("./common");
/**
 * Components for Windows that can be used with AWS Image Builder based builders. These cannot be used by {@link CodeBuildImageBuilder}.
 */
class WindowsComponents {
    static cloudwatchAgent(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'CloudWatch agent',
            description: 'Install latest version of CloudWatch agent for sending logs to CloudWatch',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i https://s3.amazonaws.com/amazoncloudwatch-agent/windows/amd64/latest/amazon-cloudwatch-agent.msi /qn\'',
            ],
        });
    }
    static awsCli(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'AWS CLI',
            description: 'Install latest version of AWS CLI',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i https://awscli.amazonaws.com/AWSCLIV2.msi /qn\'',
            ],
        });
    }
    static githubCli(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'GitHub CLI',
            description: 'Install latest version of gh',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/cli/cli/releases/latest > $Env:TEMP\\latest-gh',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-gh',
                '$GH_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
                '$ProgressPreference = \'SilentlyContinue\'',
                'Invoke-WebRequest -UseBasicParsing -Uri "https://github.com/cli/cli/releases/download/v${GH_VERSION}/gh_${GH_VERSION}_windows_amd64.msi" -OutFile gh.msi',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i gh.msi /qn\'',
                'del gh.msi',
            ],
        });
    }
    static git(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'Git',
            description: 'Install latest version of git',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/git-for-windows/git/releases/latest > $Env:TEMP\\latest-git',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-git',
                '$GIT_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
                '$GIT_VERSION_SHORT = ($GIT_VERSION -Split \'.windows.\')[0]',
                'Invoke-WebRequest -UseBasicParsing -Uri https://github.com/git-for-windows/git/releases/download/v${GIT_VERSION}/Git-${GIT_VERSION_SHORT}-64-bit.exe -OutFile git-setup.exe',
                'Start-Process git-setup.exe -Wait -ArgumentList \'/VERYSILENT\'',
                'del git-setup.exe',
            ],
        });
    }
    static githubRunner(scope, id, runnerVersion) {
        let runnerCommands;
        if (runnerVersion.is(common_1.RunnerVersion.latest())) {
            runnerCommands = [
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/actions/runner/releases/latest > $Env:TEMP\\latest-gha',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-gha',
                '$RUNNER_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
            ];
        }
        else {
            runnerCommands = [`$RUNNER_VERSION = '${runnerVersion.version}'`];
        }
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'GitHub Actions Runner',
            description: 'Install latest version of GitHub Actions Runner',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
            ].concat(runnerCommands, [
                'Invoke-WebRequest -UseBasicParsing -Uri "https://github.com/actions/runner/releases/download/v${RUNNER_VERSION}/actions-runner-win-x64-${RUNNER_VERSION}.zip" -OutFile actions.zip',
                'Expand-Archive actions.zip -DestinationPath C:\\actions',
                'del actions.zip',
            ]),
        });
    }
    static docker(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'Docker',
            description: 'Install latest version of Docker',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'Invoke-WebRequest -UseBasicParsing -Uri https://desktop.docker.com/win/main/amd64/Docker%20Desktop%20Installer.exe -OutFile docker-setup.exe',
                'Start-Process \'docker-setup.exe\' -Wait -ArgumentList \'/install --quiet --accept-license\'',
                'del docker-setup.exe',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/docker/compose/releases/latest > $Env:TEMP\\latest-docker-compose',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-docker-compose',
                '$LatestDockerCompose = ($LatestUrl -Split \'/\')[-1]',
                'Invoke-WebRequest -UseBasicParsing -Uri  "https://github.com/docker/compose/releases/download/${LatestDockerCompose}/docker-compose-Windows-x86_64.exe" -OutFile $Env:ProgramFiles\\Docker\\docker-compose.exe',
                'copy $Env:ProgramFiles\\Docker\\docker-compose.exe $Env:ProgramFiles\\Docker\\cli-plugins\\docker-compose.exe',
            ],
        });
    }
    static extraCertificates(scope, id, path) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'Extra certificates',
            description: 'Install self-signed certificates to provide access to GitHub Enterprise Server',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                'Import-Certificate -FilePath certs\\certs.pem -CertStoreLocation Cert:\\LocalMachine\\Root',
            ],
            assets: [
                {
                    path: 'certs',
                    asset: new aws_cdk_lib_1.aws_s3_assets.Asset(scope, `${id} Asset`, { path }),
                },
            ],
        });
    }
}
exports.WindowsComponents = WindowsComponents;
_a = JSII_RTTI_SYMBOL_1;
WindowsComponents[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.WindowsComponents", version: "0.7.2" };
//# sourceMappingURL=data:application/json;base64,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