# -*- coding: utf-8 -*-
from __future__ import print_function, absolute_import, division

# from builtins import map, range, object, zip, sorted
# from past.builtins import basestring


class AMPLException(Exception):
    """
    Represent an exception generated by AMPL.
    """

    def __init__(self, _impl):
        super(AMPLException, self).__init__()
        self._impl = _impl
        self.what = self._impl.what()
        self.source_name = _impl.getSourceName()
        self.line_number = _impl.getLineNumber()
        self.offset = _impl.getOffset()
        self.message = _impl.getMessage()

    def get_source_name(self):
        """
        Get the name of the file where the error was detected.
        """
        return self.source_name

    def get_line_number(self):
        """
        Get the row where the error is located.
        """
        return self.line_number

    def get_offset(self):
        """
        Get the offset where the error is located.
        """
        return self.offset

    def get_message(self):
        """
        Get the error message.
        """
        return self.message

    def __str__(self):
        return self.what.lstrip("file: -").strip("\n")

    # Aliases
    getLineNumber = get_line_number
    getMessage = get_message
    getOffset = get_offset
    getSourceName = get_source_name
