from dataclasses import dataclass


@dataclass
class PermissiveFilterConfig:
    max_ll: int = 1200
    min_len: int = 8
    min_max_ll: int = 5
    max_size_kbs: int = 1_000
    min_alphanum: float = 0.0001
    max_alphanum: float = 0.9900
    min_ave_ll: int = 8
    min_lines: int = 2


@dataclass
class ModerateFilterConfig:
    max_ll: int = 600
    min_len: int = 50
    min_max_ll: int = 25
    max_size_kbs: int = 750
    min_alphanum: float = 0.001
    max_alphanum: float = 0.975
    min_ave_ll: int = 16
    min_lines: int = 3


@dataclass
class AggressiveFilterConfig:
    max_ll: int = 300
    min_len: int = 100
    min_max_ll: int = 32
    max_size_kbs: int = 500
    min_alphanum: float = 0.0025
    max_alphanum: float = 0.9700
    min_ave_ll: int = 20
    min_lines: int = 5


@dataclass
class PythonGeneratedCaptureStrings:
    generated_by_django: str = 'enerated by Django'


@dataclass
class ProtocolBufferGeneratedCaptureStrings:
    generated_by_protocol_buffer: str = 'enerated by the protocol buffer'
    generated_protocol_buffer_code: str = 'enerated protocol buffer code'


@dataclass
class MicrosoftGeneratedCaptureStrings:
    code_generated_by_microsoft: str = '# Code generated by Microsoft'


@dataclass
class GenericGeneratedCaptureStrings:
    file_was_automatically_generated: str = 'his file was automatically generated'
    generated_by_github: str = 'enerated by: https://github.com/swagger'
    autogenerated_by_xml_generate_script: str = 'utogenerated by xml_generate script'
    file_was_generated_by: str = 'file was generated by'
    automatically_generated_by: str = '# Automatically generated by'
    this_file_was_autogenerated_by: str = '// This file was autogenerated by'
    generated_by: str = '// Generated by'
    automatically_generated_file: str = '/* Generated by'
    automatically_generated_file_notice: str = '* This is an automatically generated file'
    do_not_edit_notice: str = '// Do not edit, all changes will be lost'
    this_file_is_auto_generated: str = '// This file is auto-generated'
    this_code_was_generated_by: str = '// This code was generated by'
    this_code_was_autogenerated_by: str = '# This code was autogenerated by'
    generated_by_grpc: str = '# Generated by the gRPC'
    generated_by_typescript: str = 'This file was generated by the TypeScript'
    generated_by_xcode: str = '# This file was generated by Xcode'
    generated_using_wsdl: str = '// This file was generated using WSDL'
    generated_from_template: str = '// This file was generated from a template'
    file_is_generated_by: str = '# This file is generated by'
    autogenerated_by_generic: str = '# Autogenerated by'
    autogenerated_by_generic2: str = '// Autogenerated by'
