#!/usr/bin/env python
# -*- encoding: utf-8 -*-
from __future__ import absolute_import, print_function

from setuptools import find_packages, setup

import io
import re
from glob import glob
from os.path import basename, dirname, join, splitext


def _read(*names, **kwargs):
    return io.open(
        join(dirname(__file__), *names), encoding=kwargs.get("encoding", "utf8")
    ).read()


def _find_version(*file_paths):
    version_file = _read(*file_paths)
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]", version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")


# ======================================================================================================================

setup(
    name="21CMMC",
    version=_find_version("src", "py21cmmc", "__init__.py"),
    license="MIT license",
    description="An extensible MCMC framework for 21cmFAST",
    long_description="%s\n%s"
    % (
        re.compile("^.. start-badges.*^.. end-badges", re.M | re.S).sub(
            "", _read("README.rst")
        ),
        re.sub(":[a-z]+:`~?(.*?)`", r"``\1``", _read("CHANGELOG.rst")),
    ),
    author="Brad Greig",
    author_email="greigb@unimelb.edu.au",
    url="https://github.com/21cmFAST/21CMMC",
    packages=find_packages("src"),
    package_dir={"": "src"},
    package_data={"py21cmmc": ["data/*"]},
    py_modules=[splitext(basename(path))[0] for path in glob("src/*.py")],
    include_package_data=True,
    zip_safe=False,
    classifiers=[
        # complete classifier list: http://pypi.python.org/pypi?%3Aaction=list_classifiers
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: Unix",
        "Operating System :: POSIX",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    keywords=["Epoch of Reionization", "Cosmology"],
    install_requires=[
        "click",
        "numpy",
        "cosmoHammer",
        "scipy",
        "matplotlib>=2.1",
        "emcee<3",
        "powerbox>=0.5.7",
        "cached_property",
        "21cmFAST>=3.0.0dev1",
        "pymultinest",
    ],
    extras_require={"samplers": ["pymultinest"]},
)
