THAI_STOPWORDS = frozenset(
    [
        "ไว้",
        "ไม่",
        "ไป",
        "ได้",
        "ให้",
        "ใน",
        "โดย",
        "แห่ง",
        "แล้ว",
        "และ",
        "แรก",
        "แบบ",
        "แต่",
        "เอง",
        "เห็น",
        "เลย",
        "เริ่ม",
        "เรา",
        "เมื่อ",
        "เพื่อ",
        "เพราะ",
        "เป็นการ",
        "เป็น",
        "เปิดเผย",
        "เปิด",
        "เนื่องจาก",
        "เดียวกัน",
        "เดียว",
        "เช่น",
        "เฉพาะ",
        "เคย",
        "เข้า",
        "เขา",
        "อีก",
        "อาจ",
        "อะไร",
        "ออก",
        "อย่าง",
        "อยู่",
        "อยาก",
        "หาก",
        "หลาย",
        "หลังจาก",
        "หลัง",
        "หรือ",
        "หนึ่ง",
        "ส่วน",
        "ส่ง",
        "สุด",
        "สําหรับ",
        "ว่า",
        "วัน",
        "ลง",
        "ร่วม",
        "ราย",
        "รับ",
        "ระหว่าง",
        "รวม",
        "ยัง",
        "มี",
        "มาก",
        "มา",
        "พร้อม",
        "พบ",
        "ผ่าน",
        "ผล",
        "บาง",
        "น่า",
        "นี้",
        "นํา",
        "นั้น",
        "นัก",
        "นอกจาก",
        "ทุก",
        "ที่สุด",
        "ที่",
        "ทําให้",
        "ทํา",
        "ทาง",
        "ทั้งนี้",
        "ทั้ง",
        "ถ้า",
        "ถูก",
        "ถึง",
        "ต้อง",
        "ต่างๆ",
        "ต่าง",
        "ต่อ",
        "ตาม",
        "ตั้งแต่",
        "ตั้ง",
        "ด้าน",
        "ด้วย",
        "ดัง",
        "ซึ่ง",
        "ช่วง",
        "จึง",
        "จาก",
        "จัด",
        "จะ",
        "คือ",
        "ความ",
        "ครั้ง",
        "คง",
        "ขึ้น",
        "ของ",
        "ขอ",
        "ขณะ",
        "ก่อน",
        "ก็",
        "การ",
        "กับ",
        "กัน",
        "กว่า",
        "กล่าว",
    ]
)

# Thai normalization
THAI_NORMALIZE_PAIRS = [
    ("\u0E40\u0E40", "\u0E41"),  # Sara E + Sara E -> Sara AE
    ("\u0E4D\u0E32", "\u0E33"),  # Nikhahit + Sara AA -> Sara AM
    ("\u0E24\u0E32", "\u0E24\u0E45"),  # Ru + Sara AA -> Ru + Lakkhangyao
    ("\u0E26\u0E32", "\u0E26\u0E45"),  # Lu + Sara AA -> Lu + Lakkhangyao
]

# Thai digits to arabic digits
THAI_TO_ARABIC_DIGIT_PAIRS = [
    ("๐", "0"),
    ("๑", "1"),
    ("๒", "2"),
    ("๓", "3"),
    ("๔", "4"),
    ("๕", "5"),
    ("๖", "6"),
    ("๗", "7"),
    ("๘", "8"),
    ("๙", "9"),
]

# Replace or append some characters with a space.
TOKENIZE_PAIRS = [
    ("\0", " "),
    ("\r", " "),
    ("\n", " "),
    ("\t", " "),
    ("\u00A0", " "),  # non-breaking space
    ('"', " "),
    ("“", " "),
    ("”", " "),
    ("'", " "),
    ("`", " "),
    ("|", " "),
    (":", " "),
    (";", " "),
    ("(", " "),
    (")", " "),
    ("[", " "),
    ("]", " "),
    (">", " "),
    ("<", " "),
    ("}", " "),
    ("{", " "),
    ("~", " "),
    ("^", " "),
    ("-", " "),
    ("_", " "),
    ("+", " "),
    ("*", " "),
    ("/", " "),
    ("\\", " "),
    ("#", " "),
    ("@", " "),
    ("&", " "),
    ("?", " ? "),
    ("!", " ! "),
    ("%", " "),
    ("$", " "),  # Dollar
    ("¢", " "),  # Cent
    ("€", " "),  # Euro
    ("£", " "),  # Pound
    ("฿", " "),  # Thai Baht
    ("₭", " "),  # Lao Kip
    ("₱", " "),  # Philippine peso
    ("₹", " "),  # Indian rupee
    ("₨", " "),  # Rupee
    ("৳", " "),  # Bangladeshi Taka
    ("¥", " "),  # Yen/Yuan
    ("₩", " "),  # Won
    (",", " "),
    (".", " "),
    ("=", " "),
]
