#!/usr/bin/env python3

import pytest
from wellmap import *

@pytest.mark.parametrize(
        'args, expected', [
            (((0,0), 0, 0), []),
            (((0,0), 0, 1), []),
            (((0,0), 1, 0), []),
            (((0,0), 1, 1), [(0,0)]),
            (((0,0), 2, 1), [(0,0), (0,1)]),
            (((0,0), 1, 2), [(0,0), (1,0)]),
            (((0,0), 2, 2), [(0,0), (0,1), (1,0), (1,1)]),

            (((0,1), 0, 0), []),
            (((0,1), 0, 1), []),
            (((0,1), 1, 0), []),
            (((0,1), 1, 1), [(0,1)]),
            (((0,1), 2, 1), [(0,1), (0,2)]),
            (((0,1), 1, 2), [(0,1), (1,1)]),
            (((0,1), 2, 2), [(0,1), (0,2), (1,1), (1,2)]),

            (((1,0), 0, 0), []),
            (((1,0), 0, 1), []),
            (((1,0), 1, 0), []),
            (((1,0), 1, 1), [(1,0)]),
            (((1,0), 2, 1), [(1,0), (1,1)]),
            (((1,0), 1, 2), [(1,0), (2,0)]),
            (((1,0), 2, 2), [(1,0), (1,1), (2,0), (2,1)]),
        ],
)
def test_iter_ij_in_block(args, expected):
    print(args)
    assert set(iter_ij_in_block(*args)) == set(expected)
