"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = exports.TopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rocketmq_generated_1 = require("./rocketmq.generated");
Object.defineProperty(exports, "TopicProperty", { enumerable: true, get: function () { return rocketmq_generated_1.RosTopic; } });
/**
 * A ROS resource type:  `ALIYUN::ROCKETMQ::Topic`
 */
class Topic extends ros.Resource {
    /**
     * Create a new `ALIYUN::ROCKETMQ::Topic`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTopic = new rocketmq_generated_1.RosTopic(this, id, {
            instanceId: props.instanceId,
            perm: props.perm,
            topic: props.topic,
            messageType: props.messageType,
            remark: props.remark,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTopic;
        this.attrInstanceId = rosTopic.attrInstanceId;
        this.attrMessageType = rosTopic.attrMessageType;
        this.attrTopic = rosTopic.attrTopic;
    }
}
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,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