# Generated by Django 2.0.3 on 2018-03-30 17:59

import _socket
import django_audit_fields.fields.uuid_auto_field
import django_revision.revision_field
import edc_model_fields.fields.hostname_modification_field
import edc_model_fields.fields.userfield

# import django_audit_fields.fields.uuid_auto_field
import edc_utils
from django.db import migrations, models


class Migration(migrations.Migration):

    replaces = [
        ("django_crypto_fields", "0001_initial"),
        ("django_crypto_fields", "0002_crypt_cipher_mode"),
        ("django_crypto_fields", "0003_auto_20161124_1835"),
        ("django_crypto_fields", "0004_auto_20161221_0018"),
        ("django_crypto_fields", "0005_auto_20170106_1849"),
        ("django_crypto_fields", "0006_auto_20170328_0728"),
        ("django_crypto_fields", "0007_auto_20170518_1233"),
        ("django_crypto_fields", "0008_auto_20170624_1905"),
        ("django_crypto_fields", "0009_auto_20170903_1532"),
        ("django_crypto_fields", "0010_keyreference"),
        ("django_crypto_fields", "0011_delete_keyreference"),
    ]

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Crypt",
            fields=[
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True, max_length=50, verbose_name="user created"
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True, max_length=50, verbose_name="user modified"
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default="mac2-2.local",
                        help_text="System field. (modified on create only)",
                        max_length=50,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "hash",
                    models.CharField(
                        db_index=True, max_length=128, unique=True, verbose_name="Hash"
                    ),
                ),
                ("secret", models.BinaryField(verbose_name="Secret")),
                (
                    "algorithm",
                    models.CharField(db_index=True, max_length=25, null=True),
                ),
                ("mode", models.CharField(db_index=True, max_length=25, null=True)),
                (
                    "cipher_mode",
                    models.IntegerField(
                        help_text="pycrypto AES cipher mode (e.g. MODE_CBC)", null=True
                    ),
                ),
            ],
            options={"verbose_name": "Crypt"},
        ),
        migrations.AlterUniqueTogether(
            name="crypt", unique_together={("hash", "algorithm", "mode")}
        ),
        migrations.AlterField(
            model_name="crypt",
            name="hash",
            field=models.CharField(db_index=True, max_length=128, verbose_name="Hash"),
        ),
        migrations.AlterField(
            model_name="crypt",
            name="user_created",
            field=edc_model_fields.fields.userfield.UserField(
                blank=True,
                help_text="Updated by admin.save_model",
                max_length=50,
                verbose_name="user created",
            ),
        ),
        migrations.AlterField(
            model_name="crypt",
            name="user_modified",
            field=edc_model_fields.fields.userfield.UserField(
                blank=True,
                help_text="Updated by admin.save_model",
                max_length=50,
                verbose_name="user modified",
            ),
        ),
        migrations.AddField(
            model_name="crypt",
            name="device_created",
            field=models.CharField(blank=True, max_length=10),
        ),
        migrations.AddField(
            model_name="crypt",
            name="device_modified",
            field=models.CharField(blank=True, max_length=10),
        ),
        migrations.AddIndex(
            model_name="crypt",
            index=models.Index(
                fields=["hash", "algorithm", "mode"], name="django_cryp_hash_76d13d_idx"
            ),
        ),
        migrations.AlterField(
            model_name="crypt",
            name="hostname_created",
            field=models.CharField(
                blank=True,
                default=_socket.gethostname,
                help_text="System field. (modified on create only)",
                max_length=60,
            ),
        ),
    ]
