"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Streamlink = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
class Streamlink extends constructs_1.Construct {
    constructor(scope, id, _props = {}) {
        super(scope, id);
        const runtime = aws_lambda_1.Runtime.PYTHON_3_9;
        const streamlinkApp = path_1.join(__dirname, '..', 'streamlink');
        const layer = new lambda.LayerVersion(this, 'Layer', {
            compatibleRuntimes: [runtime],
            code: lambda.Code.fromAsset(streamlinkApp, {
                bundling: {
                    image: aws_cdk_lib_1.DockerImage.fromBuild(streamlinkApp),
                    workingDirectory: '/build',
                    command: [
                        'bash', '-c',
                        `pip install --upgrade aws_lambda_types streamlink lxml -t python/lib/${runtime.name}/site-packages/ && zip -rq /asset-output/layer.zip python`,
                    ],
                    outputType: aws_cdk_lib_1.BundlingOutput.ARCHIVED,
                },
            }),
        });
        this.function = new lambda.Function(this, 'Default', {
            runtime,
            handler: 'app.handler',
            code: lambda.Code.fromAsset(streamlinkApp),
            memorySize: 512,
            timeout: cdk.Duration.seconds(5),
            layers: [layer],
        });
    }
}
exports.Streamlink = Streamlink;
_a = JSII_RTTI_SYMBOL_1;
Streamlink[_a] = { fqn: "streamlink-serverless.Streamlink", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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