import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a Databricks Cluster
 *
 * @schema CfnClusterProps
 */
export interface CfnClusterProps {
    /**
     * If num_workers, number of worker nodes that this cluster should have. A cluster has one Spark driver and num_workers executors for a total of num_workers + 1 Spark nodes.
     *
     * @schema CfnClusterProps#NumWorkers
     */
    readonly numWorkers?: number;
    /**
     * @schema CfnClusterProps#Autoscale
     */
    readonly autoscale?: Autoscale;
    /**
     * Cluster name requested by the user. This doesn't have to be unique. If not specified at creation, the cluster name will be an empty string.
     *
     * @schema CfnClusterProps#ClusterName
     */
    readonly clusterName?: string;
    /**
     * The runtime version of the cluster. You can retrieve a list of available runtime versions by using the Runtime versions API call. This field is required.
     *
     * @schema CfnClusterProps#SparkVersion
     */
    readonly sparkVersion?: string;
    /**
     * @schema CfnClusterProps#SparkConf
     */
    readonly sparkConf?: any;
    /**
     * @schema CfnClusterProps#AwsAttributes
     */
    readonly awsAttributes?: AwsAttributes;
    /**
     * This field encodes, through a single value, the resources available to each of the Spark nodes in this cluster. For example, the Spark nodes can be provisioned and optimized for memory or compute intensive workloads A list of available node types can be retrieved by using the List node types API call. This field is required.
     *
     * @schema CfnClusterProps#NodeTypeId
     */
    readonly nodeTypeId?: string;
    /**
     * The node type of the Spark driver. This field is optional; if unset, the driver node type will be set as the same value as node_type_id defined above.
     *
     * @schema CfnClusterProps#DriverNodeTypeId
     */
    readonly driverNodeTypeId?: string;
    /**
     * SSH public key contents that will be added to each Spark node in this cluster. The corresponding private keys can be used to login with the user name ubuntu on port 2200. Up to 10 keys can be specified.
     *
     * @schema CfnClusterProps#SshPublicKeys
     */
    readonly sshPublicKeys?: string[];
    /**
     * @schema CfnClusterProps#CustomTags
     */
    readonly customTags?: any;
    /**
     * The configuration for storing init scripts. Any number of destinations can be specified. The scripts are executed sequentially in the order provided. If cluster_log_conf is specified, init script logs are sent to <destination>/<cluster-ID>/init_scripts.
     *
     * @schema CfnClusterProps#InitScripts
     */
    readonly initScripts?: InitScriptsListItem[];
    /**
     * An object containing a set of optional, user-specified environment variable key-value pairs. Key-value pairs of the form (X,Y) are exported as is (that is, export X='Y') while launching the driver and workers. In order to specify an additional set of SPARK_DAEMON_JAVA_OPTS, we recommend appending them to $SPARK_DAEMON_JAVA_OPTS as shown in the following example. This ensures that all default Databricks managed environmental variables are included as well. Example Spark environment variables: {"SPARK_WORKER_MEMORY": "28000m", "SPARK_LOCAL_DIRS": "/local_disk0"} or {"SPARK_DAEMON_JAVA_OPTS": "$SPARK_DAEMON_JAVA_OPTS
     *
     * @schema CfnClusterProps#SparkEnvVars
     */
    readonly sparkEnvVars?: any;
    /**
     * Automatically terminates the cluster after it is inactive for this time in minutes. If not set, this cluster will not be automatically terminated. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable
     *
     * @schema CfnClusterProps#AutoterminationMinutes
     */
    readonly autoterminationMinutes?: number;
    /**
     * Autoscaling Local Storage: when enabled, this cluster will dynamically acquire additional disk space when its Spark workers are running low on disk space. This feature requires specific AWS permissions to function correctly - refer to Autoscaling local storage for details.
     *
     * @schema CfnClusterProps#EnableElasticDisk
     */
    readonly enableElasticDisk?: boolean;
    /**
     * The optional ID of the instance pool to use for the driver node. You must also specify instance_pool_id. Refer to Instance Pools API 2.0 for details.
     *
     * @schema CfnClusterProps#DriverInstancePoolId
     */
    readonly driverInstancePoolId?: string;
    /**
     * The optional ID of the instance pool to use for cluster nodes. If driver_instance_pool_id is present, instance_pool_id is used for worker nodes only. Otherwise, it is used for both the driver and worker nodes. Refer to Instance Pools API 2.0 for details.
     *
     * @schema CfnClusterProps#InstancePoolId
     */
    readonly instancePoolId?: string;
    /**
     * An optional token that can be used to guarantee the idempotency of cluster creation requests. If the idempotency token is assigned to a cluster that is not in the TERMINATED state, the request does not create a new cluster but instead returns the ID of the existing cluster. Otherwise, a new cluster is created. The idempotency token is cleared when the cluster is terminated
     *
     * If you specify the idempotency token, upon failure you can retry until the request succeeds. Databricks guarantees that exactly one cluster will be launched with that idempotency token.
     *
     * This token should have at most 64 characters.
     *
     * @schema CfnClusterProps#IdempotencyToken
     */
    readonly idempotencyToken?: string;
    /**
     * Whether to use policy default values for missing cluster attributes.
     *
     *
     *
     * @schema CfnClusterProps#ApplyPolicyDefaultValues
     */
    readonly applyPolicyDefaultValues?: boolean;
    /**
     * Whether encryption of disks locally attached to the cluster is enabled.
     *
     *
     *
     * @schema CfnClusterProps#EnableLocalDiskEncryption
     */
    readonly enableLocalDiskEncryption?: boolean;
    /**
     * The type of runtime engine to use. If not specified, the runtime engine type is inferred based on the spark_version value. Allowed values include:
     *
     * PHOTON: Use the Photon runtime engine type.
     *
     * STANDARD: Use the standard runtime engine type.
     *
     * This field is optional.
     *
     * @schema CfnClusterProps#RuntimeEngine
     */
    readonly runtimeEngine?: string;
    /**
     * @schema CfnClusterProps#ClusterMemoryMb
     */
    readonly clusterMemoryMb?: number;
    /**
     * @schema CfnClusterProps#ClusterCores
     */
    readonly clusterCores?: number;
    /**
     * @schema CfnClusterProps#InstanceSource
     */
    readonly instanceSource?: CfnClusterPropsInstanceSource;
    /**
     * @schema CfnClusterProps#Driver
     */
    readonly driver?: any;
    /**
     * @schema CfnClusterProps#DriverInstanceSource
     */
    readonly driverInstanceSource?: CfnClusterPropsDriverInstanceSource;
    /**
     * @schema CfnClusterProps#ClusterSource
     */
    readonly clusterSource?: string;
    /**
     * @schema CfnClusterProps#CreatorUserName
     */
    readonly creatorUserName?: string;
    /**
     * @schema CfnClusterProps#DefaultTags
     */
    readonly defaultTags?: CfnClusterPropsDefaultTags;
    /**
     * @schema CfnClusterProps#EffectiveSparkVersion
     */
    readonly effectiveSparkVersion?: string;
    /**
     * @schema CfnClusterProps#StartTime
     */
    readonly startTime?: number;
}
/**
 * Converts an object of type 'CfnClusterProps' to JSON representation.
 */
export declare function toJson_CfnClusterProps(obj: CfnClusterProps | undefined): Record<string, any> | undefined;
/**
 * Range defining the min and max number of cluster workers
 *
 * @schema Autoscale
 */
export interface Autoscale {
    /**
     * The minimum number of workers to which the cluster can scale down when underutilized. It is also the initial number of workers the cluster will have after creation.
     *
     * @schema Autoscale#MinWorkers
     */
    readonly minWorkers: number;
    /**
     * The maximum number of workers to which the cluster can scale up when overloaded. max_workers must be strictly greater than min_workers.
     *
     * @schema Autoscale#MaxWorkers
     */
    readonly maxWorkers: number;
}
/**
 * Converts an object of type 'Autoscale' to JSON representation.
 */
export declare function toJson_Autoscale(obj: Autoscale | undefined): Record<string, any> | undefined;
/**
 * Attributes set during cluster creation related to Amazon Web Services.
 *
 * @schema AwsAttributes
 */
export interface AwsAttributes {
    /**
     * The first first_on_demand nodes of the cluster will be placed on on-demand instances. If this value is greater than 0, the cluster driver node will be placed on an on-demand instance. If this value is greater than or equal to the current cluster size, all nodes will be placed on on-demand instances. If this value is less than the current cluster size, first_on_demand nodes will be placed on on-demand instances and the remainder will be placed on availability instances. This value does not affect cluster size and cannot be mutated over the lifetime of a cluster.
     *
     * @schema AwsAttributes#FirstOnDemand
     */
    readonly firstOnDemand?: number;
    /**
     * Availability type used for all subsequent nodes past the first_on_demand ones. Note: If first_on_demand is zero, this availability type will be used for the entire cluster.
     *
     * @schema AwsAttributes#Availability
     */
    readonly availability?: AwsAttributesAvailability;
    /**
     * Identifier for the availability zone/datacenter in which the cluster resides. You have three options:
     *
     * Specify an availability zone as a string, for example: 'us-west-2a'. The provided availability zone must be in the same region as the Databricks deployment. For example, 'us-west-2a' is not a valid zone ID if the Databricks deployment resides in the 'us-east-1' region.
     *
     * Enable automatic availability zone selection ('Auto-AZ'), by setting the value 'auto'. Databricks selects the AZ based on available IPs in the workspace subnets and retries in other availability zones if AWS returns insufficient capacity errors.
     *
     * Do not specify a value. If not specified, a default zone will be used.
     *
     * @schema AwsAttributes#ZoneId
     */
    readonly zoneId?: string;
    /**
     * The max price for AWS spot instances, as a percentage of the corresponding instance type's on-demand price. For example, if this field is set to 50, and the cluster needs a new i3.xlarge spot instance, then the max price is half of the price of on-demand i3.xlarge instances. Similarly, if this field is set to 200, the max price is twice the price of on-demand i3.xlarge instances. If not specified, the default value is 100. When spot instances are requested for this cluster, only spot instances whose max price percentage matches this field will be considered. For safety, we enforce this field to be no more than 10000.
     *
     * @schema AwsAttributes#SpotBidPricePercent
     */
    readonly spotBidPricePercent?: number;
    /**
     * The type of EBS volumes that will be launched with this cluster.
     *
     * @schema AwsAttributes#EbsVolumeType
     */
    readonly ebsVolumeType?: AwsAttributesEbsVolumeType;
    /**
     * The number of volumes launched for each instance. You can choose up to 10 volumes. This feature is only enabled for supported node types. Legacy node types cannot specify custom EBS volumes. For node types with no instance store, at least one EBS volume needs to be specified; otherwise, cluster creation will fail.
     *
     * These EBS volumes will be mounted at /ebs0, /ebs1, and etc. Instance store volumes will be mounted at /local_disk0, /local_disk1, and etc.
     *
     * If EBS volumes are attached, Databricks will configure Spark to use only the EBS volumes for scratch storage because heterogeneously sized scratch devices can lead to inefficient disk utilization. If no EBS volumes are attached, Databricks will configure Spark to use instance store volumes.
     *
     * If EBS volumes are specified, then the Spark configuration spark.local.dir will be overridden.
     *
     * @schema AwsAttributes#EbsVolumeCount
     */
    readonly ebsVolumeCount?: number;
    /**
     * The size of each EBS volume (in GiB) launched for each instance. For general purpose SSD, this value must be within the range 100 - 4096. For throughput optimized HDD, this value must be within the range 500 - 4096. Custom EBS volumes cannot be specified for the legacy node types (memory-optimized and compute-optimized).
     *
     * @schema AwsAttributes#EbsVolumeSize
     */
    readonly ebsVolumeSize?: number;
    /**
     * The number of IOPS per EBS gp3 volume.
     *
     * This value must be between 3000 and 16000.
     *
     * The value of IOPS and throughput is calculated based on AWS documentation to match the maximum performance of a gp2 volume with the same volume size.
     *
     * For more information, see the EBS volume limit calculator.
     *
     * @schema AwsAttributes#EbsVolumeIops
     */
    readonly ebsVolumeIops?: number;
    /**
     * The throughput per EBS gp3 volume, in MiB per second.
     *
     * This value must be between 125 and 1000.
     *
     * @schema AwsAttributes#EbsVolumeThroughput
     */
    readonly ebsVolumeThroughput?: number;
}
/**
 * Converts an object of type 'AwsAttributes' to JSON representation.
 */
export declare function toJson_AwsAttributes(obj: AwsAttributes | undefined): Record<string, any> | undefined;
/**
 * @schema InitScriptsListItem
 */
export interface InitScriptsListItem {
    /**
     * @schema InitScriptsListItem#S3
     */
    readonly s3?: S3Destination;
}
/**
 * Converts an object of type 'InitScriptsListItem' to JSON representation.
 */
export declare function toJson_InitScriptsListItem(obj: InitScriptsListItem | undefined): Record<string, any> | undefined;
/**
 * @schema CfnClusterPropsInstanceSource
 */
export interface CfnClusterPropsInstanceSource {
    /**
     * @schema CfnClusterPropsInstanceSource#InstancePoolId
     */
    readonly instancePoolId?: string;
    /**
     * @schema CfnClusterPropsInstanceSource#NodeTypeId
     */
    readonly nodeTypeId?: string;
}
/**
 * Converts an object of type 'CfnClusterPropsInstanceSource' to JSON representation.
 */
export declare function toJson_CfnClusterPropsInstanceSource(obj: CfnClusterPropsInstanceSource | undefined): Record<string, any> | undefined;
/**
 * @schema CfnClusterPropsDriverInstanceSource
 */
export interface CfnClusterPropsDriverInstanceSource {
    /**
     * @schema CfnClusterPropsDriverInstanceSource#InstancePoolId
     */
    readonly instancePoolId?: string;
    /**
     * @schema CfnClusterPropsDriverInstanceSource#NodeTypeId
     */
    readonly nodeTypeId?: string;
}
/**
 * Converts an object of type 'CfnClusterPropsDriverInstanceSource' to JSON representation.
 */
export declare function toJson_CfnClusterPropsDriverInstanceSource(obj: CfnClusterPropsDriverInstanceSource | undefined): Record<string, any> | undefined;
/**
 * @schema CfnClusterPropsDefaultTags
 */
export interface CfnClusterPropsDefaultTags {
    /**
     * @schema CfnClusterPropsDefaultTags#ClusterId
     */
    readonly clusterId?: string;
    /**
     * @schema CfnClusterPropsDefaultTags#ClusterName
     */
    readonly clusterName?: string;
    /**
     * @schema CfnClusterPropsDefaultTags#Creator
     */
    readonly creator?: string;
    /**
     * @schema CfnClusterPropsDefaultTags#Vendor
     */
    readonly vendor?: string;
}
/**
 * Converts an object of type 'CfnClusterPropsDefaultTags' to JSON representation.
 */
export declare function toJson_CfnClusterPropsDefaultTags(obj: CfnClusterPropsDefaultTags | undefined): Record<string, any> | undefined;
/**
 * Availability type used for all subsequent nodes past the first_on_demand ones. Note: If first_on_demand is zero, this availability type will be used for the entire cluster.
 *
 * @schema AwsAttributesAvailability
 */
export declare enum AwsAttributesAvailability {
    /** SPOT */
    SPOT = "SPOT",
    /** ON_DEMAND */
    ON_DEMAND = "ON_DEMAND",
    /** SPOT_WITH_FALLBACK */
    SPOT_WITH_FALLBACK = "SPOT_WITH_FALLBACK"
}
/**
 * The type of EBS volumes that will be launched with this cluster.
 *
 * @schema AwsAttributesEbsVolumeType
 */
export declare enum AwsAttributesEbsVolumeType {
    /** GENERAL_PURPOSE_SSD */
    GENERAL_PURPOSE_SSD = "GENERAL_PURPOSE_SSD",
    /** THROUGHPUT_OPTIMIZED_HDD */
    THROUGHPUT_OPTIMIZED_HDD = "THROUGHPUT_OPTIMIZED_HDD"
}
/**
 * @schema S3destination
 */
export interface S3Destination {
    /**
     * @schema S3destination#Destination
     */
    readonly destination?: string;
    /**
     * @schema S3destination#Region
     */
    readonly region?: string;
}
/**
 * Converts an object of type 'S3Destination' to JSON representation.
 */
export declare function toJson_S3Destination(obj: S3Destination | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Databricks::Clusters::Cluster`
 *
 * @cloudformationResource Databricks::Clusters::Cluster
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
 */
export declare class CfnCluster extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Databricks::Clusters::Cluster";
    /**
     * Resource props.
     */
    readonly props: CfnClusterProps;
    /**
     * Attribute `Databricks::Clusters::Cluster.ClusterId`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrClusterId: string;
    /**
     * Attribute `Databricks::Clusters::Cluster.State`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrState: string;
    /**
     * Attribute `Databricks::Clusters::Cluster.StateMessage`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrStateMessage: string;
    /**
     * Attribute `Databricks::Clusters::Cluster.LastStateLossTime`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrLastStateLossTime: number;
    /**
     * Attribute `Databricks::Clusters::Cluster.LastActivityTime`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrLastActivityTime: number;
    /**
     * Attribute `Databricks::Clusters::Cluster.LastRestartedTime`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrLastRestartedTime: number;
    /**
     * Attribute `Databricks::Clusters::Cluster.InitScriptsSafeMode`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrInitScriptsSafeMode: cdk.IResolvable;
    /**
     * Create a new `Databricks::Clusters::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnClusterProps);
}
