# Pulled from https://stackoverflow.com/questions/24005221/ipython-notebook-early-exit-from-cell/48000614
# Used in core.py

"""
# ipython_exit.py
Allows exit() to work if script is invoked with IPython without
raising NameError Exception. Keeps kernel alive.

Use: import variable 'exit' in target script with
     'from ipython_exit import exit'
"""

import sys
from io import StringIO

from IPython import get_ipython


class IpyExit(SystemExit):
    """Exit Exception for IPython.

    Exception temporarily redirects stderr to buffer.
    """

    def __init__(self):
        # print("exiting")  # optionally print some message to stdout, too
        # ... or do other stuff before exit
        sys.stderr = StringIO()

    def __del__(self):
        sys.stderr.close()
        sys.stderr = sys.__stderr__  # restore from backup


def ipy_exit():
    raise IpyExit


if get_ipython():  # ...run with IPython
    exit = ipy_exit  # rebind to custom exit
else:
    exit = exit  # just make exit importable
