# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aw_client']

package_data = \
{'': ['*']}

install_requires = \
['aw-core>=0.5.7,<0.6.0',
 'click>=8.0,<9.0',
 'persist-queue',
 'requests',
 'tabulate',
 'typing-extensions']

entry_points = \
{'console_scripts': ['aw-client = aw_client.cli:main']}

setup_kwargs = {
    'name': 'aw-client',
    'version': '0.5.11',
    'description': 'Client library for ActivityWatch',
    'long_description': 'aw-client\n=========\n\n[![GitHub Actions badge](https://github.com/ActivityWatch/aw-client/workflows/Build/badge.svg)](https://github.com/ActivityWatch/aw-client/actions)\n[![PyPI](https://img.shields.io/pypi/v/aw-client)](https://pypi.org/project/aw-client/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Typechecking: Mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)\n\nClient library for ActivityWatch in Python.\n\nPlease see [the documentation][docs] for usage, and take a look at `examples/`.\n\n - [Documentation][docs]\n - [API Reference][apiref]\n\n[docs]: https://docs.activitywatch.net/en/latest/\n[apiref]: https://docs.activitywatch.net/en/latest/api/python.html#aw-client\n\n## How to install\n\nInstall from pip: `pip install aw-client`\n\nInstall the latest version directly from github without cloning: `pip install git+https://github.com/ActivityWatch/aw-client.git`\n\nTo install from a cloned version:\n\n - clone repo: `git clone https://github.com/ActivityWatch/aw-client.git`\n - cd into the directory: `cd aw-client`\n - run `poetry install` (will create a virtualenv, if none activated)\n   - If you don\'t want to use poetry you can also use `pip install .`, but that might not get the exact version of the dependencies (due to not reading the `poetry.lock` file).\n\n## Usage\n\nFor the CLI:\n\n```\n$ aw-client --help\nUsage: aw-client [OPTIONS] COMMAND [ARGS]...\n\n  CLI utility for aw-client to aid in interacting with the ActivityWatch\n  server\n\nOptions:\n  --host TEXT     Address of host\n  --port INTEGER  Port to use\n  -v, --verbose   Verbosity\n  --testing       Set to use testing ports by default\n  --help          Show this message and exit.\n\nCommands:\n  buckets    List all buckets\n  canonical  Query \'canonical events\' for a single host (filtered,...\n  events     Query events from bucket with ID `bucket_id`\n  heartbeat  Send a heartbeat to bucket with ID `bucket_id` with JSON `data`\n  query      Run a query in file at `path` on the server\n  report     Generate an activity report\n```\n\n\n## Debugging\n\n* Run python with `LOG_LEVEL=debug` to get additional debugging output\n* If invalid events have been queued for submission, you may need to delete the file-based queues generated by this library\n* To use the development version of this library use `aw-client = {path = "../aw-client" }` in `pyproject.toml`\n\n## Examples\n\nThe [`examples/`](examples/) directory contains a couple of example scripts, including:\n\n - [`time_spent_today.py`](examples/time_spent_today.py) - fetches all non-afk events and sums their duration to get the total active time for the day.\n - [`working_hours.py`](https://github.com/ActivityWatch/aw-client/blob/master/examples/working_hours.py) - computes hours worked per day (matching a "work" category rule), and exports matching events to a JSON file (for auditing).\n - [`load_dataframe.py`](https://github.com/ActivityWatch/aw-client/blob/master/examples/load_dataframe.py) - loads events from a host using a categorizing & AFK-filtering query, put result in a pandas dataframe, and export as CSV.\n - [`merge_buckets.py`](examples/merge_buckets.py) - merges two buckets with non-intersecting events by moving all events from one into the other.\n - [`redact_sensitive.py`](examples/redact_sensitive.py) - redact sensitive events.\n',
    'author': 'Erik Bjäreholt',
    'author_email': 'erik@bjareho.lt',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://activitywatch.net/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
