from .base import Widget
from ..libs.activity import MainActivity
from ..libs.android_widgets import RelativeLayout, RelativeLayout__LayoutParams


class Box(Widget):
    def create(self):
        self.native = RelativeLayout(MainActivity.singletonThis)

    def set_child_bounds(self, widget, x, y, width, height):
        # We assume `widget.native` has already been added to this `RelativeLayout`.
        #
        # We use `topMargin` and `leftMargin` to perform absolute layout. Not very
        # relative, but that's how we do it.
        layout_params = RelativeLayout__LayoutParams(width, height)
        layout_params.topMargin = y
        layout_params.leftMargin = x
        self.native.updateViewLayout(widget.native, layout_params)
