"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicPolicy = void 0;
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
/**
 * Applies a policy to SNS topics.
 *
 * @stability stable
 */
class TopicPolicy extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         *
         * @stability stable
         */
        this.document = new aws_iam_1.PolicyDocument({
            // statements must be unique, so we use the statement index.
            // potantially SIDs can change as a result of order change, but this should
            // not have an impact on the policy evaluation.
            // https://docs.aws.amazon.com/sns/latest/dg/AccessPolicyLanguage_SpecialInfo.html
            assignSids: true,
        });
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn),
        });
    }
}
exports.TopicPolicy = TopicPolicy;
//# sourceMappingURL=data:application/json;base64,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