"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineMergeAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const merge_branches_function_1 = require("./merge-branches-function");
/**
 * Represents a reference to a CodePipelineMergeAction.
 */
class CodePipelineMergeAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.INVOKE,
            provider: 'Lambda',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
    }
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    bound(scope, _stage, options) {
        const { repository, sourceCommitSpecifier, destinationCommitSpecifier, crossAccountRole } = this.props;
        const mergeBranchesFunction = new merge_branches_function_1.MergeBranchesFunction(scope, 'MergeBranchesFunction', {
            repository,
            crossAccountRole,
        });
        // allow pipeline to list functions
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:ListFunctions'],
            resources: ['*'],
        }));
        // allow pipeline to invoke this lambda functionn
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:InvokeFunction'],
            resources: [mergeBranchesFunction.functionArn],
        }));
        // allow lambda to put job results for this pipeline
        // CodePipeline requires this to be granted to '*'
        // (the Pipeline ARN will not be enough)
        mergeBranchesFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['codepipeline:PutJobSuccessResult', 'codepipeline:PutJobFailureResult'],
        }));
        return {
            configuration: {
                FunctionName: mergeBranchesFunction.functionName,
                UserParameters: core_1.Stack.of(scope).toJsonString({
                    repositoryName: repository.repositoryName,
                    sourceCommitSpecifier,
                    destinationCommitSpecifier,
                }),
            },
        };
    }
}
exports.CodePipelineMergeAction = CodePipelineMergeAction;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineMergeAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-merge-action.CodePipelineMergeAction", version: "1.32.1" };
//# sourceMappingURL=data:application/json;base64,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