import { Construct } from 'constructs';
import { Chain } from '../chain';
import { IChainable, INextable } from '../types';
import { State } from './state';
/**
 * The result of a Pass operation.
 *
 * @stability stable
 */
export declare class Result {
    readonly value: any;
    /**
     * The result of the operation is a string.
     *
     * @stability stable
     */
    static fromString(value: string): Result;
    /**
     * The result of the operation is a number.
     *
     * @stability stable
     */
    static fromNumber(value: number): Result;
    /**
     * The result of the operation is a boolean.
     *
     * @stability stable
     */
    static fromBoolean(value: boolean): Result;
    /**
     * The result of the operation is an object.
     *
     * @stability stable
     */
    static fromObject(value: {
        [key: string]: any;
    }): Result;
    /**
     * The result of the operation is an array.
     *
     * @stability stable
     */
    static fromArray(value: any[]): Result;
    /**
     * @param value result of the Pass operation.
     * @stability stable
     */
    protected constructor(value: any);
}
/**
 * Properties for defining a Pass state.
 *
 * @stability stable
 */
export interface PassProps {
    /**
     * An optional description for this state.
     *
     * @default No comment
     * @stability stable
     */
    readonly comment?: string;
    /**
     * JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @stability stable
     */
    readonly inputPath?: string;
    /**
     * JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @stability stable
     */
    readonly outputPath?: string;
    /**
     * JSONPath expression to indicate where to inject the state's output.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     *
     * @default $
     * @stability stable
     */
    readonly resultPath?: string;
    /**
     * If given, treat as the result of this operation.
     *
     * Can be used to inject or replace the current execution state.
     *
     * @default No injected result
     * @stability stable
     */
    readonly result?: Result;
    /**
     * Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
     *
     * @default No parameters
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
     * @stability stable
     */
    readonly parameters?: {
        [name: string]: any;
    };
}
/**
 * Define a Pass in the state machine.
 *
 * A Pass state can be used to transform the current exeuction's state.
 *
 * @stability stable
 */
export declare class Pass extends State implements INextable {
    /**
     * Continuable states of this Chainable.
     *
     * @stability stable
     */
    readonly endStates: INextable[];
    private readonly result?;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: PassProps);
    /**
     * Continue normal execution with the given state.
     *
     * @stability stable
     */
    next(next: IChainable): Chain;
    /**
     * Return the Amazon States Language object for this state.
     *
     * @stability stable
     */
    toStateJson(): object;
    /**
     * Render Parameters in ASL JSON format
     */
    private renderParameters;
}
