#line 1 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
struct drgn_error *linux_kernel_object_find(const char *name, size_t name_len,
					    const char *filename,
					    enum drgn_find_object_flags flags,
					    void *arg, struct drgn_object *ret)
{
	struct drgn_program *prog = arg;
	if (!filename && (flags & DRGN_FIND_OBJECT_CONSTANT)) {
#line 10 "linux_kernel_object_find.inc"
		/* Generated by libdrgn/build-aux/gen_strswitch.py. */
		switch (1) {
		default: {
			#define memswitch0_args(ptr, len) \
				const void *memswitch0_ptr = (ptr); \
				const char *memswitch0_str = memswitch0_ptr; \
				size_t memswitch0_len = (len);
			memswitch0_args(
#line 8 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
		            name, name_len
#line 21 "linux_kernel_object_find.inc"
			)
			#undef memswitch0_args
			if (memswitch0_len == 7) {
				if (memcmp(&memswitch0_str[0], "vmemmap", sizeof("vmemmap") - 1) == 0) {
					memswitch0_case5:
#line 20 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_vmemmap(prog, ret);
#line 29 "linux_kernel_object_find.inc"
				}
			} else if (memswitch0_len == 9) {
				if (memcmp(&memswitch0_str[0], "PAGE_", sizeof("PAGE_") - 1) == 0) {
					if (memswitch0_str[5] == 'M') {
						if (memcmp(&memswitch0_str[6], "ASK", sizeof("ASK") - 1) == 0) {
							memswitch0_case3:
#line 16 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_page_mask(prog, ret);
#line 38 "linux_kernel_object_find.inc"
							goto memswitch0_case4;
						}
					} else if (memswitch0_str[5] == 'S') {
						if (memcmp(&memswitch0_str[6], "IZE", sizeof("IZE") - 1) == 0) {
							memswitch0_case2:
#line 14 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_page_size(prog, ret);
#line 46 "linux_kernel_object_find.inc"
							goto memswitch0_case3;
						}
					}
				}
			} else if (memswitch0_len == 10) {
				if (memcmp(&memswitch0_str[0], "PAGE_SHIFT", sizeof("PAGE_SHIFT") - 1) == 0) {
					memswitch0_case1:
#line 12 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_page_shift(prog, ret);
#line 56 "linux_kernel_object_find.inc"
					goto memswitch0_case2;
				}
			} else if (memswitch0_len == 11) {
				if (memswitch0_str[0] == 'P') {
					if (memcmp(&memswitch0_str[1], "AGE_OFFSET", sizeof("AGE_OFFSET") - 1) == 0) {
#line 10 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_page_offset(prog, ret);
#line 64 "linux_kernel_object_find.inc"
						goto memswitch0_case1;
					}
				} else if (memswitch0_str[0] == 'U') {
					if (memcmp(&memswitch0_str[1], "TS_RELEASE", sizeof("TS_RELEASE") - 1) == 0) {
						memswitch0_case4:
#line 18 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_uts_release(prog, ret);
#line 72 "linux_kernel_object_find.inc"
						goto memswitch0_case5;
					}
				}
			}
		}
		}
#line 22 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
	}
	return &drgn_not_found;
}
