#!/usr/bin/env python3
# Copyright (c) Meta Platforms, Inc. and affiliates.
# SPDX-License-Identifier: GPL-3.0-or-later

C_KEYWORDS = (
    "_Atomic",
    "_Bool",
    "_Complex",
    "char",
    "class",
    "const",
    "double",
    "enum",
    "float",
    "int",
    "long",
    "restrict",
    "short",
    "signed",
    "struct",
    "union",
    "unsigned",
    "void",
    "volatile",
)


def main() -> None:
    keywords = [
        ("C_TOKEN_" + keyword.replace("_", "").upper(), keyword)
        for keyword in C_KEYWORDS
    ]
    print("/* Generated by libdrgn/build-aux/gen_c_keywords_inc_strswitch.py. */")
    print("static const char * const keyword_spelling[] = {")
    for token_kind, keyword in keywords:
        print(f'\t[{token_kind}] = "{keyword}",')
    print("};")
    print()
    print("static int identifier_token_kind(const char *s, size_t len, bool cpp)")
    print("{")
    print("\t@memswitch (s, len)@")
    for token_kind, keyword in keywords:
        print(f'\t@case "{keyword}"@')
        if keyword == "class":
            print(f"\t\treturn cpp ? {token_kind} : C_TOKEN_IDENTIFIER;")
        else:
            print(f"\t\treturn {token_kind};")
    print("\t@default@")
    print(f"\t\treturn C_TOKEN_IDENTIFIER;")
    print("\t@endswitch@")
    print("}")


if __name__ == "__main__":
    main()
