Markdown documentation created by [pyLODE](http://github.com/rdflib/pyLODE) 

# GeoSPARQL 1.1 Profile
### A Profile

## Metadata
* **URI**
  * `http://www.opengis.net/def/geosparql`
* **Publisher(s)**
  * [Open Geospatial Consortium](https://ror.org/00fsdxs93)
* **Created**
  * 2020-10-11
* **Modified**
  * 2020-12-22
* **Issued**
  * 2021-01-01
* **Version URI**
  * [http://www.opengis.net/def/geosparql/1.1](http://www.opengis.net/def/geosparql/1.1)
* **Source**
  * 
* **Profile RDF**
  * 
* **Has Resource Descriptor(s)**
  * [GeoSPARQL Functions & Rules vocabulary](http://www.opengis.net/def/geosparql/funcsrules)
  * [GeoSPARQL Rules in RIF](http://www.opengis.net/def/geosparql/rules)
  * [Generator script for GeoSPARQL Rules in RIF](http://www.opengis.net/def/geosparql/rules-script)
  * [GeoSPARQL Specification online](http://www.opengis.net/doc/IS/geosparql/1.1)
  * [GeoSPARQL Specification Document as a PDF](http://www.opengis.net/doc/IS/geosparql/1.1.pdf)
  * [GeoSPARQL Ontology](http://www.opengis.net/ont/geosparql)
  * [Validation SHACL file](http://www.opengis.net/ont/geosparql/profile/validation)
  * [Simple Features Vocabulary](http://www.opengis.net/ont/sf)
  * [Profile code repository](https://github.com/opengeospatial/ogc-geosparql)
### Description



## Resource Descriptors

### GeoSPARQL Functions & Rules vocabulary
Property | Value
--- | ---
URI | `http://www.opengis.net/def/geosparql/funcsrules`
Description | all GeoSPARQL functions and rules presented as a SKOS vocabulary
Artifact | [http://defs-dev.opengis.net/static/definitions/conceptschemes/functions_geosparql.ttl](http://defs-dev.opengis.net/static/definitions/conceptschemes/functions_geosparql.ttl)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/vocabulary](http://www.w3.org/ns/dx/prof/role/vocabulary) <br />
Conforms to |[https://www.w3.org/TR/skos-reference/](https://www.w3.org/TR/skos-reference/) <br />

### GeoSPARQL Rules in RIF
Property | Value
--- | ---
URI | `http://www.opengis.net/def/geosparql/rules`
Description | This file contains Rules Interchange Format (RIF) rules for the GeoSPARQL rules defined in the Specification. These rules have been automatically generated using the 'Generator script for GeoSPARQL Rules in RIF' which, in turn, uses the RIF template provided in the Specification.
Artifact | [https://github.com/opengeospatial/ogc-geosparql/blob/master/1.1/rules.rifps](https://github.com/opengeospatial/ogc-geosparql/blob/master/1.1/rules.rifps)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/specification](http://www.w3.org/ns/dx/prof/role/specification) <br />
Conforms to |[https://www.w3.org/TR/rif-bld/](https://www.w3.org/TR/rif-bld/) <br />

### Generator script for GeoSPARQL Rules in RIF
Property | Value
--- | ---
URI | `http://www.opengis.net/def/geosparql/rules-script`
Description | This is a Python script used to generate the 'GeoSPARQL Rules in RIF' artifact from templates specified in the 'Ontology specification in PDF'
Artifact | [https://github.com/opengeospatial/ogc-geosparql/blob/master/1.1/rifgenerator.py](https://github.com/opengeospatial/ogc-geosparql/blob/master/1.1/rifgenerator.py)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/guidance](http://www.w3.org/ns/dx/prof/role/guidance) <br />
Conforms to |[https://www.w3.org/TR/rif-bld/](https://www.w3.org/TR/rif-bld/) <br />

### GeoSPARQL Specification online
Property | Value
--- | ---
URI | `http://www.opengis.net/doc/IS/geosparql/1.1`
Artifact | [https://github.com/opengeospatial/ogc-geosparql/master/1.1/spec/_11-052r4.html](https://github.com/opengeospatial/ogc-geosparql/master/1.1/spec/_11-052r4.html)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/specification](http://www.w3.org/ns/dx/prof/role/specification) <br />

### GeoSPARQL Specification Document as a PDF
Property | Value
--- | ---
URI | `http://www.opengis.net/doc/IS/geosparql/1.1.pdf`
Artifact | [https://github.com/opengeospatial/ogc-geosparql/master/1.1/spec/_11-052r4.pdf](https://github.com/opengeospatial/ogc-geosparql/master/1.1/spec/_11-052r4.pdf)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/specification](http://www.w3.org/ns/dx/prof/role/specification) <br />

### GeoSPARQL Ontology
Property | Value
--- | ---
URI | `http://www.opengis.net/ont/geosparql`
Description | The GeoSPARQL 1.1 ontology in RDF (turtle)
Artifact | [https://github.com/opengeospatial/ogc-geosparql/master/1.1/geo.ttl](https://github.com/opengeospatial/ogc-geosparql/master/1.1/geo.ttl)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/schema](http://www.w3.org/ns/dx/prof/role/schema) <br />

### Validation SHACL file
Property | Value
--- | ---
URI | `http://www.opengis.net/ont/geosparql/profile/validation`
Description | A Shapes Contraint Language (SHACL) validator provided to validate RDF documents cliaming conformance to GeoSPARQL 1.1
Artifact | [https://github.com/opengeospatial/ogc-geosparql/master/1.1/validation.ttl](https://github.com/opengeospatial/ogc-geosparql/master/1.1/validation.ttl)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/validation](http://www.w3.org/ns/dx/prof/role/validation) <br />
Conforms to |[https://www.w3.org/TR/shacl/](https://www.w3.org/TR/shacl/) <br />

### Simple Features Vocabulary
Property | Value
--- | ---
URI | `http://www.opengis.net/ont/sf`
Description | An OWL ontology (vocabulary) of the Simple Features geometry types
Artifact | [http://schemas.opengis.net/sf/1.0/simple_features_geometries.rdf](http://schemas.opengis.net/sf/1.0/simple_features_geometries.rdf)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/vocabulary](http://www.w3.org/ns/dx/prof/role/vocabulary) <br />
Conforms to |[http://www.w3.org/TR/owl2-rdf-based-semantics/](http://www.w3.org/TR/owl2-rdf-based-semantics/) <br />

### Profile code repository
Property | Value
--- | ---
URI | `https://github.com/opengeospatial/ogc-geosparql`
Description | Code repository storing all Profile artifacts
Artifact | [https://github.com/opengeospatial/ogc-geosparql](https://github.com/opengeospatial/ogc-geosparql)
Roles(s) |[http://www.w3.org/ns/dx/prof/role/repository](http://www.w3.org/ns/dx/prof/role/repository) <br />



## Namespaces
* **dct**
  * `http://purl.org/dc/terms/`
* **ogc**
  * `http://www.opengis.net/def/`
* **owl**
  * `http://www.w3.org/2002/07/owl#`
* **prof**
  * `http://www.w3.org/ns/dx/prof/`
* **rdf**
  * `http://www.w3.org/1999/02/22-rdf-syntax-ns#`
* **rdfs**
  * `http://www.w3.org/2000/01/rdf-schema#`
* **sdo**
  * `https://schema.org/`
* **skos**
  * `http://www.w3.org/2004/02/skos/core#`
* **xsd**
  * `http://www.w3.org/2001/XMLSchema#`