# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['lyceeplus']
install_requires = \
['matplotlib>=3.7.0,<4.0.0', 'numpy>=1.24.2,<2.0.0']

setup_kwargs = {
    'name': 'lyceeplus',
    'version': '0.1.2',
    'description': '',
    'long_description': '# Module python lyceeplus.py\n\nCe module est une version du module lycee auquel j\'ai ajouté quelques fonctions.\n\nLe module lycee est un module python réalisé par le groupe AMIENS PYTHON\n\nest à pour objectif de simplifier un certain nombre de manipulations\n\navec python au lycée (cosinus en degré, calcul d\'une moyenne d\'une liste,\n\nreprésentation statistiques variées, ...)\n\nhttps://download.tuxfamily.org/edupython/lycee.py\n\n\n## FONCTIONS SAISIE CLAVIER \n\n\n## texte_demande :  \n\n**texte_demande(prompteur: str) -> str**\n\n\n\n* _prompteur_ est une chaîne de caractères\n* Ouvre une fenêtre avec le message "prompteur" et attend une chaîne de caractères.\n* retourne la chaîne de caractères entrée par l\'utilisateur.\n\n\n## demande\n\n**demande(prompteur: str) -> float | int**\n\n\n\n* _prompteur_ est une chaîne de caractères\n* Ouvre une fenêtre avec le message "prompteur" et attend un nombre.\n* retourne un nombre saisi par l\'utilisateur ou une erreur quand le texte saisi n\'est pas convertible en nombre.\n\n\n## liste_demande\n\n**liste_demande(prompteur: str) -> list**\n\n\n\n* _prompteur_ est une chaîne de caractères\n* Ouvre une fenêtre avec le message "prompteur" et attend une liste(list).\n* retourne la list saisie par l\'utilisateur ou une erreur quand le texte saisi n\'est pas convertible en list.\n\n\n## FONCTIONS MATHÉMATIQUES\n\n\n## pgcd\n\n**pgcd(a: int, b: int) -> int**\n\n\n\n* _a_ et _b_ sont 2 entiers non nuls\n* renvoie le Plus Grand Diviseur Commun des 2 nombres. La nullité de _a_ et/ou _b_ provoque une erreur.\n\n\n## abs2\n\n**abs2(x: float | int) -> float | int**\n\n\n\n* _x_ est un nombre.\n* Renvoie la valeur absolue du nombre _x_, c\'est a dire sa distance à 0\n\n\n## reste\n\n**reste(a: int, b: int) -> int**\n\n\n\n* _a,b_ sont des nombres entiers (_b_ non nul)\n* Cette fonction renvoie le reste de la division de_ a_ par _b_\n\n\n## quotient\n\n**quotient(a: int, b: int) -> int**\n\n\n\n* _a,b_ sont des nombres entiers (_b_ non nul)\n* Cette fonction renvoie le quotient (entier) de la division de a par b\n\n\n## angleMode\n\n**angleMode(mode_angle: str = \'\') -> str**\n\n\n\n* cette fonction permet de définir l\'unité d\'angle utiliser <span style="text-decoration:underline;">par les fonctions trigonométriques</span>\n* <span style="text-decoration:underline;">du module "lycee".</span>\n* _mode_angle_ : type d\'unité d\'angle à utiliser\n* \'rad\' les angles des fonctions trigonométriques seront pris comme des radians (défaut)\\n\n* \'deg\' les angles des fonctions trigonométriques seront pris comme des degrés\\n\n* \'grd\' les angles des fonctions trigonométriques seront pris comme des grades\\n\n* toute autre valeur provoque une erreur\n* retourne la valeur précédente de mode et si _mode_angle_ == "" la valeur actuelle de mode est retournée (str).\n* La valeur par défaut est le **radian**.\n\n\n## cos\n\n**cos(angle: float) -> float**\n\n\n\n* retourne le cosinus de _angle_ (réel) en fonction du mode choisi (défaut : radian)\n\n\n## sin\n\n**sin(angle: float) -> float**\n\n\n\n* retourne le sinus de _angle_ (réel) en fonction du mode choisi (défaut : radian)\n\n\n## tan\n\n**tan(angle: float) -> float**\n\n\n\n* retourne la tangente de _angle_ (réel) en fonction du mode choisi (défaut : radian)\n\n\n## acos\n\n**acos(value: float) -> float**\n\n\n\n* Retourne la valeur de l\'angle telle que cos(angle) = _valeur_ dans l\'unité définie par angleMode().\n* Le résultat est compris entre 0 et pi rd  si mode("rad").\n* Le résultat est compris entre 0 et 180° si mode("deg").\n* Le résultat est compris entre 0 et 200 grd si mode("grd").\n\n\n## asin\n\n**asin(value: float) -> float**\n\n\n\n* Retourne la valeur de l\'angle telle que sin(angle) = _valeur_ dans l\'unité définie par angleMode().\n* Le résultat est compris entre 0 et pi rd  si mode("rad").\n* Le résultat est compris entre 0 et 180° si mode("deg").\n* Le résultat est compris entre 0 et 200 grd si mode("grd").\n\n\n## atan\n\n**atan(value: float) -> float**\n\n\n\n* Retourne la valeur de l\'angle telle que tan(angle) = _valeur_ dans l\'unité définie par angleMode().\n* Le résultat est compris entre 0 et pi rd  si mode("rad").\n* Le résultat est compris entre 0 et 180° si mode("deg").\n* Le résultat est compris entre 0 et  200 grd si mode("grd").\n\n\n## radians\n\n**radians(angle: float) -> float**\n\n\n\n*     convertit l\'_angle_ dont l\'unité est définie dans angleMode() en radian\n\n\n## degres\n\n**degres(angle: float) -> float**\n\n\n\n* convertit l_\'angle_ dont l\'unité est définie dans angleMode() en degrés\n\n\n## grades\n\n**grades(angle: float) -> float**\n\n\n\n* convertit l_\'angle_ dont l\'unité est définie dans angleMode() en grades\n\n\n## racine\n\n**racine(x: float | int) -> float**\n\n\n\n* x est un nombre positif\n* Renvoie la racine carrée du nombre x\n\n\n## sqrt\n\nidem **racine**\n\n\n## factoriel\n\n**factoriel(n: int) -> int**\n\n\n\n* _n_ est un nombre entier positif\n* Renvoie _n_! = _n_ x (_n_-1) x ... x 3 x 2 x 1\n\n\n## floor\n\n**floor(x: float) -> int**\n\n\n\n* _x_ est un nombre décimal.\n* Retourne la partie entière du nombre x, c\'est a dire le plus grand entier inférieur au réel _x_.\n\n\n## exp\n\n**exp(x: float | int) -> float**\n\n\n\n* _x_ est un nombre décimal.\n* Retourne l\'image du nombre _x _par la fonction exponentielle (e<sup>x</sup>).\n\n\n## ln\n\n**ln(x: float | int) -> float**\n\n\n\n* _x_ est un nombre strictement positif.\n* Retourne l\'image du nombre _x_ par la fonction logarithme népérien.\n\n\n## FONCTIONS STAT & PROBAS\n\n\n## binomial\n\n**binomial(n: int, p: int)**\n\n\n\n* n et p sont deux entiers.\n* Retourne coefficient binomial p parmi n, c\'est à dire le nombre de chemins de l’arbre \n\n    réalisant p succès pour n répétitions.\n\n\n\n## randint\n\n**randint(min: int, max: int)**\n\n\n\n* _min_ et _max_ sont deux entiers.\n* Renvoie un entier choisi de manière (pseudo)aléatoire et équiprobable dans l\'intervalle [_min,max_].\n\n\n## choice\n\n**choice(liste: list) -> float | int | str**\n\n\n\n* _liste_ est une list.\n* Renvoie un élément de la liste list choisi (pseudo)aléatoirement et de manière équiprobable\n\n\n## random\n\n**random() -> float**\n\n\n\n* Pas d\'argument.\n* Renvoie au hasard un décimal de l\'intervalle [0;1[\n\n\n## uniform\n\n**uniform(min:int|float, max:int|float)->float**\n\n\n\n* min et max sont deux nombres.\n* Renvoie un nombre décimal choisi de manière (pseudo)aléatoire et uniforme de l\'intervalle [min,max[.\n\n\n## intervalle\n\n**intervalle(debut: int, fin: int, pas: int = \'optionnel\') -> list**\n\n\n\n* _debut, fin et pas_ sont des entiers.\n* Le paramètre pas est optionnel.\n* Retourne une liste d’entiers :\n\n          – De l’intervalle _[debut; fin_] si 2 paramètres sont renseignés\n\n\n          – De l’intervalle [_debut; fin_] mais en réalisant une suite arithmétique de raison _pas_ si les 3 paramètres sont renseignés.\n\n\n\n## range\n\n**range(debut: int, fin: int = \'optionnel\', pas: int = \'optionnel\')->list**\n\n\n\n* _debut_, _fin_ et _pas_ sont des entiers.\n* Les paramètres _debut_ et _pas_ sont optionnels.\n* Retourne une liste d’entiers :\n\n      – De l’intervalle [0; _debut_[ si un seul paramètre est renseigné.\n\n\n      – De l’intervalle [_debut; fin_[ si 2 paramètres sont renseignés\n\n\n      – De l’intervalle [_debut; fin_[ mais en réalisant une suite arithmétique de raison pas si les 3 paramètres sont renseignés.\n\n\n\n## sac_de_billes\n\n**sac_de_billes(billes:list, nb_tirages:int)->list[str|int|float]:**\n\n\n\n* billes : list décrivant les boules contenues dans le sac (couleur, numero,....)\n* nb_tirages : int nombre de tirage avec remise effectués\n* retourne une liste contenant les résultats des nb_tirages en fonction de la description des billes. exemple si billes = ["rouge","rouge","rouge","noir","noir"] pour 4 tirages le fonction pourra retourner ["rouge","rouge","noir","noir"]\n\n\n## lance_de_de\n\n**lance_de_de(nb_faces:int= 6)->int:**\n\n\n\n* nb_face: int nombre de face du dé. Par défaut sa valeur est 6.\n* Retourne un entier [1;nb_faces]\n\n\n## FONCTIONS SUR LES CHAÎNES\n\n\n## len\n\n**len(objet: str | list) -> int**\n\n\n\n* _objet_ peut être une chaîne de caractères ou une liste.\n* Retourne la longueur de cette chaîne ou de cette liste\n\n\n## fich2chaine\n\n**fich2chaine(fichier=\'optionel\')**\n\n\n\n* fichier est le nom complet (avec le chemin) d\'un fichier contenant du texte brut.\n* Si fichier n\'est pas précisé, ouvre une boîte de dialogue pour     \n* Retourne chaîne formée du contenu du fichier \'fichier\'\n\n\n## chaine2fich\n\n**chaine2fich(ch, fichier=\'optionnel\')**\n\n\n\n* ch est une chaîne de caractères \n* fichier est le nom complet (avec le chemin) d\'un fichier contenant du texte brut.\n* Si fichier n\'est pas précisé, ouvre une boîte de dialogue pour\n* Enregistre sous le nom \'fichier\' la chaîne ch\n\n\n## aligne\n\n**aligne(chaine: str, taille, aligner="g")**\n\n\n\n* aligne une chaine sur un espace donné de caractères (taille)\n* le paramètre aligner ("g,d, c, l, r, gauche, droite, centrer, left,right, center") permet un alignement de la chaine (alignement à gauche par défaut) \n\n\n## cadre\n\n**cadre(chaine: str, taille: int = 0, **kwargs)**\n\n\n\n* créer un cadre autour d\'une chaine de caractère dans la console\n* le paramètre optionnel aligner=("g,d, c, l, r, gauche, droite, centrer, left,right, center") permet l\'alignement de la chaine (alignement à gauche par défaut) dans le cadre\n\n\n## affiche_tableau\n\n**affiche_tableau(tableau: list, taille: list = [], **kwargs)**\n\n\n\n* affiche _tableau_ (list) a une ou deux dimension dans la console\n* _taille_ est une list qui permet de donner la taille de chaque colonne. Si taille n\'est pas renseignée la largeur optimale est calculée.\n\nparamètres optionnels:\n\n\n\n* padx: espace ajouté avant et après la données\n* mini: int : largeur mini d\'une colonne\n* maxi: int : largeur maxi d\'une colonne\n* sep_ligne : bool si True les lignes seront séparées\n* aligner: chaine de caractère définissant l\'alignement des colonnes "dcdg". La première colonne sera alignée à droite, la deuxième sera centrée, la troisième sera alignée à droite les dernières seront alignée à gauche\n*  entete: bool : si True la première ligne du tableau sera considérée comme\n\n    une ligne d\'entête\n\n* pied: bool si True encadre la dernière ligne du tableau\n* markdown : bool si True convertit le tableau au format markdown.\n\n\n## affiche_poly\n\naffiche_poly(liste:list)\n\n\n\n* liste est une list\n* Affiche la liste sous forme d\'un polynôme (liste[n] étant le coefficient de degré n).\n\n    ex 1+2x-3x^2 ….. Si le paramètre optionnel format= "python" le polynome est retourné au format python 1 + 2*x - 3*x**2 ……\n\n* le paramètre facultatif format=python permet d\'écrire le polynôme au format python\n\n\n## FONCTIONS SUR LES LISTES\n\n\n## CSV2liste\n\n**CSV2liste(num, fichier=\'optionnel\', sep=\';\', dec=\'.\')**\n\n\n\n* num peut contenir un numéro de ligne ou un nom de colonne (\'A\' à \'Z\' ) fichier est le nom complet (avec le chemin) d\'un fichier contenant du texte brut.\n* Si fichier n\'est pas précisé, ouvre une boîte de dialogue pour le choisir\n* Retourne une liste correspondant à la **ligne** ou la **colonne** du fichier \'fichier\'\n\n\n## liste2CSV\n\n**liste2CSV(L, fichier=\'optionnel\',affiche=False)**\n\nliste est une list\n\nfichier est le nom complet (avec le chemin) d\'un fichier contenant du texte brut.\n\nSi fichier n\'est pas précisé, ouvre une boîte de dialogue pour\n\nSi paramètre optionnel affiche = True le contenu du fichier est affiché dans la console\n\nEnregistre sous le nom \'fichier\' la liste au format CSV \n\n\n## FONCTIONS SUR NUMPY\n\n\n## vecteur\n\n**vecteur(x, y, z=\'optionnel\')->numpy.array():**\n\n\n\n* créer un vecteur au format numpy à partir des coordonnées x, y et z (optionnel)\n\n\n## norme\n\n**norme(v:numpy.array())->float:**\n\n\n\n* retourne la norme d\'un vecteur au format numpy\n\n\n## abscisse\n\n**abscisse(v:numpy.array())->float:**\n\n\n\n* retourne l\'abscisse du vecteur v\n\n\n## ordonnee\n\n**ordonnee(v:numpy.array())->float:**\n\n\n\n* retourne ordonnée du vecteur v\n\n\n## cote\n\n**cote(v:numpy.array())->float:**\n\n\n\n* retourne la cote du vecteur v (coordonnée en z du vecteur)\n\n\n## Fonction Graphique\n\n\n### figure\n\n**figure(nb_lignes=1, nb_cols=1, **kwargs)**\n\nPermet de préparer une ou plusieurs zones qui recevront le graphique\n\nex :**nb_lignes=3, nb_cols=2**\n\n1\t2\n\n3\t4\n\n5\t6\n\n\n### baton\n\n**baton(xi, ni=\'optionnel\', **kwargs)**\n\n    xi est une liste de valeurs\n\n    ni est la liste des effectifs associés, c\'est un paramètre optionnel.\n\n    couleur donne la couleur du diagramme (optionnel)\n\n    Génère le diagramme en bâtons relatif à la liste.\n\n\n## secteur\n\nsecteur(valeurs: list, etiquettes: list, **kwargs):\n\nGénère une diagramme secteur en fonction d\'une liste de valeur \n\n\n### ligne_brisee\n\nligne_brisee(xi: list, yi: list, *args: list, **kwargs)\n\nGénère un diagramme lignes brisées \n\nxi liste d\'abscisses\n\nyi liste d\'ordonnées (args place pour d\'autres ordonnées pour avoir plusieurs courbes affichées)\n\n\n### histop\n\n** histop(Liste, Classes=\'optionnel\', **kwargs)**\n\nListe est une liste de valeurs\n\n    Si seulement Liste est renseigné, les valeurs seront réparties en 10 classes.\n\n    Si Classes est un entier, les valeurs seront réparties en ce nombre de classes.\n\n    Sinon, vous pouvez choisir vos classes d\'amplitudes variées\n\n        en indiquant comme Classes    la liste ordonnée des bornes.\n\n Génère l\'histogramme relatif à la Liste d\'aire totale 1.\n\n\n### barre\n\n**barre(liste: list, a=\'optionnel\', pas=\'optionnel\', **kwargs):**\n\n    liste est une liste de valeurs\n\n    Si seulement Liste est renseigné, les valeurs seront réparties en 10 classes.\n\n    Si Liste et a sont renseignés, les valeurs seront réparties en a classes.\n\n    Si les trois paramètres sont renseignés:\n\n            a est le centre de la première classe,\n\n            et pas est l\'amplitude des classes.\n\n    Génère le diagramme en barres relatif à la Liste.\n\n\n### colonne\n\n**colonne(liste, a=\'optionnel\', pas=\'optionnel\', **kwargs)**\n\nidem barre\n\n\n### trace_courbe\n\n**trace_courbe(xi: list, yi: list, *args: list, **kwargs):**\n\n    trace une ou des courbes défini par une liste d\'abscisses et\n\n    une ou des listes d\'ordonnées\n\n\n### trace_fonction\n\n**trace_fonction(fx: str | list[str], **kwargs):**\n\n\n```\ntrace une fonction ou des fonctions (expression littérales en python) dans le repère défini par repere()\n```\n\n\n\n### nuage\n\n**nuage(xi: list, yi: list, *args: list, **kwargs):**\n\n    trace un ou des nuages de point défini par une liste d\'abscisses et\n\n    une ou des listes d\'ordonnées\n\n\n### repere \n\n**repere(xmini, xmaxi, ymini, ymaxi, **kwargs):**\n\n    défini un repère orthogonal en fonction de  xmini, xmaxi, ymini, ymaxi\n\n    Est obligatoire pour utiliser **trace_fonction** ou les fonctions de géométrie\n\n\n### segment\n\n**segment(x1, y1, x2, y2, **kwargs):**\n\n    dessine un segment dans la zone courante\n\n\n### point\n\n**point(x, y, **kwargs):**\n\n    dessine un point dans la zone courante\n\n\n### rectangle\n\n**rectangle(x, y, largeur, hauteur, **kwargs):**\n\n    dessine un rectangle dans la zone courante\n\n\n### carre\n\n**carre(x, y, largeur, **kwargs):**\n\n     dessine un carré dans la zone courante\n\n\n### triangle\n\n**triangle(x1, y1, x2, y2, x3, y3, **kwargs):**\n\n     dessine un triangle dans la zone courante\n\n\n### polygone\n\n**polygone(xyi: list[list], **kwargs):**\n\n     dessine un polygone dans la zone courante\n\n\n### cercle\n\n**cercle(x, y, rayon, **kwargs):**\n\n     dessine un cercle dans la zone courante\n\n\n### affiche_graphique\n\n**affiche_graphique()**\n\naffiche les graphiques précédemment calculés\n',
    'author': 'Pierre Lemaitre',
    'author_email': 'oultetman@sfr.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'py_modules': modules,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
