interface HandlerResponse {
    readonly status: 'SUCCESS' | 'FAILED';
    readonly reason: 'OK' | string;
    readonly data?: any;
}
export declare abstract class CustomResourceHandler<Request extends object, Response extends object> {
    protected readonly event: AWSLambda.CloudFormationCustomResourceEvent;
    protected readonly context: AWSLambda.Context;
    readonly physicalResourceId: string;
    private readonly timeout;
    private timedOut;
    constructor(event: AWSLambda.CloudFormationCustomResourceEvent, context: AWSLambda.Context);
    handle(): Promise<Response | undefined>;
    protected abstract processEvent(request: Request): Promise<Response | undefined>;
    respond(response: HandlerResponse): Promise<unknown> | undefined;
}
export {};
