"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiCallBase = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
/**
 * Base class for an ApiCall
 */
class ApiCallBase extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.flattenResponse = 'false';
    }
    getAtt(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAtt(`apiCallResponse.${attributeName}`);
    }
    getAttString(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAttString(`apiCallResponse.${attributeName}`);
    }
    expect(expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.expect);
            }
            throw error;
        }
        this.expectedResult = expected.result;
    }
    next(next) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(next);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.next);
            }
            throw error;
        }
        next.node.addDependency(this);
        return next;
    }
}
exports.ApiCallBase = ApiCallBase;
_a = JSII_RTTI_SYMBOL_1;
ApiCallBase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.ApiCallBase", version: "2.45.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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