"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Server = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process_1 = require("child_process");
const fs_1 = require("fs");
const http_1 = require("http");
const os_1 = require("os");
const path_1 = require("path");
/**
 * @stability stable
 */
class Server {
    /**
     * @stability stable
     */
    constructor(props) {
        this.appCommand = props.appCommand;
        this.server = http_1.createServer((req, res) => this.handleRequest(req, res).catch(e => {
            console.error('server error: ', e);
            res.statusCode = 500;
            res.write(e.message);
            res.end();
        }));
        this.tmpdir = fs_1.mkdtempSync(path_1.join(os_1.tmpdir(), 'cdk8s-operator-'));
    }
    /**
     * Starts HTTP server.
     *
     * @param port The port to listen to.
     * @stability stable
     */
    async listen(port) {
        var _b;
        const lport = (_b = port !== null && port !== void 0 ? port : process.env.PORT) !== null && _b !== void 0 ? _b : 0;
        return new Promise((ok, ko) => {
            this.server.listen(lport, () => {
                const addr = this.server.address();
                if (typeof (addr) === 'string') {
                    throw new Error(`cannot determine port from server address ${addr}`);
                }
                return ok(addr === null || addr === void 0 ? void 0 : addr.port);
            });
            this.server.on('error', err => ko(err));
        });
    }
    /**
     * Stop server.
     *
     * @stability stable
     */
    close() {
        this.server.close();
    }
    async handleRequest(req, res) {
        const inputfile = await this.writeInputFile(req);
        const child = child_process_1.spawn(this.appCommand, [inputfile], {
            stdio: ['ignore', 'pipe', 'pipe'],
            shell: true,
        });
        const stderr = new Array();
        res.setHeader('Content-Type', 'application/json');
        // stdout should go directly to the response
        child.stdout.on('data', chunk => {
            process.stderr.write('output: ' + chunk);
            res.write(chunk);
        });
        // for stderr: write to server terminal and only send back if we exited with a non-zero
        child.stderr.on('data', chunk => {
            process.stderr.write(chunk);
            stderr.push(chunk);
        });
        // will be caused by the async handler and 500 will be returned.
        child.on('error', err => {
            throw err;
        });
        child.on('exit', code => {
            if (code !== 0) {
                res.statusCode = 500;
                for (const c of stderr) {
                    res.write(c);
                }
                res.end();
            }
            // success
            return res.end();
        });
    }
    async writeInputFile(req) {
        return new Promise((ok, ko) => {
            const inputfile = path_1.join(this.tmpdir, `input-${Math.round(Math.random() * 999999)}.json`);
            const input = fs_1.createWriteStream(inputfile);
            req.pipe(input);
            input.on('close', () => {
                try {
                    const inputJson = JSON.parse(fs_1.readFileSync(inputfile, 'utf-8'));
                    console.error(`input: ${JSON.stringify(inputJson)}`);
                    return ok(inputfile);
                }
                catch (e) {
                    return ko(new Error(`unable to parse request body as JSON: ${e}`));
                }
            });
            req.on('error', err => ko(err.message));
        });
    }
}
exports.Server = Server;
_a = JSII_RTTI_SYMBOL_1;
Server[_a] = { fqn: "cdk8s-operator.Server", version: "0.0.171" };
//# sourceMappingURL=data:application/json;base64,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