# Neer Match Utilities


<a href="https://www.marius-liebald.com/py-neer-utilities/index.html" style="float:right; margin-left:10px;">
<img src="docs/source/_static/img/hex-logo.png" style="height:139px !important; width:auto !important;" alt="neermatch utilities website" />
</a>

<!-- badges: start -->

![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)
<!-- badges: end -->

The framework `neermatch` provides a set of tools for entity matching
based on deep learning, symbolic learning, and a hybrid approach
combining both deep and symbolic learning. It is designed to support
easy set-up, training, and inference of entity matching models. The
package provides automated fuzzy logic reasoning (by refutation)
functionality that can be used to examine the significance of particular
associations between fields in an entity matching task.

The `neermatch` framework encompasses three packages:

1.  `py-neer-match`: The `Python` implementation of the basic
    functionalities. [Learn more](https://py-neer-match.pikappa.eu)
2.  `py-neer-utilities`: A `Python` package that provides additional
    functionalities to streamline and support the entity matching
    workflow. ([this
    project](https://www.marius-liebald.com/py-neer-utilities/index.html))
3.  `r-neer-match`: The `R` implementation of the basic functionalites.
    [Learn more](https://github.com/pi-kappa-devel/r-neer-match)

The project is financially supported by the [Deutsche
Forschungsgemeinschaft](https://www.dfg.de/de) (DFG) under Grant
539465691 as part of the Infrastructure Priority Programme [*New Data
Spaces for the Social Sciences*](https://www.new-data-spaces.de/en-us/)
(SPP 2431). Reading the article [*Karapanagiotis and Liebald
(2023)*](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4541376)
helps to understand the theoretical foundation and design of `neermatch`
(note that the article refers to an earlier version of the framework,
previously labeled as `mlmatch`).

# Contributors

[Marius Liebald](https://www.marius-liebald.de) (maintainer)

[Pantelis Karapanagiotis](https://www.pikappa.eu) (contributor)

# Installation

``` bash
pip install neer-match
pip install neer-match-utilities
```

# Official Documentation

The documentation is hosted under
<https://www.marius-liebald.com/py-neer-utilities/index.html>

# License

The package is distributed under the [MIT license](LICENSE.txt).

# References

<div id="refs" class="references csl-bib-body hanging-indent"
entry-spacing="0">

<div id="ref-gram2022" class="csl-entry">

Gram, Dennis, Pantelis Karapanagiotis, Marius Liebald, and Uwe Walz.
2022. “Design and Implementation of a Historical German Firm-Level
Financial Database.” *ACM Journal of Data and Information Quality
(JDIQ)* 14 (3): 1–22. <https://doi.org/10.1145/3531533>.

</div>

<div id="ref-karapanagiotis2023" class="csl-entry">

Karapanagiotis, Pantelis, and Marius Liebald. 2023. “Entity Matching
with Similarity Encoding: A Supervised Learning Recommendation Framework
for Linking (Big) Data.” <http://dx.doi.org/10.2139/ssrn.4541376>.

</div>

<div id="ref-pyneermatch2024" class="csl-entry">

———. 2024a. “<span class="nocase">NEural-symbolic</span> Entity
Reasoning and Matching (Python Neer Match).”
<https://github.com/pi-kappa-devel/py-neer-match>.

</div>

<div id="ref-rneermatch2024" class="csl-entry">

———. 2024b. “<span class="nocase">NEural-symbolic</span> Entity
Reasoning and Matching (R Neer Match).”
<https://github.com/pi-kappa-devel/r-neer-match>.

</div>

<div id="ref-lin2017" class="csl-entry">

Lin, Tsung-Yi, Priya Goyal, Ross Girshick, Kaiming He, and Piotr Dollár.
2017. “Focal Loss for Dense Object Detection.” In *Proceedings of the
IEEE International Conference on Computer Vision (ICCV)*, 2980–88. IEEE.
<https://doi.org/10.1109/ICCV.2017.324>.

</div>

</div>
