# coding: utf-8

"""
    bit.io REST API

    bit.io API  # noqa: E501

    The version of the OpenAPI document: 1.0.0b
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bitdotio.api_client import ApiClient
from bitdotio.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ApiBitdotio(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def address_q_connection(self, user_username, name, **kwargs):  # noqa: E501
        """address_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.address_q_connection(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.address_q_connection_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def address_q_connection_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """address_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.address_q_connection_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QConnection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method address_q_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `address_q_connection`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `address_q_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/connections/{name}/address/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QConnection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def address_q_endpoint(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """address_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.address_q_endpoint(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.address_q_endpoint_with_http_info(user_username, repo_name, name, **kwargs)  # noqa: E501

    def address_q_endpoint_with_http_info(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """address_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.address_q_endpoint_with_http_info(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QEndpoint, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method address_q_endpoint" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `address_q_endpoint`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `address_q_endpoint`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `address_q_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/endpoints/{name}/address/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_column(self, user_username, repo_name, table_current_name, **kwargs):  # noqa: E501
        """create_column  # noqa: E501

        Create a column owned by the authenticated user in the given repo and table. The request body must contain the required fields for the column.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_column(user_username, repo_name, table_current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param Column column:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Column
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_column_with_http_info(user_username, repo_name, table_current_name, **kwargs)  # noqa: E501

    def create_column_with_http_info(self, user_username, repo_name, table_current_name, **kwargs):  # noqa: E501
        """create_column  # noqa: E501

        Create a column owned by the authenticated user in the given repo and table. The request body must contain the required fields for the column.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_column_with_http_info(user_username, repo_name, table_current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param Column column:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Column, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'table_current_name',
            'column'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_column" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `create_column`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `create_column`")  # noqa: E501
        # verify the required parameter 'table_current_name' is set
        if self.api_client.client_side_validation and ('table_current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_current_name` when calling `create_column`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'table_current_name' in local_var_params:
            path_params['table_current_name'] = local_var_params['table_current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'column' in local_var_params:
            body_params = local_var_params['column']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{table_current_name}/columns/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Column',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_q_connection(self, user_username, **kwargs):  # noqa: E501
        """create_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_q_connection(user_username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param QConnection q_connection:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_q_connection_with_http_info(user_username, **kwargs)  # noqa: E501

    def create_q_connection_with_http_info(self, user_username, **kwargs):  # noqa: E501
        """create_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_q_connection_with_http_info(user_username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param QConnection q_connection:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QConnection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'q_connection'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_q_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `create_q_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'q_connection' in local_var_params:
            body_params = local_var_params['q_connection']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/connections/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QConnection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_q_endpoint(self, user_username, repo_name, **kwargs):  # noqa: E501
        """create_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_q_endpoint(user_username, repo_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param QEndpoint q_endpoint:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_q_endpoint_with_http_info(user_username, repo_name, **kwargs)  # noqa: E501

    def create_q_endpoint_with_http_info(self, user_username, repo_name, **kwargs):  # noqa: E501
        """create_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_q_endpoint_with_http_info(user_username, repo_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param QEndpoint q_endpoint:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QEndpoint, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'q_endpoint'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_q_endpoint" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `create_q_endpoint`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `create_q_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'q_endpoint' in local_var_params:
            body_params = local_var_params['q_endpoint']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/endpoints/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_query_result(self, **kwargs):  # noqa: E501
        """create_query_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_query_result(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param QueryResult query_result:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_query_result_with_http_info(**kwargs)  # noqa: E501

    def create_query_result_with_http_info(self, **kwargs):  # noqa: E501
        """create_query_result  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_query_result_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param QueryResult query_result:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueryResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'query_result'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_query_result" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query_result' in local_var_params:
            body_params = local_var_params['query_result']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/query/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_repo(self, user_username, **kwargs):  # noqa: E501
        """create_repo  # noqa: E501

        Create a repository owned by the authenticated user. The request body must contain the required fields for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_repo(user_username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param Repo repo:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_repo_with_http_info(user_username, **kwargs)  # noqa: E501

    def create_repo_with_http_info(self, user_username, **kwargs):  # noqa: E501
        """create_repo  # noqa: E501

        Create a repository owned by the authenticated user. The request body must contain the required fields for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_repo_with_http_info(user_username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param Repo repo:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repo, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `create_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'repo' in local_var_params:
            body_params = local_var_params['repo']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_table(self, user_username, repo_name, **kwargs):  # noqa: E501
        """create_table  # noqa: E501

        Create a table owned by the authenticated user in the given repo. The request body must contain the required fields for the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table(user_username, repo_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param Table table:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Table
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_table_with_http_info(user_username, repo_name, **kwargs)  # noqa: E501

    def create_table_with_http_info(self, user_username, repo_name, **kwargs):  # noqa: E501
        """create_table  # noqa: E501

        Create a table owned by the authenticated user in the given repo. The request body must contain the required fields for the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table_with_http_info(user_username, repo_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param Table table:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Table, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'table'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `create_table`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `create_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'table' in local_var_params:
            body_params = local_var_params['table']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Table',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_column(self, user_username, repo_name, table_current_name, current_name, **kwargs):  # noqa: E501
        """destroy_column  # noqa: E501

        Delete the given column.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_column(user_username, repo_name, table_current_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param str current_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_column_with_http_info(user_username, repo_name, table_current_name, current_name, **kwargs)  # noqa: E501

    def destroy_column_with_http_info(self, user_username, repo_name, table_current_name, current_name, **kwargs):  # noqa: E501
        """destroy_column  # noqa: E501

        Delete the given column.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_column_with_http_info(user_username, repo_name, table_current_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param str current_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'table_current_name',
            'current_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_column" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `destroy_column`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `destroy_column`")  # noqa: E501
        # verify the required parameter 'table_current_name' is set
        if self.api_client.client_side_validation and ('table_current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_current_name` when calling `destroy_column`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `destroy_column`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'table_current_name' in local_var_params:
            path_params['table_current_name'] = local_var_params['table_current_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{table_current_name}/columns/{current_name}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_q_connection(self, user_username, name, **kwargs):  # noqa: E501
        """destroy_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_q_connection(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_q_connection_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def destroy_q_connection_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """destroy_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_q_connection_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_q_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `destroy_q_connection`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `destroy_q_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/connections/{name}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_q_endpoint(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """destroy_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_q_endpoint(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_q_endpoint_with_http_info(user_username, repo_name, name, **kwargs)  # noqa: E501

    def destroy_q_endpoint_with_http_info(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """destroy_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_q_endpoint_with_http_info(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_q_endpoint" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `destroy_q_endpoint`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `destroy_q_endpoint`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `destroy_q_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/endpoints/{name}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_repo(self, user_username, name, **kwargs):  # noqa: E501
        """destroy_repo  # noqa: E501

        Delete the given repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_repo(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_repo_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def destroy_repo_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """destroy_repo  # noqa: E501

        Delete the given repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_repo_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `destroy_repo`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `destroy_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{name}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_table(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """destroy_table  # noqa: E501

        Delete the given table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_table(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_table_with_http_info(user_username, repo_name, current_name, **kwargs)  # noqa: E501

    def destroy_table_with_http_info(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """destroy_table  # noqa: E501

        Delete the given table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_table_with_http_info(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'current_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `destroy_table`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `destroy_table`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `destroy_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{current_name}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_columns(self, user_username, repo_name, table_current_name, **kwargs):  # noqa: E501
        """list_columns  # noqa: E501

        Given a username, repo name, and table name, retrieve a list of the table's columns that the user can access in some way.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_columns(user_username, repo_name, table_current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Column]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_columns_with_http_info(user_username, repo_name, table_current_name, **kwargs)  # noqa: E501

    def list_columns_with_http_info(self, user_username, repo_name, table_current_name, **kwargs):  # noqa: E501
        """list_columns  # noqa: E501

        Given a username, repo name, and table name, retrieve a list of the table's columns that the user can access in some way.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_columns_with_http_info(user_username, repo_name, table_current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Column], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'table_current_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_columns" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `list_columns`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `list_columns`")  # noqa: E501
        # verify the required parameter 'table_current_name' is set
        if self.api_client.client_side_validation and ('table_current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_current_name` when calling `list_columns`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'table_current_name' in local_var_params:
            path_params['table_current_name'] = local_var_params['table_current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{table_current_name}/columns/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Column]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_q_connections(self, user_username, **kwargs):  # noqa: E501
        """list_q_connections  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_q_connections(user_username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[QConnection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_q_connections_with_http_info(user_username, **kwargs)  # noqa: E501

    def list_q_connections_with_http_info(self, user_username, **kwargs):  # noqa: E501
        """list_q_connections  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_q_connections_with_http_info(user_username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[QConnection], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_q_connections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `list_q_connections`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/connections/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[QConnection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_q_endpoints(self, user_username, repo_name, **kwargs):  # noqa: E501
        """list_q_endpoints  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_q_endpoints(user_username, repo_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[QEndpoint]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_q_endpoints_with_http_info(user_username, repo_name, **kwargs)  # noqa: E501

    def list_q_endpoints_with_http_info(self, user_username, repo_name, **kwargs):  # noqa: E501
        """list_q_endpoints  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_q_endpoints_with_http_info(user_username, repo_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[QEndpoint], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_q_endpoints" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `list_q_endpoints`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `list_q_endpoints`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/endpoints/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[QEndpoint]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_q_users(self, **kwargs):  # noqa: E501
        """list_q_users  # noqa: E501

        API endpoint that allows users to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_q_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[QUser]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_q_users_with_http_info(**kwargs)  # noqa: E501

    def list_q_users_with_http_info(self, **kwargs):  # noqa: E501
        """list_q_users  # noqa: E501

        API endpoint that allows users to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_q_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[QUser], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_q_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[QUser]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_repos(self, user_username, **kwargs):  # noqa: E501
        """list_repos  # noqa: E501

        Given a username, retrieve a list of the repositories that the user can access in some way.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_repos(user_username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Repo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_repos_with_http_info(user_username, **kwargs)  # noqa: E501

    def list_repos_with_http_info(self, user_username, **kwargs):  # noqa: E501
        """list_repos  # noqa: E501

        Given a username, retrieve a list of the repositories that the user can access in some way.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_repos_with_http_info(user_username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Repo], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_repos" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `list_repos`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Repo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_tables(self, user_username, repo_name, **kwargs):  # noqa: E501
        """list_tables  # noqa: E501

        Given a username and repo name, retrieve a list of the repository's tables that the user can access in some way.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tables(user_username, repo_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Table]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_tables_with_http_info(user_username, repo_name, **kwargs)  # noqa: E501

    def list_tables_with_http_info(self, user_username, repo_name, **kwargs):  # noqa: E501
        """list_tables  # noqa: E501

        Given a username and repo name, retrieve a list of the repository's tables that the user can access in some way.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tables_with_http_info(user_username, repo_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Table], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `list_tables`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `list_tables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Table]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_column(self, user_username, repo_name, table_current_name, current_name, **kwargs):  # noqa: E501
        """partial_update_column  # noqa: E501

        Given a username, repo name, table name, and column name, update one or more fields' value in the given column.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_column(user_username, repo_name, table_current_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param str current_name: (required)
        :param Column column:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Column
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_column_with_http_info(user_username, repo_name, table_current_name, current_name, **kwargs)  # noqa: E501

    def partial_update_column_with_http_info(self, user_username, repo_name, table_current_name, current_name, **kwargs):  # noqa: E501
        """partial_update_column  # noqa: E501

        Given a username, repo name, table name, and column name, update one or more fields' value in the given column.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_column_with_http_info(user_username, repo_name, table_current_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param str current_name: (required)
        :param Column column:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Column, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'table_current_name',
            'current_name',
            'column'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_column" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `partial_update_column`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `partial_update_column`")  # noqa: E501
        # verify the required parameter 'table_current_name' is set
        if self.api_client.client_side_validation and ('table_current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_current_name` when calling `partial_update_column`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `partial_update_column`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'table_current_name' in local_var_params:
            path_params['table_current_name'] = local_var_params['table_current_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'column' in local_var_params:
            body_params = local_var_params['column']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{table_current_name}/columns/{current_name}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Column',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_q_connection(self, user_username, name, **kwargs):  # noqa: E501
        """partial_update_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_q_connection(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param QConnection q_connection:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_q_connection_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def partial_update_q_connection_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """partial_update_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_q_connection_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param QConnection q_connection:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QConnection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name',
            'q_connection'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_q_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `partial_update_q_connection`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `partial_update_q_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'q_connection' in local_var_params:
            body_params = local_var_params['q_connection']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/connections/{name}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QConnection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_q_endpoint(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """partial_update_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_q_endpoint(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param QEndpoint q_endpoint:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_q_endpoint_with_http_info(user_username, repo_name, name, **kwargs)  # noqa: E501

    def partial_update_q_endpoint_with_http_info(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """partial_update_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_q_endpoint_with_http_info(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param QEndpoint q_endpoint:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QEndpoint, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'name',
            'q_endpoint'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_q_endpoint" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `partial_update_q_endpoint`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `partial_update_q_endpoint`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `partial_update_q_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'q_endpoint' in local_var_params:
            body_params = local_var_params['q_endpoint']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/endpoints/{name}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_q_user(self, username, **kwargs):  # noqa: E501
        """partial_update_q_user  # noqa: E501

        API endpoint that allows users to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_q_user(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username: (required)
        :param QUser q_user:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_q_user_with_http_info(username, **kwargs)  # noqa: E501

    def partial_update_q_user_with_http_info(self, username, **kwargs):  # noqa: E501
        """partial_update_q_user  # noqa: E501

        API endpoint that allows users to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_q_user_with_http_info(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username: (required)
        :param QUser q_user:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QUser, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'username',
            'q_user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_q_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'username' is set
        if self.api_client.client_side_validation and ('username' not in local_var_params or  # noqa: E501
                                                        local_var_params['username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `username` when calling `partial_update_q_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'username' in local_var_params:
            path_params['username'] = local_var_params['username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'q_user' in local_var_params:
            body_params = local_var_params['q_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{username}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_repo(self, user_username, name, **kwargs):  # noqa: E501
        """partial_update_repo  # noqa: E501

        Given a username and a repo name, update one or more field's value in the given repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_repo(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param Repo repo:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_repo_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def partial_update_repo_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """partial_update_repo  # noqa: E501

        Given a username and a repo name, update one or more field's value in the given repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_repo_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param Repo repo:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repo, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name',
            'repo'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `partial_update_repo`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `partial_update_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'repo' in local_var_params:
            body_params = local_var_params['repo']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{name}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_table(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """partial_update_table  # noqa: E501

        Given a username, repo name, and table name, update one or more fields value in the given table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_table(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param Table table:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Table
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_table_with_http_info(user_username, repo_name, current_name, **kwargs)  # noqa: E501

    def partial_update_table_with_http_info(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """partial_update_table  # noqa: E501

        Given a username, repo name, and table name, update one or more fields value in the given table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_table_with_http_info(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param Table table:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Table, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'current_name',
            'table'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `partial_update_table`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `partial_update_table`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `partial_update_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'table' in local_var_params:
            body_params = local_var_params['table']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{current_name}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Table',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_column(self, user_username, repo_name, table_current_name, current_name, **kwargs):  # noqa: E501
        """retrieve_column  # noqa: E501

        Given a username, repo name, table name, and column name, get the given columns's fields and values of those fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_column(user_username, repo_name, table_current_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param str current_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Column
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_column_with_http_info(user_username, repo_name, table_current_name, current_name, **kwargs)  # noqa: E501

    def retrieve_column_with_http_info(self, user_username, repo_name, table_current_name, current_name, **kwargs):  # noqa: E501
        """retrieve_column  # noqa: E501

        Given a username, repo name, table name, and column name, get the given columns's fields and values of those fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_column_with_http_info(user_username, repo_name, table_current_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param str current_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Column, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'table_current_name',
            'current_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_column" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `retrieve_column`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `retrieve_column`")  # noqa: E501
        # verify the required parameter 'table_current_name' is set
        if self.api_client.client_side_validation and ('table_current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_current_name` when calling `retrieve_column`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `retrieve_column`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'table_current_name' in local_var_params:
            path_params['table_current_name'] = local_var_params['table_current_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{table_current_name}/columns/{current_name}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Column',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_q_connection(self, user_username, name, **kwargs):  # noqa: E501
        """retrieve_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_q_connection(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_q_connection_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def retrieve_q_connection_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """retrieve_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_q_connection_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QConnection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_q_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `retrieve_q_connection`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `retrieve_q_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/connections/{name}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QConnection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_q_endpoint(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """retrieve_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_q_endpoint(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_q_endpoint_with_http_info(user_username, repo_name, name, **kwargs)  # noqa: E501

    def retrieve_q_endpoint_with_http_info(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """retrieve_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_q_endpoint_with_http_info(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QEndpoint, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_q_endpoint" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `retrieve_q_endpoint`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `retrieve_q_endpoint`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `retrieve_q_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/endpoints/{name}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_q_user(self, username, **kwargs):  # noqa: E501
        """retrieve_q_user  # noqa: E501

        API endpoint that allows users to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_q_user(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_q_user_with_http_info(username, **kwargs)  # noqa: E501

    def retrieve_q_user_with_http_info(self, username, **kwargs):  # noqa: E501
        """retrieve_q_user  # noqa: E501

        API endpoint that allows users to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_q_user_with_http_info(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QUser, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'username'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_q_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'username' is set
        if self.api_client.client_side_validation and ('username' not in local_var_params or  # noqa: E501
                                                        local_var_params['username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `username` when calling `retrieve_q_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'username' in local_var_params:
            path_params['username'] = local_var_params['username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{username}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_repo(self, user_username, name, **kwargs):  # noqa: E501
        """retrieve_repo  # noqa: E501

        Given a username and repo name, get the given repo's fields and values of those fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_repo(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_repo_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def retrieve_repo_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """retrieve_repo  # noqa: E501

        Given a username and repo name, get the given repo's fields and values of those fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_repo_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repo, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `retrieve_repo`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `retrieve_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{name}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_table(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """retrieve_table  # noqa: E501

        Given a username, repo name, and table name, get the given table's fields and values of those fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_table(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Table
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_table_with_http_info(user_username, repo_name, current_name, **kwargs)  # noqa: E501

    def retrieve_table_with_http_info(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """retrieve_table  # noqa: E501

        Given a username, repo name, and table name, get the given table's fields and values of those fields.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_table_with_http_info(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Table, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'current_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `retrieve_table`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `retrieve_table`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `retrieve_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{current_name}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Table',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def share_repo(self, user_username, name, **kwargs):  # noqa: E501
        """share_repo  # noqa: E501

        API endpoint that allows repositories to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.share_repo(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param Repo repo:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.share_repo_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def share_repo_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """share_repo  # noqa: E501

        API endpoint that allows repositories to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.share_repo_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param Repo repo:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repo, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name',
            'repo'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method share_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `share_repo`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `share_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'repo' in local_var_params:
            body_params = local_var_params['repo']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{name}/share/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def share_table(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """share_table  # noqa: E501

        API endpoint that allows tables to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.share_table(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param Table table:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Table
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.share_table_with_http_info(user_username, repo_name, current_name, **kwargs)  # noqa: E501

    def share_table_with_http_info(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """share_table  # noqa: E501

        API endpoint that allows tables to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.share_table_with_http_info(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param Table table:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Table, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'current_name',
            'table'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method share_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `share_table`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `share_table`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `share_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'table' in local_var_params:
            body_params = local_var_params['table']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{current_name}/share/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Table',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_column(self, user_username, repo_name, table_current_name, current_name, **kwargs):  # noqa: E501
        """update_column  # noqa: E501

        Given a username, repo name, table name, and column name, update the values of all fields in the given column.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_column(user_username, repo_name, table_current_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param str current_name: (required)
        :param Column column:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Column
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_column_with_http_info(user_username, repo_name, table_current_name, current_name, **kwargs)  # noqa: E501

    def update_column_with_http_info(self, user_username, repo_name, table_current_name, current_name, **kwargs):  # noqa: E501
        """update_column  # noqa: E501

        Given a username, repo name, table name, and column name, update the values of all fields in the given column.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_column_with_http_info(user_username, repo_name, table_current_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str table_current_name: (required)
        :param str current_name: (required)
        :param Column column:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Column, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'table_current_name',
            'current_name',
            'column'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_column" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `update_column`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `update_column`")  # noqa: E501
        # verify the required parameter 'table_current_name' is set
        if self.api_client.client_side_validation and ('table_current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_current_name` when calling `update_column`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `update_column`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'table_current_name' in local_var_params:
            path_params['table_current_name'] = local_var_params['table_current_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'column' in local_var_params:
            body_params = local_var_params['column']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{table_current_name}/columns/{current_name}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Column',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_q_connection(self, user_username, name, **kwargs):  # noqa: E501
        """update_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_q_connection(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param QConnection q_connection:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_q_connection_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def update_q_connection_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """update_q_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_q_connection_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param QConnection q_connection:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QConnection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name',
            'q_connection'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_q_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `update_q_connection`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `update_q_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'q_connection' in local_var_params:
            body_params = local_var_params['q_connection']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/connections/{name}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QConnection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_q_endpoint(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """update_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_q_endpoint(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param QEndpoint q_endpoint:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_q_endpoint_with_http_info(user_username, repo_name, name, **kwargs)  # noqa: E501

    def update_q_endpoint_with_http_info(self, user_username, repo_name, name, **kwargs):  # noqa: E501
        """update_q_endpoint  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_q_endpoint_with_http_info(user_username, repo_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str name: (required)
        :param QEndpoint q_endpoint:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QEndpoint, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'name',
            'q_endpoint'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_q_endpoint" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `update_q_endpoint`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `update_q_endpoint`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `update_q_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'q_endpoint' in local_var_params:
            body_params = local_var_params['q_endpoint']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/endpoints/{name}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_q_user(self, username, **kwargs):  # noqa: E501
        """update_q_user  # noqa: E501

        API endpoint that allows users to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_q_user(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username: (required)
        :param QUser q_user:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_q_user_with_http_info(username, **kwargs)  # noqa: E501

    def update_q_user_with_http_info(self, username, **kwargs):  # noqa: E501
        """update_q_user  # noqa: E501

        API endpoint that allows users to be viewed or edited.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_q_user_with_http_info(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username: (required)
        :param QUser q_user:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QUser, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'username',
            'q_user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_q_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'username' is set
        if self.api_client.client_side_validation and ('username' not in local_var_params or  # noqa: E501
                                                        local_var_params['username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `username` when calling `update_q_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'username' in local_var_params:
            path_params['username'] = local_var_params['username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'q_user' in local_var_params:
            body_params = local_var_params['q_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{username}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_repo(self, user_username, name, **kwargs):  # noqa: E501
        """update_repo  # noqa: E501

        Given a user and a repo name, update the values of all fields in the given repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_repo(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param Repo repo:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_repo_with_http_info(user_username, name, **kwargs)  # noqa: E501

    def update_repo_with_http_info(self, user_username, name, **kwargs):  # noqa: E501
        """update_repo  # noqa: E501

        Given a user and a repo name, update the values of all fields in the given repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_repo_with_http_info(user_username, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str name: (required)
        :param Repo repo:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repo, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'name',
            'repo'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `update_repo`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `update_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'repo' in local_var_params:
            body_params = local_var_params['repo']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{name}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_table(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """update_table  # noqa: E501

        Given a username, repo name, and table name, update the values of all fields in the given table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_table(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param Table table:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Table
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_table_with_http_info(user_username, repo_name, current_name, **kwargs)  # noqa: E501

    def update_table_with_http_info(self, user_username, repo_name, current_name, **kwargs):  # noqa: E501
        """update_table  # noqa: E501

        Given a username, repo name, and table name, update the values of all fields in the given table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_table_with_http_info(user_username, repo_name, current_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_username: (required)
        :param str repo_name: (required)
        :param str current_name: (required)
        :param Table table:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Table, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user_username',
            'repo_name',
            'current_name',
            'table'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_username' is set
        if self.api_client.client_side_validation and ('user_username' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_username'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_username` when calling `update_table`")  # noqa: E501
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `update_table`")  # noqa: E501
        # verify the required parameter 'current_name' is set
        if self.api_client.client_side_validation and ('current_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['current_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_name` when calling `update_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_username' in local_var_params:
            path_params['user_username'] = local_var_params['user_username']  # noqa: E501
        if 'repo_name' in local_var_params:
            path_params['repo_name'] = local_var_params['repo_name']  # noqa: E501
        if 'current_name' in local_var_params:
            path_params['current_name'] = local_var_params['current_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'table' in local_var_params:
            body_params = local_var_params['table']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user_username}/repos/{repo_name}/tables/{current_name}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Table',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
