# AUTOMATICALLY GENERATED BY PYCBF WRAPPER - DO NOT EDIT
#
# Generated from:
# - cbfdetectorwrappers.i
# - cbfgenericwrappers.i
# - cbfgoniometerwrappers.i
# - cbfhandlewrappers.i
# - cbfpositionerwrappers.i
# - make_pycbf.py
# - pycbf.i
# + version = "0.9.6.2"
# + Cython = "^0.29.23"
# + requires = ["poetry-core>=1.0.0", "setuptools", "Cython~=0.29.23"]
#
# Combined Checksum: abb27560094fcc291042b8685abbdc2d95de6c8ddd9c281fbc5e72de8c06a304

# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _pycbf
else:
    import _pycbf

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



__author__ = "Jon Wright <wright@esrf.fr>"
__date__ = "14 Dec 2005"
__version__ = "0.9.6.2"
__credits__ = """Paul Ellis and Herbert Bernstein for the excellent CBFlib!"""
__doc__=""" pycbf - python bindings to the CBFlib library

 A library for reading and writing ImageCIF and CBF files
 which store area detector images for crystallography.

 This work is a derivative of the CBFlib version 0.7.7 library
 by  Paul J. Ellis of Stanford Synchrotron Radiation Laboratory
 and Herbert J. Bernstein of Bernstein + Sons
 See:
   http://www.bernstein-plus-sons.com/software/CBF/

 Licensing is GPL based, see:
   http://www.bernstein-plus-sons.com/software/CBF/doc/CBFlib_NOTICES.html

 These bindings were automatically generated by SWIG, and the
 input to SWIG was automatically generated by a python script.
 We very strongly recommend you do not attempt to edit them
 by hand!



 Copyright (C) 2007    Jonathan Wright
                       ESRF, Grenoble, France
                email: wright@esrf.fr

  Revised, August 2010  Herbert J. Bernstein
    Add defines from CBFlib 0.9.1

"""

class doubleArray(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, nelements):
        _pycbf.doubleArray_swiginit(self, _pycbf.new_doubleArray(nelements))
    __swig_destroy__ = _pycbf.delete_doubleArray

    def __getitem__(self, index):
        return _pycbf.doubleArray___getitem__(self, index)

    def __setitem__(self, index, value):
        return _pycbf.doubleArray___setitem__(self, index, value)

    def cast(self):
        return _pycbf.doubleArray_cast(self)

    @staticmethod
    def frompointer(t):
        return _pycbf.doubleArray_frompointer(t)

# Register doubleArray in _pycbf:
_pycbf.doubleArray_swigregister(doubleArray)

def doubleArray_frompointer(t):
    return _pycbf.doubleArray_frompointer(t)

class intArray(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, nelements):
        _pycbf.intArray_swiginit(self, _pycbf.new_intArray(nelements))
    __swig_destroy__ = _pycbf.delete_intArray

    def __getitem__(self, index):
        return _pycbf.intArray___getitem__(self, index)

    def __setitem__(self, index, value):
        return _pycbf.intArray___setitem__(self, index, value)

    def cast(self):
        return _pycbf.intArray_cast(self)

    @staticmethod
    def frompointer(t):
        return _pycbf.intArray_frompointer(t)

# Register intArray in _pycbf:
_pycbf.intArray_swigregister(intArray)

def intArray_frompointer(t):
    return _pycbf.intArray_frompointer(t)

class shortArray(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, nelements):
        _pycbf.shortArray_swiginit(self, _pycbf.new_shortArray(nelements))
    __swig_destroy__ = _pycbf.delete_shortArray

    def __getitem__(self, index):
        return _pycbf.shortArray___getitem__(self, index)

    def __setitem__(self, index, value):
        return _pycbf.shortArray___setitem__(self, index, value)

    def cast(self):
        return _pycbf.shortArray_cast(self)

    @staticmethod
    def frompointer(t):
        return _pycbf.shortArray_frompointer(t)

# Register shortArray in _pycbf:
_pycbf.shortArray_swigregister(shortArray)

def shortArray_frompointer(t):
    return _pycbf.shortArray_frompointer(t)

class longArray(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, nelements):
        _pycbf.longArray_swiginit(self, _pycbf.new_longArray(nelements))
    __swig_destroy__ = _pycbf.delete_longArray

    def __getitem__(self, index):
        return _pycbf.longArray___getitem__(self, index)

    def __setitem__(self, index, value):
        return _pycbf.longArray___setitem__(self, index, value)

    def cast(self):
        return _pycbf.longArray_cast(self)

    @staticmethod
    def frompointer(t):
        return _pycbf.longArray_frompointer(t)

# Register longArray in _pycbf:
_pycbf.longArray_swigregister(longArray)

def longArray_frompointer(t):
    return _pycbf.longArray_frompointer(t)

CBF_INTEGER = _pycbf.CBF_INTEGER
CBF_FLOAT = _pycbf.CBF_FLOAT
CBF_CANONICAL = _pycbf.CBF_CANONICAL
CBF_PACKED = _pycbf.CBF_PACKED
CBF_PACKED_V2 = _pycbf.CBF_PACKED_V2
CBF_BYTE_OFFSET = _pycbf.CBF_BYTE_OFFSET
CBF_PREDICTOR = _pycbf.CBF_PREDICTOR
CBF_NONE = _pycbf.CBF_NONE
CBF_COMPRESSION_MASK = _pycbf.CBF_COMPRESSION_MASK
CBF_FLAG_MASK = _pycbf.CBF_FLAG_MASK
CBF_UNCORRELATED_SECTIONS = _pycbf.CBF_UNCORRELATED_SECTIONS
CBF_FLAT_IMAGE = _pycbf.CBF_FLAT_IMAGE
CBF_NO_EXPAND = _pycbf.CBF_NO_EXPAND
PLAIN_HEADERS = _pycbf.PLAIN_HEADERS
MIME_HEADERS = _pycbf.MIME_HEADERS
MSG_NODIGEST = _pycbf.MSG_NODIGEST
MSG_DIGEST = _pycbf.MSG_DIGEST
MSG_DIGESTNOW = _pycbf.MSG_DIGESTNOW
MSG_DIGESTWARN = _pycbf.MSG_DIGESTWARN
PAD_1K = _pycbf.PAD_1K
PAD_2K = _pycbf.PAD_2K
PAD_4K = _pycbf.PAD_4K
CBF_PARSE_BRC = _pycbf.CBF_PARSE_BRC
CBF_PARSE_PRN = _pycbf.CBF_PARSE_PRN
CBF_PARSE_BKT = _pycbf.CBF_PARSE_BKT
CBF_PARSE_BRACKETS = _pycbf.CBF_PARSE_BRACKETS
CBF_PARSE_TQ = _pycbf.CBF_PARSE_TQ
CBF_PARSE_CIF2_DELIMS = _pycbf.CBF_PARSE_CIF2_DELIMS
CBF_PARSE_DDLm = _pycbf.CBF_PARSE_DDLm
CBF_PARSE_CIF2 = _pycbf.CBF_PARSE_CIF2
CBF_PARSE_DEFINES = _pycbf.CBF_PARSE_DEFINES
CBF_PARSE_WIDE = _pycbf.CBF_PARSE_WIDE
CBF_PARSE_UTF8 = _pycbf.CBF_PARSE_UTF8
HDR_DEFAULT = _pycbf.HDR_DEFAULT
MIME_NOHEADERS = _pycbf.MIME_NOHEADERS
CBF = _pycbf.CBF
CIF = _pycbf.CIF
ENC_NONE = _pycbf.ENC_NONE
ENC_BASE64 = _pycbf.ENC_BASE64
ENC_BASE32K = _pycbf.ENC_BASE32K
ENC_QP = _pycbf.ENC_QP
ENC_BASE10 = _pycbf.ENC_BASE10
ENC_BASE16 = _pycbf.ENC_BASE16
ENC_BASE8 = _pycbf.ENC_BASE8
ENC_FORWARD = _pycbf.ENC_FORWARD
ENC_BACKWARD = _pycbf.ENC_BACKWARD
ENC_CRTERM = _pycbf.ENC_CRTERM
ENC_LFTERM = _pycbf.ENC_LFTERM
ENC_DEFAULT = _pycbf.ENC_DEFAULT

def airy_disk(x, y, cenx, ceny, volume, fwhm):
    r"""

    Returns : Float value
    *args   : double x,double y,double cenx,double ceny,double volume,double fwhm

    C prototype: int cbf_airy_disk(double x, double y, double cenx, double ceny,
                     double      volume, double fwhm, double * value);

    CBFLib documentation:
    DESCRIPTION
    cbf_airy_disk sets value to point to the value taken at (x,y) of an
    truncated Airy function approximation to a point-spread function of
    total included volume volume and full width at half max fwhm centered
    on (cenx, ceny).
    cbf_airy_disk_volume sets to point to the integral in the box with
    diagonal corners (xlo, ylo) and of (xhi, yhi) of a truncated Airy
    function approximation to a point-spread function of total included
    volume volume and full width at half max fwhm centered on (cenx,
    ceny).
    The Airy function used is an 8-digit approximation up to the first
    minimum, after which it is forced to zero, so it cannot be used to
    simulate diffraction rings.
    ARGUMENTS
    x           the x-coordinate of a point in the real plane y
    the y-coordinate of a point in the real plane xlo         the
    x-coordinate of a point in the real plane marking the left bound of
    integration ylo         the y-coordinate of a point in the real plane
    marking the bottom bound of integration xhi         the x-coordinate
    of a point in the real plane marking the right bound of integration
    yhi         the y-coordinate of a point in the real plane marking the
    top bound of integration cenx        the x-coordinate of a point in
    the real plane marking the PSF center ceny        the y-coordinate of
    a point in the real plane marking the PSF center volume      the
    total volume of the PSF fwhm        the full-width at half max of the
    PSF value       Pointer to the value of the Airy function volumeout
    Pointer to the value of the integral/TR>
    RETURN VALUE
    Returns an error code on failure or 0 for success.
    ----------------------------------------------------------------------

    """
    return _pycbf.airy_disk(x, y, cenx, ceny, volume, fwhm)

def airy_disk_volume(xlo, ylo, xhi, yhi, cenx, ceny, volume, fwhm):
    r"""

    Returns : Float volumeout
    *args   : double xlo,double ylo,double xhi,double yhi,double cenx,double ceny,
              double volume,double fwhm

    C prototype: int cbf_airy_disk_volume(double xlo, double ylo, double xhi,
                     double yhi,      double cenx, double ceny, double volume,
                     double fwhm, double *      volumeout);

    CBFLib documentation:
    DESCRIPTION
    cbf_airy_disk sets value to point to the value taken at (x,y) of an
    truncated Airy function approximation to a point-spread function of
    total included volume volume and full width at half max fwhm centered
    on (cenx, ceny).
    cbf_airy_disk_volume sets to point to the integral in the box with
    diagonal corners (xlo, ylo) and of (xhi, yhi) of a truncated Airy
    function approximation to a point-spread function of total included
    volume volume and full width at half max fwhm centered on (cenx,
    ceny).
    The Airy function used is an 8-digit approximation up to the first
    minimum, after which it is forced to zero, so it cannot be used to
    simulate diffraction rings.
    ARGUMENTS
    x           the x-coordinate of a point in the real plane y
    the y-coordinate of a point in the real plane xlo         the
    x-coordinate of a point in the real plane marking the left bound of
    integration ylo         the y-coordinate of a point in the real plane
    marking the bottom bound of integration xhi         the x-coordinate
    of a point in the real plane marking the right bound of integration
    yhi         the y-coordinate of a point in the real plane marking the
    top bound of integration cenx        the x-coordinate of a point in
    the real plane marking the PSF center ceny        the y-coordinate of
    a point in the real plane marking the PSF center volume      the
    total volume of the PSF fwhm        the full-width at half max of the
    PSF value       Pointer to the value of the Airy function volumeout
    Pointer to the value of the integral/TR>
    RETURN VALUE
    Returns an error code on failure or 0 for success.
    ----------------------------------------------------------------------

    """
    return _pycbf.airy_disk_volume(xlo, ylo, xhi, yhi, cenx, ceny, volume, fwhm)

def compute_cell_volume(cell):
    r"""

    Returns : Float volume
    *args   : double cell[6]

    C prototype: int cbf_compute_cell_volume ( double cell[6], double *volume );

    CBFLib documentation:
    DESCRIPTION
    cbf_compute_cell_volume sets *volume to point to the volume of the
    unit cell computed from the double values in cell[0:2] for the cell
    edge lengths a, b and c in Ångstroms and the double values given in
    cell[3:5] for the cell angles α, β and γ in degrees.
    ARGUMENTS
    cell     Pointer to the array of 6 doubles giving the cell
    parameters. volume   Pointer to the doubles for cell volume.
    RETURN VALUE
    Returns an error code on failure or 0 for success.
    SEE ALSO

    """
    return _pycbf.compute_cell_volume(cell)

def compute_reciprocal_cell(cell):
    r"""

    Returns : Float astar,Float bstar,Float cstar,Float alphastar,Float betastar,
              Float gammastar
    *args   : double cell[6]

    C prototype: int cbf_compute_reciprocal_cell ( double cell[6],
                     double rcell[6] );

    CBFLib documentation:
    DESCRIPTION
    cbf_compute_reciprocal_cell sets rcell to point to the array of
    reciprocal cell parameters computed from the double values cell[0:2]
    giving the cell edge lengths a, b and c in Ångstroms, and the double
    values cell[3:5] giving the cell angles α, β and γ in degrees. The
    double values rcell[0:2] will be set to the reciprocal cell lengths
    a^*, b^* and c^* in Ångstroms^-1 and the double values rcell[3:5]
    will be set to the reciprocal cell angles α^*, β^* and γ^* in
    degrees.
    ARGUMENTS
    cell     Pointer to the array of 6 doubles giving the cell
    parameters. rcell    Pointer to the destination array of 6 doubles
    giving the reciprocal cell parameters. volume   Pointer to the
    doubles for cell volume.
    RETURN VALUE
    Returns an error code on failure or 0 for success.
    SEE ALSO

    """
    return _pycbf.compute_reciprocal_cell(cell)

def get_local_integer_byte_order():
    r"""

    Returns : char **bo,int *bolen
    *args   :

    C prototype: int cbf_get_local_integer_byte_order (char ** byte_order);

    CBFLib documentation:
    DESCRIPTION
    cbf_get_local_integer_byte_order returns the byte order of integers
    on the machine on which the API is being run in the form of a
    character string returned as the value pointed to by byte_order.
    cbf_get_local_real_byte_order returns the byte order of reals on the
    machine on which the API is being run in the form of a character
    string returned as the value pointed to by byte_order.
    cbf_get_local_real_format returns the format of floats on the machine
    on which the API is being run in the form of a character string
    returned as the value pointed to by real_format. The strings returned
    must not be modified in any way.
    The values returned in byte_order may be the strings  "little_endian
    " or  "big-endian ". The values returned in real_format may be the
    strings  "ieee 754-1985 " or  "other ". Additional values may be
    returned by future versions of the API.
    ARGUMENTS
    byte_order    pointer to the returned string real_format   pointer to
    the returned string
    RETURN VALUE
    Returns an error code on failure or 0 for success.
    ----------------------------------------------------------------------

    """
    return _pycbf.get_local_integer_byte_order()

def get_local_real_byte_order():
    r"""

    Returns : char **bo,int *bolen
    *args   :

    C prototype: int cbf_get_local_real_byte_order (char ** byte_order);

    CBFLib documentation:
    DESCRIPTION
    cbf_get_local_integer_byte_order returns the byte order of integers
    on the machine on which the API is being run in the form of a
    character string returned as the value pointed to by byte_order.
    cbf_get_local_real_byte_order returns the byte order of reals on the
    machine on which the API is being run in the form of a character
    string returned as the value pointed to by byte_order.
    cbf_get_local_real_format returns the format of floats on the machine
    on which the API is being run in the form of a character string
    returned as the value pointed to by real_format. The strings returned
    must not be modified in any way.
    The values returned in byte_order may be the strings  "little_endian
    " or  "big-endian ". The values returned in real_format may be the
    strings  "ieee 754-1985 " or  "other ". Additional values may be
    returned by future versions of the API.
    ARGUMENTS
    byte_order    pointer to the returned string real_format   pointer to
    the returned string
    RETURN VALUE
    Returns an error code on failure or 0 for success.
    ----------------------------------------------------------------------

    """
    return _pycbf.get_local_real_byte_order()

def get_local_real_format():
    r"""

    Returns : char **rf,int *rflen
    *args   :

    C prototype: int cbf_get_local_real_format (char ** real_format );

    CBFLib documentation:
    DESCRIPTION
    cbf_get_local_integer_byte_order returns the byte order of integers
    on the machine on which the API is being run in the form of a
    character string returned as the value pointed to by byte_order.
    cbf_get_local_real_byte_order returns the byte order of reals on the
    machine on which the API is being run in the form of a character
    string returned as the value pointed to by byte_order.
    cbf_get_local_real_format returns the format of floats on the machine
    on which the API is being run in the form of a character string
    returned as the value pointed to by real_format. The strings returned
    must not be modified in any way.
    The values returned in byte_order may be the strings  "little_endian
    " or  "big-endian ". The values returned in real_format may be the
    strings  "ieee 754-1985 " or  "other ". Additional values may be
    returned by future versions of the API.
    ARGUMENTS
    byte_order    pointer to the returned string real_format   pointer to
    the returned string
    RETURN VALUE
    Returns an error code on failure or 0 for success.
    ----------------------------------------------------------------------

    """
    return _pycbf.get_local_real_format()
class cbf_positioner_struct(object):
    r"""Proxy of C cbf_positioner_struct struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    matrix = property(_pycbf.cbf_positioner_struct_matrix_get, _pycbf.cbf_positioner_struct_matrix_set, doc=r"""matrix : a(3).a(4).double""")
    axis = property(_pycbf.cbf_positioner_struct_axis_get, _pycbf.cbf_positioner_struct_axis_set, doc=r"""axis : p.cbf_axis_struct""")
    axes = property(_pycbf.cbf_positioner_struct_axes_get, _pycbf.cbf_positioner_struct_axes_set, doc=r"""axes : size_t""")
    matrix_is_valid = property(_pycbf.cbf_positioner_struct_matrix_is_valid_get, _pycbf.cbf_positioner_struct_matrix_is_valid_set, doc=r"""matrix_is_valid : int""")
    matrix_ratio_used = property(_pycbf.cbf_positioner_struct_matrix_ratio_used_get, _pycbf.cbf_positioner_struct_matrix_ratio_used_set, doc=r"""matrix_ratio_used : double""")
    axis_index_limit = property(_pycbf.cbf_positioner_struct_axis_index_limit_get, _pycbf.cbf_positioner_struct_axis_index_limit_set, doc=r"""axis_index_limit : size_t""")

    def __init__(self):
        r"""__init__(cbf_positioner_struct self) -> cbf_positioner_struct"""
        _pycbf.cbf_positioner_struct_swiginit(self, _pycbf.new_cbf_positioner_struct())
    __swig_destroy__ = _pycbf.delete_cbf_positioner_struct

    def get_goniometer_poise(self, ratio):
        r"""

        Returns : Float vector1,Float vector2,Float vector3,Float offset1,Float offset2,
                  Float offset3,Float angle
        *args   : Float ratio

        C prototype: int cbf_get_goniometer_poise(cbf_goniometer goniometer,
                         double ratio,      double * vector1, double * vector2,
                         double * vector3, double * offset1,      double * offset2,
                         double * offset3, double * angle);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_axis_poise sets vector1, vector2, vector3 to point to the
        components of the axis vector for axis axis_id, offset1, offset2,
        offset3 to point to the components of the axis base offset vector for
        axis axis_id, and angle to point to the angle of rotation of axis
        axis_id after application of the axis settings for frame frame_id,
        using ratio, a value between 0 and 1, indicating how far into the
        internal motion in the frame to go. If frame_id is the string  ".
        ", the first frame found is used. If there is more than one frame,
        which frame will be found is indeterminate. If frame_id is NULL, the
        overall setting for the scan are used, rather than those for any
        particular frame. The vector and offset reported are the reference
        vector and offset of the axis axis_id transformed by application of
        all motions of the axes on which axis_id depends.
        cbf_get_goniometer_poise vector1, vector2, vector3 to point to the
        components of the axis vector for the goniometer axis, offset1,
        offset2, offset3 to point to the components of the axis base offset
        vector for the goniometer axis, and angle to point to the angle of
        rotation of the goniometer axis after application of all axis
        settings in the goniometer deriving the vector, offset and angle from
        the resulting matrix. Calculation of the vector is indeterminate if
        the angle is zero.
        cbf_get_axis_reference_poise sets vector1, vector2, vector3 to point
        to the components of the axis vector for axis axis_id, offset1,
        offset2, offset3 to point to the components of the axis base offset
        vector for axis axis_id unmodified by axis rotations. Any of the
        pointers may be specified as NULL.
        ARGUMENTS
        handle       CBF handle. ratio        A number between 0 and 1
        indication how far into the frame to go vector1      Pointer to the
        first component of the axis vector vector2      Pointer to the second
        component of the axis vector vector3      Pointer to the third
        component of the axis vector offset1      Pointer to the first
        component of the axis offset offset2      Pointer to the second
        component of the axis offset offset3      Pointer to the third
        component of the axis offset angle        Pointer to the rotation
        angle axis_id      The specified axis frame_id     The specified
        frame positioner   CBF goniometer
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_positioner_struct_get_goniometer_poise(self, ratio)

    def get_reciprocal(self, ratio, wavelength, real1, real2, real3):
        r"""

        Returns : double reciprocal1,double reciprocal2,double reciprocal3
        *args   : double ratio,double wavelength,double real1,double real2,double real3

        C prototype: int cbf_get_reciprocal (cbf_goniometer goniometer,
                         unsigned int      reserved, double ratio, double wavelength,
                         double real1, double real2,      double real3,
                         double *reciprocal1, double *reciprocal2,
                         double      *reciprocal3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_reciprocal sets *reciprocal1, * reciprocal2, and *
        reciprocal3 to the 3 components of the of the reciprocal-space vector
        corresponding to the real-space vector (real1, real2, real3). The
        reciprocal-space vector is oriented to correspond to the goniometer
        setting with all axes at 0. The value wavelength is the wavlength in
        Å and the value ratio specifies the current goniometer setting and
        varies from 0.0 at the beginning of the exposur e to 1.0 at the end,
        irrespective of the actual rotation range.
        Any of the destination pointers may be NULL.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        goniometer    Goniometer handle. reserved      Unused. Any value
        other than 0 is invalid. ratio         Goniometer setting. 0 =
        beginning of exposure, 1 = end. wavelength    Wavelength in Å. real1
               x component of the real-space vector. real2         y
        component of the real-space vector. real3         z component of the
        real-space vector. reciprocal1   Pointer to the destination x
        component of the reciprocal-space vector. reciprocal2   Pointer to
        the destination y component of the reciprocal-space vector.
        reciprocal3   Pointer to the destination z component of the
        reciprocal-space vector.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_positioner_struct_get_reciprocal(self, ratio, wavelength, real1, real2, real3)

    def get_rotation_axis(self):
        r"""

        Returns : double vector1,double vector2,double vector3
        *args   :

        C prototype: int cbf_get_rotation_axis (cbf_goniometer goniometer,
                         unsigned int      reserved, double *vector1, double *vector2,
                         double *vector3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_rotation_axis sets *vector1, *vector2, and *vector3 to the 3
        components of the goniometer rotation axis used for the exposure.
        Any of the destination pointers may be NULL.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        goniometer   Goniometer handle. reserved     Unused. Any value other
        than 0 is invalid. vector1      Pointer to the destination x
        component of the rotation axis. vector2      Pointer to the
        destination y component of the rotation axis. vector3      Pointer to
        the destination z component of the rotation axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_positioner_struct_get_rotation_axis(self)

    def get_rotation_range(self):
        r"""

        Returns : Float start,Float increment
        *args   :

        C prototype: int cbf_get_rotation_range (cbf_goniometer goniometer,
                         unsigned int      reserved, double *start, double *increment);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_rotation_range sets *start and *increment to the
        corresponding values of the goniometer rotation axis used for the
        exposure.
        Either of the destination pointers may be NULL.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        goniometer   Goniometer handle. reserved     Unused. Any value other
        than 0 is invalid. start        Pointer to the destination start
        value. increment    Pointer to the destination increment value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_positioner_struct_get_rotation_range(self)

    def rotate_vector(self, ratio, initial1, initial2, initial3):
        r"""

        Returns : double final1,double final2,double final3
        *args   : double ratio,double initial1,double initial2,double initial3

        C prototype: int cbf_rotate_vector (cbf_goniometer goniometer,
                         unsigned int reserved,      double ratio, double initial1,
                         double initial2, double initial3, double      *final1,
                         double *final2, double *final3);

        CBFLib documentation:
        DESCRIPTION
        cbf_rotate_vector sets *final1, *final2, and *final3 to the 3
        components of the of the vector (initial1, initial2, initial3) after
        reorientation by applying the goniometer rotations. The value ratio
        specif ies the goniometer setting and varies from 0.0 at the
        beginning of the exposure to 1.0 at the end, irrespective of the
        actual rotation range.
        Any of the destination pointers may be NULL.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        goniometer   Goniometer handle. reserved     Unused. Any value other
        than 0 is invalid. ratio        Goniometer setting. 0 = beginning of
        exposure, 1 = end. initial1     x component of the initial vector.
        initial2     y component of the initial vector. initial3     z
        component of the initial vector. vector1      Pointer to the
        destination x component of the final vector. vector2      Pointer to
        the destination y component of the final vector. vector3      Pointer
        to the destination z component of the final vector.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_positioner_struct_rotate_vector(self, ratio, initial1, initial2, initial3)

# Register cbf_positioner_struct in _pycbf:
_pycbf.cbf_positioner_struct_swigregister(cbf_positioner_struct)

class cbf_detector_struct(object):
    r"""Proxy of C cbf_detector_struct struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    positioner = property(_pycbf.cbf_detector_struct_positioner_get, _pycbf.cbf_detector_struct_positioner_set, doc=r"""positioner : cbf_positioner""")
    displacement = property(_pycbf.cbf_detector_struct_displacement_get, _pycbf.cbf_detector_struct_displacement_set, doc=r"""displacement : a(2).double""")
    increment = property(_pycbf.cbf_detector_struct_increment_get, _pycbf.cbf_detector_struct_increment_set, doc=r"""increment : a(2).double""")
    axes = property(_pycbf.cbf_detector_struct_axes_get, _pycbf.cbf_detector_struct_axes_set, doc=r"""axes : size_t""")
    index = property(_pycbf.cbf_detector_struct_index_get, _pycbf.cbf_detector_struct_index_set, doc=r"""index : a(2).size_t""")

    def __init__(self):
        r"""__init__(cbf_detector_struct self) -> cbf_detector_struct"""
        _pycbf.cbf_detector_struct_swiginit(self, _pycbf.new_cbf_detector_struct())
    __swig_destroy__ = _pycbf.delete_cbf_detector_struct

    def get_beam_center(self):
        r"""

        Returns : double index1,double index2,double center1,double center2
        *args   :

        C prototype: int cbf_get_beam_center (cbf_detector detector,
                         double *indexslow,      double *indexfast, double *centerslow,
                         double *centerfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_beam_center(self)

    def get_beam_center_fs(self):
        r"""

        Returns : double indexfast,double indexslow,double centerfast,double centerslow
        *args   :

        C prototype: int cbf_get_beam_center_fs (cbf_detector detector,
                         double *indexfast,      double *indexslow, double *centerfast,
                         double *centerslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_beam_center_fs(self)

    def get_beam_center_sf(self):
        r"""

        Returns : double indexslow,double indexfast,double centerslow,double centerfast
        *args   :

        C prototype: int cbf_get_beam_center_sf (cbf_detector detector,
                         double *indexslow,      double *indexfast, double *centerslow,
                         double *centerfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_beam_center_sf(self)

    def get_detector_axes(self):
        r"""

        Returns : double slowaxis1,double slowaxis2,double slowaxis3,double fastaxis1,
                  double fastaxis2,double fastaxis3
        *args   :

        C prototype: int cbf_get_detector_axes (cbf_detector detector,
                         double *slowaxis1,      double *slowaxis2, double *slowaxis3,
                         double *fastaxis1, double      *fastaxis2, double *fastaxis3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_detector_axis_slow sets *slowaxis1, *slowaxis2, and
        *slowaxis3 to the 3 components of the slow axis of the specified
        detector at the current settings of all axes.
        cbf_get_detector_axis_slow sets *fastaxis1, *fastaxis2, and
        *fastaxis3 to the 3 components of the fast axis of the specified
        detector at the current settings of all axes. cbf_get_detector_axes,
        cbf_get_detector_axes_fs and int cbf_get_detector_axes_sf set
        *slowaxis1, *slowaxis2, and *slowaxis3 to the 3 components of the
        slow axis and *fastaxis1, *fastaxis2, and *fastaxis3 to the 3
        components of the fast axis of the specified detector at the current
        settings of all axes. cbf_get_detector_surface_axes sets *axis_id1
        and *axis_id2 to the names of the two surface axes of the detector or
         ". ",
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector    Detector handle. slowaxis1   Pointer to the destination x
        component of the slow axis vector. slowaxis2   Pointer to the
        destination y component of the slow axis vector. slowaxis3   Pointer
        to the destination z component of the slow axis vector. fastaxis1
        Pointer to the destination x component of the fast axis vector.
        fastaxis2   Pointer to the destination y component of the fast axis
        vector. fastaxis3   Pointer to the destination z component of the
        fast axis vector. axis_id1    Pointer to the destination first
        surface axis name. axis_id1    Pointer to the destination first
        surface axis name. axis_id2    Pointer to the destination second
        surface axis name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_detector_axes(self)

    def get_detector_axes_fs(self):
        r"""get_detector_axes_fs(cbf_detector_struct self)"""
        return _pycbf.cbf_detector_struct_get_detector_axes_fs(self)

    def get_detector_axes_sf(self):
        r"""

        Returns : double slowaxis1,double slowaxis2,double slowaxis3,double fastaxis1,
                  double fastaxis2,double fastaxis3
        *args   :

        C prototype: int cbf_get_detector_axes_sf (cbf_detector detector,
                         double *slowaxis1,      double *slowaxis2, double *slowaxis3,
                         double *fastaxis1, double      *fastaxis2, double *fastaxis3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_detector_axis_slow sets *slowaxis1, *slowaxis2, and
        *slowaxis3 to the 3 components of the slow axis of the specified
        detector at the current settings of all axes.
        cbf_get_detector_axis_slow sets *fastaxis1, *fastaxis2, and
        *fastaxis3 to the 3 components of the fast axis of the specified
        detector at the current settings of all axes. cbf_get_detector_axes,
        cbf_get_detector_axes_fs and int cbf_get_detector_axes_sf set
        *slowaxis1, *slowaxis2, and *slowaxis3 to the 3 components of the
        slow axis and *fastaxis1, *fastaxis2, and *fastaxis3 to the 3
        components of the fast axis of the specified detector at the current
        settings of all axes. cbf_get_detector_surface_axes sets *axis_id1
        and *axis_id2 to the names of the two surface axes of the detector or
         ". ",
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector    Detector handle. slowaxis1   Pointer to the destination x
        component of the slow axis vector. slowaxis2   Pointer to the
        destination y component of the slow axis vector. slowaxis3   Pointer
        to the destination z component of the slow axis vector. fastaxis1
        Pointer to the destination x component of the fast axis vector.
        fastaxis2   Pointer to the destination y component of the fast axis
        vector. fastaxis3   Pointer to the destination z component of the
        fast axis vector. axis_id1    Pointer to the destination first
        surface axis name. axis_id1    Pointer to the destination first
        surface axis name. axis_id2    Pointer to the destination second
        surface axis name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_detector_axes_sf(self)

    def get_detector_axis_fast(self):
        r"""

        Returns : double fastaxis1,double fastaxis2,double fastaxis3
        *args   :

        C prototype: int cbf_get_detector_axis_fast (cbf_detector detector,
                         double      *fastaxis1, double *fastaxis2, double *fastaxis3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_detector_axis_slow sets *slowaxis1, *slowaxis2, and
        *slowaxis3 to the 3 components of the slow axis of the specified
        detector at the current settings of all axes.
        cbf_get_detector_axis_slow sets *fastaxis1, *fastaxis2, and
        *fastaxis3 to the 3 components of the fast axis of the specified
        detector at the current settings of all axes. cbf_get_detector_axes,
        cbf_get_detector_axes_fs and int cbf_get_detector_axes_sf set
        *slowaxis1, *slowaxis2, and *slowaxis3 to the 3 components of the
        slow axis and *fastaxis1, *fastaxis2, and *fastaxis3 to the 3
        components of the fast axis of the specified detector at the current
        settings of all axes. cbf_get_detector_surface_axes sets *axis_id1
        and *axis_id2 to the names of the two surface axes of the detector or
         ". ",
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector    Detector handle. slowaxis1   Pointer to the destination x
        component of the slow axis vector. slowaxis2   Pointer to the
        destination y component of the slow axis vector. slowaxis3   Pointer
        to the destination z component of the slow axis vector. fastaxis1
        Pointer to the destination x component of the fast axis vector.
        fastaxis2   Pointer to the destination y component of the fast axis
        vector. fastaxis3   Pointer to the destination z component of the
        fast axis vector. axis_id1    Pointer to the destination first
        surface axis name. axis_id1    Pointer to the destination first
        surface axis name. axis_id2    Pointer to the destination second
        surface axis name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_detector_axis_fast(self)

    def get_detector_axis_slow(self):
        r"""

        Returns : double slowaxis1,double slowaxis2,double slowaxis3
        *args   :

        C prototype: int cbf_get_detector_axis_slow (cbf_detector detector,
                         double      *slowaxis1, double *slowaxis2, double *slowaxis3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_detector_axis_slow sets *slowaxis1, *slowaxis2, and
        *slowaxis3 to the 3 components of the slow axis of the specified
        detector at the current settings of all axes.
        cbf_get_detector_axis_slow sets *fastaxis1, *fastaxis2, and
        *fastaxis3 to the 3 components of the fast axis of the specified
        detector at the current settings of all axes. cbf_get_detector_axes,
        cbf_get_detector_axes_fs and int cbf_get_detector_axes_sf set
        *slowaxis1, *slowaxis2, and *slowaxis3 to the 3 components of the
        slow axis and *fastaxis1, *fastaxis2, and *fastaxis3 to the 3
        components of the fast axis of the specified detector at the current
        settings of all axes. cbf_get_detector_surface_axes sets *axis_id1
        and *axis_id2 to the names of the two surface axes of the detector or
         ". ",
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector    Detector handle. slowaxis1   Pointer to the destination x
        component of the slow axis vector. slowaxis2   Pointer to the
        destination y component of the slow axis vector. slowaxis3   Pointer
        to the destination z component of the slow axis vector. fastaxis1
        Pointer to the destination x component of the fast axis vector.
        fastaxis2   Pointer to the destination y component of the fast axis
        vector. fastaxis3   Pointer to the destination z component of the
        fast axis vector. axis_id1    Pointer to the destination first
        surface axis name. axis_id1    Pointer to the destination first
        surface axis name. axis_id2    Pointer to the destination second
        surface axis name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_detector_axis_slow(self)

    def get_detector_distance(self):
        r"""

        Returns : double distance
        *args   :

        C prototype: int cbf_get_detector_distance (cbf_detector detector,
                         double *distance);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_detector_distance sets *distance to the nearest distance from
        the sample position to the detector plane.
        ARGUMENTS
        detector   Detector handle. distance   Pointer to the destination
        distance.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_detector_distance(self)

    def get_detector_normal(self):
        r"""

        Returns : double normal1,double normal2,double normal3
        *args   :

        C prototype: int cbf_get_detector_normal (cbf_detector detector,
                         double *normal1,      double *normal2, double *normal3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_detector_normal sets *normal1, *normal2, and *normal3 to the
        3 components of the of the normal vector to the detector plane. The
        vector is normalized.
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector   Detector handle. normal1    Pointer to the destination x
        component of the normal vector. normal2    Pointer to the destination
        y component of the normal vector. normal3    Pointer to the
        destination z component of the normal vector.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_detector_normal(self)

    def get_detector_surface_axes(self, index):
        r"""get_detector_surface_axes(cbf_detector_struct self, int index) -> char const *"""
        return _pycbf.cbf_detector_struct_get_detector_surface_axes(self, index)

    def get_inferred_pixel_size(self, axis_number):
        r"""

        Returns : Float pixel size
        *args   : Int axis_number

        C prototype: int cbf_get_inferred_pixel_size (cbf_detector detector,
                         int axis_number,      double *psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_inferred_pixel_size, cbf_get_inferred_pixel_size_sf set
        *psize to point to the double value in millimeters of the pixel size
        for the axis axis_number value. The slow index is treated as axis 1
        and the next faster index is treated as axis 2.
        cbf_get_inferred_pixel_size_fs sets *psize to point to the double
        value in millimeters of the pixel size for the axis axis_number
        value. The fast index is treated as axis 1 and the next slower index
        is treated as axis 2.
        If the axis number is negative, the axes are used in the reverse
        order so that an axis_number of -1 indicates the fast axes in a call
        to cbf_get_inferred_pixel_size or cbf_get_inferred_pixel_size_sf and
        indicates the fast axis in a call to cbf_get_inferred_pixel_size_fs.
        ARGUMENTS
        detector      Detector handle. axis_number   The number of the axis.
        area          Pointer to the destination pizel size in mm.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_inferred_pixel_size(self, axis_number)

    def get_inferred_pixel_size_fs(self, axis_number):
        r"""

        Returns : Float pixel size
        *args   : Int axis_number

        C prototype: int cbf_get_inferred_pixel_size_fs(cbf_detector detector,
                         int      axis_number, double *psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_inferred_pixel_size, cbf_get_inferred_pixel_size_sf set
        *psize to point to the double value in millimeters of the pixel size
        for the axis axis_number value. The slow index is treated as axis 1
        and the next faster index is treated as axis 2.
        cbf_get_inferred_pixel_size_fs sets *psize to point to the double
        value in millimeters of the pixel size for the axis axis_number
        value. The fast index is treated as axis 1 and the next slower index
        is treated as axis 2.
        If the axis number is negative, the axes are used in the reverse
        order so that an axis_number of -1 indicates the fast axes in a call
        to cbf_get_inferred_pixel_size or cbf_get_inferred_pixel_size_sf and
        indicates the fast axis in a call to cbf_get_inferred_pixel_size_fs.
        ARGUMENTS
        detector      Detector handle. axis_number   The number of the axis.
        area          Pointer to the destination pizel size in mm.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_inferred_pixel_size_fs(self, axis_number)

    def get_inferred_pixel_size_sf(self, axis_number):
        r"""

        Returns : Float pixel size
        *args   : Int axis_number

        C prototype: int cbf_get_inferred_pixel_size_sf(cbf_detector detector,
                         int      axis_number, double *psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_inferred_pixel_size, cbf_get_inferred_pixel_size_sf set
        *psize to point to the double value in millimeters of the pixel size
        for the axis axis_number value. The slow index is treated as axis 1
        and the next faster index is treated as axis 2.
        cbf_get_inferred_pixel_size_fs sets *psize to point to the double
        value in millimeters of the pixel size for the axis axis_number
        value. The fast index is treated as axis 1 and the next slower index
        is treated as axis 2.
        If the axis number is negative, the axes are used in the reverse
        order so that an axis_number of -1 indicates the fast axes in a call
        to cbf_get_inferred_pixel_size or cbf_get_inferred_pixel_size_sf and
        indicates the fast axis in a call to cbf_get_inferred_pixel_size_fs.
        ARGUMENTS
        detector      Detector handle. axis_number   The number of the axis.
        area          Pointer to the destination pizel size in mm.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_inferred_pixel_size_sf(self, axis_number)

    def get_pixel_area(self, index1, index2):
        r"""

        Returns : double area,double projected_area
        *args   : double index1,double index2

        C prototype: int cbf_get_pixel_area (cbf_detector detector, double indexslow,
                         double      indexfast, double *area, double *projected_area);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_area, cbf_get_pixel_area_fs and cbf_get_pixel_area_sf
        set *area to the area of the pixel at (indexfast, indexslow) on the
        detector surface and *projected_area to the apparent area of the
        pixel as viewed from the sample position, with indexslow being the
        slow axis and indexfast being the fast axis.
        Either of the destination pointers may be NULL.
        ARGUMENTS
        detector         Detector handle. indexfast        Fast index.
        indexslow        Slow index. area             Pointer to the
        destination area in mm2. projected_area   Pointer to the destination
        apparent area in mm2.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_pixel_area(self, index1, index2)

    def get_pixel_area_fs(self, indexfast, indexslow):
        r"""

        Returns : double area,double projected_area
        *args   : double indexfast,double indexslow

        C prototype: int cbf_get_pixel_area_fs(cbf_detector detector,
                         double indexfast,      double indexslow, double *area,
                         double *projected_area);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_area, cbf_get_pixel_area_fs and cbf_get_pixel_area_sf
        set *area to the area of the pixel at (indexfast, indexslow) on the
        detector surface and *projected_area to the apparent area of the
        pixel as viewed from the sample position, with indexslow being the
        slow axis and indexfast being the fast axis.
        Either of the destination pointers may be NULL.
        ARGUMENTS
        detector         Detector handle. indexfast        Fast index.
        indexslow        Slow index. area             Pointer to the
        destination area in mm2. projected_area   Pointer to the destination
        apparent area in mm2.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_pixel_area_fs(self, indexfast, indexslow)

    def get_pixel_area_sf(self, indexslow, indexfast):
        r"""

        Returns : double area,double projected_area
        *args   : double indexslow,double indexfast

        C prototype: int cbf_get_pixel_area_sf(cbf_detector detector,
                         double indexslow,      double indexfast, double *area,
                         double *projected_area);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_area, cbf_get_pixel_area_fs and cbf_get_pixel_area_sf
        set *area to the area of the pixel at (indexfast, indexslow) on the
        detector surface and *projected_area to the apparent area of the
        pixel as viewed from the sample position, with indexslow being the
        slow axis and indexfast being the fast axis.
        Either of the destination pointers may be NULL.
        ARGUMENTS
        detector         Detector handle. indexfast        Fast index.
        indexslow        Slow index. area             Pointer to the
        destination area in mm2. projected_area   Pointer to the destination
        apparent area in mm2.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_pixel_area_sf(self, indexslow, indexfast)

    def get_pixel_coordinates(self, index1, index2):
        r"""

        Returns : double coordinate1,double coordinate2,double coordinate3
        *args   : double index1,double index2

        C prototype: int cbf_get_pixel_coordinates (cbf_detector detector,
                         double indexslow,      double indexfast, double *coordinate1,
                         double *coordinate2, double      *coordinate3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_coordinates, cbf_get_pixel_coordinates_fs and
        cbf_get_pixel_coordinates_sf ses *coordinate1, *coordinate2, and
        *coordinate3 to the vector position of pixel (indexfast, indexslow)
        on the detector surface. If indexslow and indexfast are integers then
        the coordinates correspond to the center of a pixel.
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector      Detector handle. indexslow     Slow index. indexfast
         Fast index. coordinate1   Pointer to the destination x component.
        coordinate2   Pointer to the destination y component. coordinate3
        Pointer to the destination z component.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_pixel_coordinates(self, index1, index2)

    def get_pixel_coordinates_fs(self, indexfast, indexslow):
        r"""

        Returns : double coordinate1,double coordinate2,double coordinate3
        *args   : double indexfast,double indexslow

        C prototype: int cbf_get_pixel_coordinates_fs (cbf_detector detector,
                         double      indexfast, double indexslow, double *coordinate1,
                         double *coordinate2,      double *coordinate3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_coordinates, cbf_get_pixel_coordinates_fs and
        cbf_get_pixel_coordinates_sf ses *coordinate1, *coordinate2, and
        *coordinate3 to the vector position of pixel (indexfast, indexslow)
        on the detector surface. If indexslow and indexfast are integers then
        the coordinates correspond to the center of a pixel.
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector      Detector handle. indexslow     Slow index. indexfast
         Fast index. coordinate1   Pointer to the destination x component.
        coordinate2   Pointer to the destination y component. coordinate3
        Pointer to the destination z component.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_pixel_coordinates_fs(self, indexfast, indexslow)

    def get_pixel_coordinates_sf(self, indexslow, indexfast):
        r"""

        Returns : double coordinate1,double coordinate2,double coordinate3
        *args   : double indexslow,double indexfast

        C prototype: int cbf_get_pixel_coordinates_sf (cbf_detector detector,
                         double      indexslow, double indexfast, double *coordinate1,
                         double *coordinate2,      double *coordinate3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_coordinates, cbf_get_pixel_coordinates_fs and
        cbf_get_pixel_coordinates_sf ses *coordinate1, *coordinate2, and
        *coordinate3 to the vector position of pixel (indexfast, indexslow)
        on the detector surface. If indexslow and indexfast are integers then
        the coordinates correspond to the center of a pixel.
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector      Detector handle. indexslow     Slow index. indexfast
         Fast index. coordinate1   Pointer to the destination x component.
        coordinate2   Pointer to the destination y component. coordinate3
        Pointer to the destination z component.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_pixel_coordinates_sf(self, indexslow, indexfast)

    def get_pixel_normal(self, index1, index2):
        r"""

        Returns : double normal1,double normal2,double normal3
        *args   : double index1,double index2

        C prototype: int cbf_get_pixel_normal (cbf_detector detector,
                         double indexslow,      double indexfast, double *normal1,
                         double *normal2, double *normal3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_detector_normal, cbf_get_pixel_normal_fs and
        cbf_get_pixel_normal_sf set *normal1, *normal2, and *normal3 to the 3
        components of the of the normal vector to the pixel at (indexfast,
        indexslow). The vector is normalized.
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector    Detector handle. indexslow   Slow index. indexfast   Fast
        index. normal1     Pointer to the destination x component of the
        normal vector. normal2     Pointer to the destination y component of
        the normal vector. normal3     Pointer to the destination z component
        of the normal vector.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_pixel_normal(self, index1, index2)

    def get_pixel_normal_fs(self, indexfast, indexslow):
        r"""

        Returns : double normal1,double normal2,double normal3
        *args   : double indexfast,double indexslow

        C prototype: int cbf_get_pixel_normal_fs (cbf_detector detector,
                         double indexfast,      double indexslow, double *normal1,
                         double *normal2, double *normal3);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_detector_normal, cbf_get_pixel_normal_fs and
        cbf_get_pixel_normal_sf set *normal1, *normal2, and *normal3 to the 3
        components of the of the normal vector to the pixel at (indexfast,
        indexslow). The vector is normalized.
        Any of the destination pointers may be NULL.
        ARGUMENTS
        detector    Detector handle. indexslow   Slow index. indexfast   Fast
        index. normal1     Pointer to the destination x component of the
        normal vector. normal2     Pointer to the destination y component of
        the normal vector. normal3     Pointer to the destination z component
        of the normal vector.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_get_pixel_normal_fs(self, indexfast, indexslow)

    def set_beam_center(self):
        r"""

        Returns :
        *args   : double indexslow,double indexfast,double centerslow,double centerfast

        C prototype: int cbf_set_beam_center (cbf_detector detector,
                         double *indexslow,      double *indexfast, double *centerslow,
                         double *centerfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_set_beam_center(self)

    def set_beam_center_fs(self):
        r"""

        Returns :
        *args   : double indexfast,double indexslow,double centerfast,double centerslow

        C prototype: int cbf_set_beam_center_fs (cbf_detector detector,
                         double *indexfast,      double *indexslow, double *centerfast,
                         double *centerslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_set_beam_center_fs(self)

    def set_beam_center_sf(self):
        r"""

        Returns :
        *args   : double indexslow,double indexfast,double centerslow,double centerfast

        C prototype: int cbf_set_beam_center_sf (cbf_detector detector,
                         double *indexslow,      double *indexfast, double *centerslow,
                         double *centerfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_set_beam_center_sf(self)

    def set_reference_beam_center(self):
        r"""

        Returns :
        *args   : double indexslow,double indexfast,double centerslow,double centerfast

        C prototype: int cbf_set_reference_beam_center (cbf_detector detector,
                         double      *indexslow, double *indexfast, double *centerslow,
                         double *centerfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_set_reference_beam_center(self)

    def set_reference_beam_center_fs(self):
        r"""

        Returns :
        *args   : double indexfast,double indexslow,double centerfast,double centerslow

        C prototype: int cbf_set_reference_beam_center_fs (cbf_detector detector,
                         double      *indexfast, double *indexslow, double *centerfast,
                         double *centerslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_set_reference_beam_center_fs(self)

    def set_reference_beam_center_sf(self):
        r"""

        Returns :
        *args   : double indexslow,double indexfast,double centerslow,double centerfast

        C prototype: int cbf_set_reference_beam_center_sf (cbf_detector detector,
                         double      *indexslow, double *indexfast, double *centerslow,
                         double *centerfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_beam_center sets *centerfast and *centerslow to the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector and *indexfast and
        *indexslow to the corresponding indices. cbf_set_beam_center sets the
        offsets in the axis category for the detector element axis with
        precedence 1 to place the beam center at the position given in mm by
        *centerfast and *centerslow as the displacements in mm along the
        detector axes from pixel (0, 0) to the point at which the beam
        intersects the detector at the indices given *indexfast and
        *indexslow. cbf_set_reference_beam_center sets the displacments in
        the array_structure_list_axis category to place the beam center at
        the position given in mm by *centerfast and *centerslow as the
        displacements in mm along the detector axes from pixel (0, 0) to the
        point at which the beam intersects the detector at the indices given
        by *indexfast and *indexslow. In order to achieve consistent results,
        a reference detector should be used for detector to have all axes at
        their reference settings.
        Note that the precedence 1 axis is the fastest axis, so that
        *centerfast and *indexfast are the fast axis components of the center
        and *centerslow and *indexslow are the slow axis components of the
        center.
        The _fs calls give the displacments in a fast-to-slow order. The
        calls with no suffix and the calls _sf calls give the displacements
        in slow-to-fast order
        Any of the destination pointers may be NULL for getting the beam
        center. For setting the beam axis, either the indices of the center
        must not be NULL.
        The indices are non-negative for beam centers within the detector
        surface, but the center for an axis with a negative increment will be
        negative for a beam center within the detector surface.
        For cbf_set_beam_center if the diffrn_data_frame category exists with
        a row for the corresponding element id, the values will be set for
        _diffrn_data_frame.center_fast and _diffrn_data_frame.center_slow in
        millimetres and the value of _diffrn_data_frame.center_units will be
        set to 'mm'.
        For cbf_set_reference_beam_center if the diffrn_detector_element
        category exists with a row for the corresponding element id, the
        values will be set for _diffrn_detector_element.reference_center_fast
        and _diffrn_detector_element.reference_center_slow in millimetres and
        the value of _diffrn_detector_element.reference_units will be set to
        'mm'.
        ARGUMENTS
        detector     Detector handle. indexfast    Pointer to the destination
        fast index. indexslow    Pointer to the destination slow index.
        centerfast   Pointer to the destination displacement along the fast
        axis. centerslow   Pointer to the destination displacement along the
        slow axis.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_detector_struct_set_reference_beam_center_sf(self)

# Register cbf_detector_struct in _pycbf:
_pycbf.cbf_detector_struct_swigregister(cbf_detector_struct)

CBF_UNDEFNODE = _pycbf.CBF_UNDEFNODE

CBF_LINK = _pycbf.CBF_LINK

CBF_ROOT = _pycbf.CBF_ROOT

CBF_DATABLOCK = _pycbf.CBF_DATABLOCK

CBF_SAVEFRAME = _pycbf.CBF_SAVEFRAME

CBF_CATEGORY = _pycbf.CBF_CATEGORY

CBF_COLUMN = _pycbf.CBF_COLUMN

class cbf_handle_struct(object):
    r"""Proxy of C cbf_handle_struct struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    node = property(_pycbf.cbf_handle_struct_node_get, _pycbf.cbf_handle_struct_node_set, doc=r"""node : p.cbf_node""")
    row = property(_pycbf.cbf_handle_struct_row_get, _pycbf.cbf_handle_struct_row_set, doc=r"""row : int""")
    search_row = property(_pycbf.cbf_handle_struct_search_row_get, _pycbf.cbf_handle_struct_search_row_set, doc=r"""search_row : int""")

    def __init__(self):
        r"""__init__(cbf_handle_struct self) -> cbf_handle_struct"""
        _pycbf.cbf_handle_struct_swiginit(self, _pycbf.new_cbf_handle_struct())
    __swig_destroy__ = _pycbf.delete_cbf_handle_struct

    def category_name(self):
        r"""

        Returns :
        *args   : string

        C prototype: int cbf_category_name (cbf_handle handle,
                         const char **categoryname);

        CBFLib documentation:
        DESCRIPTION
        cbf_category_name sets *categoryname to point to the name of the
        current category of the current data block.
        The category name will be valid as long as the category exists.
        The name must not be modified by the program in any way.
        ARGUMENTS
        handle         CBF handle. categoryname   Pointer to the destination
        category name pointer.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_category_name(self)

    def column_name(self):
        r"""

        Returns :
        *args   : string

        C prototype: int cbf_column_name (cbf_handle handle, const char **columnname);

        CBFLib documentation:
        DESCRIPTION
        cbf_column_name sets *columnname to point to the name of the current
        column of the current category.
        The column name will be valid as long as the column exists.
        The name must not be modified by the program in any way.
        cbf_set_column_name sets the name of the current column to
        newcolumnname
        ARGUMENTS
        handle          CBF handle. columnname      Pointer to the
        destination column name pointer. newcolumnname   New column name
        pointer.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_column_name(self)

    def construct_detector(self, element_number):
        r"""

        Returns : pycbf detector object
        *args   : Integer element_number

        C prototype: int cbf_construct_detector (cbf_handle handle,
                         cbf_detector *detector,      unsigned int element_number);

        CBFLib documentation:
        DESCRIPTION
        cbf_construct_detector constructs a detector object for detector
        element number element_number using the description in the CBF object
        handle and initialises the detector handle *detector.
        cbf_construct_reference_detector constructs a detector object for
        detector element number element_number using the description in the
        CBF object handle and initialises the detector handle *detector using
        the reference settings of the axes. cbf_require_reference_detector is
        similar, but try to force the creations of missing intermediate
        categories needed to construct a detector object.
        ARGUMENTS
        handle           CBF handle. detector         Pointer to the
        destination detector handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_construct_detector(self, element_number)

    def construct_goniometer(self):
        r"""

        Returns : pycbf goniometer object
        *args   :

        C prototype: int cbf_construct_goniometer (cbf_handle handle,
                         cbf_goniometer      *goniometer);

        CBFLib documentation:
        DESCRIPTION
        cbf_construct_goniometer constructs a goniometer object using the
        description in the CBF object handle and initialises the goniometer
        handle *goniometer.
        ARGUMENTS
        handle       CBF handle. goniometer   Pointer to the destination
        goniometer handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_construct_goniometer(self)

    def construct_positioner(self, axis_id):
        r"""

        Returns : pycbf positioner object
        *args   : String axis_id

        C prototype: int cbf_construct_positioner (cbf_handle handle,
                         cbf_positioner      *positioner, const char *axis_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_construct_positioner constructs a positioner object for the axis
        given by axis_id using the description in the CBF object handle and
        initialises the positioner handle *positioner.
        cbf_construct_reference positioner constructs a positioner object for
        the axis given by axis_id using the description in the CBF object
        handle and initialises the detector handle *detector using the
        reference settings of the axes.
        ARGUMENTS
        handle     CBF handle. detector   Pointer to the destination detector
        handle. axis_id    The identifier of the axis in the  "axis "
        category.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_construct_positioner(self, axis_id)

    def construct_reference_detector(self, element_number):
        r"""

        Returns : pycbf detector object
        *args   : Integer element_number

        C prototype: int cbf_construct_reference_detector (cbf_handle handle,
                         cbf_detector      *detector, unsigned int element_number);

        CBFLib documentation:
        DESCRIPTION
        cbf_construct_detector constructs a detector object for detector
        element number element_number using the description in the CBF object
        handle and initialises the detector handle *detector.
        cbf_construct_reference_detector constructs a detector object for
        detector element number element_number using the description in the
        CBF object handle and initialises the detector handle *detector using
        the reference settings of the axes. cbf_require_reference_detector is
        similar, but try to force the creations of missing intermediate
        categories needed to construct a detector object.
        ARGUMENTS
        handle           CBF handle. detector         Pointer to the
        destination detector handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_construct_reference_detector(self, element_number)

    def construct_reference_positioner(self, axis_id):
        r"""

        Returns : pycbf positioner object
        *args   : String axis_id

        C prototype: int cbf_construct_reference_positioner (cbf_handle handle,
                              cbf_positioner *positioner, const char *axis_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_construct_positioner constructs a positioner object for the axis
        given by axis_id using the description in the CBF object handle and
        initialises the positioner handle *positioner.
        cbf_construct_reference positioner constructs a positioner object for
        the axis given by axis_id using the description in the CBF object
        handle and initialises the detector handle *detector using the
        reference settings of the axes.
        ARGUMENTS
        handle     CBF handle. detector   Pointer to the destination detector
        handle. axis_id    The identifier of the axis in the  "axis "
        category.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_construct_reference_positioner(self, axis_id)

    def count_axis_ancestors(self, axis_id):
        r"""

        Returns : Integer
        *args   : String axis_id

        C prototype: int cbf_count_axis_ancestors (cbf_handle handle,
                         const char *axis_id,      unsigned int *ancestors);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_count_axis_ancestors(self, axis_id)

    def count_categories(self):
        r"""

        Returns : Integer
        *args   :

        C prototype: int cbf_count_categories (cbf_handle handle,
                         unsigned int *categories);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_categories puts the number of categories in the current
        data block in *categories.
        ARGUMENTS
        handle       CBF handle. categories   Pointer to the destination
        category count.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_count_categories(self)

    def count_columns(self):
        r"""

        Returns : Integer
        *args   :

        C prototype: int cbf_count_columns (cbf_handle handle, unsigned int *columns);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_columns puts the number of columns in the current category
        in *columns.
        ARGUMENTS
        handle    CBF handle. columns   Pointer to the destination column
        count.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_count_columns(self)

    def count_datablocks(self):
        r"""

        Returns : Integer
        *args   :

        C prototype: int cbf_count_datablocks (cbf_handle handle,
                         unsigned int *datablocks);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_datablocks puts the number of data blocks in *datablocks .
        ARGUMENTS
        handle       CBF handle. datablocks   Pointer to the destination data
        block count.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_count_datablocks(self)

    def count_elements(self):
        r"""

        Returns : Integer
        *args   :

        C prototype: int cbf_count_elements (cbf_handle handle,
                         unsigned int *elements);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_elements sets *elements to the number of detector elements.
        ARGUMENTS
        handle     CBF handle. elements   Pointer to the destination count.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_count_elements(self)

    def count_rows(self):
        r"""

        Returns : Integer
        *args   :

        C prototype: int cbf_count_rows (cbf_handle handle, unsigned int *rows);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_rows puts the number of rows in the current category in
        *rows .
        ARGUMENTS
        handle   CBF handle. rows     Pointer to the destination row count.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_count_rows(self)

    def datablock_name(self):
        r"""

        Returns :
        *args   : string

        C prototype: int cbf_datablock_name (cbf_handle handle,
                         const char **datablockname);

        CBFLib documentation:
        DESCRIPTION
        cbf_datablock_name sets *datablockname to point to the name of the
        current data block.
        The data block name will be valid as long as the data block exists
        and has not been renamed.
        The name must not be modified by the program in any way.
        ARGUMENTS
        handle          CBF handle. datablockname   Pointer to the
        destination data block name pointer.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_datablock_name(self)

    def delete_row(self, arg):
        r"""

        Returns :
        *args   : Integer

        C prototype: int cbf_delete_row (cbf_handle handle, unsigned int rownumber);

        CBFLib documentation:
        DESCRIPTION
        cbf_delete_row deletes a row from the current category. Rows starting
        from rownumber +1 are moved down by 1. If the current row was higher
        than rownumber, or if the current row is the last row, it will also
        move down by 1.
        The row numbers start from 0.
        ARGUMENTS
        handle      CBF handle. rownumber   The number of the row to delete.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_delete_row(self, arg)

    def find_category(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_find_category (cbf_handle handle,
                         const char *categoryname);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_category makes the category in the current data block with
        name categoryname the current category.
        The comparison is case-insensitive.
        If the category does not exist, the function returns CBF_NOTFOUND.
        The current column and row become undefined.
        ARGUMENTS
        handle         CBF handle. categoryname   The name of the category to
        find.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_find_category(self, arg)

    def find_category_root(self, categoryname):
        r"""

        Returns : String categoryroot
        *args   : String categoryname

        C prototype: int cbf_find_category_root (cbf_handle handle,
                         const char* categoryname,      const char** categoryroot);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_category_root sets *categoryroot to the root category of
        which categoryname is an alias. cbf_set_category_root sets
        categoryname_in as an alias of categoryroot in the dictionary
        associated with handle, creating the dictionary if necessary.
        cbf_require_category_root sets *categoryroot to the root category of
        which categoryname is an alias, if there is one, or to the value of
        categoryname, if categoryname is not an alias.
        A returned categoryroot string must not be modified in any way.
        ARGUMENTS
        handle            CBF handle. categoryname      category name which
        may be an alias. categoryroot      pointer to a returned category
        root name. categoryroot_in   input category root name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_find_category_root(self, categoryname)

    def find_column(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_find_column (cbf_handle handle, const char *columnname);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_column makes the columns in the current category with name
        columnname the current column.
        The comparison is case-insensitive.
        If the column does not exist, the function returns CBF_NOTFOUND.
        The current row is not affected.
        ARGUMENTS
        handle       CBF handle. columnname   The name of column to find.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_find_column(self, arg)

    def find_datablock(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_find_datablock (cbf_handle handle,
                         const char *datablockname);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_datablock makes the data block with name datablockname the
        current data block.
        The comparison is case-insensitive.
        If the data block does not exist, the function returns CBF_NOTFOUND.
        The current category becomes undefined.
        ARGUMENTS
        handle          CBF handle. datablockname   The name of the data
        block to find.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_find_datablock(self, arg)

    def find_nextrow(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_find_nextrow (cbf_handle handle, const char *value);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_nextrow makes the makes the next row in the current column
        with value value the current row. The search starts from the row
        following the last row found with cbf_find_row or cbf_find_nextrow,
        or from the current row if the current row was defined using any
        other function.
        The comparison is case-sensitive.
        If no more matching rows exist, the function returns CBF_NOTFOUND.
        The current column is not affected.
        ARGUMENTS
        handle   CBF handle. value    the value to search for.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_find_nextrow(self, arg)

    def find_row(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_find_row (cbf_handle handle, const char *value);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_row makes the first row in the current column with value
        value the current row.
        The comparison is case-sensitive.
        If a matching row does not exist, the function returns CBF_NOTFOUND.
        The current column is not affected.
        ARGUMENTS
        handle   CBF handle. value    The value of the row to find.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_find_row(self, arg)

    def find_tag_category(self, tagname):
        r"""

        Returns : String categoryname
        *args   : String tagname

        C prototype: int cbf_find_tag_category (cbf_handle handle,
                         const char* tagname, const      char** categoryname);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_tag_category sets categoryname to the category associated
        with tagname in the dictionary associated with handle.
        cbf_set_tag_category upddates the dictionary associated with handle
        to indicated that tagname is in category categoryname_in.
        ARGUMENTS
        handle            CBF handle. tagname           tag name.
        categoryname      pointer to a returned category name.
        categoryname_in   input category name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_find_tag_category(self, tagname)

    def find_tag_root(self, tagname):
        r"""

        Returns : String tagroot
        *args   : String tagname

        C prototype: int cbf_find_tag_root (cbf_handle handle, const char* tagname,
                         const      char** tagroot);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_tag_root sets *tagroot to the root tag of which tagname is
        an alias. cbf_set_tag_root sets tagname as an alias of tagroot_in in
        the dictionary associated with handle, creating the dictionary if
        necessary. cbf_require_tag_root sets *tagroot to the root tag of
        which tagname is an alias, if there is one, or to the value of
        tagname, if tagname is not an alias.
        A returned tagroot string must not be modified in any way.
        ARGUMENTS
        handle       CBF handle. tagname      tag name which may be an alias.
        tagroot      pointer to a returned tag root name. tagroot_in   input
        tag root name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_find_tag_root(self, tagname)

    def force_new_category(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_force_new_category (cbf_handle handle,
                         const char *categoryname);

        CBFLib documentation:
        DESCRIPTION
        cbf_force_new_category creates a new category in the current data
        block with name categoryname and makes it the current category.
        Duplicate category names are allowed.
        Even if a category with this name already exists, a new category of
        the same name is created and becomes the current category. The allows
        for the creation of unlooped tag/value lists drawn from the same
        category.
        ARGUMENTS
        handle         CBF handle. categoryname   The name of the new
        category.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_force_new_category(self, arg)

    def force_new_datablock(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_force_new_datablock (cbf_handle handle,
                         const char    *datablockname);

        CBFLib documentation:
        DESCRIPTION
        cbf_force_new_datablock creates a new data block with name
        datablockname and makes it the current data block. Duplicate data
        block names are allowed. cbf_force_new_saveframe creates a new savew
        frame with name saveframename and makes it the current save frame.
        Duplicate save frame names are allowed.
        Even if a save frame with this name already exists, a new save frame
        is created and becomes the current save frame.
        ARGUMENTS
        handle          CBF handle. datablockname   The name of the new data
        block. saveframename   The name of the new save frame.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_force_new_datablock(self, arg)

    def force_new_saveframe(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_force_new_saveframe (cbf_handle handle,
                         const char    *saveframename);

        CBFLib documentation:
        DESCRIPTION
        cbf_force_new_datablock creates a new data block with name
        datablockname and makes it the current data block. Duplicate data
        block names are allowed. cbf_force_new_saveframe creates a new savew
        frame with name saveframename and makes it the current save frame.
        Duplicate save frame names are allowed.
        Even if a save frame with this name already exists, a new save frame
        is created and becomes the current save frame.
        ARGUMENTS
        handle          CBF handle. datablockname   The name of the new data
        block. saveframename   The name of the new save frame.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_force_new_saveframe(self, arg)

    def get_3d_image_as_string(self, element_number, elsize, elsign, ndimfast, ndimmid, ndimslow):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int elsign,int ndimslow,int ndimmid,
                  int ndimfast

        C prototype: int cbf_get_3d_image (cbf_handle handle, unsigned int reserved,
                         unsigned      int element_number, void *array, size_t elsize,
                         int elsign, size_t      ndimslow, size_t ndimmid,
                         size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_3d_image_as_string(self, element_number, elsize, elsign, ndimfast, ndimmid, ndimslow)

    def get_3d_image_fs_as_string(self, element_number, elsize, elsign, ndimfast, ndimmid, ndimslow):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int elsign,int ndimfast,int ndimmid,
                  int ndimslow

        C prototype: int cbf_get_3d_image_fs (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         void *array, size_t elsize, int elsign,      size_t ndimfast,
                         size_t ndimmid, size_t ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_3d_image_fs_as_string(self, element_number, elsize, elsign, ndimfast, ndimmid, ndimslow)

    def get_3d_image_sf_as_string(self, element_number, elsize, elsign, ndimfast, ndimmid, ndimslow):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int elsign,int ndimslow,int ndimmid,
                  int ndimfast

        C prototype: int cbf_get_3d_image_sf (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         void *array, size_t elsize, int elsign,      size_t ndimslow,
                         size_t ndimmid, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_3d_image_sf_as_string(self, element_number, elsize, elsign, ndimfast, ndimmid, ndimslow)

    def get_3d_image_size(self, element_number):
        r"""

        Returns : size_t ndimslow,size_t ndimmid,size_t ndimfast
        *args   : Integer element_number

        C prototype: int cbf_get_3d_image_size (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         size_t *ndimslow, size_t *ndimmid, size_t      *ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image_size, cbf_get_image_size_fs and cbf_get_image_size_sf
        set *ndimslow and *ndimfast to the slow and fast dimensions of the
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimfast
        will be set to 1. If the array is 3-dimensional an error code will be
        returned. cbf_get_3d_image_size, cbf_get_3d_image_size_fs and
        cbf_get_3d_image_size_sf set *ndimslow, *ndimmid and *ndimfast to the
        slowest, next fastest and fastest dimensions, respectively, of the 3D
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimmid
        and

        """
        return _pycbf.cbf_handle_struct_get_3d_image_size(self, element_number)

    def get_3d_image_size_fs(self, element_number):
        r"""get_3d_image_size_fs(cbf_handle_struct self, unsigned int element_number)"""
        return _pycbf.cbf_handle_struct_get_3d_image_size_fs(self, element_number)

    def get_3d_image_size_sf(self, element_number):
        r"""

        Returns : size_t ndimslow,size_t ndimmid,size_t ndimfast
        *args   : Integer element_number

        C prototype: int cbf_get_3d_image_size_sf (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         size_t *ndimslow, size_t *ndimmid, size_t      *ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image_size, cbf_get_image_size_fs and cbf_get_image_size_sf
        set *ndimslow and *ndimfast to the slow and fast dimensions of the
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimfast
        will be set to 1. If the array is 3-dimensional an error code will be
        returned. cbf_get_3d_image_size, cbf_get_3d_image_size_fs and
        cbf_get_3d_image_size_sf set *ndimslow, *ndimmid and *ndimfast to the
        slowest, next fastest and fastest dimensions, respectively, of the 3D
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimmid
        and

        """
        return _pycbf.cbf_handle_struct_get_3d_image_size_sf(self, element_number)

    def get_axis_ancestor(self, axis_id, ancestor_index):
        r"""

        Returns : String
        *args   : String axis_id,Integer ancestor_index

        C prototype: int cbf_get_axis_ancestor (cbf_handle handle,
                         const char *axis_id, const      unsigned int ancestor_index,
                         const char * *ancestor);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_ancestor(self, axis_id, ancestor_index)

    def get_axis_depends_on(self, axis_id):
        r"""

        Returns : String
        *args   : String axis_id

        C prototype: int cbf_get_axis_depends_on (cbf_handle handle,
                         const char *axis_id,      const char * *depends_on);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_depends_on(self, axis_id)

    def get_axis_equipment(self, axis_id):
        r"""

        Returns : String
        *args   : String axis_id

        C prototype: int cbf_get_axis_equipment (cbf_handle handle,
                         const char *axis_id,      const char * *equipment);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_equipment(self, axis_id)

    def get_axis_equipment_component(self, axis_id):
        r"""

        Returns : String
        *args   : String axis_id

        C prototype: int cbf_get_axis_equipment_component (cbf_handle handle,
                         const char      *axis_id, const char * *equipment_component);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_equipment_component(self, axis_id)

    def get_axis_offset(self, axis_id):
        r"""

        Returns : Float offset1,Float offset2,Float offset3
        *args   : String axis_id

        C prototype: int cbf_get_axis_offset (cbf_handle handle, const char *axis_id,
                         double      *offset1, double *offset2, double *offset3);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_offset(self, axis_id)

    def get_axis_poise(self, ratio, axis_id, frame_id):
        r"""

        Returns : Float vector1,Float vector2,Float vector3,Float offset1,Float offset2,
                  Float offset3,Float angle
        *args   : Float ratio,String axis_id,String frame_id

        C prototype: int cbf_get_axis_poise(cbf_handle handle, double ratio,
                         double *      vector1, double * vector2, double * vector3,
                         double * offset1, double *      offset2, double * offset3,
                         double * angle, const char * axis_id,
                         const      char * frame_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_axis_poise sets vector1, vector2, vector3 to point to the
        components of the axis vector for axis axis_id, offset1, offset2,
        offset3 to point to the components of the axis base offset vector for
        axis axis_id, and angle to point to the angle of rotation of axis
        axis_id after application of the axis settings for frame frame_id,
        using ratio, a value between 0 and 1, indicating how far into the
        internal motion in the frame to go. If frame_id is the string  ".
        ", the first frame found is used. If there is more than one frame,
        which frame will be found is indeterminate. If frame_id is NULL, the
        overall setting for the scan are used, rather than those for any
        particular frame. The vector and offset reported are the reference
        vector and offset of the axis axis_id transformed by application of
        all motions of the axes on which axis_id depends.
        cbf_get_goniometer_poise vector1, vector2, vector3 to point to the
        components of the axis vector for the goniometer axis, offset1,
        offset2, offset3 to point to the components of the axis base offset
        vector for the goniometer axis, and angle to point to the angle of
        rotation of the goniometer axis after application of all axis
        settings in the goniometer deriving the vector, offset and angle from
        the resulting matrix. Calculation of the vector is indeterminate if
        the angle is zero.
        cbf_get_axis_reference_poise sets vector1, vector2, vector3 to point
        to the components of the axis vector for axis axis_id, offset1,
        offset2, offset3 to point to the components of the axis base offset
        vector for axis axis_id unmodified by axis rotations. Any of the
        pointers may be specified as NULL.
        ARGUMENTS
        handle       CBF handle. ratio        A number between 0 and 1
        indication how far into the frame to go vector1      Pointer to the
        first component of the axis vector vector2      Pointer to the second
        component of the axis vector vector3      Pointer to the third
        component of the axis vector offset1      Pointer to the first
        component of the axis offset offset2      Pointer to the second
        component of the axis offset offset3      Pointer to the third
        component of the axis offset angle        Pointer to the rotation
        angle axis_id      The specified axis frame_id     The specified
        frame positioner   CBF goniometer
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_poise(self, ratio, axis_id, frame_id)

    def get_axis_reference_poise(self, axis_id):
        r"""

        Returns : Float vector1,Float vector2,Float vector3,Float offset1,Float offset2,
                  Float offset3
        *args   : String axis_id

        C prototype: int cbf_get_axis_reference_poise(cbf_handle handle,
                         double * vector1,      double * vector2, double * vector3,
                         double * offset1, double * offset2,      double * offset3,
                         const char * axis_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_axis_poise sets vector1, vector2, vector3 to point to the
        components of the axis vector for axis axis_id, offset1, offset2,
        offset3 to point to the components of the axis base offset vector for
        axis axis_id, and angle to point to the angle of rotation of axis
        axis_id after application of the axis settings for frame frame_id,
        using ratio, a value between 0 and 1, indicating how far into the
        internal motion in the frame to go. If frame_id is the string  ".
        ", the first frame found is used. If there is more than one frame,
        which frame will be found is indeterminate. If frame_id is NULL, the
        overall setting for the scan are used, rather than those for any
        particular frame. The vector and offset reported are the reference
        vector and offset of the axis axis_id transformed by application of
        all motions of the axes on which axis_id depends.
        cbf_get_goniometer_poise vector1, vector2, vector3 to point to the
        components of the axis vector for the goniometer axis, offset1,
        offset2, offset3 to point to the components of the axis base offset
        vector for the goniometer axis, and angle to point to the angle of
        rotation of the goniometer axis after application of all axis
        settings in the goniometer deriving the vector, offset and angle from
        the resulting matrix. Calculation of the vector is indeterminate if
        the angle is zero.
        cbf_get_axis_reference_poise sets vector1, vector2, vector3 to point
        to the components of the axis vector for axis axis_id, offset1,
        offset2, offset3 to point to the components of the axis base offset
        vector for axis axis_id unmodified by axis rotations. Any of the
        pointers may be specified as NULL.
        ARGUMENTS
        handle       CBF handle. ratio        A number between 0 and 1
        indication how far into the frame to go vector1      Pointer to the
        first component of the axis vector vector2      Pointer to the second
        component of the axis vector vector3      Pointer to the third
        component of the axis vector offset1      Pointer to the first
        component of the axis offset offset2      Pointer to the second
        component of the axis offset offset3      Pointer to the third
        component of the axis offset angle        Pointer to the rotation
        angle axis_id      The specified axis frame_id     The specified
        frame positioner   CBF goniometer
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_reference_poise(self, axis_id)

    def get_axis_rotation(self, axis_id):
        r"""

        Returns : Float
        *args   : String axis_id

        C prototype: int cbf_get_axis_rotation (cbf_handle handle,
                         const char *axis_id,      double *rotation);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_rotation(self, axis_id)

    def get_axis_rotation_axis(self, axis_id):
        r"""

        Returns : String
        *args   : String axis_id

        C prototype: int cbf_get_axis_rotation_axis (cbf_handle handle,
                         const char *axis_id,      const char * *rotation_axis);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_rotation_axis(self, axis_id)

    def get_axis_setting(self, axis_id):
        r"""

        Returns : Float start,Float increment
        *args   : String axis_id

        C prototype: int cbf_get_axis_setting (cbf_handle handle,
                         unsigned int reserved,      const char *axis_id, double *start,
                         double *increment);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_setting(self, axis_id)

    def get_axis_type(self, axis_id):
        r"""

        Returns : String
        *args   : String axis_id

        C prototype: int cbf_get_axis_type (cbf_handle handle, const char *axis_id,
                              cbf_axis_type *axis_type);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_type(self, axis_id)

    def get_axis_vector(self, axis_id):
        r"""

        Returns : Float vector1,Float vector2,Float vector3
        *args   : String axis_id

        C prototype: int cbf_get_axis_vector (cbf_handle handle, const char *axis_id,
                         double      *vector1, double *vector2, double *vector3);

        CBFLib documentation:
        DESCRIPTION
        cbf_count_axis_ancestors sets ancestors to the number of ancestors of
        axis axis_id. cbf_get_axis_ancestor sets *ancestor to the ancestor
        axis of index ancestor_index of axis axis_id, starting with axis_id
        for ancestor_index 0.
        cbf_get_axis_depends_on sets *depends_on to the immediate ancestor of
        axis_id or to  ". " if there is no such ancestor.
        cbf_get_axis_equipment sets *equipment to the equipment of axis_id or
        to  ". " if there is no such equipment.
        cbf_get_axis_equipment_component sets *equipment_component to the
        equipment_component of axis_id or to  ". " if there is no such
        equipment_component.
        cbf_get_axis_offset sets *offset1, *offset2 and *offset3 to the
        components of the ofset of axis_id.
        cbf_get_axis_rotation sets rotation to the rotation of axis_id or to
        0 if there is no such rotation. cbf_get_axis_rotation_axis sets
        *rotation_axis to the rotation_axis of axis_id or to  ". " if there
        is no such rotation_axis.
        cbf_get_axis_setting sets *start and *increment to the corresponding
        values of the axis axis_id. Any of the destination pointers may be
        NULL.
        cbf_get_axis_type sets axis_type to the type of axis_id.
        cbf_get_axis_vector sets *vector1, *vector2 and *vector3 to the
        components of the vector of axis_id.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle                CBF handle. reserved              Unused. Any
        value other than 0 is invalid. axis_id               Axis id.
        ancestor_index        Integer index of the desired ancestor, starting
        with 0 for the current axis_id. ancestor              Pointer to
        destination ancestor name pointer. depends_on            Pointer to
        destination depends_on name pointer. equipment             Pointer to
        destination equipment name pointer. equipment_component   Pointer to
        destination equipment_component name pointer. offset1
        Pointer to destination first offset component value. offset2
             Pointer to destination second offset component value. offset3
                   Pointer to destination third offset component value.
        rotation              Pointer to destination rotation value.
        rotation_axis         Pointer to destination rotation_axisn name
        pointer. start                 Pointer to the destination start
        value. increment             Pointer to the destination increment
        value. type                  Pointer to destination axis type of type
        . vector1               Pointer to destination first vector component
        value. vector2               Pointer to destination second vector
        component value. vector3               Pointer to destination third
        vector component value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_axis_vector(self, axis_id)

    def get_bin_sizes(self, element_number):
        r"""

        Returns : Float slowbinsize,Float fastbinsize
        *args   : Integer element_number

        C prototype: int cbf_get_bin_sizes(cbf_handle handle,
                         unsigned int element_number,      double * slowbinsize,
                         double * fastbinsize);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_bin_sizes sets slowbinsize to point to the value of the
        number of pixels composing one array element in the dimension that
        changes at the second-fastest rate and fastbinsize to point to the
        value of the number of pixels composing one array element in the
        dimension that changes at the fastest rate for the dectector element
        with the ordinal element_number. cbf_set_bin_sizes sets the the pixel
        bin sizes in the  "array_intensities " category to the values of
        slowbinsize_in for the number of pixels composing one array element
        in the dimension that changes at the second-fastest rate and
        fastbinsize_in for the number of pixels composing one array element
        in the dimension that changes at the fastest rate for the dectector
        element with the ordinal element_number.
        In order to allow for software binning involving fractions of pixels,
        the bin sizes are doubles rather than ints.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. slowbinsize      Pointer to the
        returned number of pixels composing one array element in the
        dimension that changes at the second-fastest rate. fastbinsize
        Pointer to the returned number of pixels composing one array element
        in the dimension that changes at the fastest rate. slowbinsize_in
        The number of pixels composing one array element in the dimension
        that changes at the second-fastest rate. fastbinsize_in   The number
        of pixels composing one array element in the dimension that changes
        at the fastest rate.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_bin_sizes(self, element_number)

    def get_crystal_id(self):
        r"""

        Returns :
        *args   : string

        C prototype: int cbf_get_crystal_id (cbf_handle handle,
                         const char **crystal_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_crystal_id sets *crystal_id to point to the ASCII value of
        the  "diffrn.crystal_id " entry.
        If the value is not ASCII, the function returns CBF_BINARY.
        The value will be valid as long as the item exists and has not been
        set to a new value.
        The value must not be modified by the program in any way.
        ARGUMENTS
        handle       CBF handle. crystal_id   Pointer to the destination
        value pointer.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_crystal_id(self)

    def get_datestamp(self):
        r"""

        Returns : int year,int month,int day,int hour,int minute,double second,
                  int timezone
        *args   :

        C prototype: int cbf_get_datestamp (cbf_handle handle, unsigned int reserved,
                         int      *year, int *month, int *day, int *hour, int *minute,
                         double *second, int      *timezone);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_datestamp sets *year, *month, *day, *hour, *minute and
        *second to the corresponding values of the collection timestamp.
        *timezone is set to timezone difference from UTC in minutes. The
        parameter < i>reserved is presently unused and should be set to 0.
        Any of the destination pointers may be NULL.
        ARGUMENTS
        handle     CBF handle. reserved   Unused. Any value other than 0 is
        invalid. year       Pointer to the destination timestamp year. month
            Pointer to the destination timestamp month (1-12). day
        Pointer to the destination timestamp day (1-31). hour       Pointer
        to the destination timestamp hour (0-23). minute     Pointer to the
        destination timestamp minute (0-59). second     Pointer to the
        destination timestamp second (0-60.0). timezone   Pointer to the
        destination timezone difference from UTC in minutes.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_datestamp(self)

    def get_dictionary(self):
        r"""

        Returns : CBFHandle dictionary
        *args   :

        C prototype: int cbf_get_dictionary (cbf_handle handle,
                         cbf_handle * dictionary);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_dictionary sets *dictionary to the handle of a CBF which has
        been associated with the CBF handle by cbf_set_dictionary.
        cbf_set_dictionary associates the CBF handle dictionary_in with
        handle as its dictionary. cbf_require_dictionary sets *dictionary to
        the handle of a CBF which has been associated with the CBF handle by
        cbf_set_dictionary or creates a new empty CBF and associates it with
        handle, returning the new handle in *dictionary.
        ARGUMENTS
        handle          CBF handle. dictionary      Pointer to CBF handle of
        dictionary. dictionary_in   CBF handle of dcitionary.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_dictionary(self)

    def get_diffrn_id(self):
        r"""

        Returns :
        *args   : string

        C prototype: int cbf_get_diffrn_id (cbf_handle handle,
                         const char **diffrn_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_diffrn_id sets *diffrn_id to point to the ASCII value of the
        "diffrn.id " entry. cbf_require_diffrn_id also sets *diffrn_id to
        point to the ASCII value of the  "diffrn.id " entry, but, if the
        "diffrn.id " entry does not exist, it sets the value in the CBF and
        in*diffrn_id to the character string given by default_id, creating
        the category and column is necessary.
        The diffrn_id will be valid as long as the item exists and has not
        been set to a new value.
        The diffrn_id must not be modified by the program in any way.
        ARGUMENTS
        handle       CBF handle. diffrn_id    Pointer to the destination
        value pointer. default_id   Character string default value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_diffrn_id(self)

    def get_divergence(self):
        r"""

        Returns : Float div_x_source,Float div_y_source,Float div_x_y_source
        *args   :

        C prototype: int cbf_get_divergence (cbf_handle handle, double *div_x_source,
                         double      *div_y_source, double *div_x_y_source);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_divergence sets *div_x_source, *div_y_source and
        *div_x_y_source to the corresponding source divergence parameters.
        Any of the destination pointers may be NULL.
        ARGUMENTS
        handle           CBF handle. div_x_source     Pointer to the
        destination div_x_source. div_y_source     Pointer to the destination
        div_y_source. div_x_y_source   Pointer to the destination
        div_x_y_source.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_divergence(self)

    def get_doublevalue(self):
        r"""

        Returns : double
        *args   :

        C prototype: int cbf_get_doublevalue (cbf_handle handle, double *number);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_doublevalue sets *number to the value of the ASCII item at
        the current column and row interpreted as a decimal floating-point
        number. cbf_require_doublevalue sets *number to the value of the
        ASCII item at the current column and row interpreted as a decimal
        floating-point number, setting it to defaultvalue if necessary.
        If the value is not ASCII, the function returns CBF_BINARY.
        ARGUMENTS
        handle         CBF handle. number         Pointer to the destination
        number. defaultvalue   default number value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_doublevalue(self)

    def get_element_id(self, element_number):
        r"""

        Returns : String
        *args   : Integer element_number

        C prototype: int cbf_get_element_id (cbf_handle handle,
                         unsigned int element_number,      const char **element_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_element_number sets element_number to a number that can be
        used in other cbf_simple calls to identify the detector element
        element_id and optionally the specific array_id> and
        array_section_id. cbf_get_element_id sets *element_id to point to the
        ASCII value of the element_number'th
        "diffrn_data_frame.detector_element_id " entry, counting from 0.
        The element_number is the ordinal of the detector element in the
        DIFFRN_DETECTOR_ELEMENT category. If an array_section_id is specified
        (i.e. is not NULL), the element_number is the sum of the ordinal of
        the detector element plus the number of detector elements multiplied
        by the ordinal of array_section_id for the specified array_id> in the
        ARRAY_STRUCTURE_LIST_SECTION category.
        If the detector element does not exist, the function returns
        CBF_NOTFOUND.
        The element_id will be valid as long as the item exists and has not
        been set to a new value.
        The element_id must not be modified by the program in any way.
        ARGUMENTS
        handle             CBF handle. element_number     The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. element_id         Pointer to the
        destination string for cbf_get_element_id, but the string itself for
        cbf_get_element_number. array_id           The optional array id or
        NULL. array_section_id   The optional array_section_id or NULL.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_element_id(self, element_number)

    def get_element_number(self):
        r"""get_element_number(cbf_handle_struct self)"""
        return _pycbf.cbf_handle_struct_get_element_number(self)

    def get_gain(self, element_number):
        r"""

        Returns : Float gain,Float gain_esd
        *args   :

        C prototype: int cbf_get_gain (cbf_handle handle, unsigned int element_number,
                         double      *gain, double *gain_esd);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_gain sets *gain and *gain_esd to the corresponding gain
        parameters for element number element_number.
        Either of the destination pointers may be NULL.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. gain             Pointer to the
        destination gain. gain_esd         Pointer to the destination
        gain_esd.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_gain(self, element_number)

    def get_image_as_string(self, element_number, elsize, elsign, ndimslow, ndimfast):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int elsign,int ndimslow,int ndimfast

        C prototype: int cbf_get_image (cbf_handle handle, unsigned int reserved,
                         unsigned      int element_number, void *array, size_t elsize,
                         int elsign, size_t      ndimslow, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_image_as_string(self, element_number, elsize, elsign, ndimslow, ndimfast)

    def get_image_fs_as_string(self, element_number, elsize, elsign, ndimfast, ndimslow):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int elsign,int ndimfast,int ndimslow

        C prototype: int cbf_get_image_fs (cbf_handle handle, unsigned int reserved,
                         unsigned      int element_number, void *array, size_t elsize,
                         int elsign, size_t      ndimfast, size_t ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_image_fs_as_string(self, element_number, elsize, elsign, ndimfast, ndimslow)

    def get_image_sf_as_string(self, element_number, elsize, elsign, ndimslow, ndimfast):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int elsign,int ndimslow,int ndimfast

        C prototype: int cbf_get_image_sf (cbf_handle handle, unsigned int reserved,
                         unsigned      int element_number, void *array, size_t elsize,
                         int elsign, size_t      ndimslow, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_image_sf_as_string(self, element_number, elsize, elsign, ndimslow, ndimfast)

    def get_image_size(self, element_number):
        r"""

        Returns : size_t ndim1,size_t ndim2
        *args   : Integer element_number

        C prototype: int cbf_get_image_size (cbf_handle handle, unsigned int reserved,
                              unsigned int element_number, size_t *ndimslow,
                         size_t *ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image_size, cbf_get_image_size_fs and cbf_get_image_size_sf
        set *ndimslow and *ndimfast to the slow and fast dimensions of the
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimfast
        will be set to 1. If the array is 3-dimensional an error code will be
        returned. cbf_get_3d_image_size, cbf_get_3d_image_size_fs and
        cbf_get_3d_image_size_sf set *ndimslow, *ndimmid and *ndimfast to the
        slowest, next fastest and fastest dimensions, respectively, of the 3D
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimmid
        and

        """
        return _pycbf.cbf_handle_struct_get_image_size(self, element_number)

    def get_image_size_fs(self, element_number):
        r"""

        Returns : size_t ndimfast,size_t ndimslow
        *args   : Integer element_number

        C prototype: int cbf_get_image_size_fs (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         size_t *ndimfast, size_t *ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image_size, cbf_get_image_size_fs and cbf_get_image_size_sf
        set *ndimslow and *ndimfast to the slow and fast dimensions of the
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimfast
        will be set to 1. If the array is 3-dimensional an error code will be
        returned. cbf_get_3d_image_size, cbf_get_3d_image_size_fs and
        cbf_get_3d_image_size_sf set *ndimslow, *ndimmid and *ndimfast to the
        slowest, next fastest and fastest dimensions, respectively, of the 3D
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimmid
        and

        """
        return _pycbf.cbf_handle_struct_get_image_size_fs(self, element_number)

    def get_image_size_sf(self, element_number):
        r"""

        Returns : size_t ndimslow,size_t ndimfast
        *args   : Integer element_number

        C prototype: int cbf_get_image_size_sf (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         size_t *ndimslow, size_t *ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image_size, cbf_get_image_size_fs and cbf_get_image_size_sf
        set *ndimslow and *ndimfast to the slow and fast dimensions of the
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimfast
        will be set to 1. If the array is 3-dimensional an error code will be
        returned. cbf_get_3d_image_size, cbf_get_3d_image_size_fs and
        cbf_get_3d_image_size_sf set *ndimslow, *ndimmid and *ndimfast to the
        slowest, next fastest and fastest dimensions, respectively, of the 3D
        image array for element number element_number. If the array is
        1-dimensional, *ndimslow will be set to the array size and *ndimmid
        and

        """
        return _pycbf.cbf_handle_struct_get_image_size_sf(self, element_number)

    def get_integerarray_as_string(self):
        r"""

        Returns : (Binary)String
        *args   :

        C prototype: int cbf_get_integerarray (cbf_handle handle, int *binary_id,
                         void *array,    size_t elsize, int elsigned, size_t elements,
                         size_t *elements_read);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarray reads the binary value of the item at the
        current column and row into an integer array. The array consists of
        elements elements of elsize bytes each, starting at array. The
        elements are signed if elsigned is non-0 and unsigned otherwise.
        *binary_id is set to the binary section identifier and *elements_read
        to the number of elements actually read. cbf_get_realarray reads the
        binary value of the item at the current column and row into a real
        array. The array consists of elements elements of elsize bytes each,
        starting at array. *binary_id is set to the binary section identifier
        and *elements_read to the number of elements actually read.
        If any element in the integer binary data cant fit into the
        destination element, the destination is set the nearest possible
        value.
        If the value is not binary, the function returns CBF_ASCII.
        If the requested number of elements cant be read, the function will
        read as many as it can and then return CBF_ENDOFDATA.
        Currently, the destination array must consist of chars, shorts or
        ints (signed or unsigned). If elsize is not equal to sizeof (char),
        sizeof (short) or sizeof (int), for cbf_get_integerarray, or
        sizeof(double) or sizeof(float), for cbf_get_realarray the function
        returns CBF_ARGUMENT.
        An additional restriction in the current version of CBFlib is that
        values too large to fit in an int are not correctly decompressed. As
        an example, if the machine with 32-bit ints is reading an array
        containing a value outside the range 0 .. 2^^32-1 (unsigned) or
        -2^^31 .. 2^^31-1 (signed), the array will not be correctly
        decompressed. This restriction will be removed in a future release.
        For cbf_get_realarray, only IEEE format is supported. No conversion
        to other floating point formats is done at this time.
        ARGUMENTS
        handle          CBF handle. binary_id       Pointer to the
        destination integer binary identifier. array           Pointer to the
        destination array. elsize          Size in bytes of each destination
        array element. elsigned        Set to non-0 if the destination array
        elements are signed. elements        The number of elements to read.
        elements_read   Pointer to the destination number of elements
        actually read.
        RETURN VALUE
        Returns an error code on failure or 0 for success. SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_integerarray_as_string(self)

    def get_integerarrayparameters(self):
        r"""

        Returns : int compression,int binary_id,int elsize,int elsigned,int elunsigned,
                  int elements,int minelement,int maxelement
        *args   :

        C prototype: int cbf_get_integerarrayparameters (cbf_handle handle,
                         unsigned int    *compression, int *binary_id, size_t *elsize,
                         int *elsigned, int    *elunsigned, size_t *elements,
                         int *minelement, int *maxelement);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarrayparameters sets *compression, *binary_id,
        *elsize, *elsigned, *elunsigned, *elements, *minelement and
        *maxelement to values read from the binary value of the item at the
        current column and row. This provides all the arguments needed for a
        subsequent call to cbf_set_integerarray, if a copy of the array is to
        be made into another CIF or CBF. cbf_get_realarrayparameters sets
        *compression, *binary_id, *elsize, *elements to values read from the
        binary value of the item at the current column and row. This provides
        all the arguments needed for a subsequent call to cbf_set_realarray,
        if a copy of the arry is to be made into another CIF or CBF.
        The variants cbf_get_integerarrayparameters_wdims,
        cbf_get_integerarrayparameters_wdims_fs,
        cbf_get_integerarrayparameters_wdims_sf,
        cbf_get_realarrayparameters_wdims,
        cbf_get_realarrayparameters_wdims_fs,
        cbf_get_realarrayparameters_wdims_sf set **byteorder, *dimfast,
        *dimmid, *dimslow, and *padding as well, providing the additional
        parameters needed for a subsequent call to cbf_set_integerarray_wdims
        or cbf_set_realarray_wdims.
        The value returned in *byteorder is a pointer either to the string
        "little_endian " or to the string  "big_endian ". This should be
        the byte order of the data, not necessarily of the host machine. No
        attempt should be made to modify this string. At this time only
        "little_endian " will be returned.
        The values returned in *dimfast, *dimmid and *dimslow are the sizes
        of the fastest changing, second fastest changing and third fastest
        changing dimensions of the array, if specified, or zero, if not
        specified.
        The value returned in *padding is the size of the post-data padding,
        if any and if specified in the data header. The value is given as a
        count of octets.
        If the value is not binary, the function returns CBF_ASCII.
        ARGUMENTS
        handle        CBF handle. compression   Compression method used.
        elsize        Size in bytes of each array element. binary_id
        Pointer to the destination integer binary identifier. elsigned
        Pointer to an integer. Set to 1 if the elements can be read as signed
        integers. elunsigned    Pointer to an integer. Set to 1 if the
        elements can be read as unsigned integers. elements      Pointer to
        the destination number of elements. minelement    Pointer to the
        destination smallest element. maxelement    Pointer to the
        destination largest element. byteorder     Pointer to the destination
        byte order. dimfast       Pointer to the destination fastest
        dimension. dimmid        Pointer to the destination second fastest
        dimension. dimslow       Pointer to the destination third fastest
        dimension. padding       Pointer to the destination padding size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_integerarrayparameters(self)

    def get_integerarrayparameters_wdims(self):
        r"""

        Returns : int compression,int binary_id,int elsize,int elsigned,int elunsigned,
                  int elements,int minelement,int maxelement,char **bo,int *bolen,
                  int dimfast,int dimmid,int dimslow,int padding
        *args   :

        C prototype: int cbf_get_integerarrayparameters_wdims (cbf_handle handle,
                         unsigned int    *compression, int *binary_id, size_t *elsize,
                         int *elsigned, int    *elunsigned, size_t *elements,
                         int *minelement, int *maxelement, const    char **byteorder,
                         size_t *dimfast, size_t *dimmid, size_t *dimslow,
                         size_t    *padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarrayparameters sets *compression, *binary_id,
        *elsize, *elsigned, *elunsigned, *elements, *minelement and
        *maxelement to values read from the binary value of the item at the
        current column and row. This provides all the arguments needed for a
        subsequent call to cbf_set_integerarray, if a copy of the array is to
        be made into another CIF or CBF. cbf_get_realarrayparameters sets
        *compression, *binary_id, *elsize, *elements to values read from the
        binary value of the item at the current column and row. This provides
        all the arguments needed for a subsequent call to cbf_set_realarray,
        if a copy of the arry is to be made into another CIF or CBF.
        The variants cbf_get_integerarrayparameters_wdims,
        cbf_get_integerarrayparameters_wdims_fs,
        cbf_get_integerarrayparameters_wdims_sf,
        cbf_get_realarrayparameters_wdims,
        cbf_get_realarrayparameters_wdims_fs,
        cbf_get_realarrayparameters_wdims_sf set **byteorder, *dimfast,
        *dimmid, *dimslow, and *padding as well, providing the additional
        parameters needed for a subsequent call to cbf_set_integerarray_wdims
        or cbf_set_realarray_wdims.
        The value returned in *byteorder is a pointer either to the string
        "little_endian " or to the string  "big_endian ". This should be
        the byte order of the data, not necessarily of the host machine. No
        attempt should be made to modify this string. At this time only
        "little_endian " will be returned.
        The values returned in *dimfast, *dimmid and *dimslow are the sizes
        of the fastest changing, second fastest changing and third fastest
        changing dimensions of the array, if specified, or zero, if not
        specified.
        The value returned in *padding is the size of the post-data padding,
        if any and if specified in the data header. The value is given as a
        count of octets.
        If the value is not binary, the function returns CBF_ASCII.
        ARGUMENTS
        handle        CBF handle. compression   Compression method used.
        elsize        Size in bytes of each array element. binary_id
        Pointer to the destination integer binary identifier. elsigned
        Pointer to an integer. Set to 1 if the elements can be read as signed
        integers. elunsigned    Pointer to an integer. Set to 1 if the
        elements can be read as unsigned integers. elements      Pointer to
        the destination number of elements. minelement    Pointer to the
        destination smallest element. maxelement    Pointer to the
        destination largest element. byteorder     Pointer to the destination
        byte order. dimfast       Pointer to the destination fastest
        dimension. dimmid        Pointer to the destination second fastest
        dimension. dimslow       Pointer to the destination third fastest
        dimension. padding       Pointer to the destination padding size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_integerarrayparameters_wdims(self)

    def get_integerarrayparameters_wdims_fs(self):
        r"""

        Returns : int compression,int binary_id,int elsize,int elsigned,int elunsigned,
                  int elements,int minelement,int maxelement,char **bo,int *bolen,
                  int dimfast,int dimmid,int dimslow,int padding
        *args   :

        C prototype: int cbf_get_integerarrayparameters_wdims_fs (cbf_handle handle,
                         unsigned    int *compression, int *binary_id, size_t *elsize,
                         int *elsigned, int    *elunsigned, size_t *elements,
                         int *minelement, int *maxelement, const    char **byteorder,
                         size_t *dimfast, size_t *dimmid, size_t *dimslow,
                         size_t    *padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarrayparameters sets *compression, *binary_id,
        *elsize, *elsigned, *elunsigned, *elements, *minelement and
        *maxelement to values read from the binary value of the item at the
        current column and row. This provides all the arguments needed for a
        subsequent call to cbf_set_integerarray, if a copy of the array is to
        be made into another CIF or CBF. cbf_get_realarrayparameters sets
        *compression, *binary_id, *elsize, *elements to values read from the
        binary value of the item at the current column and row. This provides
        all the arguments needed for a subsequent call to cbf_set_realarray,
        if a copy of the arry is to be made into another CIF or CBF.
        The variants cbf_get_integerarrayparameters_wdims,
        cbf_get_integerarrayparameters_wdims_fs,
        cbf_get_integerarrayparameters_wdims_sf,
        cbf_get_realarrayparameters_wdims,
        cbf_get_realarrayparameters_wdims_fs,
        cbf_get_realarrayparameters_wdims_sf set **byteorder, *dimfast,
        *dimmid, *dimslow, and *padding as well, providing the additional
        parameters needed for a subsequent call to cbf_set_integerarray_wdims
        or cbf_set_realarray_wdims.
        The value returned in *byteorder is a pointer either to the string
        "little_endian " or to the string  "big_endian ". This should be
        the byte order of the data, not necessarily of the host machine. No
        attempt should be made to modify this string. At this time only
        "little_endian " will be returned.
        The values returned in *dimfast, *dimmid and *dimslow are the sizes
        of the fastest changing, second fastest changing and third fastest
        changing dimensions of the array, if specified, or zero, if not
        specified.
        The value returned in *padding is the size of the post-data padding,
        if any and if specified in the data header. The value is given as a
        count of octets.
        If the value is not binary, the function returns CBF_ASCII.
        ARGUMENTS
        handle        CBF handle. compression   Compression method used.
        elsize        Size in bytes of each array element. binary_id
        Pointer to the destination integer binary identifier. elsigned
        Pointer to an integer. Set to 1 if the elements can be read as signed
        integers. elunsigned    Pointer to an integer. Set to 1 if the
        elements can be read as unsigned integers. elements      Pointer to
        the destination number of elements. minelement    Pointer to the
        destination smallest element. maxelement    Pointer to the
        destination largest element. byteorder     Pointer to the destination
        byte order. dimfast       Pointer to the destination fastest
        dimension. dimmid        Pointer to the destination second fastest
        dimension. dimslow       Pointer to the destination third fastest
        dimension. padding       Pointer to the destination padding size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_integerarrayparameters_wdims_fs(self)

    def get_integerarrayparameters_wdims_sf(self):
        r"""

        Returns : int compression,int binary_id,int elsize,int elsigned,int elunsigned,
                  int elements,int minelement,int maxelement,char **bo,int *bolen,
                  int dimslow,int dimmid,int dimfast,int padding
        *args   :

        C prototype: int cbf_get_integerarrayparameters_wdims_sf (cbf_handle handle,
                         unsigned    int *compression, int *binary_id, size_t *elsize,
                         int *elsigned, int    *elunsigned, size_t *elements,
                         int *minelement, int *maxelement, const    char **byteorder,
                         size_t *dimslow, size_t *dimmid, size_t *dimfast,
                         size_t    *padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarrayparameters sets *compression, *binary_id,
        *elsize, *elsigned, *elunsigned, *elements, *minelement and
        *maxelement to values read from the binary value of the item at the
        current column and row. This provides all the arguments needed for a
        subsequent call to cbf_set_integerarray, if a copy of the array is to
        be made into another CIF or CBF. cbf_get_realarrayparameters sets
        *compression, *binary_id, *elsize, *elements to values read from the
        binary value of the item at the current column and row. This provides
        all the arguments needed for a subsequent call to cbf_set_realarray,
        if a copy of the arry is to be made into another CIF or CBF.
        The variants cbf_get_integerarrayparameters_wdims,
        cbf_get_integerarrayparameters_wdims_fs,
        cbf_get_integerarrayparameters_wdims_sf,
        cbf_get_realarrayparameters_wdims,
        cbf_get_realarrayparameters_wdims_fs,
        cbf_get_realarrayparameters_wdims_sf set **byteorder, *dimfast,
        *dimmid, *dimslow, and *padding as well, providing the additional
        parameters needed for a subsequent call to cbf_set_integerarray_wdims
        or cbf_set_realarray_wdims.
        The value returned in *byteorder is a pointer either to the string
        "little_endian " or to the string  "big_endian ". This should be
        the byte order of the data, not necessarily of the host machine. No
        attempt should be made to modify this string. At this time only
        "little_endian " will be returned.
        The values returned in *dimfast, *dimmid and *dimslow are the sizes
        of the fastest changing, second fastest changing and third fastest
        changing dimensions of the array, if specified, or zero, if not
        specified.
        The value returned in *padding is the size of the post-data padding,
        if any and if specified in the data header. The value is given as a
        count of octets.
        If the value is not binary, the function returns CBF_ASCII.
        ARGUMENTS
        handle        CBF handle. compression   Compression method used.
        elsize        Size in bytes of each array element. binary_id
        Pointer to the destination integer binary identifier. elsigned
        Pointer to an integer. Set to 1 if the elements can be read as signed
        integers. elunsigned    Pointer to an integer. Set to 1 if the
        elements can be read as unsigned integers. elements      Pointer to
        the destination number of elements. minelement    Pointer to the
        destination smallest element. maxelement    Pointer to the
        destination largest element. byteorder     Pointer to the destination
        byte order. dimfast       Pointer to the destination fastest
        dimension. dimmid        Pointer to the destination second fastest
        dimension. dimslow       Pointer to the destination third fastest
        dimension. padding       Pointer to the destination padding size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_integerarrayparameters_wdims_sf(self)

    def get_integervalue(self):
        r"""

        Returns : int
        *args   :

        C prototype: int cbf_get_integervalue (cbf_handle handle, int *number);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integervalue sets *number to the value of the ASCII item at
        the current column and row interpreted as a decimal integer.
        cbf_require_integervalue sets *number to the value of the ASCII item
        at the current column and row interpreted as a decimal integer,
        setting it to defaultvalue if necessary.
        If the value is not ASCII, the function returns CBF_BINARY.
        ARGUMENTS
        handle         CBF handle. number         pointer to the number.
        defaultvalue   default number value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_integervalue(self)

    def get_integration_time(self):
        r"""

        Returns : Float time
        *args   :

        C prototype: int cbf_get_integration_time (cbf_handle handle,
                         unsigned int reserved,      double *time);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integration_time sets *time to the integration time in
        seconds. The parameter reserved is presently unused and should be set
        to 0.
        ARGUMENTS
        handle     CBF handle. reserved   Unused. Any value other than 0 is
        invalid. time       Pointer to the destination time.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_integration_time(self)

    def get_orientation_matrix(self):
        r"""

        Returns : Float matrix_0,Float matrix_1,Float matrix_2,Float matrix_3,
                  Float matrix_4,Float matrix_5,Float matrix_6,Float matrix_7,
                  Float matrix_8
        *args   :

        C prototype: int cbf_get_orientation_matrix (cbf_handle handle,
                         double ub_matrix[9]);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_orientation_matrix sets ub_matrix to point to the array of
        orientation matrix entries in the  "diffrn " category in the order
        of columns:
         "UB[1][1] "  "UB[1][2] "  "UB[1][3] "  "UB[2][1] "
        "UB[2][2] "  "UB[2][3] "  "UB[3][1] "  "UB[3][2] "
        "UB[3][3] "
        cbf_set_orientation_matrix sets the values in the  "diffrn "
        category to the values pointed to by ub_matrix.
        ARGUMENTS
        handle     CBF handle. ubmatric   Source or destination array of 9
        doubles giving the orientation matrix parameters.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_orientation_matrix(self)

    def get_overload(self, element_number):
        r"""

        Returns : Float overload
        *args   : Integer element_number

        C prototype: int cbf_get_overload (cbf_handle handle,
                         unsigned int element_number,      double *overload);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_overload sets *overload to the overload value for element
        number element_number.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. overload         Pointer to the
        destination overload.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_overload(self, element_number)

    def get_pixel_size(self, element_number, axis_number):
        r"""

        Returns : Float pixel_size
        *args   : Int element_number,Int axis_number

        C prototype: int cbf_get_pixel_size (cbf_handle handle,
                         unsigned int element_number,      int axis_number,
                         double *psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_size and cbf_get_pixel_size_sf set *psize to point to
        the double value in millimeters of the axis axis_number of the
        detector element element_number. The axis_number is numbered from 1,
        starting with the slowest axis. cbf_get_pixel_size_fs sets *psize to
        point to the double value in millimeters of the axis axis_number of
        the detector element element_number. The axis_number is numbered from
        1, starting with the fastest axis.
        If a negative axis number is given, the order of axes is reversed, so
        that -1 specifies the slowest axis for cbf_get_pixel_size_fs and the
        fastest axis for cbf_get_pixel_size_sf.
        If the pixel size is not given explcitly in the  "array_element_size
        " category, the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. axis_number      The number of the
        axis, starting from 1 for the fastest for cbf_get_pixel_size and
        cbf_get_pixel_size_fs and the slowest for cbf_get_pixel_size_sf.
        psize            Pointer to the destination pixel size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_pixel_size(self, element_number, axis_number)

    def get_pixel_size_fs(self, element_number, axis_number):
        r"""

        Returns : Float pixel_size
        *args   : Int element_number,Int axis_number

        C prototype: int cbf_get_pixel_size_fs(cbf_handle handle,
                         unsigned int      element_number, int axis_number,
                         double *psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_size and cbf_get_pixel_size_sf set *psize to point to
        the double value in millimeters of the axis axis_number of the
        detector element element_number. The axis_number is numbered from 1,
        starting with the slowest axis. cbf_get_pixel_size_fs sets *psize to
        point to the double value in millimeters of the axis axis_number of
        the detector element element_number. The axis_number is numbered from
        1, starting with the fastest axis.
        If a negative axis number is given, the order of axes is reversed, so
        that -1 specifies the slowest axis for cbf_get_pixel_size_fs and the
        fastest axis for cbf_get_pixel_size_sf.
        If the pixel size is not given explcitly in the  "array_element_size
        " category, the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. axis_number      The number of the
        axis, starting from 1 for the fastest for cbf_get_pixel_size and
        cbf_get_pixel_size_fs and the slowest for cbf_get_pixel_size_sf.
        psize            Pointer to the destination pixel size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_pixel_size_fs(self, element_number, axis_number)

    def get_pixel_size_sf(self, element_number, axis_number):
        r"""

        Returns : Float pixel_size
        *args   : Int element_number,Int axis_number

        C prototype: int cbf_get_pixel_size_sf(cbf_handle handle,
                         unsigned int      element_number, int axis_number,
                         double *psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_pixel_size and cbf_get_pixel_size_sf set *psize to point to
        the double value in millimeters of the axis axis_number of the
        detector element element_number. The axis_number is numbered from 1,
        starting with the slowest axis. cbf_get_pixel_size_fs sets *psize to
        point to the double value in millimeters of the axis axis_number of
        the detector element element_number. The axis_number is numbered from
        1, starting with the fastest axis.
        If a negative axis number is given, the order of axes is reversed, so
        that -1 specifies the slowest axis for cbf_get_pixel_size_fs and the
        fastest axis for cbf_get_pixel_size_sf.
        If the pixel size is not given explcitly in the  "array_element_size
        " category, the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. axis_number      The number of the
        axis, starting from 1 for the fastest for cbf_get_pixel_size and
        cbf_get_pixel_size_fs and the slowest for cbf_get_pixel_size_sf.
        psize            Pointer to the destination pixel size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_pixel_size_sf(self, element_number, axis_number)

    def get_polarization(self):
        r"""

        Returns : float polarizn_source_ratio,float polarizn_source_norm
        *args   :

        C prototype: int cbf_get_polarization (cbf_handle handle,
                         double      *polarizn_source_ratio,
                         double *polarizn_source_norm);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_polarization sets *polarizn_source_ratio and
        *polarizn_source_norm to the corresponding source polarization
        parameters.
        Either destination pointer may be NULL.
        ARGUMENTS
        handle                  CBF handle. polarizn_source_ratio   Pointer
        to the destination polarizn_source_ratio. polarizn_source_norm
        Pointer to the destination polarizn_source_norm.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_polarization(self)

    def get_real_3d_image_as_string(self, element_number, elsize, ndimslow, ndimmid, ndimfast):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int ndimslow,int ndimmid,int ndimfast

        C prototype: int cbf_get_real_3d_image (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         void *array, size_t elsize, size_t      ndimslow,
                         size_t ndimmid, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_real_3d_image_as_string(self, element_number, elsize, ndimslow, ndimmid, ndimfast)

    def get_real_3d_image_fs_as_string(self, element_number, elsize, ndimfast, ndimmid, ndimslow):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int ndimfast,int ndimmid,int ndimslow

        C prototype: int cbf_get_real_3d_image_fs (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         void *array, size_t elsize, size_t      ndimfast,
                         size_t ndimmid, size_t ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_real_3d_image_fs_as_string(self, element_number, elsize, ndimfast, ndimmid, ndimslow)

    def get_real_3d_image_sf_as_string(self, element_number, elsize, ndimslow, ndimmid, ndimfast):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int ndimslow,int ndimmid,int ndimfast

        C prototype: int cbf_get_real_3d_image_sf (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         void *array, size_t elsize, size_t      ndimslow,
                         size_t ndimmid, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_real_3d_image_sf_as_string(self, element_number, elsize, ndimslow, ndimmid, ndimfast)

    def get_real_image_as_string(self, element_number, elsize, ndimslow, ndimfast):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int ndimslow,int ndimfast

        C prototype: int cbf_get_real_image (cbf_handle handle, unsigned int reserved,
                              unsigned int element_number, void *array, size_t elsize,
                         size_t      ndimslow, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_real_image_as_string(self, element_number, elsize, ndimslow, ndimfast)

    def get_real_image_fs_as_string(self, element_number, elsize, ndimfast, ndimslow):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int ndimfast,int ndimslow

        C prototype: int cbf_get_real_image_fs (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         void *array, size_t elsize, size_t      ndimfast,
                         size_t ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_real_image_fs_as_string(self, element_number, elsize, ndimfast, ndimslow)

    def get_real_image_sf_as_string(self, element_number, elsize, ndimslow, ndimfast):
        r"""

        Returns : (Binary)String
        *args   : int element_number,int elsize,int ndimslow,int ndimfast

        C prototype: int cbf_get_real_image_sf (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         void *array, size_t elsize, size_t      ndimslow,
                         size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_image, cbf_get_image_fs and cbf_get_image_sf read the image
        array for element number element_number into an array. The array
        consists of ndimslow×ndimfast elements of elsize bytes each, starting
        at array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_image, cbf_get_real_image_fs and
        cbf_get_real_image_sf read the image array of IEEE doubles or floats
        for element number element_number into an array. A real array is
        always signed. cbf_get_3d_image, cbf_get_3d_image_fs and
        cbf_get_3d_image_sf read the 3D image array for element number
        element_number into an array. The array consists of
        ndimslow×ndimmid×ndimfast elements of elsize bytes each, starting at
        array. The elements are signed if elsign is non-0 and unsigned
        otherwise. cbf_get_real_3d_image, cbf_get_real_3d_image_fs,
        cbf_get_real_3d_image_sf reads the 3D image array of IEEE doubles or
        floats for element number element_number into an array. A real array
        is always signed.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        The structure of the array as a 1-, 2- or 3-dimensional array should
        agree with the structure of the array given in the
        ARRAY_STRUCTURE_LIST category. If the array is 1-dimensional,
        ndimslow should be the array size and ndimfast and, for the 3D calls,
        ndimmid, should be set to 1 both in the call and in the imgCIF data
        being processed. If the array is 2-dimensional and a 3D call is used,
        ndimslow and ndimmid should be the

        """
        return _pycbf.cbf_handle_struct_get_real_image_sf_as_string(self, element_number, elsize, ndimslow, ndimfast)

    def get_realarray_as_string(self):
        r"""

        Returns : (Binary)String
        *args   :

        C prototype: int cbf_get_realarray (cbf_handle handle, int *binary_id,
                         void *array,    size_t elsize, size_t elements,
                         size_t *elements_read);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarray reads the binary value of the item at the
        current column and row into an integer array. The array consists of
        elements elements of elsize bytes each, starting at array. The
        elements are signed if elsigned is non-0 and unsigned otherwise.
        *binary_id is set to the binary section identifier and *elements_read
        to the number of elements actually read. cbf_get_realarray reads the
        binary value of the item at the current column and row into a real
        array. The array consists of elements elements of elsize bytes each,
        starting at array. *binary_id is set to the binary section identifier
        and *elements_read to the number of elements actually read.
        If any element in the integer binary data cant fit into the
        destination element, the destination is set the nearest possible
        value.
        If the value is not binary, the function returns CBF_ASCII.
        If the requested number of elements cant be read, the function will
        read as many as it can and then return CBF_ENDOFDATA.
        Currently, the destination array must consist of chars, shorts or
        ints (signed or unsigned). If elsize is not equal to sizeof (char),
        sizeof (short) or sizeof (int), for cbf_get_integerarray, or
        sizeof(double) or sizeof(float), for cbf_get_realarray the function
        returns CBF_ARGUMENT.
        An additional restriction in the current version of CBFlib is that
        values too large to fit in an int are not correctly decompressed. As
        an example, if the machine with 32-bit ints is reading an array
        containing a value outside the range 0 .. 2^^32-1 (unsigned) or
        -2^^31 .. 2^^31-1 (signed), the array will not be correctly
        decompressed. This restriction will be removed in a future release.
        For cbf_get_realarray, only IEEE format is supported. No conversion
        to other floating point formats is done at this time.
        ARGUMENTS
        handle          CBF handle. binary_id       Pointer to the
        destination integer binary identifier. array           Pointer to the
        destination array. elsize          Size in bytes of each destination
        array element. elsigned        Set to non-0 if the destination array
        elements are signed. elements        The number of elements to read.
        elements_read   Pointer to the destination number of elements
        actually read.
        RETURN VALUE
        Returns an error code on failure or 0 for success. SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_realarray_as_string(self)

    def get_realarrayparameters(self):
        r"""

        Returns : int compression,int binary_id,int elsize,int elements
        *args   :

        C prototype: int cbf_get_realarrayparameters (cbf_handle handle,
                         unsigned int    *compression, int *binary_id, size_t *elsize,
                         size_t *elements);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarrayparameters sets *compression, *binary_id,
        *elsize, *elsigned, *elunsigned, *elements, *minelement and
        *maxelement to values read from the binary value of the item at the
        current column and row. This provides all the arguments needed for a
        subsequent call to cbf_set_integerarray, if a copy of the array is to
        be made into another CIF or CBF. cbf_get_realarrayparameters sets
        *compression, *binary_id, *elsize, *elements to values read from the
        binary value of the item at the current column and row. This provides
        all the arguments needed for a subsequent call to cbf_set_realarray,
        if a copy of the arry is to be made into another CIF or CBF.
        The variants cbf_get_integerarrayparameters_wdims,
        cbf_get_integerarrayparameters_wdims_fs,
        cbf_get_integerarrayparameters_wdims_sf,
        cbf_get_realarrayparameters_wdims,
        cbf_get_realarrayparameters_wdims_fs,
        cbf_get_realarrayparameters_wdims_sf set **byteorder, *dimfast,
        *dimmid, *dimslow, and *padding as well, providing the additional
        parameters needed for a subsequent call to cbf_set_integerarray_wdims
        or cbf_set_realarray_wdims.
        The value returned in *byteorder is a pointer either to the string
        "little_endian " or to the string  "big_endian ". This should be
        the byte order of the data, not necessarily of the host machine. No
        attempt should be made to modify this string. At this time only
        "little_endian " will be returned.
        The values returned in *dimfast, *dimmid and *dimslow are the sizes
        of the fastest changing, second fastest changing and third fastest
        changing dimensions of the array, if specified, or zero, if not
        specified.
        The value returned in *padding is the size of the post-data padding,
        if any and if specified in the data header. The value is given as a
        count of octets.
        If the value is not binary, the function returns CBF_ASCII.
        ARGUMENTS
        handle        CBF handle. compression   Compression method used.
        elsize        Size in bytes of each array element. binary_id
        Pointer to the destination integer binary identifier. elsigned
        Pointer to an integer. Set to 1 if the elements can be read as signed
        integers. elunsigned    Pointer to an integer. Set to 1 if the
        elements can be read as unsigned integers. elements      Pointer to
        the destination number of elements. minelement    Pointer to the
        destination smallest element. maxelement    Pointer to the
        destination largest element. byteorder     Pointer to the destination
        byte order. dimfast       Pointer to the destination fastest
        dimension. dimmid        Pointer to the destination second fastest
        dimension. dimslow       Pointer to the destination third fastest
        dimension. padding       Pointer to the destination padding size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_realarrayparameters(self)

    def get_realarrayparameters_wdims(self):
        r"""

        Returns : int compression,int binary_id,int elsize,int elements,char **bo,
                  int *bolen,int dimfast,int dimmid,int dimslow,int padding
        *args   :

        C prototype: int cbf_get_realarrayparameters_wdims (cbf_handle handle,
                         unsigned int    *compression, int *binary_id, size_t *elsize,
                         size_t *elements, const char    **byteorder, size_t *dimfast,
                         size_t *dimmid, size_t *dimslow, size_t    *padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarrayparameters sets *compression, *binary_id,
        *elsize, *elsigned, *elunsigned, *elements, *minelement and
        *maxelement to values read from the binary value of the item at the
        current column and row. This provides all the arguments needed for a
        subsequent call to cbf_set_integerarray, if a copy of the array is to
        be made into another CIF or CBF. cbf_get_realarrayparameters sets
        *compression, *binary_id, *elsize, *elements to values read from the
        binary value of the item at the current column and row. This provides
        all the arguments needed for a subsequent call to cbf_set_realarray,
        if a copy of the arry is to be made into another CIF or CBF.
        The variants cbf_get_integerarrayparameters_wdims,
        cbf_get_integerarrayparameters_wdims_fs,
        cbf_get_integerarrayparameters_wdims_sf,
        cbf_get_realarrayparameters_wdims,
        cbf_get_realarrayparameters_wdims_fs,
        cbf_get_realarrayparameters_wdims_sf set **byteorder, *dimfast,
        *dimmid, *dimslow, and *padding as well, providing the additional
        parameters needed for a subsequent call to cbf_set_integerarray_wdims
        or cbf_set_realarray_wdims.
        The value returned in *byteorder is a pointer either to the string
        "little_endian " or to the string  "big_endian ". This should be
        the byte order of the data, not necessarily of the host machine. No
        attempt should be made to modify this string. At this time only
        "little_endian " will be returned.
        The values returned in *dimfast, *dimmid and *dimslow are the sizes
        of the fastest changing, second fastest changing and third fastest
        changing dimensions of the array, if specified, or zero, if not
        specified.
        The value returned in *padding is the size of the post-data padding,
        if any and if specified in the data header. The value is given as a
        count of octets.
        If the value is not binary, the function returns CBF_ASCII.
        ARGUMENTS
        handle        CBF handle. compression   Compression method used.
        elsize        Size in bytes of each array element. binary_id
        Pointer to the destination integer binary identifier. elsigned
        Pointer to an integer. Set to 1 if the elements can be read as signed
        integers. elunsigned    Pointer to an integer. Set to 1 if the
        elements can be read as unsigned integers. elements      Pointer to
        the destination number of elements. minelement    Pointer to the
        destination smallest element. maxelement    Pointer to the
        destination largest element. byteorder     Pointer to the destination
        byte order. dimfast       Pointer to the destination fastest
        dimension. dimmid        Pointer to the destination second fastest
        dimension. dimslow       Pointer to the destination third fastest
        dimension. padding       Pointer to the destination padding size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_realarrayparameters_wdims(self)

    def get_realarrayparameters_wdims_fs(self):
        r"""

        Returns : int compression,int binary_id,int elsize,int elements,char **bo,
                  int *bolen,int dimfast,int dimmid,int dimslow,int padding
        *args   :

        C prototype: int cbf_get_realarrayparameters_wdims_fs (cbf_handle handle,
                         unsigned int    *compression, int *binary_id, size_t *elsize,
                         size_t *elements, const char    **byteorder, size_t *dimfast,
                         size_t *dimmid, size_t *dimslow, size_t    *padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarrayparameters sets *compression, *binary_id,
        *elsize, *elsigned, *elunsigned, *elements, *minelement and
        *maxelement to values read from the binary value of the item at the
        current column and row. This provides all the arguments needed for a
        subsequent call to cbf_set_integerarray, if a copy of the array is to
        be made into another CIF or CBF. cbf_get_realarrayparameters sets
        *compression, *binary_id, *elsize, *elements to values read from the
        binary value of the item at the current column and row. This provides
        all the arguments needed for a subsequent call to cbf_set_realarray,
        if a copy of the arry is to be made into another CIF or CBF.
        The variants cbf_get_integerarrayparameters_wdims,
        cbf_get_integerarrayparameters_wdims_fs,
        cbf_get_integerarrayparameters_wdims_sf,
        cbf_get_realarrayparameters_wdims,
        cbf_get_realarrayparameters_wdims_fs,
        cbf_get_realarrayparameters_wdims_sf set **byteorder, *dimfast,
        *dimmid, *dimslow, and *padding as well, providing the additional
        parameters needed for a subsequent call to cbf_set_integerarray_wdims
        or cbf_set_realarray_wdims.
        The value returned in *byteorder is a pointer either to the string
        "little_endian " or to the string  "big_endian ". This should be
        the byte order of the data, not necessarily of the host machine. No
        attempt should be made to modify this string. At this time only
        "little_endian " will be returned.
        The values returned in *dimfast, *dimmid and *dimslow are the sizes
        of the fastest changing, second fastest changing and third fastest
        changing dimensions of the array, if specified, or zero, if not
        specified.
        The value returned in *padding is the size of the post-data padding,
        if any and if specified in the data header. The value is given as a
        count of octets.
        If the value is not binary, the function returns CBF_ASCII.
        ARGUMENTS
        handle        CBF handle. compression   Compression method used.
        elsize        Size in bytes of each array element. binary_id
        Pointer to the destination integer binary identifier. elsigned
        Pointer to an integer. Set to 1 if the elements can be read as signed
        integers. elunsigned    Pointer to an integer. Set to 1 if the
        elements can be read as unsigned integers. elements      Pointer to
        the destination number of elements. minelement    Pointer to the
        destination smallest element. maxelement    Pointer to the
        destination largest element. byteorder     Pointer to the destination
        byte order. dimfast       Pointer to the destination fastest
        dimension. dimmid        Pointer to the destination second fastest
        dimension. dimslow       Pointer to the destination third fastest
        dimension. padding       Pointer to the destination padding size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_realarrayparameters_wdims_fs(self)

    def get_realarrayparameters_wdims_sf(self):
        r"""

        Returns : int compression,int binary_id,int elsize,int elements,char **bo,
                  int *bolen,int dimslow,int dimmid,int dimfast,int padding
        *args   :

        C prototype: int cbf_get_realarrayparameters_wdims_sf (cbf_handle handle,
                         unsigned int    *compression, int *binary_id, size_t *elsize,
                         size_t *elements, const char    **byteorder, size_t *dimslow,
                         size_t *dimmid, size_t *dimfast, size_t    *padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integerarrayparameters sets *compression, *binary_id,
        *elsize, *elsigned, *elunsigned, *elements, *minelement and
        *maxelement to values read from the binary value of the item at the
        current column and row. This provides all the arguments needed for a
        subsequent call to cbf_set_integerarray, if a copy of the array is to
        be made into another CIF or CBF. cbf_get_realarrayparameters sets
        *compression, *binary_id, *elsize, *elements to values read from the
        binary value of the item at the current column and row. This provides
        all the arguments needed for a subsequent call to cbf_set_realarray,
        if a copy of the arry is to be made into another CIF or CBF.
        The variants cbf_get_integerarrayparameters_wdims,
        cbf_get_integerarrayparameters_wdims_fs,
        cbf_get_integerarrayparameters_wdims_sf,
        cbf_get_realarrayparameters_wdims,
        cbf_get_realarrayparameters_wdims_fs,
        cbf_get_realarrayparameters_wdims_sf set **byteorder, *dimfast,
        *dimmid, *dimslow, and *padding as well, providing the additional
        parameters needed for a subsequent call to cbf_set_integerarray_wdims
        or cbf_set_realarray_wdims.
        The value returned in *byteorder is a pointer either to the string
        "little_endian " or to the string  "big_endian ". This should be
        the byte order of the data, not necessarily of the host machine. No
        attempt should be made to modify this string. At this time only
        "little_endian " will be returned.
        The values returned in *dimfast, *dimmid and *dimslow are the sizes
        of the fastest changing, second fastest changing and third fastest
        changing dimensions of the array, if specified, or zero, if not
        specified.
        The value returned in *padding is the size of the post-data padding,
        if any and if specified in the data header. The value is given as a
        count of octets.
        If the value is not binary, the function returns CBF_ASCII.
        ARGUMENTS
        handle        CBF handle. compression   Compression method used.
        elsize        Size in bytes of each array element. binary_id
        Pointer to the destination integer binary identifier. elsigned
        Pointer to an integer. Set to 1 if the elements can be read as signed
        integers. elunsigned    Pointer to an integer. Set to 1 if the
        elements can be read as unsigned integers. elements      Pointer to
        the destination number of elements. minelement    Pointer to the
        destination smallest element. maxelement    Pointer to the
        destination largest element. byteorder     Pointer to the destination
        byte order. dimfast       Pointer to the destination fastest
        dimension. dimmid        Pointer to the destination second fastest
        dimension. dimslow       Pointer to the destination third fastest
        dimension. padding       Pointer to the destination padding size.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_realarrayparameters_wdims_sf(self)

    def get_reciprocal_cell(self):
        r"""

        Returns : Float astar,Float bstar,Float cstar,Float alphastar,Float betastar,
                  Float gammastar
        *args   :

        C prototype: int cbf_get_reciprocal_cell (cbf_handle handle, double cell[6],
                         double      cell_esd[6] );

        CBFLib documentation:
        DESCRIPTION
        cbf_get_reciprocal_cell sets cell[0:2] to the double values of the
        reciprocal cell edge lengths a^*, b^* and c^* in Ångstroms^-1,
        cell[3:5] to the double values of the reciprocal cell angles α^*, β^*
        and γ^* in degrees, cell_esd[0:2] to the double values of the
        estimated strandard deviations of the reciprocal cell edge lengths
        a^*, b^* and c^* in Ångstroms^-1, cell_esd[3:5] to the double values
        of the estimated standard deviations of the the reciprocal cell
        angles α^*, β^* and γ^* in degrees.
        The values returned are retrieved from the first row of the  "cell
        " category. The value of  "_cell.entry_id " is ignored.
        cell or cell_esd may be NULL.
        If cell is NULL, the reciprocal cell parameters are not retrieved.
        If cell_esd is NULL, the reciprocal cell parameter esds are not
        retrieved.
        If the  "cell " category is present, but some of the values are
        missing, zeros are returned for the missing values.
        ARGUMENTS
        handle     CBF handle. cell       Pointer to the destination array of
        6 doubles for the reciprocal cell parameters. cell_esd   Pointer to
        the destination array of 6 doubles for the reciprocal cell parameter
        esds.
        RETURN VALUE
        Returns an error code on failure or 0 for success. No errors is
        returned for missing values if the  "cell " category exists.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_reciprocal_cell(self)

    def get_reciprocal_cell_esd(self):
        r"""get_reciprocal_cell_esd(cbf_handle_struct self)"""
        return _pycbf.cbf_handle_struct_get_reciprocal_cell_esd(self)

    def get_timestamp(self):
        r"""

        Returns : Float time,Integer timezone
        *args   :

        C prototype: int cbf_get_timestamp (cbf_handle handle, unsigned int reserved,
                         double      *time, int *timezone);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_timestamp sets *time to the collection timestamp in seconds
        since January 1 1970. *timezone is set to timezone difference from
        UTC in minutes. The parameter reserved is presently unused and should
        be set to 0.
        Either of the destination pointers may be NULL.
        ARGUMENTS
        handle     CBF handle. reserved   Unused. Any value other than 0 is
        invalid. time       Pointer to the destination collection timestamp.
        timezone   Pointer to the destination timezone difference.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_timestamp(self)

    def get_typeofvalue(self):
        r"""

        Returns :
        *args   : string

        C prototype: int cbf_get_typeofvalue (cbf_handle handle,
                         const char **typeofvalue);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_value sets *typeofvalue to point an ASCII descriptor of the
        value of the item at the current column and row. The strings that may
        be returned are:
         "null " for a null value indicated by a  ". " or a  "? "
        "bnry " for a binary value  "word " for an unquoted string
        "dblq " for a double-quoted string  "sglq " for a single-quoted
        string  "text " for a semicolon-quoted string (multiline text
        field)  "prns " for a parenthesis-bracketed string (multiline text
        field)  "brcs " for a brace-bracketed string (multiline text field)
         "bkts " for a square-bracket-bracketed string (multiline text
        field)  "tsqs " for a treble-single-quote quoted string (multiline
        text field)  "tdqs " for a treble-double-quote quoted string
        (multiline text field)
        Not all types are valid for all type of CIF files. In partcular the
        types  "prns ",  "brcs ",  "bkts " were introduced with DDLm
        and are not valid in DDL1 or DDL2 CIFS. The types  "tsqs " and
        "tdqs " are not formally part of the CIF syntax. A field for which
        no value has been set sets *typeofvalue to NULL rather than to the
        string  "null ".
        The typeofvalue must not be modified by the program in any way.
        ARGUMENTS
        handle        CBF handle. typeofvalue   Pointer to the destination
        type-of-value string pointer.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_typeofvalue(self)

    def get_unit_cell(self):
        r"""

        Returns : Float a,Float b,Float c,Float alpha,Float beta,Float gamma
        *args   :

        C prototype: int cbf_get_unit_cell (cbf_handle handle, double cell[6],
                         double      cell_esd[6] );

        CBFLib documentation:
        DESCRIPTION
        cbf_get_unit_cell sets cell[0:2] to the double values of the cell
        edge lengths a, b and c in Ångstroms, cell[3:5] to the double values
        of the cell angles α, β and γ in degrees, cell_esd[0:2] to the double
        values of the estimated strandard deviations of the cell edge lengths
        a, b and c in Ångstroms, cell_esd[3:5] to the double values of the
        estimated standard deviations of the the cell angles α, β and γ in
        degrees.
        The values returned are retrieved from the first row of the  "cell
        " category. The value of  "_cell.entry_id " is ignored.
        cell or cell_esd may be NULL.
        If cell is NULL, the cell parameters are not retrieved.
        If cell_esd is NULL, the cell parameter esds are not retrieved.
        If the  "cell " category is present, but some of the values are
        missing, zeros are returned for the missing values.
        ARGUMENTS
        handle     CBF handle. cell       Pointer to the destination array of
        6 doubles for the cell parameters. cell_esd   Pointer to the
        destination array of 6 doubles for the cell parameter esds.
        RETURN VALUE
        Returns an error code on failure or 0 for success. No errors is
        returned for missing values if the  "cell " category exists.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_unit_cell(self)

    def get_unit_cell_esd(self):
        r"""get_unit_cell_esd(cbf_handle_struct self)"""
        return _pycbf.cbf_handle_struct_get_unit_cell_esd(self)

    def get_value(self):
        r"""

        Returns :
        *args   : string

        C prototype: int cbf_get_value (cbf_handle handle, const char **value);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_value sets *value to point to the ASCII value of the item at
        the current column and row. cbf_require_value sets *value to point to
        the ASCII value of the item at the current column and row, creating
        the data item if necessary and initializing it to a copy of
        defaultvalue.
        If the value is not ASCII, the function returns CBF_BINARY.
        The value will be valid as long as the item exists and has not been
        set to a new value.
        The value must not be modified by the program in any way.
        ARGUMENTS
        handle         CBF handle. value          Pointer to the destination
        value pointer. defaultvalue   Default value character string.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_get_value(self)

    def get_wavelength(self):
        r"""

        Returns : double
        *args   :

        C prototype: int cbf_get_wavelength (cbf_handle handle, double *wavelength);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_wavelength sets *wavelength to the current wavelength in Å.
        ARGUMENTS
        handle       CBF handle. wavelength   Pointer to the destination.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_get_wavelength(self)

    def insert_row(self, arg):
        r"""

        Returns :
        *args   : Integer

        C prototype: int cbf_insert_row (cbf_handle handle, unsigned int rownumber);

        CBFLib documentation:
        DESCRIPTION
        cbf_insert_row adds a new row to the current category. The new row is
        inserted as row rownumber and existing rows starting from rownumber
        are moved up by 1. The new row becomes the current row.
        If the category has fewer than rownumber rows, the function returns
        CBF_NOTFOUND.
        The row numbers start from 0.
        ARGUMENTS
        handle      CBF handle. rownumber   The row number of the new row.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_insert_row(self, arg)

    def new_category(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_new_category (cbf_handle handle,
                         const char *categoryname);

        CBFLib documentation:
        DESCRIPTION
        cbf_new_category creates a new category in the current data block
        with name categoryname and makes it the current category.
        If a category with this name already exists, the existing category
        becomes the current category.
        ARGUMENTS
        handle         CBF handle. categoryname   The name of the new
        category.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_new_category(self, arg)

    def new_column(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_new_column (cbf_handle handle, const char *columnname);

        CBFLib documentation:
        DESCRIPTION
        cbf_new_column creates a new column in the current category with name
        columnname and makes it the current column.
        If a column with this name already exists, the existing column
        becomes the current category.
        ARGUMENTS
        handle       CBF handle. columnname   The name of the new column.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_new_column(self, arg)

    def new_datablock(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_new_datablock (cbf_handle handle,
                         const char *datablockname);

        CBFLib documentation:
        DESCRIPTION
        cbf_new_datablock creates a new data block with name datablockname
        and makes it the current data block. cbf_new_saveframe creates a new
        save frame with name saveframename within the current data block and
        makes the new save frame the current save frame.
        If a data block or save frame with this name already exists, the
        existing data block or save frame becomes the current data block or
        save frame.
        ARGUMENTS
        handle          CBF handle. datablockname   The name of the new data
        block. saveframename   The name of the new save frame.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_new_datablock(self, arg)

    def new_row(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_new_row (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_new_row adds a new row to the current category and makes it the
        current row.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_new_row(self)

    def new_saveframe(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_new_saveframe (cbf_handle handle,
                         const char *saveframename);

        CBFLib documentation:
        DESCRIPTION
        cbf_new_datablock creates a new data block with name datablockname
        and makes it the current data block. cbf_new_saveframe creates a new
        save frame with name saveframename within the current data block and
        makes the new save frame the current save frame.
        If a data block or save frame with this name already exists, the
        existing data block or save frame becomes the current data block or
        save frame.
        ARGUMENTS
        handle          CBF handle. datablockname   The name of the new data
        block. saveframename   The name of the new save frame.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_new_saveframe(self, arg)

    def next_category(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_next_category (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_next_category makes the category following the current category
        in the current data block the current category.
        If there are no more categories, the function returns CBF_NOTFOUND.
        The current column and row become undefined.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_next_category(self)

    def next_column(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_next_column (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_next_column makes the column following the current column in the
        current category the current column.
        If there are no more columns, the function returns CBF_NOTFOUND.
        The current row is not affected.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_next_column(self)

    def next_datablock(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_next_datablock (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_next_datablock makes the data block following the current data
        block the current data block.
        If there are no more data blocks, the function returns CBF_NOTFOUND.
        The current category becomes undefined.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_next_datablock(self)

    def next_row(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_next_row (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_next_row makes the row following the current row in the current
        category the current row.
        If there are no more rows, the function returns CBF_NOTFOUND.
        The current column is not affected.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_next_row(self)

    def read_buffer(self, buffer, flags=0):
        r"""

        Returns :
        *args   : Bytes object,Integer Flags

        C prototype: int cbf_read_buffered_file (cbf_handle handle, FILE *stream,
                         int flags, const char * buffer, size_t buffer_len)

        CBFLib documentation:
        Read from a bytes buffer instead of a file.
        Args:
           buffer (bytes): The python bytes-buffer to read from.
           flags (int): Same meaning as for read_file

        """
        return _pycbf.cbf_handle_struct_read_buffer(self, buffer, flags)

    def read_file(self, filename, headers):
        r"""

        Returns :
        *args   : String filename,Integer headers

        C prototype: int cbf_read_file (cbf_handle handle, FILE *file, int flags);

        CBFLib documentation:
        DESCRIPTION
        cbf_read_file reads the CBF or CIF file file into the CBF object
        specified by handle, using the CIF 1.0 convention of 80 character
        lines. cbf_read_widefile reads the CBF or CIF file file into the CBF
        object specified by handle, using the CIF 1.1 convention of 2048
        character lines. A warning is issued to stderr for ascii lines over
        the limit. No test is performed on binary sections.
        Validation is performed in three ways levels: during the lexical
        scan, during the parse, and, if a dictionary was converted, against
        the value types, value enumerations, categories and parent-child
        relationships specified in the dictionary.
        flags controls the interpretation of binary section headers, the
        parsing of brackets constructs and the parsing of treble-quoted
        strings.
        MSG_DIGEST:               Instructs CBFlib to check that the digest
        of the binary section matches any header digest value. If the digests
        do not match, the call will return CBF_FORMAT. This evaluation and
        comparison is delayed (a  "lazy " evaluation) to ensure maximal
        processing efficiency. If an immediately evaluation is required, see
        MSG_DIGESTNOW, below. MSG_DIGESTNOW:            Instructs CBFlib to
        check that the digest of the binary section matches any header
        digeste value. If the digests do not match, the call will return
        CBF_FORMAT. This evaluation and comparison is performed during
        initial parsing of the section to ensure timely error reporting at
        the expense of processing efficiency. If a more efficient delayed (
        "lazy ") evaluation is required, see MSG_DIGEST, above.
        MSG_DIGESTWARN:           Instructs CBFlib to check that the digest
        of the binary section matches any header digeste value. If the
        digests do not match, a warning message will be sent to stderr, but
        processing will attempt to continue. This evaluation and comparison
        is first performed during initial parsing of the section to ensure
        timely error reporting at the expense of processing efficiency. An
        mismatch of the message digest usually indicates a serious error, but
        it is sometimes worth continuing processing to try to isolate the
        cause of the error. Use this option with caution. MSG_NODIGEST:
              Do not check the digest (default). PARSE_BRACKETS:
        Accept DDLm bracket-delimited [item,item,...item] or
        {item,item,...item} or (item,item,...item) constructs as valid,
        stripping non-quoted embedded whitespace and comments. These
        constructs may span multiple lines. PARSE_LIBERAL_BRACKETS:   Accept
        DDLm bracket-delimited [item,item,...item] or {item,item,...item} or
        (item,item,...item) constructs as valid, stripping embedded
        non-quoted, non-separating whitespace and comments. These constructs
        may span multiple lines. In this case, whitespace may be used as an
        alternative to the comma. PARSE_TRIPLE_QUOTES:      Accept DDLm
        triple-quoted  " " "item,item,...item " " " or
        '''item,item,...item''' constructs as valid, stripping embedded
        whitespace and comments. These constructs may span multiple lines. If
        this flag is set, then ''' will not be interpreted as a quoted
        apoptrophe and  " " " will not be interpreted as a quoted double
        quote mark and PARSE_NOBRACKETS:         Do not accept DDLm
        bracket-delimited [item,item,...item] or {item,item,...item} or
        (item,item,...item) constructs as valid, stripping non-quoted
        embedded whitespace and comments. These constructs may span multiple
        lines. PARSE_NOTRIPLE_QUOTES:    No not accept DDLm triple-quoted  "
        " "item,item,...item " " " or '''item,item,...item''' constructs
        as valid, stripping embedded whitespace and comments. These
        constructs may span multiple lines. If this flag is set, then '''
        will be interpreted as a quoted apostrophe and  " " " will be
        interpreted as a quoted double quote mark.
        CBFlib defers reading binary sections as long as possible. In the
        current version of CBFlib, this means that:
        1. The file must be a random-access file opened in binary mode (fopen
        ( ,

        """
        return _pycbf.cbf_handle_struct_read_file(self, filename, headers)

    def read_template(self, filename):
        r"""

        Returns :
        *args   : String filename

        C prototype: int cbf_read_template (cbf_handle handle, FILE *file);

        CBFLib documentation:
        DESCRIPTION
        cbf_read_template reads the CBF or CIF file file into the CBF object
        specified by handle and selects the first datablock as the current
        datablock.
        ARGUMENTS
        handle   Pointer to a CBF handle. file     Pointer to a file
        descriptor.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_read_template(self, filename)

    def read_widefile(self, filename, headers):
        r"""

        Returns :
        *args   : String filename,Integer headers

        C prototype: int cbf_read_widefile (cbf_handle handle, FILE *file, int flags);

        CBFLib documentation:
        DESCRIPTION
        cbf_read_file reads the CBF or CIF file file into the CBF object
        specified by handle, using the CIF 1.0 convention of 80 character
        lines. cbf_read_widefile reads the CBF or CIF file file into the CBF
        object specified by handle, using the CIF 1.1 convention of 2048
        character lines. A warning is issued to stderr for ascii lines over
        the limit. No test is performed on binary sections.
        Validation is performed in three ways levels: during the lexical
        scan, during the parse, and, if a dictionary was converted, against
        the value types, value enumerations, categories and parent-child
        relationships specified in the dictionary.
        flags controls the interpretation of binary section headers, the
        parsing of brackets constructs and the parsing of treble-quoted
        strings.
        MSG_DIGEST:               Instructs CBFlib to check that the digest
        of the binary section matches any header digest value. If the digests
        do not match, the call will return CBF_FORMAT. This evaluation and
        comparison is delayed (a  "lazy " evaluation) to ensure maximal
        processing efficiency. If an immediately evaluation is required, see
        MSG_DIGESTNOW, below. MSG_DIGESTNOW:            Instructs CBFlib to
        check that the digest of the binary section matches any header
        digeste value. If the digests do not match, the call will return
        CBF_FORMAT. This evaluation and comparison is performed during
        initial parsing of the section to ensure timely error reporting at
        the expense of processing efficiency. If a more efficient delayed (
        "lazy ") evaluation is required, see MSG_DIGEST, above.
        MSG_DIGESTWARN:           Instructs CBFlib to check that the digest
        of the binary section matches any header digeste value. If the
        digests do not match, a warning message will be sent to stderr, but
        processing will attempt to continue. This evaluation and comparison
        is first performed during initial parsing of the section to ensure
        timely error reporting at the expense of processing efficiency. An
        mismatch of the message digest usually indicates a serious error, but
        it is sometimes worth continuing processing to try to isolate the
        cause of the error. Use this option with caution. MSG_NODIGEST:
              Do not check the digest (default). PARSE_BRACKETS:
        Accept DDLm bracket-delimited [item,item,...item] or
        {item,item,...item} or (item,item,...item) constructs as valid,
        stripping non-quoted embedded whitespace and comments. These
        constructs may span multiple lines. PARSE_LIBERAL_BRACKETS:   Accept
        DDLm bracket-delimited [item,item,...item] or {item,item,...item} or
        (item,item,...item) constructs as valid, stripping embedded
        non-quoted, non-separating whitespace and comments. These constructs
        may span multiple lines. In this case, whitespace may be used as an
        alternative to the comma. PARSE_TRIPLE_QUOTES:      Accept DDLm
        triple-quoted  " " "item,item,...item " " " or
        '''item,item,...item''' constructs as valid, stripping embedded
        whitespace and comments. These constructs may span multiple lines. If
        this flag is set, then ''' will not be interpreted as a quoted
        apoptrophe and  " " " will not be interpreted as a quoted double
        quote mark and PARSE_NOBRACKETS:         Do not accept DDLm
        bracket-delimited [item,item,...item] or {item,item,...item} or
        (item,item,...item) constructs as valid, stripping non-quoted
        embedded whitespace and comments. These constructs may span multiple
        lines. PARSE_NOTRIPLE_QUOTES:    No not accept DDLm triple-quoted  "
        " "item,item,...item " " " or '''item,item,...item''' constructs
        as valid, stripping embedded whitespace and comments. These
        constructs may span multiple lines. If this flag is set, then '''
        will be interpreted as a quoted apostrophe and  " " " will be
        interpreted as a quoted double quote mark.
        CBFlib defers reading binary sections as long as possible. In the
        current version of CBFlib, this means that:
        1. The file must be a random-access file opened in binary mode (fopen
        ( ,

        """
        return _pycbf.cbf_handle_struct_read_widefile(self, filename, headers)

    def remove_category(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_remove_category (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_remove_category deletes the current category.
        The current category becomes undefined.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_remove_category(self)

    def remove_column(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_remove_column (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_remove_column deletes the current column.
        The current column becomes undefined.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_remove_column(self)

    def remove_datablock(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_remove_datablock (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_remove_datablock deletes the current data block.
        cbf_remove_saveframe deletes the current save frame.
        The current data block becomes undefined.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_remove_datablock(self)

    def remove_row(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_remove_row (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_remove_row deletes the current row in the current category.
        If the current row was the last row, it will move down by 1,
        otherwise, it will remain the same.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_remove_row(self)

    def remove_saveframe(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_remove_saveframe (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_remove_datablock deletes the current data block.
        cbf_remove_saveframe deletes the current save frame.
        The current data block becomes undefined.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_remove_saveframe(self)

    def require_category(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_require_category (cbf_handle handle,
                         const char *categoryname);

        CBFLib documentation:
        DESCRIPTION
        cbf_rewuire_category makes the category in the current data block
        with name categoryname the current category, if it exists, or creates
        the catagory if it does not exist.
        The comparison is case-insensitive.
        The current column and row become undefined.
        ARGUMENTS
        handle         CBF handle. categoryname   The name of the category to
        find.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_category(self, arg)

    def require_category_root(self, categoryname):
        r"""require_category_root(cbf_handle_struct self, char const * categoryname) -> char const *"""
        return _pycbf.cbf_handle_struct_require_category_root(self, categoryname)

    def require_column(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_require_column (cbf_handle handle,
                         const char *columnname);

        CBFLib documentation:
        DESCRIPTION
        cbf_require_column makes the columns in the current category with
        name columnname the current column, if it exists, or creates it if it
        does not.
        The comparison is case-insensitive.
        The current row is not affected.
        ARGUMENTS
        handle       CBF handle. columnname   The name of column to find.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_column(self, arg)

    def require_column_doublevalue(self, columnname, defaultvalue):
        r"""

        Returns : Float defaultvalue
        *args   : String columnname,Float Value

        C prototype: int cbf_require_column_doublevalue (cbf_handle handle,
                         const char      *columnname, double *number,
                         const double defaultvalue);

        CBFLib documentation:
        DESCRIPTION
        cbf_require_column_doublevalue sets *number to the value of the ASCII
        item at the current row for the column given with the name given by
        *columnname, with the value interpreted as a decimal floating-point
        number, or to the number given by defaultvalue if the item cannot be
        found.
        ARGUMENTS
        handle         CBF handle. columnname     Name of the column
        containing the number. number         pointer to the location to
        receive the floating-point value. defaultvalue   Value to use if the
        requested column and value cannot be found.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_column_doublevalue(self, columnname, defaultvalue)

    def require_column_integervalue(self, columnname, defaultvalue):
        r"""

        Returns : Int Value
        *args   : String Columnvalue,Int default

        C prototype: int cbf_require_column_integervalue (cbf_handle handle,
                         const char      *columnname, int *number,
                         const int defaultvalue);

        CBFLib documentation:
        DESCRIPTION
        cbf_require_column_doublevalue sets *number to the value of the ASCII
        item at the current row for the column given with the name given by
        *columnname, with the value interpreted as an integer number, or to
        the number given by defaultvalue if the item cannot be found.
        ARGUMENTS
        handle         CBF handle. columnname     Name of the column
        containing the number. number         pointer to the location to
        receive the integer value. defaultvalue   Value to use if the
        requested column and value cannot be found.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_column_integervalue(self, columnname, defaultvalue)

    def require_column_value(self, columnname, defaultvalue):
        r"""

        Returns : String Name
        *args   : String columnnanme,String Default

        C prototype: int cbf_require_column_value (cbf_handle handle,
                         const char *columnname,      const char **value,
                         const char *defaultvalue);

        CBFLib documentation:
        DESCRIPTION
        cbf_require_column_doublevalue sets *value to the ASCII item at the
        current row for the column given with the name given by *columnname,
        or to the string given by defaultvalue if the item cannot be found.
        ARGUMENTS
        handle         CBF handle. columnname     Name of the column
        containing the number. value          pointer to the location to
        receive the value. defaultvalue   Value to use if the requested
        column and value cannot be found.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_column_value(self, columnname, defaultvalue)

    def require_datablock(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_require_datablock (cbf_handle handle,
                         const char      *datablockname);

        CBFLib documentation:
        DESCRIPTION
        cbf_require_datablock makes the data block with name datablockname
        the current data block, if it exists, or creates it if it does not.
        The comparison is case-insensitive.
        The current category becomes undefined.
        ARGUMENTS
        handle          CBF handle. datablockname   The name of the data
        block to find or create.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_datablock(self, arg)

    def require_doublevalue(self, defaultvalue):
        r"""

        Returns : Float Number
        *args   : Float Default

        C prototype: int cbf_require_doublevalue (cbf_handle handle, double *number,
                         double    defaultvalue);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_doublevalue sets *number to the value of the ASCII item at
        the current column and row interpreted as a decimal floating-point
        number. cbf_require_doublevalue sets *number to the value of the
        ASCII item at the current column and row interpreted as a decimal
        floating-point number, setting it to defaultvalue if necessary.
        If the value is not ASCII, the function returns CBF_BINARY.
        ARGUMENTS
        handle         CBF handle. number         Pointer to the destination
        number. defaultvalue   default number value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_doublevalue(self, defaultvalue)

    def require_integervalue(self, thedefault):
        r"""

        Returns : Int number
        *args   : Int thedefault

        C prototype: int cbf_require_integervalue (cbf_handle handle, int *number,
                         int    defaultvalue);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_integervalue sets *number to the value of the ASCII item at
        the current column and row interpreted as a decimal integer.
        cbf_require_integervalue sets *number to the value of the ASCII item
        at the current column and row interpreted as a decimal integer,
        setting it to defaultvalue if necessary.
        If the value is not ASCII, the function returns CBF_BINARY.
        ARGUMENTS
        handle         CBF handle. number         pointer to the number.
        defaultvalue   default number value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_integervalue(self, thedefault)

    def require_reference_detector(self, element_number):
        r"""

        Returns : pycbf detector object
        *args   : Integer element_number

        C prototype: int cbf_require_reference_detector (cbf_handle handle,
                         cbf_detector      *detector, unsigned int element_number);

        CBFLib documentation:
        DESCRIPTION
        cbf_construct_detector constructs a detector object for detector
        element number element_number using the description in the CBF object
        handle and initialises the detector handle *detector.
        cbf_construct_reference_detector constructs a detector object for
        detector element number element_number using the description in the
        CBF object handle and initialises the detector handle *detector using
        the reference settings of the axes. cbf_require_reference_detector is
        similar, but try to force the creations of missing intermediate
        categories needed to construct a detector object.
        ARGUMENTS
        handle           CBF handle. detector         Pointer to the
        destination detector handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_require_reference_detector(self, element_number)

    def require_tag_root(self, tagname):
        r"""

        Returns : String tagroot
        *args   : String tagname

        C prototype: int cbf_require_tag_root (cbf_handle handle, const char* tagname,
                         const      char** tagroot);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_tag_root sets *tagroot to the root tag of which tagname is
        an alias. cbf_set_tag_root sets tagname as an alias of tagroot_in in
        the dictionary associated with handle, creating the dictionary if
        necessary. cbf_require_tag_root sets *tagroot to the root tag of
        which tagname is an alias, if there is one, or to the value of
        tagname, if tagname is not an alias.
        A returned tagroot string must not be modified in any way.
        ARGUMENTS
        handle       CBF handle. tagname      tag name which may be an alias.
        tagroot      pointer to a returned tag root name. tagroot_in   input
        tag root name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_require_tag_root(self, tagname)

    def require_value(self, defaultvalue):
        r"""

        Returns : String Value
        *args   : String defaultvalue

        C prototype: int cbf_require_value (cbf_handle handle, const char **value,
                         const char    *defaultvalue );

        CBFLib documentation:
        DESCRIPTION
        cbf_get_value sets *value to point to the ASCII value of the item at
        the current column and row. cbf_require_value sets *value to point to
        the ASCII value of the item at the current column and row, creating
        the data item if necessary and initializing it to a copy of
        defaultvalue.
        If the value is not ASCII, the function returns CBF_BINARY.
        The value will be valid as long as the item exists and has not been
        set to a new value.
        The value must not be modified by the program in any way.
        ARGUMENTS
        handle         CBF handle. value          Pointer to the destination
        value pointer. defaultvalue   Default value character string.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_require_value(self, defaultvalue)

    def reset_category(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_reset_category (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_reset_category deletes all columns and rows from current category.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_reset_category(self)

    def reset_datablock(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_reset_datablock (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_reset_datablock deletes all categories from the current data
        block. cbf_reset_saveframe deletes all categories from the current
        save frame.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_reset_datablock(self)

    def reset_datablocks(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_reset_datablocks (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_reset_datablocks deletes all categories from all data blocks.
        The current data block does not change.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_reset_datablocks(self)

    def reset_saveframe(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_reset_saveframe (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_reset_datablock deletes all categories from the current data
        block. cbf_reset_saveframe deletes all categories from the current
        save frame.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_reset_saveframe(self)

    def rewind_blockitem(self):
        r"""

        Returns : CBF_NODETYPE
        *args   :

        C prototype: int cbf_rewind_blockitem (cbf_handle handle,
                         CBF_NODETYPE * type);

        CBFLib documentation:
        DESCRIPTION
        cbf_rewind_category makes the first category in the current data
        block the current category. cbf_rewind_saveframe makes the first
        saveframe in the current data block the current saveframe.
        cbf_rewind_blockitem makes the first blockitem (category or
        saveframe) in the current data block the current blockitem. The type
        of the blockitem (CBF_CATEGORY or CBF_SAVEFRAME) is returned in type.
        If there are no categories, saveframes or blockitems the function
        returns CBF_NOTFOUND.
        The current column and row become undefined.
        ARGUMENTS
        handle   CBF handle. type     CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_rewind_blockitem(self)

    def rewind_category(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_rewind_category (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_rewind_category makes the first category in the current data
        block the current category. cbf_rewind_saveframe makes the first
        saveframe in the current data block the current saveframe.
        cbf_rewind_blockitem makes the first blockitem (category or
        saveframe) in the current data block the current blockitem. The type
        of the blockitem (CBF_CATEGORY or CBF_SAVEFRAME) is returned in type.
        If there are no categories, saveframes or blockitems the function
        returns CBF_NOTFOUND.
        The current column and row become undefined.
        ARGUMENTS
        handle   CBF handle. type     CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_rewind_category(self)

    def rewind_column(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_rewind_column (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_rewind_column makes the first column in the current category the
        current column.
        If there are no columns, the function returns CBF_NOTFOUND.
        The current row is not affected.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_rewind_column(self)

    def rewind_datablock(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_rewind_datablock (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_rewind_datablock makes the first data block the current data
        block.
        If there are no data blocks, the function returns CBF_NOTFOUND.
        The current category becomes undefined.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_rewind_datablock(self)

    def rewind_row(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_rewind_row (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_rewind_row makes the first row in the current category the
        current row.
        If there are no rows, the function returns CBF_NOTFOUND.
        The current column is not affected.
        ARGUMENTS
        handle   CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_rewind_row(self)

    def rewind_saveframe(self):
        r"""

        Returns :
        *args   :

        C prototype: int cbf_rewind_saveframe (cbf_handle handle);

        CBFLib documentation:
        DESCRIPTION
        cbf_rewind_category makes the first category in the current data
        block the current category. cbf_rewind_saveframe makes the first
        saveframe in the current data block the current saveframe.
        cbf_rewind_blockitem makes the first blockitem (category or
        saveframe) in the current data block the current blockitem. The type
        of the blockitem (CBF_CATEGORY or CBF_SAVEFRAME) is returned in type.
        If there are no categories, saveframes or blockitems the function
        returns CBF_NOTFOUND.
        The current column and row become undefined.
        ARGUMENTS
        handle   CBF handle. type     CBF handle.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_rewind_saveframe(self)

    def row_number(self):
        r"""

        Returns : Integer
        *args   :

        C prototype: int cbf_row_number (cbf_handle handle, unsigned int *row);

        CBFLib documentation:
        DESCRIPTION
        cbf_row_number sets *row to the number of the current row of the
        current category.
        ARGUMENTS
        handle   CBF handle. row      Pointer to the destination row number.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_row_number(self)

    def select_category(self, arg):
        r"""

        Returns :
        *args   : Integer

        C prototype: int cbf_select_category (cbf_handle handle,
                         unsigned int category);

        CBFLib documentation:
        DESCRIPTION
        cbf_select_category selects category number category in the current
        data block as the current category.
        The first category is number 0.
        The current column and row become undefined.
        If the category does not exist, the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle     CBF handle. category   Number of the category to select.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_select_category(self, arg)

    def select_column(self, arg):
        r"""

        Returns :
        *args   : Integer

        C prototype: int cbf_select_column (cbf_handle handle, unsigned int column);

        CBFLib documentation:
        DESCRIPTION
        cbf_select_column selects column number column in the current
        category as the current column.
        The first column is number 0.
        The current row is not affected
        If the column does not exist, the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle   CBF handle. column   Number of the column to select.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_select_column(self, arg)

    def select_datablock(self, arg):
        r"""

        Returns :
        *args   : Integer

        C prototype: int cbf_select_datablock (cbf_handle handle,
                         unsigned int datablock);

        CBFLib documentation:
        DESCRIPTION
        cbf_select_datablock selects data block number datablock as the
        current data block.
        The first data block is number 0.
        If the data block does not exist, the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle      CBF handle. datablock   Number of the data block to
        select.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_select_datablock(self, arg)

    def select_row(self, arg):
        r"""

        Returns :
        *args   : Integer

        C prototype: int cbf_select_row (cbf_handle handle, unsigned int row);

        CBFLib documentation:
        DESCRIPTION
        cbf_select_row selects row number row in the current category as the
        current row.
        The first row is number 0.
        The current column is not affected
        If the row does not exist, the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle   CBF handle. row      Number of the row to select.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_select_row(self, arg)

    def set_3d_image(self, element_number, compression, data, elsize, elsign, ndimslow, ndimmid, ndimfast):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int elsign,int dimslow,int dimmid,int dimfast

        C prototype: int cbf_set_3d_image (cbf_handle handle, unsigned int reserved,
                         unsigned      int element_number, unsigned int compression,
                         void *array, size_t      elsize, int elsign, size_t ndimslow,
                         size_t ndimmid, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_3d_image(self, element_number, compression, data, elsize, elsign, ndimslow, ndimmid, ndimfast)

    def set_3d_image_fs(self, element_number, compression, data, elsize, elsign, ndimfast, ndimmid, ndimslow):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int elsign,int dimfast,int dimmid,int dimslow

        C prototype: int cbf_set_3d_image_fs(cbf_handle handle, unsigned int reserved,
                              unsigned int element_number, unsigned int compression,
                         void *array,      size_t elsize, int elsign, size_t ndimfast,
                         size_t ndimmid, size_t      ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_3d_image_fs(self, element_number, compression, data, elsize, elsign, ndimfast, ndimmid, ndimslow)

    def set_3d_image_sf(self, element_number, compression, data, elsize, elsign, ndimslow, ndimmid, ndimfast):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int elsign,int dimslow,int dimmid,int dimfast

        C prototype: int cbf_set_3d_image_sf(cbf_handle handle, unsigned int reserved,
                              unsigned int element_number, unsigned int compression,
                         void *array,      size_t elsize, int elsign, size_t ndimslow,
                         size_t ndimmid, size_t      ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_3d_image_sf(self, element_number, compression, data, elsize, elsign, ndimslow, ndimmid, ndimfast)

    def set_axis_setting(self, axis_id, start, increment):
        r"""

        Returns :
        *args   : String axis_id,Float start,Float increment

        C prototype: int cbf_set_axis_setting (cbf_handle handle,
                         unsigned int reserved,      const char *axis_id, double start,
                         double increment);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_axis_setting sets the starting and increment values of the
        axis axis_id to start and increment.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle      CBF handle. reserved    Unused. Any value other than 0 is
        invalid. axis_id     Axis id. start       Start value. increment
        Increment value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_axis_setting(self, axis_id, start, increment)

    def set_bin_sizes(self, element_number, slowbinsize_in, fastbinsize_in):
        r"""

        Returns :
        *args   : Integer element_number,Float slowbinsize_in,Float fastbinsize_in

        C prototype: int cbf_set_bin_sizes(cbf_handle handle,
                         unsigned int element_number,      double slowbinsize_in,
                        double fastbinsize_in);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_bin_sizes sets slowbinsize to point to the value of the
        number of pixels composing one array element in the dimension that
        changes at the second-fastest rate and fastbinsize to point to the
        value of the number of pixels composing one array element in the
        dimension that changes at the fastest rate for the dectector element
        with the ordinal element_number. cbf_set_bin_sizes sets the the pixel
        bin sizes in the  "array_intensities " category to the values of
        slowbinsize_in for the number of pixels composing one array element
        in the dimension that changes at the second-fastest rate and
        fastbinsize_in for the number of pixels composing one array element
        in the dimension that changes at the fastest rate for the dectector
        element with the ordinal element_number.
        In order to allow for software binning involving fractions of pixels,
        the bin sizes are doubles rather than ints.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. slowbinsize      Pointer to the
        returned number of pixels composing one array element in the
        dimension that changes at the second-fastest rate. fastbinsize
        Pointer to the returned number of pixels composing one array element
        in the dimension that changes at the fastest rate. slowbinsize_in
        The number of pixels composing one array element in the dimension
        that changes at the second-fastest rate. fastbinsize_in   The number
        of pixels composing one array element in the dimension that changes
        at the fastest rate.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_bin_sizes(self, element_number, slowbinsize_in, fastbinsize_in)

    def set_category_root(self, categoryname, categoryroot):
        r"""

        Returns :
        *args   : String categoryname,String categoryroot

        C prototype: int cbf_set_category_root (cbf_handle handle,
                         const char*      categoryname_in, const char*categoryroot);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_category_root sets *categoryroot to the root category of
        which categoryname is an alias. cbf_set_category_root sets
        categoryname_in as an alias of categoryroot in the dictionary
        associated with handle, creating the dictionary if necessary.
        cbf_require_category_root sets *categoryroot to the root category of
        which categoryname is an alias, if there is one, or to the value of
        categoryname, if categoryname is not an alias.
        A returned categoryroot string must not be modified in any way.
        ARGUMENTS
        handle            CBF handle. categoryname      category name which
        may be an alias. categoryroot      pointer to a returned category
        root name. categoryroot_in   input category root name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_category_root(self, categoryname, categoryroot)

    def set_crystal_id(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_set_crystal_id (cbf_handle handle,
                         const char *crystal_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_crystal_id sets the  "diffrn.crystal_id " entry to the
        ASCII value crystal_id.
        ARGUMENTS
        handle       CBF handle. crystal_id   ASCII value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_crystal_id(self, arg)

    def set_current_timestamp(self, timezone):
        r"""

        Returns :
        *args   : Integer timezone

        C prototype: int cbf_set_current_timestamp (cbf_handle handle,
                         unsigned int reserved,      int timezone);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_current_timestamp sets the collection timestamp to the
        current time. The timezone difference from UTC in minutes is set to
        timezone. If no timezone is desired, timezone should be
        CBF_NOTIMEZONE. If no timezone is used, the timest amp will be UTC.
        The parameter reserved is presently unused and should be set to 0.
        The new timestamp will have a precision of 1 second.
        ARGUMENTS
        handle     CBF handle. reserved   Unused.   Any value other than 0 is
        invalid. timezone   Timezone difference from UTC in minutes or
        CBF_NOTIMEZONE.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_current_timestamp(self, timezone)

    def set_datablockname(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_set_datablockname (cbf_handle handle,
                         const char *datablockname);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_datablockname changes the name of the current data block to
        datablockname. cbf_set_saveframename changes the name of the current
        save frame to saveframename.
        If a data block or save frame with this name already exists
        (comparison is case-insensitive), the function returns CBF_IDENTICAL.
        ARGUMENTS
        handle          CBF handle. datablockname   The new data block name.
        datablockname   The new save frame name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_datablockname(self, arg)

    def set_datestamp(self, year, month, day, hour, minute, second, timezone, precision):
        r"""

        Returns :
        *args   : int year,int month,int day,int hour,int minute,double second,
                  int timezone,Float precision

        C prototype: int cbf_set_datestamp (cbf_handle handle, unsigned int reserved,
                         int      year, int month, int day, int hour, int minute,
                         double second, int      timezone, double precision);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_datestamp sets the collection timestamp in seconds since
        January 1 1970 to the value specified by time. The timezone
        difference from UTC

        """
        return _pycbf.cbf_handle_struct_set_datestamp(self, year, month, day, hour, minute, second, timezone, precision)

    def set_dictionary(self, other):
        r"""

        Returns :
        *args   : CBFHandle dictionary

        C prototype: int cbf_set_dictionary (cbf_handle handle,
                         cbf_handle dictionary_in);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_dictionary sets *dictionary to the handle of a CBF which has
        been associated with the CBF handle by cbf_set_dictionary.
        cbf_set_dictionary associates the CBF handle dictionary_in with
        handle as its dictionary. cbf_require_dictionary sets *dictionary to
        the handle of a CBF which has been associated with the CBF handle by
        cbf_set_dictionary or creates a new empty CBF and associates it with
        handle, returning the new handle in *dictionary.
        ARGUMENTS
        handle          CBF handle. dictionary      Pointer to CBF handle of
        dictionary. dictionary_in   CBF handle of dcitionary.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_dictionary(self, other)

    def set_diffrn_id(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_set_diffrn_id (cbf_handle handle, const char *diffrn_id);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_diffrn_id sets the  "diffrn.id " entry of the current
        datablock to the ASCII value diffrn_id.
        This function also changes corresponding  "diffrn_id " entries in
        the  "diffrn_source ",  "diffrn_radiation ",  "diffrn_detector
        " and  "diffrn_measurement " categories.
        ARGUMENTS
        handle      CBF handle. diffrn_id   ASCII value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_diffrn_id(self, arg)

    def set_divergence(self, div_x_source, div_y_source, div_x_y_source):
        r"""

        Returns :
        *args   : Float div_x_source,Float div_y_source,Float div_x_y_source

        C prototype: int cbf_set_divergence (cbf_handle handle, double div_x_source,
                         double      div_y_source, double div_x_y_source);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_divergence sets the source divergence parameters to the
        values specified by div_x_source, div_y_source and div_x_y_source.
        ARGUMENTS
        handle           CBF handle. div_x_source     New value of
        div_x_source. div_y_source     New value of div_y_source.
        div_x_y_source   New value of div_x_y_source.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_divergence(self, div_x_source, div_y_source, div_x_y_source)

    def set_doublevalue(self, format, number):
        r"""

        Returns :
        *args   : String format,Float number

        C prototype: int cbf_set_doublevalue (cbf_handle handle, const char *format,
                         double    number);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_doublevalue sets the item at the current column and row to
        the floating-point value number written as an ASCII string with the
        format specified by format as appropriate for the printf function.
        ARGUMENTS
        handle   CBF handle. format   Format for the number. number
        Floating-point value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_doublevalue(self, format, number)

    def set_gain(self, element_number, gain, gain_esd):
        r"""

        Returns :
        *args   : Float gain,Float gain_esd

        C prototype: int cbf_set_gain (cbf_handle handle, unsigned int element_number,
                         double      gain, double gain_esd);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_gain sets the gain of element number element_number to the
        values specified by gain and gain_esd.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. gain             New gain value.
        gain_esd         New gain_esd value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_gain(self, element_number, gain, gain_esd)

    def set_image(self, element_number, compression, data, elsize, elsign, ndimslow, ndimfast):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int elsign,int dimslow,int dimfast

        C prototype: int cbf_set_image (cbf_handle handle, unsigned int reserved,
                         unsigned      int element_number, unsigned int compression,
                         void *array, size_t      elsize, int elsign, size_t ndimslow,
                         size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_image(self, element_number, compression, data, elsize, elsign, ndimslow, ndimfast)

    def set_image_fs(self, element_number, compression, data, elsize, elsign, ndimfast, ndimslow):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int elsign,int dimfast,int dimslow

        C prototype: int cbf_set_image_fs(cbf_handle handle, unsigned int reserved,
                         unsigned      int element_number, unsigned int compression,
                         void *array, size_t      elsize, int elsign, size_t ndimfast,
                         size_t ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_image_fs(self, element_number, compression, data, elsize, elsign, ndimfast, ndimslow)

    def set_image_sf(self, element_number, compression, data, elsize, elsign, ndimslow, ndimfast):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int elsign,int dimslow,int dimfast

        C prototype: int cbf_set_image_sf(cbf_handle handle, unsigned int reserved,
                         unsigned      int element_number, unsigned int compression,
                         void *array, size_t      elsize, int elsign, size_t ndimslow,
                         size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_image_sf(self, element_number, compression, data, elsize, elsign, ndimslow, ndimfast)

    def set_integerarray(self, compression, binary_id, data, elsize, elsigned, elements):
        r"""

        Returns :
        *args   : int compression,int binary_id,(binary) String data,int elsize,
                  int elsigned,int elements

        C prototype: int cbf_set_integerarray (cbf_handle handle,
                         unsigned int compression, int    binary_id, void *array,
                         size_t elsize, int elsigned, size_t elements);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integerarray sets the binary value of the item at the current
        column and row to an integer array. The array consists of elements
        elements of elsize bytes each, starting at array. The elements are
        signed if elsigned is non-0 and unsigned otherwise. binary_id is the
        binary section identifier. cbf_set_realarray sets the binary value of
        the item at the current column and row to an integer array. The array
        consists of elements elements of elsize bytes each, starting at
        array. binary_id is the binary section identifier.
        The cbf_set_integerarray_wdims, cbf_set_integerarray_wdims_fs,
        cbf_set_integerarray_wdims_sf, cbf_set_realarray_wdims,
        cbf_set_realarray_wdims_fs and cbf_set_realarray_wdims_sf variants
        allow the data header values of byteorder, dimfast, dimmid, dimslow
        and padding to be set to the data byte order, the fastest, second
        fastest and third fastest array dimensions and the size in byte of
        the post data padding to be used.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL       Canonical-code compression (section 3.3.1)
        CBF_PACKED          CCP4-style packing (section 3.3.2) CBF_PACKED_V2
             CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
         Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE            No compression.
        NOTE: This scheme is by far the slowest of the four and uses much
        more disk space. It is intended for routine use with small arrays
        only. With large arrays (like images) it should be used only for
        debugging.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned), for cbf_set_integerarray, or IEEE doubles or
        floats for cbf_set_realarray. If elsize is not equal to sizeof
        (char), sizeof (short) or sizeof (int), the function returns
        CBF_ARGUMENT.
        ARGUMENTS
        handle        CBF handle. compression   Compression method to use.
        binary_id     Integer binary identifier. array         Pointer to the
        source array. elsize        Size in bytes of each source array
        element. elsigned      Set to non-0 if the source array elements are
        signed. elements: The number of elements in the array.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_integerarray(self, compression, binary_id, data, elsize, elsigned, elements)

    def set_integerarray_wdims(self, compression, binary_id, data, elsize, elsigned, elements, bo, dimfast, dimmid, dimslow, padding):
        r"""

        Returns :
        *args   : int compression,int binary_id,(binary) String data,int elsize,
                  int elsigned,int elements,String byteorder,int dimfast,int dimmid,
                  int dimslow,int padding

        C prototype: int cbf_set_integerarray_wdims (cbf_handle handle,
                         unsigned int    compression, int binary_id, void *array,
                         size_t elsize, int elsigned,    size_t elements,
                         const char *byteorder, size_t dimfast, size_t dimmid,
                            size_t dimslow, size_t padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integerarray sets the binary value of the item at the current
        column and row to an integer array. The array consists of elements
        elements of elsize bytes each, starting at array. The elements are
        signed if elsigned is non-0 and unsigned otherwise. binary_id is the
        binary section identifier. cbf_set_realarray sets the binary value of
        the item at the current column and row to an integer array. The array
        consists of elements elements of elsize bytes each, starting at
        array. binary_id is the binary section identifier.
        The cbf_set_integerarray_wdims, cbf_set_integerarray_wdims_fs,
        cbf_set_integerarray_wdims_sf, cbf_set_realarray_wdims,
        cbf_set_realarray_wdims_fs and cbf_set_realarray_wdims_sf variants
        allow the data header values of byteorder, dimfast, dimmid, dimslow
        and padding to be set to the data byte order, the fastest, second
        fastest and third fastest array dimensions and the size in byte of
        the post data padding to be used.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL       Canonical-code compression (section 3.3.1)
        CBF_PACKED          CCP4-style packing (section 3.3.2) CBF_PACKED_V2
             CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
         Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE            No compression.
        NOTE: This scheme is by far the slowest of the four and uses much
        more disk space. It is intended for routine use with small arrays
        only. With large arrays (like images) it should be used only for
        debugging.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned), for cbf_set_integerarray, or IEEE doubles or
        floats for cbf_set_realarray. If elsize is not equal to sizeof
        (char), sizeof (short) or sizeof (int), the function returns
        CBF_ARGUMENT.
        ARGUMENTS
        handle        CBF handle. compression   Compression method to use.
        binary_id     Integer binary identifier. array         Pointer to the
        source array. elsize        Size in bytes of each source array
        element. elsigned      Set to non-0 if the source array elements are
        signed. elements: The number of elements in the array.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_integerarray_wdims(self, compression, binary_id, data, elsize, elsigned, elements, bo, dimfast, dimmid, dimslow, padding)

    def set_integerarray_wdims_fs(self, compression, binary_id, data, elsize, elsigned, elements, bo, dimfast, dimmid, dimslow, padding):
        r"""

        Returns :
        *args   : int compression,int binary_id,(binary) String data,int elsize,
                  int elsigned,int elements,String byteorder,int dimfast,int dimmid,
                  int dimslow,int padding

        C prototype: int cbf_set_integerarray_wdims_fs (cbf_handle handle,
                         unsigned int    compression, int binary_id, void *array,
                         size_t elsize, int elsigned,    size_t elements,
                         const char *byteorder, size_t dimfast, size_t dimmid,
                            size_t dimslow, size_t padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integerarray sets the binary value of the item at the current
        column and row to an integer array. The array consists of elements
        elements of elsize bytes each, starting at array. The elements are
        signed if elsigned is non-0 and unsigned otherwise. binary_id is the
        binary section identifier. cbf_set_realarray sets the binary value of
        the item at the current column and row to an integer array. The array
        consists of elements elements of elsize bytes each, starting at
        array. binary_id is the binary section identifier.
        The cbf_set_integerarray_wdims, cbf_set_integerarray_wdims_fs,
        cbf_set_integerarray_wdims_sf, cbf_set_realarray_wdims,
        cbf_set_realarray_wdims_fs and cbf_set_realarray_wdims_sf variants
        allow the data header values of byteorder, dimfast, dimmid, dimslow
        and padding to be set to the data byte order, the fastest, second
        fastest and third fastest array dimensions and the size in byte of
        the post data padding to be used.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL       Canonical-code compression (section 3.3.1)
        CBF_PACKED          CCP4-style packing (section 3.3.2) CBF_PACKED_V2
             CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
         Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE            No compression.
        NOTE: This scheme is by far the slowest of the four and uses much
        more disk space. It is intended for routine use with small arrays
        only. With large arrays (like images) it should be used only for
        debugging.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned), for cbf_set_integerarray, or IEEE doubles or
        floats for cbf_set_realarray. If elsize is not equal to sizeof
        (char), sizeof (short) or sizeof (int), the function returns
        CBF_ARGUMENT.
        ARGUMENTS
        handle        CBF handle. compression   Compression method to use.
        binary_id     Integer binary identifier. array         Pointer to the
        source array. elsize        Size in bytes of each source array
        element. elsigned      Set to non-0 if the source array elements are
        signed. elements: The number of elements in the array.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_integerarray_wdims_fs(self, compression, binary_id, data, elsize, elsigned, elements, bo, dimfast, dimmid, dimslow, padding)

    def set_integerarray_wdims_sf(self, compression, binary_id, data, elsize, elsigned, elements, bo, dimslow, dimmid, dimfast, padding):
        r"""

        Returns :
        *args   : int compression,int binary_id,(binary) String data,int elsize,
                  int elsigned,int elements,String byteorder,int dimslow,int dimmid,
                  int dimfast,int padding

        C prototype: int cbf_set_integerarray_wdims_sf (cbf_handle handle,
                         unsigned int    compression, int binary_id, void *array,
                         size_t elsize, int elsigned,    size_t elements,
                         const char *byteorder, size_t dimslow, size_t dimmid,
                            size_t dimfast, size_t padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integerarray sets the binary value of the item at the current
        column and row to an integer array. The array consists of elements
        elements of elsize bytes each, starting at array. The elements are
        signed if elsigned is non-0 and unsigned otherwise. binary_id is the
        binary section identifier. cbf_set_realarray sets the binary value of
        the item at the current column and row to an integer array. The array
        consists of elements elements of elsize bytes each, starting at
        array. binary_id is the binary section identifier.
        The cbf_set_integerarray_wdims, cbf_set_integerarray_wdims_fs,
        cbf_set_integerarray_wdims_sf, cbf_set_realarray_wdims,
        cbf_set_realarray_wdims_fs and cbf_set_realarray_wdims_sf variants
        allow the data header values of byteorder, dimfast, dimmid, dimslow
        and padding to be set to the data byte order, the fastest, second
        fastest and third fastest array dimensions and the size in byte of
        the post data padding to be used.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL       Canonical-code compression (section 3.3.1)
        CBF_PACKED          CCP4-style packing (section 3.3.2) CBF_PACKED_V2
             CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
         Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE            No compression.
        NOTE: This scheme is by far the slowest of the four and uses much
        more disk space. It is intended for routine use with small arrays
        only. With large arrays (like images) it should be used only for
        debugging.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned), for cbf_set_integerarray, or IEEE doubles or
        floats for cbf_set_realarray. If elsize is not equal to sizeof
        (char), sizeof (short) or sizeof (int), the function returns
        CBF_ARGUMENT.
        ARGUMENTS
        handle        CBF handle. compression   Compression method to use.
        binary_id     Integer binary identifier. array         Pointer to the
        source array. elsize        Size in bytes of each source array
        element. elsigned      Set to non-0 if the source array elements are
        signed. elements: The number of elements in the array.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_integerarray_wdims_sf(self, compression, binary_id, data, elsize, elsigned, elements, bo, dimslow, dimmid, dimfast, padding)

    def set_integervalue(self, number):
        r"""

        Returns : int number
        *args   :

        C prototype: int cbf_set_integervalue (cbf_handle handle, int number);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integervalue sets the item at the current column and row to
        the integer value number written as a decimal ASCII string.
        ARGUMENTS
        handle   CBF handle. number   Integer value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_integervalue(self, number)

    def set_integration_time(self, time):
        r"""

        Returns :
        *args   : Float time

        C prototype: int cbf_set_integration_time (cbf_handle handle,
                         unsigned int reserved,      double time);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integration_time sets the integration time in seconds to the
        value specified by time. The parameter reserved is presently unused
        and should be set to 0.
        ARGUMENTS
        handle             CBF handle. reserved           Unused. Any value
        other than 0 is invalid. time Integration   time in seconds.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_integration_time(self, time)

    def set_orientation_matrix(self, m0, m1, m2, m3, m4, m5, m6, m7, m8):
        r"""

        Returns :
        *args   : Float matrix_0,Float matrix_1,Float matrix_2,Float matrix_3,
                  Float matrix_4,Float matrix_5,Float matrix_6,Float matrix_7,
                  Float matrix_8

        C prototype: int cbf_set_orientation_matrix (cbf_handle handle,
                         double ub_matrix[9]);

        CBFLib documentation:
        DESCRIPTION
        cbf_get_orientation_matrix sets ub_matrix to point to the array of
        orientation matrix entries in the  "diffrn " category in the order
        of columns:
         "UB[1][1] "  "UB[1][2] "  "UB[1][3] "  "UB[2][1] "
        "UB[2][2] "  "UB[2][3] "  "UB[3][1] "  "UB[3][2] "
        "UB[3][3] "
        cbf_set_orientation_matrix sets the values in the  "diffrn "
        category to the values pointed to by ub_matrix.
        ARGUMENTS
        handle     CBF handle. ubmatric   Source or destination array of 9
        doubles giving the orientation matrix parameters.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_orientation_matrix(self, m0, m1, m2, m3, m4, m5, m6, m7, m8)

    def set_overload(self, element_number, overload):
        r"""

        Returns :
        *args   : Integer element_number,Float overload

        C prototype: int cbf_set_overload (cbf_handle handle,
                         unsigned int element_number,      double overload);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_overload sets the overload value of element number
        element_number to overload.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. overload         New overload value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_overload(self, element_number, overload)

    def set_pixel_size(self, element_number, axis_number, psize):
        r"""

        Returns :
        *args   : Int element_number,Int axis_number,Float pixel size

        C prototype: int cbf_set_pixel_size (cbf_handle handle,
                         unsigned int element_number,      int axis_number,
                         double psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_pixel_size and cbf_set_pixel_size_sf set the item in the
        "size " column of the  "array_structure_list " category at the
        row which matches axis axis_number of the detector element
        element_number converting the double pixel size psize from meters to
        millimeters in storing it in the  "size " column for the axis
        axis_number of the detector element element_number. The axis_number
        is numbered from 1, starting with the slowest axis.
        cbf_set_pixel_size_fs sets the item in the  "size " column of the
        "array_structure_list " category at the row which matches axis
        axis_number of the detector element element_number converting the
        double pixel size psize from meters to millimeters in storing it in
        the  "size " column for the axis axis_number of the detector
        element element_number. The axis_number is numbered from 1, starting
        with the fastest axis.
        If a negative axis number is given, the order of axes is reversed, so
        that -1 specifies the slowest axis for cbf_get_pixel_size_fs and the
        fastest axis for cbf_get_pixel_size_sf.
        If the  "array_structure_list " category does not already exist, it
        is created.
        If the appropriate row in the  "array_structure_list " catgeory
        does not already exist, it is created.
        If the pixel size is not given explcitly in the  "array_element_size
        category ", the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. axis_number      The number of the
        axis, fastest first, starting from 1.

        """
        return _pycbf.cbf_handle_struct_set_pixel_size(self, element_number, axis_number, psize)

    def set_pixel_size_fs(self, element_number, axis_number, psize):
        r"""

        Returns :
        *args   : Int element_number,Int axis_number,Float pixel size

        C prototype: int cbf_set_pixel_size_fs(cbf_handle handle,
                         unsigned int      element_number, int axis_number,
                         double psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_pixel_size and cbf_set_pixel_size_sf set the item in the
        "size " column of the  "array_structure_list " category at the
        row which matches axis axis_number of the detector element
        element_number converting the double pixel size psize from meters to
        millimeters in storing it in the  "size " column for the axis
        axis_number of the detector element element_number. The axis_number
        is numbered from 1, starting with the slowest axis.
        cbf_set_pixel_size_fs sets the item in the  "size " column of the
        "array_structure_list " category at the row which matches axis
        axis_number of the detector element element_number converting the
        double pixel size psize from meters to millimeters in storing it in
        the  "size " column for the axis axis_number of the detector
        element element_number. The axis_number is numbered from 1, starting
        with the fastest axis.
        If a negative axis number is given, the order of axes is reversed, so
        that -1 specifies the slowest axis for cbf_get_pixel_size_fs and the
        fastest axis for cbf_get_pixel_size_sf.
        If the  "array_structure_list " category does not already exist, it
        is created.
        If the appropriate row in the  "array_structure_list " catgeory
        does not already exist, it is created.
        If the pixel size is not given explcitly in the  "array_element_size
        category ", the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. axis_number      The number of the
        axis, fastest first, starting from 1.

        """
        return _pycbf.cbf_handle_struct_set_pixel_size_fs(self, element_number, axis_number, psize)

    def set_pixel_size_sf(self, element_number, axis_number, psize):
        r"""

        Returns :
        *args   : Int element_number,Int axis_number,Float pixel size

        C prototype: int cbf_set_pixel_size_sf(cbf_handle handle,
                         unsigned int      element_number, int axis_number,
                         double psize);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_pixel_size and cbf_set_pixel_size_sf set the item in the
        "size " column of the  "array_structure_list " category at the
        row which matches axis axis_number of the detector element
        element_number converting the double pixel size psize from meters to
        millimeters in storing it in the  "size " column for the axis
        axis_number of the detector element element_number. The axis_number
        is numbered from 1, starting with the slowest axis.
        cbf_set_pixel_size_fs sets the item in the  "size " column of the
        "array_structure_list " category at the row which matches axis
        axis_number of the detector element element_number converting the
        double pixel size psize from meters to millimeters in storing it in
        the  "size " column for the axis axis_number of the detector
        element element_number. The axis_number is numbered from 1, starting
        with the fastest axis.
        If a negative axis number is given, the order of axes is reversed, so
        that -1 specifies the slowest axis for cbf_get_pixel_size_fs and the
        fastest axis for cbf_get_pixel_size_sf.
        If the  "array_structure_list " category does not already exist, it
        is created.
        If the appropriate row in the  "array_structure_list " catgeory
        does not already exist, it is created.
        If the pixel size is not given explcitly in the  "array_element_size
        category ", the function returns CBF_NOTFOUND.
        ARGUMENTS
        handle           CBF handle. element_number   The number of the
        detector element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. axis_number      The number of the
        axis, fastest first, starting from 1.

        """
        return _pycbf.cbf_handle_struct_set_pixel_size_sf(self, element_number, axis_number, psize)

    def set_polarization(self, polarizn_source_ratio, polarizn_source_norm):
        r"""

        Returns :
        *args   : Float polarizn_source_ratio,Float polarizn_source_norm

        C prototype: int cbf_set_polarization (cbf_handle handle,
                         double      polarizn_source_ratio,
                         double polarizn_source_norm);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_polarization sets the source polarization to the values
        specified by polarizn_source_ratio and polarizn_source_norm.
        ARGUMENTS
        handle                  CBF handle. polarizn_source_ratio   New value
        of polarizn_source_ratio. polarizn_source_norm    New value of
        polarizn_source_norm.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_polarization(self, polarizn_source_ratio, polarizn_source_norm)

    def set_real_3d_image(self, element_number, compression, data, elsize, ndimslow, ndimmid, ndimfast):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int dimslow,int dimmid,int dimfast

        C prototype: int cbf_set_real_3d_image (cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         unsigned int compression, void      *array,size_t elsize,
                         size_t ndimslow, size_t ndimmid, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_real_3d_image(self, element_number, compression, data, elsize, ndimslow, ndimmid, ndimfast)

    def set_real_3d_image_fs(self, element_number, compression, data, elsize, ndimfast, ndimmid, ndimslow):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int dimfast,int dimmid,int dimslow

        C prototype: int cbf_set_real_3d_image_fs(cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         unsigned int compression, void      *array,size_t elsize,
                         size_t ndimfast, size_t ndimmid, size_t ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_real_3d_image_fs(self, element_number, compression, data, elsize, ndimfast, ndimmid, ndimslow)

    def set_real_3d_image_sf(self, element_number, compression, data, elsize, ndimslow, ndimmid, ndimfast):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int dimslow,int dimmid,int dimfast

        C prototype: int cbf_set_real_3d_image_sf(cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         unsigned int compression, void      *array,size_t elsize,
                         size_t ndimslow, size_t ndimmid, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_real_3d_image_sf(self, element_number, compression, data, elsize, ndimslow, ndimmid, ndimfast)

    def set_real_image(self, element_number, compression, data, elsize, ndimslow, ndimfast):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int dimslow,int dimfast

        C prototype: int cbf_set_real_image (cbf_handle handle, unsigned int reserved,
                              unsigned int element_number, unsigned int compression,
                         void      *array,size_t elsize, size_t ndimslow,
                         size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_real_image(self, element_number, compression, data, elsize, ndimslow, ndimfast)

    def set_real_image_fs(self, element_number, compression, data, elsize, ndimfast, ndimslow):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int dimfast,int dimslow

        C prototype: int cbf_set_real_image_fs(cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         unsigned int compression, void      *array,size_t elsize,
                         size_t ndimfast, size_t ndimslow);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_real_image_fs(self, element_number, compression, data, elsize, ndimfast, ndimslow)

    def set_real_image_sf(self, element_number, compression, data, elsize, ndimslow, ndimfast):
        r"""

        Returns :
        *args   : int element_number,int compression,(binary) String data,int elsize,
                  int dimslow,int dimfast

        C prototype: int cbf_set_real_image_sf(cbf_handle handle,
                         unsigned int reserved,      unsigned int element_number,
                         unsigned int compression, void      *array,size_t elsize,
                         size_t ndimslow, size_t ndimfast);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_image, cbf_set_image_fs and cbf_set_image_sf write the image
        array for element number element_number. The array consists of
        ndimfast×ndimslow elements of elsize bytes each, starting at array.
        The elements are signed if elsign is non-zero and unsigned otherwise.
        cbf_set_real_image, cbf_set_real_image_fs and cbf_set_real_image_sf
        write the image array for element number element_number. The array
        consists of ndimfast×ndimslow IEEE double or float elements of elsize
        bytes each, starting at array. cbf_set_3d_image, cbf_set_3d_image_fs
        and cbf_set_3d_image_sf write the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow
        elements of elsize bytes each, starting at array. The elements are
        signed if elsign is non-0 and unsigned otherwise.
        cbf_set_real_3d_image, cbf_set_real_3d_image_fs and
        cbf_set_real_3d_image_sf writes the 3D image array for element number
        element_number. The array consists of ndimfast×ndimmid×ndimslow IEEE
        double or float elements of elsize bytes each, starting at array.
        The _fs calls give the dimensions in a fast-to-slow order. The calls
        with no suffix and the calls _sf calls give the dimensions in
        slow-to-fast order
        If the array is 1-dimensional, ndimslow should be the array size and
        ndimfast and, for the 3D calls, ndimmid, should be set to 1. If the
        array is 2-dimensional and the 3D calls are used, ndimslow and
        ndimmid should be used for the array dimensions and ndimfast should
        be set to 1.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL     Canonical-code compression (section 3.3.1)
        CBF_PACKED        CCP4-style packing (section 3.3.2) CBF_PACKED_V2
           CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
        Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE          No compression.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned)for cbf_set_image, or IEEE doubles or floats for
        cbf_set_real_image. If elsize is not equal to sizeof (short), sizeof
        (int), sizeof(double) or sizeof(float), the function returns
        CBF_ARGUMENT.
        The parameter reserved is presently unused and should be set to 0.
        ARGUMENTS
        handle           CBF handle. reserved         Unused. Any value other
        than 0 is invalid. element_number   The number of the detector
        element counting from 0 by order of appearance in the
        "diffrn_data_frame " category. compression      Compression type.
        array            Pointer to the image array. elsize           Size in
        bytes of each image array element. elsigned         Set to non-0 if
        the image array elements are signed. ndimslow         Slowest array
        dimension. ndimmid          Second slowest array dimension. ndimfast
               Fastest array dimension.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_real_image_sf(self, element_number, compression, data, elsize, ndimslow, ndimfast)

    def set_realarray(self, compression, binary_id, data, elsize, elements):
        r"""

        Returns :
        *args   : int compression,int binary_id,(binary) String data,int elsize,
                  int elements

        C prototype: int cbf_set_realarray (cbf_handle handle,
                         unsigned int compression, int    binary_id, void *array,
                         size_t elsize, size_t elements);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integerarray sets the binary value of the item at the current
        column and row to an integer array. The array consists of elements
        elements of elsize bytes each, starting at array. The elements are
        signed if elsigned is non-0 and unsigned otherwise. binary_id is the
        binary section identifier. cbf_set_realarray sets the binary value of
        the item at the current column and row to an integer array. The array
        consists of elements elements of elsize bytes each, starting at
        array. binary_id is the binary section identifier.
        The cbf_set_integerarray_wdims, cbf_set_integerarray_wdims_fs,
        cbf_set_integerarray_wdims_sf, cbf_set_realarray_wdims,
        cbf_set_realarray_wdims_fs and cbf_set_realarray_wdims_sf variants
        allow the data header values of byteorder, dimfast, dimmid, dimslow
        and padding to be set to the data byte order, the fastest, second
        fastest and third fastest array dimensions and the size in byte of
        the post data padding to be used.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL       Canonical-code compression (section 3.3.1)
        CBF_PACKED          CCP4-style packing (section 3.3.2) CBF_PACKED_V2
             CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
         Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE            No compression.
        NOTE: This scheme is by far the slowest of the four and uses much
        more disk space. It is intended for routine use with small arrays
        only. With large arrays (like images) it should be used only for
        debugging.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned), for cbf_set_integerarray, or IEEE doubles or
        floats for cbf_set_realarray. If elsize is not equal to sizeof
        (char), sizeof (short) or sizeof (int), the function returns
        CBF_ARGUMENT.
        ARGUMENTS
        handle        CBF handle. compression   Compression method to use.
        binary_id     Integer binary identifier. array         Pointer to the
        source array. elsize        Size in bytes of each source array
        element. elsigned      Set to non-0 if the source array elements are
        signed. elements: The number of elements in the array.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_realarray(self, compression, binary_id, data, elsize, elements)

    def set_realarray_wdims(self, compression, binary_id, data, elsize, elements, bo, dimfast, dimmid, dimslow, padding):
        r"""

        Returns :
        *args   : int compression,int binary_id,(binary) String data,int elsize,
                  int elements,String byteorder,int dimfast,int dimmid,int dimslow,
                  int padding

        C prototype: int cbf_set_realarray_wdims (cbf_handle handle,
                         unsigned int compression,    int binary_id, void *array,
                         size_t elsize, size_t elements, const char    *byteorder,
                         size_t dimfast, size_t dimmid, size_t dimslow,
                         size_t    padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integerarray sets the binary value of the item at the current
        column and row to an integer array. The array consists of elements
        elements of elsize bytes each, starting at array. The elements are
        signed if elsigned is non-0 and unsigned otherwise. binary_id is the
        binary section identifier. cbf_set_realarray sets the binary value of
        the item at the current column and row to an integer array. The array
        consists of elements elements of elsize bytes each, starting at
        array. binary_id is the binary section identifier.
        The cbf_set_integerarray_wdims, cbf_set_integerarray_wdims_fs,
        cbf_set_integerarray_wdims_sf, cbf_set_realarray_wdims,
        cbf_set_realarray_wdims_fs and cbf_set_realarray_wdims_sf variants
        allow the data header values of byteorder, dimfast, dimmid, dimslow
        and padding to be set to the data byte order, the fastest, second
        fastest and third fastest array dimensions and the size in byte of
        the post data padding to be used.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL       Canonical-code compression (section 3.3.1)
        CBF_PACKED          CCP4-style packing (section 3.3.2) CBF_PACKED_V2
             CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
         Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE            No compression.
        NOTE: This scheme is by far the slowest of the four and uses much
        more disk space. It is intended for routine use with small arrays
        only. With large arrays (like images) it should be used only for
        debugging.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned), for cbf_set_integerarray, or IEEE doubles or
        floats for cbf_set_realarray. If elsize is not equal to sizeof
        (char), sizeof (short) or sizeof (int), the function returns
        CBF_ARGUMENT.
        ARGUMENTS
        handle        CBF handle. compression   Compression method to use.
        binary_id     Integer binary identifier. array         Pointer to the
        source array. elsize        Size in bytes of each source array
        element. elsigned      Set to non-0 if the source array elements are
        signed. elements: The number of elements in the array.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_realarray_wdims(self, compression, binary_id, data, elsize, elements, bo, dimfast, dimmid, dimslow, padding)

    def set_realarray_wdims_fs(self, compression, binary_id, data, elsize, elements, bo, dimfast, dimmid, dimslow, padding):
        r"""

        Returns :
        *args   : int compression,int binary_id,(binary) String data,int elsize,
                  int elements,String byteorder,int dimfast,int dimmid,int dimslow,
                  int padding

        C prototype: int cbf_set_realarray_wdims_fs (cbf_handle handle,
                         unsigned int    compression, int binary_id, void *array,
                         size_t elsize, size_t elements,    const char *byteorder,
                         size_t dimfast, size_t dimmid, size_t dimslow,
                            size_t padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integerarray sets the binary value of the item at the current
        column and row to an integer array. The array consists of elements
        elements of elsize bytes each, starting at array. The elements are
        signed if elsigned is non-0 and unsigned otherwise. binary_id is the
        binary section identifier. cbf_set_realarray sets the binary value of
        the item at the current column and row to an integer array. The array
        consists of elements elements of elsize bytes each, starting at
        array. binary_id is the binary section identifier.
        The cbf_set_integerarray_wdims, cbf_set_integerarray_wdims_fs,
        cbf_set_integerarray_wdims_sf, cbf_set_realarray_wdims,
        cbf_set_realarray_wdims_fs and cbf_set_realarray_wdims_sf variants
        allow the data header values of byteorder, dimfast, dimmid, dimslow
        and padding to be set to the data byte order, the fastest, second
        fastest and third fastest array dimensions and the size in byte of
        the post data padding to be used.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL       Canonical-code compression (section 3.3.1)
        CBF_PACKED          CCP4-style packing (section 3.3.2) CBF_PACKED_V2
             CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
         Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE            No compression.
        NOTE: This scheme is by far the slowest of the four and uses much
        more disk space. It is intended for routine use with small arrays
        only. With large arrays (like images) it should be used only for
        debugging.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned), for cbf_set_integerarray, or IEEE doubles or
        floats for cbf_set_realarray. If elsize is not equal to sizeof
        (char), sizeof (short) or sizeof (int), the function returns
        CBF_ARGUMENT.
        ARGUMENTS
        handle        CBF handle. compression   Compression method to use.
        binary_id     Integer binary identifier. array         Pointer to the
        source array. elsize        Size in bytes of each source array
        element. elsigned      Set to non-0 if the source array elements are
        signed. elements: The number of elements in the array.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_realarray_wdims_fs(self, compression, binary_id, data, elsize, elements, bo, dimfast, dimmid, dimslow, padding)

    def set_realarray_wdims_sf(self, compression, binary_id, data, elsize, elements, bo, dimslow, dimmid, dimfast, padding):
        r"""

        Returns :
        *args   : int compression,int binary_id,(binary) String data,int elsize,
                  int elements,String byteorder,int dimslow,int dimmid,int dimfast,
                  int padding

        C prototype: int cbf_set_realarray_wdims_sf (cbf_handle handle,
                         unsigned int    compression, int binary_id, void *array,
                         size_t elsize, size_t elements,    const char *byteorder,
                         size_t dimslow, size_t dimmid, size_t dimfast,
                            size_t padding);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_integerarray sets the binary value of the item at the current
        column and row to an integer array. The array consists of elements
        elements of elsize bytes each, starting at array. The elements are
        signed if elsigned is non-0 and unsigned otherwise. binary_id is the
        binary section identifier. cbf_set_realarray sets the binary value of
        the item at the current column and row to an integer array. The array
        consists of elements elements of elsize bytes each, starting at
        array. binary_id is the binary section identifier.
        The cbf_set_integerarray_wdims, cbf_set_integerarray_wdims_fs,
        cbf_set_integerarray_wdims_sf, cbf_set_realarray_wdims,
        cbf_set_realarray_wdims_fs and cbf_set_realarray_wdims_sf variants
        allow the data header values of byteorder, dimfast, dimmid, dimslow
        and padding to be set to the data byte order, the fastest, second
        fastest and third fastest array dimensions and the size in byte of
        the post data padding to be used.
        The array will be compressed using the compression scheme specifed by
        compression. Currently, the available schemes are:
        CBF_CANONICAL       Canonical-code compression (section 3.3.1)
        CBF_PACKED          CCP4-style packing (section 3.3.2) CBF_PACKED_V2
             CCP4-style packing, version 2 (section 3.3.2) CBF_BYTE_OFFSET
         Simple  "byte_offset " compression. CBF_NIBBLE_OFFSET   Simple
        "nibble_offset " compression. CBF_NONE            No compression.
        NOTE: This scheme is by far the slowest of the four and uses much
        more disk space. It is intended for routine use with small arrays
        only. With large arrays (like images) it should be used only for
        debugging.
        The values compressed are limited to 64 bits. If any element in the
        array is larger than 64 bits, the value compressed is the nearest
        64-bit value.
        Currently, the source array must consist of chars, shorts or ints
        (signed or unsigned), for cbf_set_integerarray, or IEEE doubles or
        floats for cbf_set_realarray. If elsize is not equal to sizeof
        (char), sizeof (short) or sizeof (int), the function returns
        CBF_ARGUMENT.
        ARGUMENTS
        handle        CBF handle. compression   Compression method to use.
        binary_id     Integer binary identifier. array         Pointer to the
        source array. elsize        Size in bytes of each source array
        element. elsigned      Set to non-0 if the source array elements are
        signed. elements: The number of elements in the array.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_realarray_wdims_sf(self, compression, binary_id, data, elsize, elements, bo, dimslow, dimmid, dimfast, padding)

    def set_reciprocal_cell(self, cell):
        r"""

        Returns :
        *args   : double cell[6]

        C prototype: int cbf_set_reciprocal_cell (cbf_handle handle, double cell[6],
                         double      cell_esd[6] );

        CBFLib documentation:
        DESCRIPTION
        cbf_set_reciprocal_cell sets the reciprocal cell parameters to the
        double values given in cell[0:2] for the reciprocal cell edge lengths
        a^*, b^* and c^* in Ångstroms^-1, the double values given in
        cell[3:5] for the reciprocal cell angles α^*, β^* and γ^* in degrees,
        the double values given in cell_esd[0:2] for the estimated strandard
        deviations of the reciprocal cell edge lengths a^*, b^* and c^* in
        Ångstroms, and the double values given in cell_esd[3:5] for the
        estimated standard deviations of the reciprocal cell angles α^*, β^*
        and γ^* in degrees.
        The values are placed in the first row of the  "cell " category. If
        no value has been given for  "_cell.entry_id ", it is set to the
        value of the  "diffrn.id " entry of the current data block.
        cell or cell_esd may be NULL.
        If cell is NULL, the reciprocal cell parameters are not set.
        If cell_esd is NULL, the reciprocal cell parameter esds are not set.
        If the  "cell " category is not present, it is created. If any of
        the necessary columns are not present, they are created.
        ARGUMENTS
        handle     CBF handle. cell       Pointer to the array of 6 doubles
        for the reciprocal cell parameters. cell_esd   Pointer to the array
        of 6 doubles for the reciprocal cell parameter esds.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_reciprocal_cell(self, cell)

    def set_reciprocal_cell_esd(self, cell_esd):
        r"""

        Returns :
        *args   : double cell_esd[6]

        C prototype: int cbf_set_reciprocal_cell (cbf_handle handle, double cell[6],
                         double      cell_esd[6] );

        CBFLib documentation:
        DESCRIPTION
        cbf_set_reciprocal_cell sets the reciprocal cell parameters to the
        double values given in cell[0:2] for the reciprocal cell edge lengths
        a^*, b^* and c^* in Ångstroms^-1, the double values given in
        cell[3:5] for the reciprocal cell angles α^*, β^* and γ^* in degrees,
        the double values given in cell_esd[0:2] for the estimated strandard
        deviations of the reciprocal cell edge lengths a^*, b^* and c^* in
        Ångstroms, and the double values given in cell_esd[3:5] for the
        estimated standard deviations of the reciprocal cell angles α^*, β^*
        and γ^* in degrees.
        The values are placed in the first row of the  "cell " category. If
        no value has been given for  "_cell.entry_id ", it is set to the
        value of the  "diffrn.id " entry of the current data block.
        cell or cell_esd may be NULL.
        If cell is NULL, the reciprocal cell parameters are not set.
        If cell_esd is NULL, the reciprocal cell parameter esds are not set.
        If the  "cell " category is not present, it is created. If any of
        the necessary columns are not present, they are created.
        ARGUMENTS
        handle     CBF handle. cell       Pointer to the array of 6 doubles
        for the reciprocal cell parameters. cell_esd   Pointer to the array
        of 6 doubles for the reciprocal cell parameter esds.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_reciprocal_cell_esd(self, cell_esd)

    def set_saveframename(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_set_saveframename (cbf_handle handle,
                         const char *saveframename);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_datablockname changes the name of the current data block to
        datablockname. cbf_set_saveframename changes the name of the current
        save frame to saveframename.
        If a data block or save frame with this name already exists
        (comparison is case-insensitive), the function returns CBF_IDENTICAL.
        ARGUMENTS
        handle          CBF handle. datablockname   The new data block name.
        datablockname   The new save frame name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_saveframename(self, arg)

    def set_tag_category(self, tagname, categoryname_in):
        r"""

        Returns :
        *args   : String tagname,String categoryname_in

        C prototype: int cbf_set_tag_category (cbf_handle handle, const char* tagname,
                         const      char* categoryname_in);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_tag_category sets categoryname to the category associated
        with tagname in the dictionary associated with handle.
        cbf_set_tag_category upddates the dictionary associated with handle
        to indicated that tagname is in category categoryname_in.
        ARGUMENTS
        handle            CBF handle. tagname           tag name.
        categoryname      pointer to a returned category name.
        categoryname_in   input category name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_tag_category(self, tagname, categoryname_in)

    def set_tag_root(self, tagname, tagroot_in):
        r"""

        Returns :
        *args   : String tagname,String tagroot_in

        C prototype: int cbf_set_tag_root (cbf_handle handle, const char* tagname,
                         const      char*tagroot_in);

        CBFLib documentation:
        DESCRIPTION
        cbf_find_tag_root sets *tagroot to the root tag of which tagname is
        an alias. cbf_set_tag_root sets tagname as an alias of tagroot_in in
        the dictionary associated with handle, creating the dictionary if
        necessary. cbf_require_tag_root sets *tagroot to the root tag of
        which tagname is an alias, if there is one, or to the value of
        tagname, if tagname is not an alias.
        A returned tagroot string must not be modified in any way.
        ARGUMENTS
        handle       CBF handle. tagname      tag name which may be an alias.
        tagroot      pointer to a returned tag root name. tagroot_in   input
        tag root name.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_tag_root(self, tagname, tagroot_in)

    def set_timestamp(self, time, timezone, precision):
        r"""

        Returns :
        *args   : Float time,Integer timezone,Float precision

        C prototype: int cbf_set_timestamp (cbf_handle handle, unsigned int reserved,
                         double      time, int timezone, double precision);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_timestamp sets the collection timestamp in seconds since
        January 1 1970 to the value specified by time. The timezone
        difference from UTC

        """
        return _pycbf.cbf_handle_struct_set_timestamp(self, time, timezone, precision)

    def set_typeofvalue(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_set_typeofvalue (cbf_handle handle,
                         const char *typeofvalue);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_typeofvalue sets the type of the item at the current column
        and row to the type specified by the ASCII character string given by
        typeofvalue. The strings that may be used are:
         "null " for a null value indicated by a  ". " or a  "? "
        "bnry " for a binary value  "word " for an unquoted string
        "dblq " for a double-quoted string  "sglq " for a single-quoted
        string  "text " for a semicolon-quoted string (multiline text
        field)  "prns " for a parenthesis-bracketed string (multiline text
        field)  "brcs " for a brace-bracketed string (multiline text field)
         "bkts " for a square-bracket-bracketed string (multiline text
        field)  "tsqs " for a treble-single-quote quoted string (multiline
        text field)  "tdqs " for a treble-double-quote quoted string
        (multiline text field)
        Not all types may be used for all values. Not all types are valid for
        all type of CIF files. In partcular the types  "prns ",  "brcs ",
         "bkts " were introduced with DDLm and are not valid in DDL1 or
        DDL2 CIFS. The types  "tsqs " and  "tdqs " are not formally part
        of the CIF syntax. No changes may be made to the type of binary
        values. You may not set the type of a string that contains a single
        quote followed by a blank or a tab or which contains multiple lines
        to  "sglq ". You may not set the type of a string that contains a
        double quote followed by a blank or a tab or which contains multiple
        lines to  "dblq ".
        ARGUMENTS
        handle        CBF handle. typeofvalue   ASCII string for desired type
        of value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_typeofvalue(self, arg)

    def set_unit_cell(self, cell):
        r"""

        Returns :
        *args   : double cell[6]

        C prototype: int cbf_set_unit_cell (cbf_handle handle, double cell[6],
                         double      cell_esd[6] );

        CBFLib documentation:
        DESCRIPTION
        cbf_set_unit_cell sets the cell parameters to the double values given
        in cell[0:2] for the cell edge lengths a, b and c in Ångstroms, the
        double values given in cell[3:5] for the cell angles α, β and γ in
        degrees, the double values given in cell_esd[0:2] for the estimated
        strandard deviations of the cell edge lengths a, b and c in
        Ångstroms, and the double values given in cell_esd[3:5] for the
        estimated standard deviations of the the cell angles α, β and γ in
        degrees.
        The values are placed in the first row of the  "cell " category. If
        no value has been given for  "_cell.entry_id ", it is set to the
        value of the  "diffrn.id " entry of the current data block.
        cell or cell_esd may be NULL.
        If cell is NULL, the cell parameters are not set.
        If cell_esd is NULL, the cell parameter esds are not set.
        If the  "cell " category is not present, it is created. If any of
        the necessary columns are not present, they are created.
        ARGUMENTS
        handle     CBF handle. cell       Pointer to the array of 6 doubles
        for the cell parameters. cell_esd   Pointer to the array of 6 doubles
        for the cell parameter esds.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_unit_cell(self, cell)

    def set_unit_cell_esd(self, cell_esd):
        r"""

        Returns :
        *args   : double cell_esd[6]

        C prototype: int cbf_set_unit_cell (cbf_handle handle, double cell[6],
                         double      cell_esd[6] );

        CBFLib documentation:
        DESCRIPTION
        cbf_set_unit_cell sets the cell parameters to the double values given
        in cell[0:2] for the cell edge lengths a, b and c in Ångstroms, the
        double values given in cell[3:5] for the cell angles α, β and γ in
        degrees, the double values given in cell_esd[0:2] for the estimated
        strandard deviations of the cell edge lengths a, b and c in
        Ångstroms, and the double values given in cell_esd[3:5] for the
        estimated standard deviations of the the cell angles α, β and γ in
        degrees.
        The values are placed in the first row of the  "cell " category. If
        no value has been given for  "_cell.entry_id ", it is set to the
        value of the  "diffrn.id " entry of the current data block.
        cell or cell_esd may be NULL.
        If cell is NULL, the cell parameters are not set.
        If cell_esd is NULL, the cell parameter esds are not set.
        If the  "cell " category is not present, it is created. If any of
        the necessary columns are not present, they are created.
        ARGUMENTS
        handle     CBF handle. cell       Pointer to the array of 6 doubles
        for the cell parameters. cell_esd   Pointer to the array of 6 doubles
        for the cell parameter esds.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_unit_cell_esd(self, cell_esd)

    def set_value(self, arg):
        r"""

        Returns : string
        *args   :

        C prototype: int cbf_set_value (cbf_handle handle, const char *value);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_value sets the item at the current column and row to the
        ASCII value value.
        ARGUMENTS
        handle   CBF handle. value    ASCII value.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        SEE ALSO

        """
        return _pycbf.cbf_handle_struct_set_value(self, arg)

    def set_wavelength(self, wavelength):
        r"""

        Returns : double wavelength
        *args   :

        C prototype: int cbf_set_wavelength (cbf_handle handle, double wavelength);

        CBFLib documentation:
        DESCRIPTION
        cbf_set_wavelength sets the current wavelength in Å to wavelength.
        ARGUMENTS
        handle       CBF handle. wavelength   Wavelength in Å.
        RETURN VALUE
        Returns an error code on failure or 0 for success.
        ----------------------------------------------------------------------

        """
        return _pycbf.cbf_handle_struct_set_wavelength(self, wavelength)

    def write_file(self, filename, ciforcbf, headers, encoding):
        r"""

        Returns :
        *args   : String filename,Integer ciforcbf,Integer Headers,Integer encoding

        C prototype: int cbf_write_file (cbf_handle handle, FILE *file, int readable,
                         int    ciforcbf, int flags, int encoding);

        CBFLib documentation:
        DESCRIPTION
        cbf_write_file writes the CBF object specified by handle into the
        file file, following CIF 1.0 conventions of 80 character lines.
        cbf_write_widefile writes the CBF object specified by handle into the
        file file, following CIF 1.1 conventions of 2048 character lines. A
        warning is issued to stderr for ascii lines over the limit, and an
        attempt is made to fold lines to fit. No test is performed on binary
        sections.
        If a dictionary has been provided, aliases will be applied on output.
        Unlike cbf_read_file, the file does not have to be random-access.
        If the file is random-access and readable, readable can be set to
        non-0 to indicate to CBFlib that the file can be used as a buffer to
        conserve disk space. If the file is not random-access or not
        readable, readable must be 0.

        """
        return _pycbf.cbf_handle_struct_write_file(self, filename, ciforcbf, headers, encoding)

    def write_widefile(self, filename, ciforcbf, headers, encoding):
        r"""

        Returns :
        *args   : String filename,Integer ciforcbf,Integer Headers,Integer encoding

        C prototype: int cbf_write_widefile (cbf_handle handle, FILE *file,
                         int readable, int    ciforcbf, int flags, int encoding);

        CBFLib documentation:
        DESCRIPTION
        cbf_write_file writes the CBF object specified by handle into the
        file file, following CIF 1.0 conventions of 80 character lines.
        cbf_write_widefile writes the CBF object specified by handle into the
        file file, following CIF 1.1 conventions of 2048 character lines. A
        warning is issued to stderr for ascii lines over the limit, and an
        attempt is made to fold lines to fit. No test is performed on binary
        sections.
        If a dictionary has been provided, aliases will be applied on output.
        Unlike cbf_read_file, the file does not have to be random-access.
        If the file is random-access and readable, readable can be set to
        non-0 to indicate to CBFlib that the file can be used as a buffer to
        conserve disk space. If the file is not random-access or not
        readable, readable must be 0.

        """
        return _pycbf.cbf_handle_struct_write_widefile(self, filename, ciforcbf, headers, encoding)

# Register cbf_handle_struct in _pycbf:
_pycbf.cbf_handle_struct_swigregister(cbf_handle_struct)


cvar = _pycbf.cvar
HAS_SWIG_PYTHON_STRICT_BYTE_CHAR = cvar.HAS_SWIG_PYTHON_STRICT_BYTE_CHAR

