# -*- coding: utf-8 -*-

"""
restapisdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""


class SessionLoginResponse(object):

    """Implementation of the 'SessionLoginResponse' model.

    Login response

    Attributes:
        user_name (string): Username of the user account for which token is
            generated
        token (string): Bearer token generated. This will be blank when token
            type is Cookie
        token_created_time (string): Date and time at which the token is
            generated
        token_expiry_duration (string): Duration in seconds after which the
            token expires
        token_type (string): Type of token generated

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "user_name": 'userName',
        "token": 'token',
        "token_created_time": 'tokenCreatedTime',
        "token_expiry_duration": 'tokenExpiryDuration',
        "token_type": 'tokenType'
    }

    def __init__(self,
                 user_name=None,
                 token=None,
                 token_created_time=None,
                 token_expiry_duration=None,
                 token_type=None):
        """Constructor for the SessionLoginResponse class"""

        # Initialize members of the class
        self.user_name = user_name
        self.token = token
        self.token_created_time = token_created_time
        self.token_expiry_duration = token_expiry_duration
        self.token_type = token_type

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        user_name = dictionary.get('userName')
        token = dictionary.get('token')
        token_created_time = dictionary.get('tokenCreatedTime')
        token_expiry_duration = dictionary.get('tokenExpiryDuration')
        token_type = dictionary.get('tokenType')

        # Return an object of this model
        return cls(user_name,
                   token,
                   token_created_time,
                   token_expiry_duration,
                   token_type)
