# -*- coding: utf-8 -*-

"""
restapisdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""


class ApiRestV2MetadataTmlImportRequest(object):

    """Implementation of the 'Api Rest V2 Metadata Tml Import Request' model.

    TODO: type model description here.

    Attributes:
        object_tml (list of string): A string array of TML objects to upload,
            in YAML or JSON format.    If TML is in YAML format, then use
            escape characters for quotes and new line characters.    Example
            TML:    guid: 6d2c1c9b-a407-409c-8c0c-819aeb51350f\ntable:\n 
            name: TESTINT\n  db: SUPPLYCHAIN_MAIN\n  schema: PUBLIC\n 
            db_table: TESTINT\n  connection:\n    name: SnowflakeConnection\n 
            columns:\n  - name: C1\n    db_column_name: C1\n    properties:\n 
            column_type: MEASURE\n      aggregation: SUM\n      index_type:
            DONT_INDEX\n    db_column_properties:\n      data_type: INT64\n   
            If TML is in JSON format, then use escape characters for quotes.  
            Example TML:    {\\"guid\\":
            \\"6d2c1c9b-a407-409c-8c0c-819aeb51350f\\", \\"table\\": {    
            \\"name\\": \\"TESTINT\\", \\"db\\": \\"SUPPLYCHAIN_MAIN\\",
            \\"schema\\": \\"PUBLIC\\", \\"db_table\\": \\"TESTINT\\",    
            \\"connection\\": { \\"name\\": \\"SnowflakeConnection\\" },
            \\"columns\\": [ { \\"name\\": \\"C1\\", \\"db_column_name\\":
            \\"C1\\", \\"properties\\": { \\"column_type\\": \\"MEASURE\\",
            \\"aggregation\\": \\"SUM\\", \\"index_type\\": \\"DONT_INDEX\\"
            }, \\"db_column_properties\\": { \\"data_type\\": \\"INT64\\" } }
            ] } }
        import_policy (ImportPolicyEnum): Policy to follow during import.   
            PARTIAL - Imports all objects that validate successfully, and
            ignores objects that do not validate successfully.    ALL_OR_NONE
            Imports the objects that validate successfully.    VALIDATE_ONLY
            Validates the objects but does not import them.
        force_create (bool): Specifies if you are updating or creating
            objects. To create new objects, specify true.    By default,
            ThoughtSpot updates existing objects that have the same GUID as
            the objects you are importing. When set to true, the GUID property
            in the imported TML is replaced on the server, and the response
            headers will include the id_guid property with the GUID of the new
            object. The new object will be assigned a new GUID, even if the
            imported TML file included a guid value. Thus, there is no need to
            include the guid in the TML file if you are using
            forceCreate=true.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "object_tml": 'objectTML',
        "import_policy": 'importPolicy',
        "force_create": 'forceCreate'
    }

    def __init__(self,
                 object_tml=None,
                 import_policy='PARTIAL',
                 force_create=False):
        """Constructor for the ApiRestV2MetadataTmlImportRequest class"""

        # Initialize members of the class
        self.object_tml = object_tml
        self.import_policy = import_policy
        self.force_create = force_create

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        object_tml = dictionary.get('objectTML')
        import_policy = dictionary.get("importPolicy") if dictionary.get("importPolicy") else 'PARTIAL'
        force_create = dictionary.get("forceCreate") if dictionary.get("forceCreate") else False

        # Return an object of this model
        return cls(object_tml,
                   import_policy,
                   force_create)
