# -*- coding: utf-8 -*-

"""
restapisdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from restapisdk.models.access_level_input import AccessLevelInput
from restapisdk.models.name_and_id_input import NameAndIdInput
from restapisdk.models.tag_name_and_id_input import TagNameAndIdInput


class ApiRestV2MetadataHeaderSearchRequest(object):

    """Implementation of the 'Api Rest V2 Metadata Header Search Request' model.

    TODO: type model description here.

    Attributes:
        output_fields (list of string): Array of header field names that need
            to be included in the header response
        offset (string): The offset point, starting from where the records
            should be included in the response.   If no input is provided then
            offset starts from 0.
        batch_size (string): The number of records that should be included in
            the response starting from offset position.    If no input is
            provided, then all records starting from the value provided in
            offset is included in the response.
        sort_by (SortByEnum): Field based on which the response needs to be
            ordered.
        sort_order (SortOrderEnum): Order in which sortBy should be applied.
        mtype (Type10Enum): Type of the metadata object being searched.
        name_pattern (string): A pattern to match the name of the metadata
            object. This parameter supports matching case-insensitive strings.
            For a wildcard match, use %.
        fetch_id (list of string): A JSON array containing the GUIDs of the
            metadata objects that you want to fetch.
        skip_id (list of string): A JSON array containing the GUIDs of the
            metadata objects that you want to skip.
        show_hidden (bool): When set to true, returns details of the hidden
            objects, such as a column in a worksheet or a table.
        auto_created (AutoCreatedEnum): String for UI and backend boolean- A
            flag to indicate whether to list only the auto created objects.
            When no value is provided as input then all objects are returned.
        access_level (list of AccessLevelInput): A JSON array of objects with
            user details for which the metadata objects should be considered
            from the repository If you specify ID or name of user and set the
            type parameter to USER, the API returns metadata objects
            associated with the user If you specify ID or name of user group
            and set the type parameter to USER_GROUP, the API returns metadata
            objects for all the users mapped to the specified user group. If
            the id or name parameter is not defined, but the type attribute is
            set to USER or USER_GROUP, then the API will not return and
            response. If no input is provided for any field for this object,
            then the API returns headers for all users. If both name and id is
            provided, then id will be considered.
        tag (list of TagNameAndIdInput): A JSON array of name or GUID of tags
            or both. When both are given then id is considered.
        favorite_for (list of NameAndIdInput): A JSON array of name or GUID of
            the user or both for whom the object is assigned as favorite. When
            both are given then id is considered.
        created_by (list of NameAndIdInput): A JSON array of name or GUID of
            the user or both who created the object. When both are given then
            id is considered.
        last_modified_by (list of NameAndIdInput): A JSON array of name or
            GUID of the user or both who last modified the object. When both
            are given then id is considered.
        owned_by (list of NameAndIdInput): A JSON array of name or GUID of the
            user or both who last modified the object. When both are given
            then id is considered.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "output_fields": 'outputFields',
        "offset": 'offset',
        "batch_size": 'batchSize',
        "sort_by": 'sortBy',
        "sort_order": 'sortOrder',
        "name_pattern": 'namePattern',
        "fetch_id": 'fetchId',
        "skip_id": 'skipId',
        "show_hidden": 'showHidden',
        "auto_created": 'autoCreated',
        "access_level": 'accessLevel',
        "tag": 'tag',
        "favorite_for": 'favoriteFor',
        "created_by": 'createdBy',
        "last_modified_by": 'lastModifiedBy',
        "owned_by": 'ownedBy'
    }

    def __init__(self,
                 mtype=None,
                 output_fields=None,
                 offset='0',
                 batch_size=None,
                 sort_by='DEFAULT',
                 sort_order='DEFAULT',
                 name_pattern=None,
                 fetch_id=None,
                 skip_id=None,
                 show_hidden=False,
                 auto_created=None,
                 access_level=None,
                 tag=None,
                 favorite_for=None,
                 created_by=None,
                 last_modified_by=None,
                 owned_by=None):
        """Constructor for the ApiRestV2MetadataHeaderSearchRequest class"""

        # Initialize members of the class
        self.output_fields = output_fields
        self.offset = offset
        self.batch_size = batch_size
        self.sort_by = sort_by
        self.sort_order = sort_order
        self.mtype = mtype
        self.name_pattern = name_pattern
        self.fetch_id = fetch_id
        self.skip_id = skip_id
        self.show_hidden = show_hidden
        self.auto_created = auto_created
        self.access_level = access_level
        self.tag = tag
        self.favorite_for = favorite_for
        self.created_by = created_by
        self.last_modified_by = last_modified_by
        self.owned_by = owned_by

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get('type')
        output_fields = dictionary.get('outputFields')
        offset = dictionary.get("offset") if dictionary.get("offset") else '0'
        batch_size = dictionary.get('batchSize')
        sort_by = dictionary.get("sortBy") if dictionary.get("sortBy") else 'DEFAULT'
        sort_order = dictionary.get("sortOrder") if dictionary.get("sortOrder") else 'DEFAULT'
        name_pattern = dictionary.get('namePattern')
        fetch_id = dictionary.get('fetchId')
        skip_id = dictionary.get('skipId')
        show_hidden = dictionary.get("showHidden") if dictionary.get("showHidden") else False
        auto_created = dictionary.get('autoCreated')
        access_level = None
        if dictionary.get('accessLevel') is not None:
            access_level = [AccessLevelInput.from_dictionary(x) for x in dictionary.get('accessLevel')]
        tag = None
        if dictionary.get('tag') is not None:
            tag = [TagNameAndIdInput.from_dictionary(x) for x in dictionary.get('tag')]
        favorite_for = None
        if dictionary.get('favoriteFor') is not None:
            favorite_for = [NameAndIdInput.from_dictionary(x) for x in dictionary.get('favoriteFor')]
        created_by = None
        if dictionary.get('createdBy') is not None:
            created_by = [NameAndIdInput.from_dictionary(x) for x in dictionary.get('createdBy')]
        last_modified_by = None
        if dictionary.get('lastModifiedBy') is not None:
            last_modified_by = [NameAndIdInput.from_dictionary(x) for x in dictionary.get('lastModifiedBy')]
        owned_by = None
        if dictionary.get('ownedBy') is not None:
            owned_by = [NameAndIdInput.from_dictionary(x) for x in dictionary.get('ownedBy')]

        # Return an object of this model
        return cls(mtype,
                   output_fields,
                   offset,
                   batch_size,
                   sort_by,
                   sort_order,
                   name_pattern,
                   fetch_id,
                   skip_id,
                   show_hidden,
                   auto_created,
                   access_level,
                   tag,
                   favorite_for,
                   created_by,
                   last_modified_by,
                   owned_by)
