# -*- coding: utf-8 -*-

"""
restapisdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from restapisdk.models.tag_name_and_id_input import TagNameAndIdInput


class ApiRestV2ConnectionSearchRequest(object):

    """Implementation of the 'Api Rest V2 Connection Search Request' model.

    TODO: type model description here.

    Attributes:
        offset (int): The offset point, starting from where the records should
            be included in the response.    If no input is provided then
            offset starts from 0.
        batch_number (int): An alternate way to set offset for the starting
            point of the response.    The value in offset field will not be
            considered if batchNumber field has value greater than 0.   
            Offset value will be calculated as (batchNumber - 1) * batchSize. 
            It is mandatory to provide a value for batchSize with
            batchNumber.
        batch_size (int): The number of records that should be included in the
            response starting from offset position. If no input is provided,
            then all records starting from the value provided in offset is
            included in the response.
        sort_by (SortByEnum): Field based on which the response needs to be
            ordered.
        sort_order (SortOrderEnum): Order in which sortBy should be applied.
        mtype (Type14Enum): Type of the connect being searched. Valid values:
        name_pattern (string): A pattern to match the name of the connection.
            This parameter supports matching case-insensitive strings. For a
            wildcard match, use %.
        fetch_id (list of string): A JSON array containing the GUIDs of the
            connections that you want to fetch.
        skip_id (list of string): A JSON array containing the GUIDs of the
            connections that you want to skip.
        tag (list of TagNameAndIdInput): A JSON array of name or GUID of tags
            or both. When both are given then id is considered

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "offset": 'offset',
        "batch_number": 'batchNumber',
        "batch_size": 'batchSize',
        "sort_by": 'sortBy',
        "sort_order": 'sortOrder',
        "name_pattern": 'namePattern',
        "fetch_id": 'fetchId',
        "skip_id": 'skipId',
        "tag": 'tag'
    }

    def __init__(self,
                 mtype=None,
                 offset=0,
                 batch_number=None,
                 batch_size=None,
                 sort_by='DEFAULT',
                 sort_order='DEFAULT',
                 name_pattern=None,
                 fetch_id=None,
                 skip_id=None,
                 tag=None):
        """Constructor for the ApiRestV2ConnectionSearchRequest class"""

        # Initialize members of the class
        self.offset = offset
        self.batch_number = batch_number
        self.batch_size = batch_size
        self.sort_by = sort_by
        self.sort_order = sort_order
        self.mtype = mtype
        self.name_pattern = name_pattern
        self.fetch_id = fetch_id
        self.skip_id = skip_id
        self.tag = tag

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get('type')
        offset = dictionary.get("offset") if dictionary.get("offset") else 0
        batch_number = dictionary.get('batchNumber')
        batch_size = dictionary.get('batchSize')
        sort_by = dictionary.get("sortBy") if dictionary.get("sortBy") else 'DEFAULT'
        sort_order = dictionary.get("sortOrder") if dictionary.get("sortOrder") else 'DEFAULT'
        name_pattern = dictionary.get('namePattern')
        fetch_id = dictionary.get('fetchId')
        skip_id = dictionary.get('skipId')
        tag = None
        if dictionary.get('tag') is not None:
            tag = [TagNameAndIdInput.from_dictionary(x) for x in dictionary.get('tag')]

        # Return an object of this model
        return cls(mtype,
                   offset,
                   batch_number,
                   batch_size,
                   sort_by,
                   sort_order,
                   name_pattern,
                   fetch_id,
                   skip_id,
                   tag)
