"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardscheme import CardScheme
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class ThreeDSecureDataV2TypedDict(TypedDict):
    cavv: str
    r"""The cardholder authentication value or AAV."""
    eci: str
    r"""The ecommerce indicator for the 3DS transaction."""
    version: str
    r"""The version of 3-D Secure that was used."""
    directory_response: str
    r"""For 3-D Secure version 1, the enrolment response. For 3-D Secure version 2 and above, the transaction status from the `ARes`."""
    directory_transaction_id: str
    r"""The transaction identifier."""
    scheme: NotRequired[Nullable[CardScheme]]
    r"""The scheme/brand of the card that is used for 3-D Secure."""
    authentication_response: NotRequired[Nullable[str]]
    r"""The transaction status after a the 3DS challenge. This will be null in case of a frictionless 3DS flow."""


class ThreeDSecureDataV2(BaseModel):
    cavv: str
    r"""The cardholder authentication value or AAV."""

    eci: str
    r"""The ecommerce indicator for the 3DS transaction."""

    version: str
    r"""The version of 3-D Secure that was used."""

    directory_response: str
    r"""For 3-D Secure version 1, the enrolment response. For 3-D Secure version 2 and above, the transaction status from the `ARes`."""

    directory_transaction_id: str
    r"""The transaction identifier."""

    scheme: Annotated[
        OptionalNullable[CardScheme], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The scheme/brand of the card that is used for 3-D Secure."""

    authentication_response: OptionalNullable[str] = UNSET
    r"""The transaction status after a the 3DS challenge. This will be null in case of a frictionless 3DS flow."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["scheme", "authentication_response"]
        nullable_fields = ["scheme", "authentication_response"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
