"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class StripeConnectOptionsTypedDict(TypedDict):
    stripe_account: NotRequired[Nullable[str]]
    r"""The Stripe Connect account to target using the `Stripe-Account` header."""
    application_fee_amount: NotRequired[Nullable[int]]
    r"""The fee to charge the connected account."""
    on_behalf_of: NotRequired[Nullable[str]]
    r"""The Stripe Connect account to target using the `on_behalf_of` request parameter."""
    transfer_data_destination: NotRequired[Nullable[str]]
    r"""The Stripe Connect account to target using the `transfer_data.destination` request parameter."""
    transfer_group: NotRequired[Nullable[str]]
    r"""A string that identifies the payment as part of a group."""


class StripeConnectOptions(BaseModel):
    stripe_account: OptionalNullable[str] = UNSET
    r"""The Stripe Connect account to target using the `Stripe-Account` header."""

    application_fee_amount: OptionalNullable[int] = UNSET
    r"""The fee to charge the connected account."""

    on_behalf_of: OptionalNullable[str] = UNSET
    r"""The Stripe Connect account to target using the `on_behalf_of` request parameter."""

    transfer_data_destination: OptionalNullable[str] = UNSET
    r"""The Stripe Connect account to target using the `transfer_data.destination` request parameter."""

    transfer_group: OptionalNullable[str] = UNSET
    r"""A string that identifies the payment as part of a group."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "stripe_account",
            "application_fee_amount",
            "on_behalf_of",
            "transfer_data_destination",
            "transfer_group",
        ]
        nullable_fields = [
            "stripe_account",
            "application_fee_amount",
            "on_behalf_of",
            "transfer_data_destination",
            "transfer_group",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
