"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PlaidPaymentMethodCreateTypedDict(TypedDict):
    r"""Plaid Payment Method

    Plaid Payment Method to use in a transaction.
    """

    token: str
    r"""The public token obtained after using Plaid Link."""
    method: Literal["plaid"]
    r"""Always `plaid`."""
    account_id: NotRequired[Nullable[str]]
    r"""The Plaid account ID corresponding to the end-user account. If not provided will be fetched from Plaid API expecting to only have one."""
    payment_service_id: NotRequired[Nullable[str]]
    r"""The ID of the Plaid payment service related to the provided public token. If not provided will be fetched from the currently active expecting to have a single one."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The ID of the buyer to attach the method to."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The merchant reference for this payment method."""
    external_identifier: NotRequired[Nullable[str]]
    r"""The merchant identifier for this payment method."""


class PlaidPaymentMethodCreate(BaseModel):
    r"""Plaid Payment Method

    Plaid Payment Method to use in a transaction.
    """

    token: str
    r"""The public token obtained after using Plaid Link."""

    METHOD: Annotated[
        Annotated[Optional[Literal["plaid"]], AfterValidator(validate_const("plaid"))],
        pydantic.Field(alias="method"),
    ] = "plaid"
    r"""Always `plaid`."""

    account_id: OptionalNullable[str] = UNSET
    r"""The Plaid account ID corresponding to the end-user account. If not provided will be fetched from Plaid API expecting to only have one."""

    payment_service_id: OptionalNullable[str] = UNSET
    r"""The ID of the Plaid payment service related to the provided public token. If not provided will be fetched from the currently active expecting to have a single one."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The ID of the buyer to attach the method to."""

    buyer_external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant reference for this payment method."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant identifier for this payment method."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "method",
            "account_id",
            "payment_service_id",
            "buyer_id",
            "buyer_external_identifier",
            "external_identifier",
        ]
        nullable_fields = [
            "account_id",
            "payment_service_id",
            "buyer_id",
            "buyer_external_identifier",
            "external_identifier",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
