"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cartitem import CartItem, CartItemTypedDict
from .guestbuyer import GuestBuyer, GuestBuyerTypedDict
from .statementdescriptor import StatementDescriptor, StatementDescriptorTypedDict
from .transactionconnectionoptions import (
    TransactionConnectionOptions,
    TransactionConnectionOptionsTypedDict,
)
from .transactionintent import TransactionIntent
from .transactionpaymentsource import TransactionPaymentSource
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkCreateTypedDict(TypedDict):
    amount: int
    r"""The amount for the payment link."""
    country: str
    r"""The country code for the payment link."""
    currency: str
    r"""The currency code for the payment link."""
    buyer: NotRequired[Nullable[GuestBuyerTypedDict]]
    r"""The guest buyer for the payment link."""
    expires_at: NotRequired[Nullable[datetime]]
    r"""The expiration date and time for the payment link."""
    connection_options: NotRequired[Nullable[TransactionConnectionOptionsTypedDict]]
    r"""Connection options for the payment link."""
    external_identifier: NotRequired[Nullable[str]]
    r"""The merchant reference for the payment link."""
    statement_descriptor: NotRequired[Nullable[StatementDescriptorTypedDict]]
    r"""The statement descriptor for the payment link."""
    locale: NotRequired[Nullable[str]]
    r"""The locale for the payment link."""
    merchant_name: NotRequired[Nullable[str]]
    r"""The merchant's display name."""
    merchant_url: NotRequired[Nullable[str]]
    r"""The merchant's website URL."""
    merchant_banner_url: NotRequired[Nullable[str]]
    r"""The merchant's banner image URL."""
    merchant_color: NotRequired[Nullable[str]]
    r"""The merchant's brand color."""
    merchant_message: NotRequired[Nullable[str]]
    r"""A message from the merchant."""
    merchant_terms_and_conditions_url: NotRequired[Nullable[str]]
    r"""URL to the merchant's terms and conditions."""
    merchant_favicon_url: NotRequired[Nullable[str]]
    r"""URL to the merchant's favicon."""
    intent: NotRequired[TransactionIntent]
    return_url: NotRequired[Nullable[str]]
    r"""The return URL after payment completion."""
    cart_items: NotRequired[Nullable[List[CartItemTypedDict]]]
    r"""The cart items for the payment link."""
    metadata: NotRequired[Nullable[Dict[str, Any]]]
    r"""Arbitrary metadata for the payment link."""
    payment_source: NotRequired[TransactionPaymentSource]
    r"""The way payment method information made it to this transaction."""
    store: NotRequired[bool]
    r"""Whether to store the payment method for future use."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The ID of the buyer to associate the payment method with. Note: When `buyer_id` is provided, the payment link should be treated as a secret as it will allow the user to manage payment methods for the associated buyer."""


class PaymentLinkCreate(BaseModel):
    amount: int
    r"""The amount for the payment link."""

    country: str
    r"""The country code for the payment link."""

    currency: str
    r"""The currency code for the payment link."""

    buyer: OptionalNullable[GuestBuyer] = UNSET
    r"""The guest buyer for the payment link."""

    expires_at: OptionalNullable[datetime] = UNSET
    r"""The expiration date and time for the payment link."""

    connection_options: OptionalNullable[TransactionConnectionOptions] = UNSET
    r"""Connection options for the payment link."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant reference for the payment link."""

    statement_descriptor: OptionalNullable[StatementDescriptor] = UNSET
    r"""The statement descriptor for the payment link."""

    locale: OptionalNullable[str] = UNSET
    r"""The locale for the payment link."""

    merchant_name: OptionalNullable[str] = UNSET
    r"""The merchant's display name."""

    merchant_url: OptionalNullable[str] = UNSET
    r"""The merchant's website URL."""

    merchant_banner_url: OptionalNullable[str] = UNSET
    r"""The merchant's banner image URL."""

    merchant_color: OptionalNullable[str] = UNSET
    r"""The merchant's brand color."""

    merchant_message: OptionalNullable[str] = UNSET
    r"""A message from the merchant."""

    merchant_terms_and_conditions_url: OptionalNullable[str] = UNSET
    r"""URL to the merchant's terms and conditions."""

    merchant_favicon_url: OptionalNullable[str] = UNSET
    r"""URL to the merchant's favicon."""

    intent: Annotated[
        Optional[TransactionIntent], PlainValidator(validate_open_enum(False))
    ] = None

    return_url: OptionalNullable[str] = UNSET
    r"""The return URL after payment completion."""

    cart_items: OptionalNullable[List[CartItem]] = UNSET
    r"""The cart items for the payment link."""

    metadata: OptionalNullable[Dict[str, Any]] = UNSET
    r"""Arbitrary metadata for the payment link."""

    payment_source: Annotated[
        Optional[TransactionPaymentSource], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The way payment method information made it to this transaction."""

    store: Optional[bool] = False
    r"""Whether to store the payment method for future use."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The ID of the buyer to associate the payment method with. Note: When `buyer_id` is provided, the payment link should be treated as a secret as it will allow the user to manage payment methods for the associated buyer."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "buyer",
            "expires_at",
            "connection_options",
            "external_identifier",
            "statement_descriptor",
            "locale",
            "merchant_name",
            "merchant_url",
            "merchant_banner_url",
            "merchant_color",
            "merchant_message",
            "merchant_terms_and_conditions_url",
            "merchant_favicon_url",
            "intent",
            "return_url",
            "cart_items",
            "metadata",
            "payment_source",
            "store",
            "buyer_id",
        ]
        nullable_fields = [
            "buyer",
            "expires_at",
            "connection_options",
            "external_identifier",
            "statement_descriptor",
            "locale",
            "merchant_name",
            "merchant_url",
            "merchant_banner_url",
            "merchant_color",
            "merchant_message",
            "merchant_terms_and_conditions_url",
            "merchant_favicon_url",
            "return_url",
            "cart_items",
            "metadata",
            "buyer_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
