"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .paymentmethods import PaymentMethods, PaymentMethodsTypedDict
from .paymentmethodstatus import PaymentMethodStatus
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Callable, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListPaymentMethodsGlobalsTypedDict(TypedDict):
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ListPaymentMethodsGlobals(BaseModel):
    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""


class ListPaymentMethodsRequestTypedDict(TypedDict):
    cursor: NotRequired[Nullable[str]]
    r"""A pointer to the page of results to return."""
    limit: NotRequired[int]
    r"""The maximum number of items that are at returned."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The ID of the buyer to filter payment methods by."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The external identifier of the buyer to filter payment methods by."""
    status: NotRequired[Nullable[List[PaymentMethodStatus]]]
    external_identifier: NotRequired[Nullable[str]]
    r"""The external identifier of the payment method to filter by."""
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ListPaymentMethodsRequest(BaseModel):
    cursor: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""A pointer to the page of results to return."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""The maximum number of items that are at returned."""

    buyer_id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The ID of the buyer to filter payment methods by."""

    buyer_external_identifier: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The external identifier of the buyer to filter payment methods by."""

    status: Annotated[
        OptionalNullable[
            List[
                Annotated[
                    PaymentMethodStatus, PlainValidator(validate_open_enum(False))
                ]
            ]
        ],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    external_identifier: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The external identifier of the payment method to filter by."""

    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cursor",
            "limit",
            "buyer_id",
            "buyer_external_identifier",
            "status",
            "external_identifier",
            "merchant_account_id",
        ]
        nullable_fields = [
            "cursor",
            "buyer_id",
            "buyer_external_identifier",
            "status",
            "external_identifier",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListPaymentMethodsResponseTypedDict(TypedDict):
    result: PaymentMethodsTypedDict


class ListPaymentMethodsResponse(BaseModel):
    next: Callable[[], Optional[ListPaymentMethodsResponse]]

    result: PaymentMethods
